

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPinJobsByCopyPrecedence.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPinJobsByCopyPrecedence.sp,v $ $Id: archPinJobsByCopyPrecedence.sp,v 1.6.48.2 2018/03/22 00:56:33 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPinJobsByCopyPrecedence <<<'

IF EXISTS (select * from sysobjects where name='archPinJobsByCopyPrecedence')
	drop procedure archPinJobsByCopyPrecedence
IF EXISTS (select * from GxQscripts where name='archPinJobsByCopyPrecedence')
	delete from GxQscripts where name = 'archPinJobsByCopyPrecedence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPinJobsByCopyPrecedence')
	delete from GXDBVersions where aliasname = 'archPinJobsByCopyPrecedence'
GO
print '... Creating Procedure: archPinJobsByCopyPrecedence'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archPinJobsByCopyPrecedence
  @i_pinOrUnpin integer,
  @i_pinEndTime bigint
AS
SET NOCOUNT ON
/* This temp table must be created and populated before executing this procedure. Initialize copyId to zero.
CREATE TABLE #tempJobs(
	jobId int, commCellId int, archGroupId int, copyId int)
*/
DECLARE @t_jobId		int
DECLARE @t_commCellId	int
DECLARE @t_copyId		int
DECLARE @t_copyPrec		int
DECLARE @retVal			int
SET	@retVal	= 0
BEGIN TRY
	DECLARE JobCopyForPin CURSOR FOR
	SELECT	DISTINCT J.jobId, J.commCellId, J.archGrpCopyId, c.copy
	FROM	JMJobDataStats J, #tempJobs T, archGroupCopy C
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
		AND J.archGrpId = T.archGroupId
AND J.status = 100 AND J.disabled & 256 = 0
		AND C.id = J.archGrpCopyId
		AND C.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ((AGC.flags & 16777216) = 0
OR (J.disabled & 2) = 0
			OR @i_pinEndTime < 0
			OR J.manualRetentionEndTime < @i_pinEndTime)
	ORDER BY J.jobId, J.commCellId, c.copy
	OPEN	JobCopyForPin
	FETCH	NEXT FROM JobCopyForPin
	INTO	@t_jobId, @t_commCellId, @t_copyId, @t_copyPrec
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		UPDATE	#tempJobs
		SET		copyId = @t_copyId
		WHERE	jobId = @t_jobId AND commCellId = @t_commCellId
			AND copyId = 0
		FETCH	NEXT FROM JobCopyForPin
		INTO	@t_jobId, @t_commCellId, @t_copyId, @t_copyPrec
	END
	CLOSE JobCopyForPin
	DEALLOCATE JobCopyForPin
	IF @i_pinOrUnpin > 0
		UPDATE	JMJobDataStats
SET		disabled = (J.disabled | 2), manualRetentionEndTime = @i_pinEndTime
		FROM	JMJobDataStats J, #tempJobs T
		WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
			AND J.archGrpCopyId = T.copyId
			--AND J.disabled & CVA_DONOTPRUNE_FLAG = 0
	ELSE
		UPDATE	JMJobDataStats
SET		disabled = (J.disabled & ~2), manualRetentionEndTime = 0
		FROM	JMJobDataStats J, #tempJobs T
		WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
			AND J.archGrpCopyId = T.copyId
			--AND J.disabled & CVA_DONOTPRUNE_FLAG <> 0
END TRY
BEGIN	CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = ERROR_NUMBER()
END		CATCH
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archPinJobsByCopyPrecedence')
	delete from GxQscripts where name = 'archPinJobsByCopyPrecedence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPinJobsByCopyPrecedence')
	delete from GXDBVersions where aliasname = 'archPinJobsByCopyPrecedence'
GO

insert into GXDBVersions values(2, 'archPinJobsByCopyPrecedence',  '00010006004800020000', 'archPinJobsByCopyPrecedence', '00010006004800020000')
GO

