

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPinJobsBasedOnJobOption.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPinJobsBasedOnJobOption.sp,v $ $Id: archPinJobsBasedOnJobOption.sp,v 1.1.2.3 2019/06/29 15:39:53 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archPinJobsBasedOnJobOption')
BEGIN
	print '>>> Drop Stored Procedure: archPinJobsBasedOnJobOption <<<'
	drop procedure archPinJobsBasedOnJobOption
END
IF EXISTS (select * from GxQscripts where name='archPinJobsBasedOnJobOption')
	delete from GxQscripts where name = 'archPinJobsBasedOnJobOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPinJobsBasedOnJobOption')
	delete from GXDBVersions where aliasname = 'archPinJobsBasedOnJobOption'
GO
print '... Creating Procedure: archPinJobsBasedOnJobOption'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archPinJobsBasedOnJobOption
  @i_dummy integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @rowCount INTEGER
SET			@rowCount = 0
SET 		@retVal = 0
/* This temp table must be created and populated by caller before calling this stored procedure
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
	CREATE TABLE #tblSelectedJobs (jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER)
*/
if (OBJECT_ID('tempdb.dbo.#tblJobCopyToRetain') IS NOT NULL) DROP TABLE #tblJobCopyToRetain
CREATE TABLE #tblJobCopyToRetain (jobId INTEGER, commCellId INTEGER, archGroupId INTEGER, archCopyId INTEGER,
																	numberOfDays INTEGER, retentionJobType INTEGER, applyJobRetentionOn INTEGER, retainUntil BIGINT)
CREATE INDEX Idx_tmptblJobCopyToRetain_1 ON #tblJobCopyToRetain (jobId, commcellId, archCopyId)
if (OBJECT_ID('tempdb.dbo.#tblJobOptionXML') IS NOT NULL) DROP TABLE #tblJobOptionXML
	CREATE TABLE #tblJobOptionXML (jobId INTEGER, commcellId INTEGER, JobOption XML)
CREATE INDEX Idx_tmptblJobOptionXML_1 ON #tblJobOptionXML (jobId, commcellId)
--Apply job retention option (if applicable)
INSERT INTO #tblJobOptionXML
SELECT JO.jobId, JO.commcellId, CAST(JO.attributeValue AS XML)
	  FROM JMJobOptions JO WITH (NOLOCK), #tblSelectedJobs T
	  WHERE JO.jobId = T.jobId
	  AND		JO.commcellId = T.commcellId
	  AND		JO.attributeId = 66
SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
IF (@retVal != 0) GOTO ERROR_EXIT
IF (@rowCount = 0) GOTO ERROR_EXIT
INSERT INTO #tblJobCopyToRetain
SELECT 	DISTINCT J.jobId, J.commcellId,
				ISNULL(CopyList.Info.value('@storagePolicyId','INTEGER'), 0) AS archGroupId,
				ISNULL(CopyList.Info.value('@copyId','INTEGER'), 0) AS archCopyId,
				ISNULL(JobRetention.Info.value('@numberofDays','INTEGER'), -1) AS numberOfDays,
				ISNULL(JobRetention.Info.value('@retentionJobType','INTEGER'), 2) AS retentionJobType,
				ISNULL(JobRetention.Info.value('@applyJobRetentionOn','INTEGER'), 0) AS applyJobRetentionOn,
				-1
FROM #tblJobOptionXML J CROSS APPLY J.JobOption.nodes('TMMsg_MediaBkpOption') AS JobRetention(Info)
OUTER APPLY J.JobOption.nodes('TMMsg_MediaBkpOption/selectedCopyList') AS CopyList(Info)
OPTION (MAXDOP 1)
SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
IF (@retVal != 0) GOTO ERROR_EXIT
IF (@rowCount = 0) GOTO ERROR_EXIT
--Update numberOfDays for INFINITE Retention
UPDATE #tblJobCopyToRetain
SET numberOfDays = -1, retainUntil = -1
WHERE retentionJobType = 0 OR numberOfDays < 0
SET @retVal = @@ERROR
IF (@retVal != 0) GOTO ERROR_EXIT
--Calculate RetainUntil
UPDATE #tblJobCopyToRetain
SET retainUntil = (JBK.servStartDate + CAST(numberOfDays AS BIGINT) * 24 * 3600)
FROM #tblJobCopyToRetain T, JMBkpStats JBK WITH (NOLOCK)
WHERE T.jobId = JBK.jobId
AND T.commcellId = JBK.commcellId
AND	T.retentionJobType = 1
AND T.numberOfDays >= 0
SET @retVal = @@ERROR
IF (@retVal != 0) GOTO ERROR_EXIT
UPDATE #tblJobCopyToRetain
SET retainUntil = (JAS.servStart + CAST(numberOfDays AS BIGINT) * 24 * 3600)
FROM #tblJobCopyToRetain T, JMAdminJobStatsTable JAS WITH (NOLOCK)
WHERE T.jobId = JAS.jobId
AND T.commcellId = JAS.commcellId
AND	T.retentionJobType = 1
AND T.numberOfDays >= 0
SET @retVal = @@ERROR
IF (@retVal != 0) GOTO ERROR_EXIT
--Update RetainUntil to 0 if retentionJobType = 2 --No job retention
UPDATE #tblJobCopyToRetain
SET retainUntil = 0
WHERE retentionJobType NOT IN (0, 1)
SET @retVal = @@ERROR
IF (@retVal != 0) GOTO ERROR_EXIT
IF EXISTS (SELECT 1 FROM #tblJobCopyToRetain WHERE retainUntil != 0)
BEGIN
	UPDATE JMJobDataStats
SET disabled = disabled | 2,
			manualRetentionEndTime = TMP.manualRetentionEndTime
	FROM JMJobDataStats JDS, (SELECT J.jobId, J.commcellId, J.archGrpCopyId, CASE WHEN MIN(manualRetentionEndTime) < 0 THEN -1 ELSE MAX(manualRetentionEndTime) END AS manualRetentionEndTime
														FROM JMJobDataStats J, #tblSelectedJobs T
														WHERE J.jobId = T.jobId
														AND		J.commcellId = T.commcellId
														AND		J.archGrpCopyId = T.copyId
														GROUP BY J.jobId, J.commcellId, J.archGrpCopyId) TMP
	WHERE JDS.jobId = TMP.jobId
	AND		JDS.commcellId = TMP.commcellId
	AND		JDS.archGrpCopyId = TMP.archGrpCopyId
	AND		TMP.manualRetentionEndTime != 0
	SET @retVal = @@ERROR
	IF (@retVal != 0) GOTO ERROR_EXIT
	UPDATE JMJobDataStats
SET disabled = disabled | 2,
			manualRetentionEndTime = TMP.retainUntil
	FROM JMJobDataStats JDS, #tblSelectedJobs T, #tblJobCopyToRetain TMP, archGroup AG WITH (NOLOCK)
	WHERE JDS.jobId = T.jobId
	AND		JDS.commcellId = T.commcellId
	AND		JDS.archGrpCopyId = T.copyId
	AND 	JDS.archGrpId = AG.id
	AND		JDS.jobId = TMP.jobId
	AND		JDS.commcellId = TMP.commcellId
	AND		(
					(TMP.applyJobRetentionOn NOT IN (1, 2) AND (JDS.archGrpCopyId = AG.defaultCopy OR JDS.archGrpCopyId = AG.defaultSnapCopy)) --Apply retention on Primary Copy
					OR
					(TMP.applyJobRetentionOn = 1) --Apply Retention on All Copies
					OR
					(TMP.applyJobRetentionOn = 2 AND JDS.archGrpId = TMP.archGroupId AND JDS.archGrpCopyId = TMP.archCopyId) --Apply Retention on specific list of Copies
				)
	AND		TMP.retainUntil != 0
	AND   (TMP.retainUntil = -1 OR JDS.manualRetentionEndTime < TMP.retainUntil)
	SET @retVal = @@ERROR
	IF (@retVal != 0) GOTO ERROR_EXIT
END
ERROR_EXIT:
	if (OBJECT_ID('tempdb.dbo.#tblJobCopyToRetain') IS NOT NULL) DROP TABLE #tblJobCopyToRetain
	if (OBJECT_ID('tempdb.dbo.#tblJobOptionXML') IS NOT NULL) DROP TABLE #tblJobOptionXML
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archPinJobsBasedOnJobOption')
	delete from GxQscripts where name = 'archPinJobsBasedOnJobOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPinJobsBasedOnJobOption')
	delete from GXDBVersions where aliasname = 'archPinJobsBasedOnJobOption'
GO

insert into GXDBVersions values(2, 'archPinJobsBasedOnJobOption',  '00010001000200030000', 'archPinJobsBasedOnJobOption', '00010001000200030000')
GO

