

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archModifyJobStateByMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archModifyJobStateByMedia.sp,v $ $Id: archModifyJobStateByMedia.sp,v 1.6.210.3 2018/09/04 10:33:37 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archModifyJobStateByMedia <<<'

IF EXISTS (select * from sysobjects where name='archModifyJobStateByMedia')
	drop procedure archModifyJobStateByMedia
IF EXISTS (select * from GxQscripts where name='archModifyJobStateByMedia')
	delete from GxQscripts where name = 'archModifyJobStateByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archModifyJobStateByMedia')
	delete from GXDBVersions where aliasname = 'archModifyJobStateByMedia'
GO
print '... Creating Procedure: archModifyJobStateByMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archModifyJobStateByMedia
  @i_mediaId integer,
  @i_copyOrNot integer
AS
  DECLARE @o_jobId integer;
  DECLARE @o_copyId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblJob	TABLE (
	jobId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (jobId, commCellId, archCopyId))
DECLARE @tblCopyToSet TABLE (
	copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
DECLARE	@retVal		INT
SET		@retVal = 0
DECLARE	@l_copyId	INT
SET		@l_copyId = 0
DECLARE	@l_now	INT
SET		@l_now = dbo.GetUnixTime(GETUTCDATE())
INSERT	INTO @tblJob
SELECT	DISTINCT AF.jobId, AF.commCellId, ACM.archCopyId
FROM	archFile AF WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1
AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId AND ACM.flags & 256 = 0
AND AC.volumeId = V.VolumeId AND AC.flags & 256 = 0
	AND V.MediaId = @i_mediaId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
SELECT	TOP 1 @l_copyId = ISNULL(archCopyId, 0) FROM @tblJob
IF @l_copyId = 0 GOTO FINISH
INSERT	INTO @tblCopyToSet
EXEC	ArchDestinationCopyList @l_copyId
IF @i_copyOrNot = 0
	UPDATE	JMJobDataStats
SET		disabled = (J.disabled | 1), modifiedTime = @l_now
	FROM	JMJobDataStats J, @tblJob A, @tblCopyToSet C
	WHERE	J.jobId = A.jobId AND J.commCellId = A.commCellId
		AND	(J.archGrpCopyId = A.archCopyId OR J.archGrpCopyId = C.copyId AND J.status IN (101, 102, 103))
AND J.disabled & (1 + 256) = 0
ELSE
	UPDATE	JMJobDataStats
SET		disabled = (J.disabled & ~1), modifiedTime = @l_now
	FROM	JMJobDataStats J, @tblJob A, @tblCopyToSet C
	WHERE	J.jobId = A.jobId AND J.commCellId = A.commCellId
		AND	(J.archGrpCopyId = A.archCopyId OR J.archGrpCopyId = C.copyId AND J.status IN (101, 102, 103))
AND J.disabled & (1 + 256) = 1
SET @retVal = @@ERROR
FINISH:
IF @retVal <> 0
	SELECT -@retVal, @l_copyId
ELSE
	SELECT jobId, @l_copyId FROM @tblJob ORDER BY jobId
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archModifyJobStateByMedia')
	delete from GxQscripts where name = 'archModifyJobStateByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archModifyJobStateByMedia')
	delete from GXDBVersions where aliasname = 'archModifyJobStateByMedia'
GO

insert into GXDBVersions values(2, 'archModifyJobStateByMedia',  '00010006021000030000', 'archModifyJobStateByMedia', '00010006021000030000')
GO

