

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archModifyEncKeyProvider.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archModifyEncKeyProvider.sp,v $ $Id: archModifyEncKeyProvider.sp,v 1.1.2.16 2020/08/20 05:13:18 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archModifyEncKeyProvider"							|
--	|																		|
--	| Updates key provider properties										|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archModifyEncKeyProvider')
BEGIN
	print '>>> Drop Stored Procedure: archModifyEncKeyProvider <<<'
	drop procedure archModifyEncKeyProvider
END
IF EXISTS (select * from GxQscripts where name='archModifyEncKeyProvider')
	delete from GxQscripts where name = 'archModifyEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archModifyEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archModifyEncKeyProvider'
GO
print '... Creating Procedure: archModifyEncKeyProvider'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archModifyEncKeyProvider
  @i_userId int,
  @i_keyProviderId int,
  @i_newKeyProviderName nvarchar(1024),
  @i_newEncType int,
  @i_newEncKeLength int,
  @i_newKeyProviderType int,
  @i_newProperties xml,
  @i_rotatePassphrase int,
  @i_secAssocXml xml,
  @i_localeId bigint
AS
BEGIN
  DECLARE @o_errorCode int;
  DECLARE @o_errorString NVARCHAR(1024);
  DECLARE @o_oldEncKeyLength int;
  DECLARE @o_oldProviderType int;
  DECLARE @o_oldProperties xml;
  DECLARE @o_newProperties xml;
  DECLARE @o_oldPassphraseFileName varchar(256);
  DECLARE @o_newPassphraseFileName varchar(256);
  DECLARE @o_rotatePassphrase int;
  DECLARE @o_newPassphrase uniqueidentifier;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
SET @o_errorCode = 0
	DECLARE @now int = dbo.getunixtime(getutcdate())
	DECLARE @l_keyProviderType 		int
	DECLARE @l_keyProviderGUID 		uniqueidentifier
	DECLARE @l_properties			xml = ''
	DECLARE @l_newProperties 		xml = ''
	DECLARE @l_encKeyLength 		int
	DECLARE	@l_configFilePath		nvarchar(2048) = ''
	DECLARE	@l_certPassword			varchar(2048) = ''
	DECLARE	@l_host					nvarchar(256) = ''
	DECLARE	@l_port					int = 0
	DECLARE	@l_certFilePath			nvarchar(2048) = ''
	DECLARE	@l_keyFilePath			nvarchar(2048) = ''
	DECLARE	@l_caCertFilePath		nvarchar(2048) = ''
	DECLARE	@l_regionName			nvarchar(256) = ''
	DECLARE	@l_regionCode			varchar(256) = ''
	DECLARE	@l_accessKey			varchar(1024) = ''
	DECLARE	@l_secretAccessKey		varchar(2048) = ''
	DECLARE	@l_passphraseFileName	varchar(256) = ''
	DECLARE	@l_newPassphraseFileName	varchar(256) = ''
	DECLARE @l_newPassphraseClientListXml	xml = ''
	DECLARE @l_rotatePassphrase		int = @i_rotatePassphrase
	DECLARE @l_keyVaultCredential	xml = ''
	-- Validation
	SELECT 	@l_keyProviderType = KeyProviderType, @l_properties = Properties, @l_encKeyLength = encKeyLength,
			@l_keyProviderGUID = GUID
	FROM 	ArchEncKeyProvider WHERE KeyProviderId = @i_keyProviderId
	IF @i_newKeyProviderName <> ''
		AND EXISTS(SELECT 1 FROM ArchEncKeyProvider WHERE KeyProviderName = @i_newKeyProviderName)
	BEGIN
SET @o_errorCode = 173
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (192 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
        SET @o_errorString = REPLACE(@o_errorString, '^1%s', @i_newKeyProviderName)
		GOTO CX_EXIT
	END
	-- Only AES is supported except for Azure
	-- For Azure RSA and RSA_HSM are supported
	IF @i_newEncType > 0 AND (
		(
@l_keyProviderType <> 4
AND @i_newEncType <> 3
		)
		OR
		(
@l_keyProviderType = 4
AND @i_newEncType NOT IN (1001, 1002)
		)
	)
	BEGIN
SET @o_errorCode = 223
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (206 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	-- Only 128 or 256 is supported except for Azure
	-- For Azure 2048 and 3072 are supported
	IF @i_newEncKeLength > 0 AND (
		(
@l_keyProviderType <> 4
			AND @i_newEncKeLength NOT IN (128, 256)
		)
		OR
		(
@l_keyProviderType = 4
			AND @i_newEncKeLength NOT IN (2048, 3072)
		)
	)
	BEGIN
SET @o_errorCode = 224
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (205 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	--Changing provider type is allowed only from SAFENET to KMIP and vice versa.
	IF @i_newKeyProviderType > 0 AND @i_newKeyProviderType <> @l_keyProviderType
AND (@i_newKeyProviderType NOT IN (2, 5)
OR @l_keyProviderType  NOT IN (2, 5))
	BEGIN
SET @o_errorCode = 201
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (207 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	--Get old properties
	SELECT	@l_configFilePath =  col.value('@configurationFilePath', 'nvarchar(2048)'),
			@l_certPassword = col.value('@sslPassPhrase', 'varchar(2048)'),
			@l_host = col.value('@host', 'nvarchar(256)'),
			@l_port = col.value('@port', 'int'),
			@l_certFilePath = col.value('@certFilePath', 'nvarchar(2048)'),
			@l_keyFilePath = col.value('@keyFilePath', 'nvarchar(2048)'),
			@l_caCertFilePath = col.value('@caCertFilePath', 'nvarchar(2048)'),
			@l_regionName = col.value('@regionName', 'nvarchar(256)'),
			@l_regionCode = col.value('@regionCode', 'varchar(256)'),
			@l_accessKey = col.value('userAccount[1]/@userName', 'varchar(1024)'),
			@l_secretAccessKey = col.value('userAccount[1]/@password', 'varchar(2048)'),
			@l_passphraseFileName = col.value('@passphraseFileName', 'varchar(256)'),
			@l_keyVaultCredential = col.query('keyVaultCredential')
	FROM @l_properties.nodes('App_EncKeyProviderProperties') as node(col)
	IF @@ERROR <> 0
	BEGIN
SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	IF @i_newProperties.exist('*') > 0
	BEGIN
		--Set new properties
IF @l_keyProviderType = 3 /*CVA_ENC_KEY_PROVIDER_AWS_KMS*/
		BEGIN
			DECLARE	@l_newConfigFilePath		nvarchar(2048)
			DECLARE	@l_newRegionName			nvarchar(256)
			DECLARE	@l_newRegionCode			varchar(256)
			DECLARE	@l_newAccessKey				varchar(1024)
			DECLARE	@l_newSecretAccessKey		varchar(2048)
			SELECT	@l_newConfigFilePath = col.value('@configurationFilePath', 'nvarchar(2048)'),
					@l_newRegionName = col.value('@regionName', 'nvarchar(256)'),
					@l_newRegionCode = col.value('@regionCode', 'varchar(256)'),
					@l_newAccessKey = col.value('userAccount[1]/@userName', 'varchar(1024)'),
					@l_newSecretAccessKey = col.value('userAccount[1]/@password', 'varchar(2048)')
			FROM @i_newProperties.nodes('App_EncKeyProviderProperties') as node(col)
			IF ISNULL(@l_newConfigFilePath, N'') <> '' AND ISNULL(@l_newAccessKey, N'') = N''
			BEGIN
				-- Using credential file from environment variable
				SET @l_newProperties =
				(
					SELECT	@l_newConfigFilePath AS '@configurationFilePath'
					FOR XML PATH('App_EncKeyProviderProperties')
				)
			END
			ELSE
			BEGIN
				-- Using access info stored in DB
				SET @l_newProperties =
				(
					SELECT	@l_newRegionName AS '@regionName',
							@l_newRegionCode AS '@regionCode',
							@l_newAccessKey AS 'userAccount/@userName',
							@l_newSecretAccessKey AS 'userAccount/@password'
					FOR XML PATH('App_EncKeyProviderProperties')
				)
			END
			IF @@ERROR <> 0
			BEGIN
SET @o_errorCode = 2
				GOTO CX_EXIT
			END
		END
		ELSE
		BEGIN
			SET @l_newProperties =
			(
				SELECT	ISNULL(NULLIF(col.value('@configurationFilePath', 'nvarchar(2048)'), ''), @l_configFilePath) AS '@configurationFilePath',
					ISNULL(NULLIF(col.value('@sslPassPhrase', 'varchar(2048)'), ''), @l_certPassword) AS '@sslPassPhrase',
					ISNULL(NULLIF(col.value('@host', 'nvarchar(256)'), ''), @l_host) AS '@host',
					ISNULL(NULLIF(col.value('@port', 'int'), 0), @l_port) AS '@port',
					ISNULL(NULLIF(col.value('@certFilePath', 'nvarchar(2048)'), ''), @l_certFilePath) AS '@certFilePath',
					ISNULL(NULLIF(col.value('@keyFilePath', 'nvarchar(2048)'), ''), @l_keyFilePath) AS '@keyFilePath',
					ISNULL(NULLIF(col.value('@caCertFilePath', 'nvarchar(2048)'), ''), @l_caCertFilePath) AS '@caCertFilePath',
					ISNULL(NULLIF(col.value('@regionName', 'nvarchar(256)'), ''), @l_regionName) AS '@regionName',
					ISNULL(NULLIF(col.value('@regionCode', 'varchar(256)'), ''), @l_regionCode) AS '@regionCode',
					@l_passphraseFileName AS '@passphraseFileName',
					ISNULL(NULLIF(col.value('userAccount[1]/@userName', 'varchar(1024)'), ''), @l_accessKey) AS 'userAccount/@userName',
					ISNULL(NULLIF(col.value('userAccount[1]/@password', 'varchar(2048)'), ''), @l_secretAccessKey) AS 'userAccount/@password',
					ISNULL(CAST(NULLIF(CAST(col.query('keyVaultCredential') AS NVARCHAR(MAX)), N'') AS XML), @l_keyVaultCredential)
				FROM @i_newProperties.nodes('App_EncKeyProviderProperties') as node(col)
				FOR XML PATH('App_EncKeyProviderProperties')
			)
			IF @@ERROR <> 0
			BEGIN
SET @o_errorCode = 2
				GOTO CX_EXIT
			END
		END
		--For Passphrase KMS check for passphrase client list
IF @l_keyProviderType = 6
		BEGIN
			IF @i_newProperties.exist('/App_EncKeyProviderProperties/passphraseClient/client/@clientId') = 1
				AND @i_newProperties.exist('/App_EncKeyProviderProperties/passphraseClient/client[@clientId='''']') = 0
			BEGIN
				--Passphrase client list got changed, use the new list
				SELECT @l_newPassphraseClientListXml = @i_newProperties.query('App_EncKeyProviderProperties/passphraseClient')
				--
				-- Check if any duplicate export location is specified.
				-- Duplicates are not allowed
				--
				IF EXISTS
				(
					SELECT 1
					FROM (SELECT 	col.value('client[1]/@clientId', 'int') clientId,
									(CASE WHEN RIGHT(col.value('filePath[1]/@path', 'varchar(max)'), 1) IN ('/', '\')
											THEN LEFT(col.value('filePath[1]/@path', 'varchar(max)'), LEN(col.value('filePath[1]/@path', 'varchar(max)')) - 1)
											ELSE col.value('filePath[1]/@path', 'varchar(max)')
									END) path
							FROM 	@i_newProperties.nodes('App_EncKeyProviderProperties/passphraseClient') as node(col)) AS T
					GROUP BY T.clientId, T.path
					HAVING COUNT(*) > 1
				)
				BEGIN
SET @o_errorCode = 225
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (250 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
					GOTO CX_EXIT
				END
				--
				--Compare old and new passphrase client list to see if there are any changes
				--We should rotate passphrase if there are any changes to client export locations
				--
				IF @l_rotatePassphrase = 0
				IF EXISTS
				(
					SELECT 	col.value('client[1]/@clientId', 'int'), col.value('filePath[1]/@path', 'varchar(max)')
					FROM @i_newProperties.nodes('App_EncKeyProviderProperties/passphraseClient') as node(col)
					EXCEPT
					SELECT 	col.value('client[1]/@clientId', 'int'), col.value('filePath[1]/@path', 'varchar(max)')
					FROM @l_properties.nodes('App_EncKeyProviderProperties/passphraseClient') as node(col)
				)
				BEGIN
					SET @l_rotatePassphrase = 1
				END
			END
			ELSE
			BEGIN
				--No change to passphrase client list, keep previous list
				SELECT @l_newPassphraseClientListXml = @l_properties.query('App_EncKeyProviderProperties/passphraseClient')
			END
			--Set the new client list in properties
			SET @l_newProperties.modify('insert sql:variable("@l_newPassphraseClientListXml") into (/App_EncKeyProviderProperties[1])')
		END
	END
	ELSE
	BEGIN
		--if there are no changes to properties keep the old properties
		SET @l_newProperties = @l_properties
	END
	--PASSPHRASE KMS:  we need to form passphrase file name and update properties with new fileName for rotation
IF @l_keyProviderType = 6 /*CVA_ENC_KEY_PROVIDER_PASSPHRASE*/
		AND @l_rotatePassphrase = 1
	BEGIN
		--Random GUID will be used as passphrase if user opts to generate it
		SET @o_newPassphrase = newid()
		--Passphrase file name will be in format "Passphrase_<KeyProviderGUID>_<Timestamp>"
		SET @l_newPassphraseFileName = 'Passphrase_' + cast(@l_keyProviderGUID as varchar(36)) + '_' + cast(@now as varchar(10))
		SET @l_newProperties.modify('replace value of (/App_EncKeyProviderProperties[1]/@passphraseFileName) with sql:variable("@l_newPassphraseFileName")')
	END
	-- Update provider
	UPDATE 	ArchEncKeyProvider
	SET		KeyProviderName = (CASE WHEN @i_newKeyProviderName <> '' THEN @i_newKeyProviderName ELSE KeyProviderName END),
			EncType			= (CASE WHEN @i_newEncType > 0 THEN @i_newEncType ELSE EncType END),
			EncKeyLength	= (CASE WHEN @i_newEncKeLength > 0 THEN @i_newEncKeLength ELSE EncKeyLength END),
			Properties 		= cast(@l_newProperties as nvarchar(max)),
			Modified 		=  @now,
			KeyProviderType = (CASE WHEN @i_newKeyProviderType > 0 THEN @i_newKeyProviderType ELSE KeyProviderType END)
	WHERE 	KeyProviderId = @i_keyProviderId
	IF @@ERROR <> 0
	BEGIN
SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	--
	--Security Associations specified by user
	--
	IF @i_secAssocXml.exist('*') > 0
	BEGIN
		IF OBJECT_ID('tempdb..#lt_Error') IS NOT NULL DROP TABLE #lt_Error
		CREATE TABLE #lt_Error (errorCode int, errorString nvarchar(1024))
		INSERT INTO #lt_Error
		EXEC sec_setSecurityAssociationsFromEntity
					@xmlIn = @i_secAssocXml,
					@userId = @i_userId,
					@isCmdLine = 0,
					@skipSecurityCheck = 1,
@entityType1 = 178 /*KEY_MANAGEMENT_SERVER_ENTITY*/,
					@entityId1 = @i_keyProviderId,
					@entityType2 = 0,
					@entityId2 = 0,
					@entityType3 = 0,
					@entityId3 = 0,
					@entityType4 = 0,
					@entityId4 = 0,
					@entityType5 = 0,
					@entityId5 = 0
		SELECT @o_errorCode = errorCode, @o_errorString = errorString FROM #lt_Error
	END
CX_EXIT:
SELECT 	@o_errorCode 				AS 'o_errorCode',
		@o_errorString 				AS 'o_errorString',
		@l_encKeyLength 			AS 'o_oldEncKeyLength',
		@l_keyProviderType 			AS 'o_oldProviderType',
		@l_properties 				AS 'o_oldProperties',
		@l_newProperties 			AS 'o_newProperties',
		@l_passphraseFileName 		AS 'o_oldPassphraseFileName',
		@l_newPassphraseFileName 	AS 'o_newPassphraseFileName',
		@l_rotatePassphrase 		AS 'o_rotatePassphrase',
		@o_newPassphrase			AS 'o_newPassphrase'
END

IF EXISTS (select * from GxQscripts where name = 'archModifyEncKeyProvider')
	delete from GxQscripts where name = 'archModifyEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archModifyEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archModifyEncKeyProvider'
GO

insert into GXDBVersions values(2, 'archModifyEncKeyProvider',  '00010001000200160000', 'archModifyEncKeyProvider', '00010001000200160000')
GO

