

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMiningPickNewJobByMiningAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMiningPickNewJobByMiningAppId.sp,v $ $Id: archMiningPickNewJobByMiningAppId.sp,v 1.4.60.2 2018/03/22 01:10:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMiningPickNewJobByMiningAppId <<<'

IF EXISTS (select * from sysobjects where name='archMiningPickNewJobByMiningAppId')
	drop procedure archMiningPickNewJobByMiningAppId
IF EXISTS (select * from GxQscripts where name='archMiningPickNewJobByMiningAppId')
	delete from GxQscripts where name = 'archMiningPickNewJobByMiningAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMiningPickNewJobByMiningAppId')
	delete from GXDBVersions where aliasname = 'archMiningPickNewJobByMiningAppId'
GO
print '... Creating Procedure: archMiningPickNewJobByMiningAppId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMiningPickNewJobByMiningAppId
  @i_miningAppId integer,
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_nextFullTime integer,
  @i_today integer,
  @errCode integer	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@i_commCellId   INTEGER
SET	@i_commCellId = 2
DECLARE	@l_miningArchGrpId	INT
DECLARE	@l_enabled			INT
DECLARE	@l_type				INT
DECLARE	@l_flags			INT
DECLARE	@l_startTime		INT
DECLARE	@l_numPeriod		INT
DECLARE	@l_dayNumber		INT
DECLARE	@l_currPeriodBegin	INT
DECLARE	@l_currPeriodEnd	INT
DECLARE	@l_prevPeriodBegin	INT
DECLARE	@l_nextPeriodEnd	INT
SET		@errCode			= 0
SET		@l_miningArchGrpId	= 0
BEGIN TRY
SELECT	@l_miningArchGrpId = dataArchGrpId
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @i_miningAppId
IF @l_miningArchGrpId <= 1
	GOTO RETURN_PROC
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags,
		@l_startTime = startTime, @l_numPeriod = numPeriod, @l_dayNumber = dayNumber,
		@l_currPeriodBegin = currPeriodBegin, @l_currPeriodEnd = currPeriodEnd,
		@l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	archGroupMiningProp WITH (NOLOCK)
WHERE	archGroupId = @l_miningArchGrpId
IF	@l_enabled = 0
OR @l_type = 8
OR @l_type = 9
OR @l_type <> 0 AND @i_backupLevel NOT IN (1, 64, 128, 1024, 32768)
 OR @i_startDate < @l_startTime
	GOTO RETURN_PROC
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
	GOTO SELECT_JOB
-- Apply selection rules.
IF	@l_type IN (1, 3, 2, 4, 6)
BEGIN
	DECLARE @l_startDate	INT
	DECLARE @l_fullCycleNum	INT
	SELECT	TOP 1 @l_startDate = J.servStartDate, @l_fullCycleNum = J.fullCycleNum
	FROM	JMBkpStats J WITH (NOLOCK), JMJobMiningStats S WITH (NOLOCK)
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId
		AND S.appId = @i_appId AND S.miningAppId = @i_miningAppId
		AND S.miningStatus IN (0, 1)
	ORDER BY J.servStartDate DESC
IF	@l_type = 1
	BEGIN
		IF	@i_fullCycleNum < (@l_numPeriod + @l_fullCycleNum)
			GOTO RETURN_PROC
	END
	ELSE
IF	@l_type IN (3, 2, 4, 6)
	BEGIN
		DECLARE	@l_clientId int
		SELECT	@l_clientId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId
		DECLARE	@l_TimeZone varchar(255)
		SET		@l_TimeZone = dbo.ArchGroupTimeZone(@l_miningArchGrpId, @l_clientId)
		IF @l_TimeZone <> ''
		BEGIN
			DECLARE	@l_csTimeZone varchar(255)
			SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
			IF	@l_TimeZone <> @l_csTimeZone
			BEGIN
				SET	@i_today = @i_today + dbo.GetDiffFromCSTimeZone(@i_today, @l_TimeZone, @l_csTimeZone)
				SET	@i_startDate = @i_startDate + dbo.GetDiffFromCSTimeZone(@i_startDate, @l_TimeZone, @l_csTimeZone)
IF	@i_nextFullTime > 0 AND (@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0
					SET	@i_nextFullTime = @i_nextFullTime + dbo.GetDiffFromCSTimeZone(@i_nextFullTime, @l_TimeZone, @l_csTimeZone)
			END
		END
		IF	@i_startDate <  @l_currPeriodBegin AND @l_startDate < @l_currPeriodBegin AND @l_startDate >= @l_prevPeriodBegin
		OR	@i_startDate >= @l_currPeriodBegin AND @i_startDate < @l_currPeriodEnd   AND @l_startDate >= @l_currPeriodBegin AND @l_startDate < @l_currPeriodEnd
		OR	@i_startDate >= @l_currPeriodEnd   AND @i_startDate < @l_nextPeriodEnd   AND @l_startDate >= @l_currPeriodEnd
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0 AND @i_nextFullTime > 0 AND
			(	@i_startDate <  @l_currPeriodBegin AND @i_nextFullTime < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @i_startDate    < @l_currPeriodEnd AND @i_nextFullTime < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @i_nextFullTime < @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) <> 0 AND
			(	@i_startDate <  @l_currPeriodBegin AND @i_today <  @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @i_today >= @l_currPeriodBegin AND @i_startDate < @l_currPeriodEnd AND @i_today < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @i_today >= @l_currPeriodEnd)
			GOTO RETURN_PROC
	END
END
SELECT_JOB:
INSERT	INTO JMJobMiningStats (
		jobId, commCellId, appId, miningAppId, miningArchGrpId, miningStatus, miningJobId, miningCommCellId, flags)
SELECT	@i_jobId, @i_commCellId, @i_appId, @i_miningAppId, @l_miningArchGrpId, 0, 0, 0, 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET	@errCode = ERROR_NUMBER()
END CATCH
RETURN_PROC:
RETURN	@errCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMiningPickNewJobByMiningAppId')
	delete from GxQscripts where name = 'archMiningPickNewJobByMiningAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMiningPickNewJobByMiningAppId')
	delete from GXDBVersions where aliasname = 'archMiningPickNewJobByMiningAppId'
GO

insert into GXDBVersions values(2, 'archMiningPickNewJobByMiningAppId',  '00010004006000020000', 'archMiningPickNewJobByMiningAppId', '00010004006000020000')
GO

