

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMiningPickJobsByMiningAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMiningPickJobsByMiningAppId.sp,v $ $Id: archMiningPickJobsByMiningAppId.sp,v 1.7.34.2 2018/03/22 01:06:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMiningPickJobsByMiningAppId <<<'

IF EXISTS (select * from sysobjects where name='archMiningPickJobsByMiningAppId')
	drop procedure archMiningPickJobsByMiningAppId
IF EXISTS (select * from GxQscripts where name='archMiningPickJobsByMiningAppId')
	delete from GxQscripts where name = 'archMiningPickJobsByMiningAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMiningPickJobsByMiningAppId')
	delete from GXDBVersions where aliasname = 'archMiningPickJobsByMiningAppId'
GO
print '... Creating Procedure: archMiningPickJobsByMiningAppId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMiningPickJobsByMiningAppId
  @i_miningAppId integer,
  @i_today integer,
  @i_order integer
AS
  DECLARE @r_jobId integer;
  DECLARE @r_commCellId integer;
  DECLARE @r_appId integer;
  DECLARE @r_startDate integer;
  DECLARE @r_miningArchGrpId integer;
  DECLARE @r_selected integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #notSelectedJob (jobId INT, commCellId INT, bkpLevel INT, startDate INT, fullCycleNum INT, selected INT)
DECLARE	@FULL_BITS		INT
SET		@FULL_BITS		= (1+64+128+1024+32768)
DECLARE	@l_appId 			INT
DECLARE @l_enabled			INT
DECLARE	@l_type				INT
DECLARE	@l_flags			INT
DECLARE	@l_startTime		INT
DECLARE	@l_numPeriod		INT
DECLARE	@l_dayNumber		INT
DECLARE	@l_currPeriodBegin	INT
DECLARE	@l_currPeriodEnd	INT
DECLARE	@l_prevPeriodBegin	INT
DECLARE	@l_nextPeriodEnd	INT
DECLARE	@l_clientId			INT
DECLARE	@t_startDate		INT
SET		@l_appId			= 0
SET		@l_type				= 0
SET		@t_startDate		= 0
DECLARE	@l_miningArchGrpId	INT
SET		@l_miningArchGrpId	= 0
SELECT	@l_miningArchGrpId = dataArchGrpId, @l_clientId = clientId
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @i_miningAppId
IF @l_miningArchGrpId <= 1
	GOTO OUTPUT_EXIT
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags,
		@l_startTime = startTime, @l_numPeriod = numPeriod, @l_dayNumber = dayNumber,
		@l_currPeriodBegin = currPeriodBegin, @l_currPeriodEnd = currPeriodEnd,
		@l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	archGroupMiningProp WITH (NOLOCK)
WHERE	archGroupId = @l_miningArchGrpId
IF	@l_enabled = 0 OR @l_type IN (0, 9) OR @l_startTime > @i_today
	GOTO OUTPUT_EXIT
INSERT	INTO #notSelectedJob
SELECT	TOP 1 B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 1
FROM	JMBkpStats B WITH (NOLOCK), JMJobMiningStats S WITH (NOLOCK)
WHERE	B.appId = @l_appId AND B.servStartDate > @l_startTime
	AND	S.miningAppId = @i_miningAppId
	AND S.jobId = B.jobId AND S.commCellId = B.commCellId
	AND S.miningStatus IN (0, 1)
ORDER BY B.servStartDate DESC
SELECT	@t_startDate = startDate
FROM	#notSelectedJob
IF	@l_startTime < @t_startDate
SET	@l_startTime = @t_startDate
INSERT	INTO #notSelectedJob
SELECT	DISTINCT B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 0
FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK), archGroupCopy C WITH (NOLOCK)
WHERE	B.appId = @l_appId AND B.servStartDate > @l_startTime AND B.opType IN (59, 65)
	AND	J.jobId = B.jobId AND J.commCellId = B.commCellId AND J.dataType IN (1, 4)
	AND J.archGrpCopyId = C.id AND C.isSnapCopy = 1
	AND J.status = 100 AND J.disabled & (1+256) = 0
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
BEGIN
	INSERT	INTO JMJobMiningStats (
			jobId, commCellId, appId, miningAppId, miningArchGrpId, miningStatus, miningJobId, miningCommCellId, flags)
	SELECT	DISTINCT jobId, commCellId, @l_appId, @i_miningAppId, @l_miningArchGrpId, 0, 0, 0, 0
	FROM	#notSelectedJob
	WHERE	selected = 0
	TRUNCATE TABLE #notSelectedJob
END
IF	@l_type IN (3, 2, 4, 6)
BEGIN
	DECLARE	@l_TimeZoneType	INT
	DECLARE @l_TimeZone		VARCHAR(255)
	DECLARE @l_csTimeZone	VARCHAR(255)
	SELECT	@l_TimeZoneType = TimeZoneType, @l_TimeZone = TimeZone
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @l_miningArchGrpId
	IF	@l_TimeZoneType > 0
		SET @l_csTimeZone = dbo.GetClientTimeZone(2)
	IF	@l_TimeZoneType = 1
	BEGIN
		SET @l_TimeZone = dbo.ArchGroupTimeZone(@l_miningArchGrpId, @l_clientId)
		IF @l_TimeZone <> @l_csTimeZone
			UPDATE	#notSelectedJob
			SET		startDate = startDate + dbo.GetDiffFromCSTimeZone(J.startDate, @l_TimeZone, @l_csTimeZone)
	END
	ELSE
	IF	@l_TimeZoneType = 2 AND @l_TimeZone <> @l_csTimeZone
		UPDATE	#notSelectedJob
		SET		startDate = startDate + dbo.GetDiffFromCSTimeZone(startDate, @l_TimeZone, @l_csTimeZone)
IF	(@l_flags & 4096) <> 0
	BEGIN
		DECLARE	@nextFullTime	INT
		DECLARE	@tblNextFullTime TABLE (nextFullTime int)
		INSERT	INTO @tblNextFullTime
		EXEC	@nextFullTime = TM_GetNextScheduleRunTime @l_appId, 1/*BkpLevel Full*/, 1/*counDisabled*/, 1/*countRunnigJob*/
		IF	@nextFullTime > 0 AND @l_TimeZone <> '' AND @l_TimeZone <> @l_csTimeZone
			SET	@nextFullTime = @nextFullTime + dbo.GetDiffFromCSTimeZone(@nextFullTime, @l_TimeZone, @l_csTimeZone)
IF	(@l_flags & 8192) = 0
		BEGIN
			IF	@nextFullTime >= @l_prevPeriodBegin AND @nextFullTime < @l_currPeriodBegin
			AND @t_startDate  >= @l_prevPeriodBegin AND @t_startDate  < @l_currPeriodBegin
				DELETE	FROM #notSelectedJob
				WHERE	startDate >= @l_prevPeriodBegin AND startDate < @l_currPeriodBegin
			IF	@nextFullTime >= @l_currPeriodBegin AND @nextFullTime < @l_currPeriodEnd
			AND @t_startDate  >= @l_currPeriodBegin AND @t_startDate  < @l_currPeriodEnd
				DELETE	FROM #notSelectedJob
				WHERE	startDate >= @l_currPeriodBegin AND startDate < @l_currPeriodEnd
			IF	@nextFullTime >= @l_currPeriodEnd AND @nextFullTime < @l_nextPeriodEnd
			AND @t_startDate  >= @l_currPeriodEnd AND @t_startDate  < @l_nextPeriodEnd
				DELETE	FROM #notSelectedJob
				WHERE	startDate >= @l_currPeriodEnd AND startDate < @l_nextPeriodEnd
		END
		ELSE
IF	(@l_flags & 8192) <> 0
		BEGIN
			DELETE	#notSelectedJob
			WHERE	@nextFullTime >= @l_prevPeriodBegin AND startDate >= @l_prevPeriodBegin AND
					@nextFullTime <  @l_currPeriodBegin AND startDate <  @l_currPeriodBegin
				 OR @nextFullTime >= @l_currPeriodBegin AND startDate >= @l_currPeriodBegin AND
					@nextFullTime <  @l_currPeriodEnd   AND startDate <  @l_currPeriodEnd
				 OR @nextFullTime >= @l_currPeriodEnd   AND startDate >= @l_currPeriodEnd   AND
					@nextFullTime <  @l_nextPeriodEnd   AND startDate <  @l_nextPeriodEnd
		END
	END
END
OUTPUT_EXIT:
IF	@i_order = 0
	SELECT	jobId, commCellId, @l_appId, startDate, @l_miningArchGrpId, selected
	FROM	#notSelectedJob
	ORDER BY startDate ASC
ELSE
	SELECT	jobId, commCellId, @l_appId, startDate, @l_miningArchGrpId, selected
	FROM	#notSelectedJob
	ORDER BY startDate DESC
DROP TABLE #notSelectedJob
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMiningPickJobsByMiningAppId')
	delete from GxQscripts where name = 'archMiningPickJobsByMiningAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMiningPickJobsByMiningAppId')
	delete from GXDBVersions where aliasname = 'archMiningPickJobsByMiningAppId'
GO

insert into GXDBVersions values(2, 'archMiningPickJobsByMiningAppId',  '00010007003400020000', 'archMiningPickJobsByMiningAppId', '00010007003400020000')
GO

