

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMiningPickJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMiningPickJobs.sp,v $ $Id: archMiningPickJobs.sp,v 1.1.278.2 2018/03/22 01:18:19 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMiningPickJobs <<<'

IF EXISTS (select * from sysobjects where name='archMiningPickJobs')
	drop procedure archMiningPickJobs
IF EXISTS (select * from GxQscripts where name='archMiningPickJobs')
	delete from GxQscripts where name = 'archMiningPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMiningPickJobs')
	delete from GXDBVersions where aliasname = 'archMiningPickJobs'
GO
print '... Creating Procedure: archMiningPickJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archMiningPickJobs
  @i_miningAppId integer,
  @i_jobIdsXml xml
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #tempJobIds (jobId int, commCellId int, appId int, hasSource int)
INSERT	INTO #tempJobIds
SELECT	T.c.value('@jobId', 'int'), T.c.value('@commCellId', 'int'), 0, 0
FROM	@i_jobIdsXml.nodes('/r/h') T(c)
DECLARE	@l_miningArchGrpId INT = 0
SELECT	@l_miningArchGrpId = dataArchGrpId
FROM	APP_Application
WHERE	id = @i_miningAppId
IF	@l_miningArchGrpId = 0
SET @retVal = 80
BEGIN
	UPDATE	#tempJobIds
	SET		appId = J.appId, hasSource = 1
	FROM	archGroup AG WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK), #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
AND J.dataType IN (1, 4)
		AND J.archGrpId = AG.id AND J.archGrpCopyId = AG.defaultSnapCopy
		AND J.status = 100 AND J.disabled & (1+256) = 0
	DELETE	#tempJobIds
	FROM	JMJobMiningStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.miningAppId = @i_miningAppId
		AND (J.miningStatus <> 2 OR T.hasSource = 1)
	INSERT	INTO JMJobMiningStats (
			jobId, commCellId, appId, miningAppId, miningArchGrpId, miningStatus, miningJobId, miningCommCellId, flags)
	SELECT	DISTINCT jobId, commCellId, appId, @i_miningAppId, @l_miningArchGrpId, 0, 0, 0, 0
	FROM	#tempJobIds
	WHERE	hasSource = 1
END
SELECT	@retVal
DROP TABLE #tempJobIds
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMiningPickJobs')
	delete from GxQscripts where name = 'archMiningPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMiningPickJobs')
	delete from GXDBVersions where aliasname = 'archMiningPickJobs'
GO

insert into GXDBVersions values(2, 'archMiningPickJobs',  '00010001027800020000', 'archMiningPickJobs', '00010001027800020000')
GO

