

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMgrViewer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMgrViewer.sp,v $ $Id: archMgrViewer.sp,v 1.9.48.2 2018/03/22 01:13:04 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMgrViewer <<<'

IF EXISTS (select * from sysobjects where name='archMgrViewer')
	drop procedure archMgrViewer
IF EXISTS (select * from GxQscripts where name='archMgrViewer')
	delete from GxQscripts where name = 'archMgrViewer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMgrViewer')
	delete from GXDBVersions where aliasname = 'archMgrViewer'
GO
print '... Creating Procedure: archMgrViewer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMgrViewer
  @i_ChunkId int,
  @i_archFileId int,
  @i_JobId int,
  @i_commCellId int,
  @i_barCode nvarchar(255),
  @i_volName nvarchar(255),
  @i_mountPathName nvarchar(255),
  @i_QueryType int
AS
  DECLARE @o_clientId int
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_archFileId int
  DECLARE @o_archFileName NVARCHAR(2048)
  DECLARE @o_appId int
  DECLARE @o_commCellId int
  DECLARE @o_archGroupId int
  DECLARE @o_archChunkId int
  DECLARE @o_volumeId int
  DECLARE @o_jobId int
  DECLARE @o_archCopyId int
  DECLARE @o_chunkNumber int
  DECLARE @o_fileMarkerNo int
  DECLARE @o_createTime int
  DECLARE @o_physicalSize int
  DECLARE @o_logicalSize int
  DECLARE @o_writeTime int
  DECLARE @o_modifiedTime int
  DECLARE @o_isValid int
  DECLARE @o_fileType int
  DECLARE @o_cTime int
  DECLARE @o_backupLevel int
SET NOCOUNT ON
IF object_id('tempdb.dbo.#temparchChunkToarchChunkMapping') IS NOT null DROP TABLE #temparchChunkToarchChunkMapping
IF object_id('tempdb.dbo.#temparchChunkMappingToarchFile') IS NOT null DROP TABLE #temparchChunkMappingToarchFile
IF object_id('tempdb.dbo.#temparchFileToJobBkpStats') IS NOT null DROP TABLE #temparchFileToJobBkpStats
IF object_id('tempdb.dbo.#temparchFileToAPPApplication') IS NOT null DROP TABLE #temparchFileToAPPApplication
IF object_id('tempdb.dbo.#tempMediaInformation') IS NOT null DROP TABLE #tempMediaInformation
IF object_id('tempdb.dbo.#tempJobData') IS NOT null DROP TABLE #tempJobData
-- Values for @i_QueryType
-- i_QueryType = 1 = Information for given ChunkId
-- i_QueryType = 2 = Information for given archFileId
-- i_QueryType = 3 = Information for given JobId
-- i_QueryType = 4 = Information for given Media Barcode
-- i_QueryType = 5 = Information for given Volume Name
-- i_QueryType = 6 = Information for given Mount Path Name
CREATE TABLE #temparchChunkToarchChunkMapping
(
	archChunkId			bigint,
	commcellId			int,
	archFileId			int,
	archCopyId			int,
	chunkNumber			int,
	volumeId			int,
	fileMarkerNo			int,
	createTime			int,
	physicalSize		     bigint,
	logicalSize		     bigint,
	writeTime			int,
	modifiedTime			int,
	archGroupCopyName	nvarchar(64),
	PRIMARY KEY(archChunkId, commCellId, archFileId)
)
CREATE TABLE #temparchChunkMappingToarchFile
(
	archFileId			int,
	commCellId			int,
	archChunkId			bigint,
	archCopyId			int,
	chunkNumber			int,
	archGroupId			int,
	appId				int,
	subClientName		nvarchar(128),
	jobId				int,
	fileType			int,
	cTime				int,
	backupLevel			int,
	isValid				int,
	archGroupName		nvarchar(144),
archFileName		NVARCHAR(2048),
	PRIMARY KEY(archFileId, commCellId, archChunkId, archCopyId)
)
CREATE TABLE #temparchFileToJobBkpStats
(
	archFileId			int,
	commCellId			int,
	jobId				int,
	appId				int,
	copyId				int,
	bkpLevel			int
)
CREATE TABLE #temparchFileToAPPApplication
(
	clientId			int,
	appId				int,
	clientName			nvarchar(255),
	backupSet			int,
	backupSetName		nvarchar(255),
	instance			int,
	instanceName		nvarchar(255),
	appTypeId			int,
	appTypeName			nvarchar(255)
)
CREATE TABLE #tempMediaInformation
(
	volumeId			int,
	MMMediaId			int,
	MMMediaSideId		int,
	barcode				varchar(256),
	MountPathName		nvarchar(1024),
	volName				nvarchar(255)
)
CREATE TABLE #tempJobData
(
	jobId				int,
	commCellId			int,
	appId				int,
	minStatus			int,
	maxStatus			int,
	disabled			int,
	toBeCopied			int,
	jobCopyAttributes	int,
	physicalSize		bigint,
	errorCode			int,
	archCheckEndTime	int,
	archCheckStatus		int,
	extRetentionFlags	int,
	retentionDays		int,
	manualRetentionEndTime bigint,
	copiedTime			int,
	agedTime			int,
	copyId				int,
	PRIMARY KEY(jobId, commCellId, copyId)
)
DECLARE @regularAge	INT
DECLARE @archiverAge INT
-- Values for @i_QueryType
-- i_QueryType = 1 = Information for given ChunkId
-- i_QueryType = 2 = Information for given archFileId
-- i_QueryType = 3 = Information for given JobId
--Insert into temparchChunktoarchChunkMapping for given ChunkId
IF @i_QueryType = 1
BEGIN
	INSERT INTO #temparchChunkToarchChunkMapping
		SELECT AC.id as archChunkId, AC.commCellId, ACM.archFileId, ACM.archCopyId, ACM.chunkNumber, AC.volumeId, AC.fileMarkerNo, AC.createTime,
			AC.physicalSize, AC.logicalSize, AC.writeTime, AC.modifiedTime, ''
		FROM archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK)
		WHERE AC.id = ACM.archChunkId and AC.id = @i_ChunkId and AC.commCellId = @i_commCellId
	UPDATE #temparchChunkToarchChunkMapping
	SET archGroupCopyName = AGC.name
	FROM archGroupCopy AGC
	WHERE archCopyId = AGC.id
	INSERT INTO #temparchChunkMappingToarchFile
		SELECT ACM.archFileId, ACM.commCellId, ACM.archChunkId, ACM.archCopyId, ACM.chunkNumber, AF.archGroupId,
			AF.appId, '', AF.jobId, AF.fileType, AF.cTime, AF.backupLevel, AF.isValid, AG.name as archGroupName, AF.name as archFileName
		FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE ACM.archFileId = AF.id and
			ACM.commCellId = AF.commCellId and
			AF.archGroupId = AG.id and
			ACM.archChunkId = @i_ChunkId and
			AF.commCellId = @i_commCellId
	UPDATE #temparchChunkMappingToarchFile
	SET subClientName = APP.subClientName
	FROM APP_Application APP
	WHERE appId = APP.id
	INSERT INTO #temparchFileToJobBkpStats
		SELECT T.archFileId, T.commCellId, T.jobId, T.appId, JBS.copyId, JBS.bkpLevel
		FROM #temparchChunkMappingToarchFile T, JMBkpStats JBS WITH (NOLOCK)
		WHERE T.commCellId = JBS.commCellId and
			T.jobId = JBS.jobId
END
ELSE
IF @i_QueryType = 2
BEGIN
	INSERT INTO #temparchChunkMappingToarchFile
		SELECT ACM.archFileId, AF.commCellId, ACM.archChunkId, ACM.archCopyId, ACM.chunkNumber, AF.archGroupId,
			AF.appId, '', AF.jobId, AF.fileType, AF.cTime, AF.backupLevel, AF.isValid, AG.name as archGroupName, AF.name as archFileName
		FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE ACM.archFileId = AF.id and
			ACM.commCellId = AF.commCellId and
			AF.archGroupId = AG.id and
			AF.Id = @i_archFileId and
			AF.commCellId = @i_commCellId
	UPDATE #temparchChunkMappingToarchFile
	SET subClientName = APP.subClientName
	FROM APP_Application APP
	WHERE appId = APP.id
	INSERT INTO #temparchChunkToarchChunkMapping
		SELECT AC.id as archChunkId, AC.commCellId, T.archFileId, T.archCopyId, T.chunkNumber, AC.volumeId, AC.fileMarkerNo, AC.createTime,
			AC.physicalSize, AC.logicalSize, AC.writeTime, AC.modifiedTime, ''
		FROM archChunk AC WITH (NOLOCK), #temparchChunkMappingToarchFile T
		WHERE AC.id = T.archChunkId and
		AC.commCellId = T.commCellId
	UPDATE #temparchChunkToarchChunkMapping
	SET archGroupCopyName = AGC.name
	FROM archGroupCopy AGC
	WHERE archCopyId = AGC.id
	INSERT INTO #temparchFileToJobBkpStats
		SELECT T.archFileId, T.commCellId, T.jobId, T.appId, JBS.copyId, JBS.bkpLevel
		FROM #temparchChunkMappingToarchFile T, JMBkpStats JBS WITH (NOLOCK)
		WHERE T.commCellId = JBS.commCellId and
			T.jobId = JBS.jobId
END
ELSE
IF @i_QueryType = 3
BEGIN
	INSERT INTO #temparchFileToJobBkpStats
		SELECT AF.Id archFileId, AF.commCellId, AF.jobId, AF.appId, JBS.copyId, JBS.bkpLevel
		FROM archFile AF WITH (NOLOCK), JMBkpStats JBS WITH (NOLOCK)
		WHERE AF.commCellId = JBS.commCellId and
			AF.jobId = JBS.jobId and
			JBS.jobId = @i_jobId and
			AF.commCellId = @i_commCellId
	INSERT INTO #temparchChunkMappingToarchFile
		SELECT AF.id as archFileId, AF.commCellId, ACM.archChunkId, ACM.archCopyId, ACM.chunkNumber, AF.archGroupId,
			AF.appId, '', AF.jobId, AF.fileType, AF.cTime, AF.backupLevel, AF.isValid, AG.name as archGroupName, AF.name as archFileName
		FROM archChunkMapping ACM, archFile AF, #temparchFileToJobBkpStats T, archGroup AG WITH (NOLOCK)
		WHERE ACM.archFileId = AF.id and
			ACM.commCellId = AF.commCellId and
			AF.archGroupId = AG.id and
			T.jobId = AF.jobId and
			T.archFileId = AF.id
	UPDATE #temparchChunkMappingToarchFile
	SET subClientName = APP.subClientName
	FROM APP_Application APP
	WHERE appId = APP.id
	INSERT INTO #temparchChunkToarchChunkMapping
		SELECT AC.id as archChunkId, AC.commCellId, T.archFileId, T.archCopyId, T.chunkNumber, AC.volumeId, AC.fileMarkerNo, AC.createTime,
			AC.physicalSize, AC.logicalSize, AC.writeTime, AC.modifiedTime, ''
		FROM archChunk AC WITH (NOLOCK), #temparchChunkMappingToarchFile T
		WHERE AC.id = T.archChunkId and
		AC.commCellId = T.commCellId
	UPDATE #temparchChunkToarchChunkMapping
	SET archGroupCopyName = AGC.name
	FROM archGroupCopy AGC
	WHERE archCopyId = AGC.id
END
ELSE
IF ((@i_QueryType = 4) or (@i_QueryType = 5) or (@i_QueryType = 6))
BEGIN
	IF (@i_QueryType = 4)
        BEGIN
	        INSERT INTO #tempMediaInformation
			SELECT MMV.VolumeId, MMM.MediaId, MMV.MediaSideId, MMM.BarCode, '', MMV.VolumeName
		        FROM MMMedia MMM WITH (NOLOCK), MMVolume MMV WITH (NOLOCK)
		        WHERE MMM.BarCode = @i_barcode and
		        MMM.MediaId = MMV.MediaId
	END
	ELSE IF (@i_QueryType = 5)
	BEGIN
		INSERT INTO #tempMediaInformation
			SELECT MMV.VolumeId, MMM.MediaId, MMV.MediaSideId, MMM.BarCode, '', MMV.VolumeName
			FROM MMMedia MMM WITH (NOLOCK), MMVolume MMV WITH (NOLOCK)
			WHERE MMV.VolumeName = @i_volName and
			MMM.MediaId = MMV.MediaId
	END
	ELSE
	BEGIN
		INSERT INTO #tempMediaInformation
			SELECT MMV.VolumeId, MMV.MediaId, MMV.MediaSideId, 'CV_MAGNETIC', MMMP.MountPathName, MMV.VolumeName
			FROM MMS2getMountPathNameGUIView MMMP WITH (NOLOCK), MMVolume MMV WITH (NOLOCK)
			WHERE MMMP.MountPathName = @i_mountPathName and
			MMMP.MediaSideId = MMV.MediaSideId
	END
	INSERT INTO #temparchChunkToarchChunkMapping
		SELECT AC.id as archChunkId, AC.commCellId, ACM.archFileId, ACM.archCopyId, ACM.chunkNumber, AC.volumeId, AC.fileMarkerNo, AC.createTime,
			AC.physicalSize, AC.logicalSize, AC.writeTime, AC.modifiedTime, ''
		FROM archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), #tempMediaInformation T
		WHERE AC.id = ACM.archChunkId and AC.volumeId = T.VolumeId and AC.commCellId = @i_commCellId
	UPDATE #temparchChunkToarchChunkMapping
	SET archGroupCopyName = AGC.name
	FROM archGroupCopy AGC
	WHERE archCopyId = AGC.id
	INSERT INTO #temparchChunkMappingToarchFile
		SELECT ACM.archFileId, ACM.commCellId, ACM.archChunkId, ACM.archCopyId, ACM.chunkNumber, AF.archGroupId,
			AF.appId, '', AF.jobId, AF.fileType, AF.cTime, AF.backupLevel, AF.isValid, AG.name as archGroupName, AF.name as archFileName
		FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), archGroup AG WITH (NOLOCK), #temparchChunkToarchChunkMapping T
		WHERE ACM.archFileId = AF.id and
			ACM.commCellId = AF.commCellId and
			AF.archGroupId = AG.id and
			ACM.archChunkId = T.archChunkId and
			T.archFileId = AF.id and
			T.commcellId = AF.commCellId
	UPDATE #temparchChunkMappingToarchFile
	SET subClientName = APP.subClientName
	FROM APP_Application APP
	WHERE appId = APP.id
	INSERT INTO #temparchFileToJobBkpStats
		SELECT T.archFileId, T.commCellId, T.jobId, T.appId, JBS.copyId, JBS.bkpLevel
		FROM #temparchChunkMappingToarchFile T, JMBkpStats JBS WITH (NOLOCK)
		WHERE T.commCellId = JBS.commCellId and
			T.jobId = JBS.jobId
END
	INSERT INTO #temparchFileToAPPApplication
		SELECT APP.clientId, APP.id as appId, APPC.name as clientName, APP.backupSet,
		(select APPBS.name from APP_BackupSetName APPBS where APPBS.id = APP.backupSet),
		APP.instance,
		(select APPI.name from APP_InstanceName APPI where APPI.id = APP.instance),
		APP.appTypeId,
		(select APPIDA.name from APP_iDAType APPIDA where APPIDA.type = APP.appTypeId)
		FROM #temparchFileToJobBkpStats T, APP_Application APP WITH (NOLOCK), APP_Client APPC WITH (NOLOCK)
		WHERE APP.id = T.appId and
		APP.clientId = APPC.id
		GROUP BY APP.clientId, APP.id, APPC.name, APP.backupSet, APP.instance, APP.appTypeId
IF ((@i_QueryType <> 4) and (@i_QueryType <> 5) and (@i_QueryType <> 6))
BEGIN
	INSERT INTO #tempMediaInformation
		SELECT DISTINCT(T.volumeId), MMV.MediaId, MMV.MediaSideId, MMM.barcode, '', MMV.VolumeName
		FROM #temparchChunkToarchChunkMapping T, MMVolume MMV WITH (NOLOCK), MMMedia MMM WITH (NOLOCK)
		WHERE T.volumeId = MMV.volumeId and
			MMV.MediaId = MMM.MediaId
END
if (@i_QueryType <> 6)
BEGIN
	UPDATE #tempMediaInformation
	SET Mountpathname = MMMP.MountPathName
	FROM MMS2getMountPathNameGUIView MMMP WITH (NOLOCK)
	WHERE MMMediaSideId = MMMP.MediaSideId
END
INSERT	INTO #tempJobData
	SELECT	J.jobId, J.commCellId, J.appId,
		MIN(J.status), MAX(J.status), MAX(J.disabled), 0, 0, 0, 0,
		MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
		MAX(J.retentionFlags), 0, MAX(J.manualRetentionEndTime),
		MAX(J.copiedTime), MAX(J.agedTime), J.archGrpCopyId
	FROM	JMJobDataStats J WITH (NOLOCK), #temparchFileToJobBkpStats T, #temparchChunkToarchChunkMapping T2
	WHERE  	J.archGrpCopyId = T2.archCopyId
	AND J.jobId = T.jobId
	and J.commCellId = T2.commCellId
	GROUP BY J.jobId, J.commCellId, J.appId, J.archGrpCopyId
UPDATE #tempJobData
SET retentionDays = AAR.retentionDays
FROM archAgingRule AAR, #tempJobData T
WHERE AAR.copyId = T.copyId
IF @regularAge >= 0
BEGIN
	CREATE	TABLE #tempAgingRulesExt(retentionDays INT, retentionRule INT, copyId INT)
	INSERT	INTO #tempAgingRulesExt
	SELECT	AARE.retentionDays, AARE.retentionRule, T.archCopyId
	FROM	archAgingRuleExtended AARE WITH (NOLOCK), #temparchChunkToarchChunkMapping T
	WHERE	AARE.copyId = T.archCopyId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
	BEGIN
		DECLARE @l_ExtRetentionRuleSum	INT
		DECLARE @sumRetentionRule CURSOR
		SET @sumRetentionRule = CURSOR FOR
		SELECT	SUM(T.retentionRule), T.copyId FROM #tempAgingRulesExt T GROUP BY T.copyId
		OPEN @sumRetentionRule FETCH NEXT
		FROM @sumRetentionRule INTO @l_ExtRetentionRuleSum
		WHILE @@FETCH_STATUS = 0
		BEGIN
			UPDATE	#tempJobData
			SET		extRetentionFlags = (
					case
					when extRetentionFlags & 64 <> 0 then 64
					when extRetentionFlags & 32 <> 0 then 32
					when extRetentionFlags & 16 <> 0 then 16
					when extRetentionFlags & 8 <> 0 then 8
					when extRetentionFlags & 4 <> 0 then 4
					when extRetentionFlags & 2 <> 0 then 2
					end)
			FROM #temparchChunkToarchChunkMapping T
			WHERE	extRetentionFlags & @l_ExtRetentionRuleSum <> 0 and copyId = T.archCopyId
			FETCH NEXT FROM @sumRetentionRule INTO @l_ExtRetentionRuleSum
END
		UPDATE	#tempJobData
		SET		retentionDays = b.retentionDays
		FROM	#tempJobData a, #tempAgingRulesExt b
		WHERE	b.retentionRule = a.extRetentionFlags
			AND (b.retentionDays < 0 OR b.retentionDays > a.retentionDays)
	END
	DROP TABLE #tempAgingRulesExt
	CLOSE @sumRetentionRule
	DEALLOCATE @sumRetentionRule
END
SELECT T5.clientId, T5.clientName, T3.archFileId, T3.archFileName, T3.appId as subClientId, T3.subClientName, T3.commCellId, T3.archGroupId, T3.archGroupName as storagePolicyName, T1.archChunkId, T1.volumeId, T3.jobId, T1.archCopyId as copyId, T1.archGroupCopyName as copyName, T1.chunkNumber,
T1.fileMarkerNo, dbo.getDateTime(T1.createTime) as ChunkCreateTime, T1.physicalSize, T1.logicalSize, T1.writeTime, dbo.getDateTime(T1.modifiedTime) as modifiedTime, T3.isValid, T3.fileType, dbo.getDateTime(T3.cTime) as archFileCreateTime, T3.backupLevel, T6.barcode, T6.MountPathName, T7.retentionDays, T5.backupSet, T5.instance, T5.appTypeId,
T5.backupSetName, T5.instanceName, T5.appTypeName, T6.volName
FROM #temparchChunkToarchChunkMapping T1, #temparchChunkMappingToarchFile T3, #temparchFileToAPPApplication T5, #tempMediaInformation T6, #tempJobData T7
WHERE T1.archFileId = T3.archFileId and
T1.commCellId = T3.commCellId and
T1.archChunkId = T3.archChunkId and
T1.archCopyId = T3.archCopyId and
T1.volumeId = T6.volumeId and
T3.jobId = T7.jobId and
T3.commCellId = T7.commCellId and
T1.archCopyId = T7.copyId and
T3.appId = T5.appId
delete from #temparchChunkToarchChunkMapping
delete from #temparchChunkMappingToarchFile
delete from #temparchFileToJobBkpStats
delete from #temparchFileToAPPApplication
delete from #tempMediaInformation
delete from #tempJobData
DROP TABLE #temparchChunkToarchChunkMapping
DROP TABLE #temparchChunkMappingToarchFile
DROP TABLE #temparchFileToJobBkpStats
DROP TABLE #temparchFileToAPPApplication
DROP TABLE #tempMediaInformation
DROP TABLE #tempJobData
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archMgrViewer')
	delete from GxQscripts where name = 'archMgrViewer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMgrViewer')
	delete from GXDBVersions where aliasname = 'archMgrViewer'
GO

insert into GXDBVersions values(2, 'archMgrViewer',  '00010009004800020000', 'archMgrViewer', '00010009004800020000')
GO

