

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMediaRefreshingQualifyMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMediaRefreshingQualifyMedia.sp,v $ $Id: archMediaRefreshingQualifyMedia.sp,v 1.20.2.3 2018/06/05 06:18:16 daruloli Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMediaRefreshingQualifyMedia <<<'

IF EXISTS (select * from sysobjects where name='archMediaRefreshingQualifyMedia')
	drop procedure archMediaRefreshingQualifyMedia
IF EXISTS (select * from GxQscripts where name='archMediaRefreshingQualifyMedia')
	delete from GxQscripts where name = 'archMediaRefreshingQualifyMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingQualifyMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingQualifyMedia'
GO
print '... Creating Procedure: archMediaRefreshingQualifyMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMediaRefreshingQualifyMedia
  @i_archGroupd INTEGER,
  @i_copyId INTEGER,
  @i_daysInAdvance BIGINT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE	@MAXINT	INTEGER
--SET		@MAXINT = 0x7FFFFFFF
DECLARE @magRefreshCopies TABLE(srcCopyId INTEGER,TranCopyId INTEGER)
INSERT @magRefreshCopies
SELECT DISTINCT sourceCopyId,id FROM archGroupCopy AGC WITH (READUNCOMMITTED), JMJobDataStats JDS WITH (READUNCOMMITTED) WHERE AGC.archGroupId = @i_archGroupd
AND (@i_copyId = 0 OR AGC.sourceCopyId = @i_copyId)
AND AGC.type = 5 AND AGC.id = JDS.archGrpCopyId AND JDS.status IN (101,102,103) AND (disabled & 1 = 0)
IF EXISTS (SELECT 1 FROM @magRefreshCopies)
BEGIN
-- make checks again
	IF EXISTS ( SELECT TOP 1 1
	FROM archGroupCopy AGC WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED),@magRefreshCopies C
	WHERE AGC.id = DP.CopyId
	AND DP.SpareGroupId <> 0
	AND AGC.id = C.srcCopyId)
	BEGIN
		UPDATE JDS
SET disabled |= 1
		FROM JMJobDataStats JDS
		INNER JOIN @magRefreshCopies MR
		ON JDS.archGrpCopyId = MR.TranCopyId
	END
	IF EXISTS ( SELECT TOP 1 1
	FROM JMJobDataStats JDS WITH (READUNCOMMITTED), @magRefreshCopies
	WHERE JDS.archGrpCopyId = srcCopyId
AND (JDS.disabled & 64 > 0 OR JDS.disabled & 256 > 0))
	BEGIN
		UPDATE JDS
SET disabled |= 1
		FROM JMJobDataStats JDS
		INNER JOIN @magRefreshCopies MR
			ON JDS.archGrpCopyId = MR.TranCopyId
		INNER JOIN (SELECT jobId,commcellId,dataType FROM JMJobDataStats WITH (READUNCOMMITTED), @magRefreshCopies
				WHERE archGrpCopyId = srcCopyId
AND (disabled & 64 > 0 OR disabled & 256 > 0)) S
			ON S.jobId = JDS.jobId
		AND S.commCellId = JDS.commCellId
		AND S.dataType = JDS.dataType
	END
-- Not really needed but for safety.
	UPDATE AGCD
	SET SIDBStoreId = AGCS.SIDBStoreId, dedupeFlags = AGCS.dedupeFlags, SIDBSnapIntervalHours = AGCS.SIDBSnapIntervalHours, sealStoreTaskId = AGCS.sealStoreTaskId
	, nDataInstance = AGCS.nDataInstance, DDBLimitExtensionTimeStamp = AGCS.DDBLimitExtensionTimeStamp, DDBLimitExtensionTimeStampEncrypted = AGCS.DDBLimitExtensionTimeStampEncrypted
	FROM archGroupCopy AGCD, archGroupCopy AGCS WITH (READUNCOMMITTED), @magRefreshCopies MR
	WHERE AGCD.id = MR.TranCopyId
	AND AGCD.sourceCopyId = AGCS.id
END
IF  NOT EXISTS (SELECT 1 FROM @magRefreshCopies)
OR
(SELECT COUNT(*)  - (SELECT COUNT(*) FROM @magRefreshCopies) FROM archGroupCopy WITH (READUNCOMMITTED)
WHERE flags & 33554432 > 0 ) <> 0
BEGIN
	DECLARE @MAXINT BIGINT
	SET @MAXINT = 0x7FFFFFFFFFFFFFFF
	DECLARE	@now	INTEGER
	SET		@now	= dbo.GetUnixTime(GETUTCDATE())
	CREATE	TABLE #Vol (CopyId INT, Stream INT, MediaGroupId INT, VolumeId INT, MediaId INT,
						MediaRefreshFlags INT, DaysBeforeAged BIGINT, ThresholdMB BIGINT,
						NumberOfRestores INT, NumberOfBackups INT, NumberOfSoftErrors INT,
						NumberOfHardErrors INT, NumberOfReUses INT,	QualifiedReason INT)
	INSERT	INTO #Vol
	SELECT	MG.archGroupCopyId, MG.stream, MG.mediaGroupId, V.VolumeId, V.MediaId,
			MR.flags, MR.daysBeforeAged, MS.TotalSpaceMB * MR.percentage /100,
			MS.NumberOfRestores, MS.NumberOfBackups, MS.NumberOfSoftErrors,
			MS.NumberOfHardErrors, MS.NumberOfReUses, 0
	FROM	archGroupCopy AGC WITH (NOLOCK),
			archCopyMediaRefreshProp MR WITH (NOLOCK),
			archStream MG WITH (NOLOCK),
			MMVolume V WITH (NOLOCK),
			MMMediaSide MS WITH (NOLOCK)
	WHERE (@i_archGroupd = 0 OR AGC.archGroupId = @i_archGroupd)
		AND (@i_copyId = 0 OR AGC.id = @i_copyId)
AND (AGC.flags & 33554432) <> 0
		AND AGC.siloAppId = 0
		AND MR.copyId = AGC.Id
		AND MG.archGroupCopyId = AGC.id
		AND V.MediaGroupId = MG.mediaGroupId
		AND MS.MediaSideId = V.MediaSideId
		AND V.VolumeFlags = 2 /*VOL_FULL*/
		AND V.RecordingFormatId <> 10001
AND (V.Attributes & (8 | 16)) = 0
		AND (V.LastBackupTime + CONVERT(BIGINT,MR.daysAfterWritten)*24*3600) < (@now + @i_daysInAdvance * 24 * 3600)
	-- check Media Retirement Threshold
IF EXISTS (SELECT CopyId FROM #Vol WHERE (MediaRefreshFlags & 1) > 0)
	BEGIN
		UPDATE	#Vol
SET		QualifiedReason = (QualifiedReason | 256)
		FROM	MMMedia M WITH (NOLOCK), MMMediaType MT WITH (NOLOCK)
WHERE	(#Vol.MediaRefreshFlags & 1) > 0
			AND #Vol.MediaId = M.MediaId
			AND M.MediaTypeId = MT.MediaTypeId
			AND (#Vol.NumberOfSoftErrors >= MT.NumberOfSoftErrorsThreshold
			  OR #Vol.NumberOfHardErrors >= MT.NumberOfHardErrorsThreshold
			  OR #Vol.NumberOfReUses >= MT.NumberOfReUsesThreshold
			  OR (#Vol.NumberOfRestores + #Vol.NumberOfBackups) >= MT.ShortLengthDurabilityThreshold
			  OR DATEDIFF(month, DATEADD(second, M.CreationTime, '01/01/1970'), getutcdate()) >= MT.MonthsInUseThreshold)
	END
	-- check percentage of valid data out of capacity
	IF EXISTS (SELECT CopyId FROM #Vol WHERE ThresholdMB > 0)
	BEGIN
		CREATE	TABLE #VolDataSize (VolumeId INT, TotalDataSizeMB BIGINT)
		INSERT	INTO #VolDataSize
		SELECT	V.VolumeId, SUM(ACM.physicalSize)/1024/1024
		FROM	#Vol V, archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK)
		WHERE	AC.volumeId = V.VolumeId AND V.ThresholdMB > 0
			AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
		GROUP BY V.VolumeId
		UPDATE	#Vol
SET		QualifiedReason = (QualifiedReason | 128)
		FROM	#VolDataSize T
		WHERE	#Vol.VolumeId = T.VolumeId
			AND #Vol.ThresholdMB >= T.TotalDataSizeMB
		DROP	TABLE #VolDataSize
	END
	DELETE	#Vol
	WHERE	QualifiedReason = 0
AND ((MediaRefreshFlags & 1) > 0 OR ThresholdMB > 0)
	-- check aging date. Don't count cycle and chaining.
	IF EXISTS (SELECT CopyId FROM #Vol WHERE DaysBeforeAged > 0)
	BEGIN
		CREATE	TABLE #VolJob (
				volumeId INT, jobId INT, archGrpCopyId INT, commCellId INT, agingTime BIGINT,
				retentionFlags INT, pinEndTime BIGINT, jobStartDate INT, appType INT, retentionDays BIGINT)
		CREATE	TABLE #CopyAgingRule (
				CopyId INT, RetentionDays BIGINT, ArchiverRetDays BIGINT, ExtendedRetDays BIGINT, ExtendedRetRule INT)
		INSERT	INTO #CopyAgingRule
		SELECT	AR.copyId,
				CASE WHEN AR.RetentionDays  = -1 THEN @MAXINT ELSE AR.RetentionDays END,
				CASE WHEN AR.ArchiverRetDays = -1 THEN @MAXINT ELSE AR.ArchiverRetDays END,
				CASE WHEN ARE.copyId IS NULL THEN 0 WHEN ARE.RetentionDays = -1 THEN @MAXINT ELSE ARE.RetentionDays END,
				ISNULL(ARE.RetentionRule, 0)
		FROM	#Vol V
INNER JOIN (SELECT AGC.id, AG.flags & 16384  'GSCPFlag'
							FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
							WHERE AGC.archGroupId = AG.id) AGF
						ON	AGF.id = V.CopyId
				INNER JOIN archGroupCopy  AGC WITH (NOLOCK)
						ON	(( AGF.GSCPFlag > 0 AND AGC.destMediaCopyId = AGF.id) OR (AGF.GSCPFlag = 0 AND AGC.Id = AGF.id))
				INNER JOIN archAgingRule AR WITH (NOLOCK)
						ON	AR.CopyId = AGC.id
				LEFT OUTER JOIN archAgingRuleExtended ARE WITH (NOLOCK)
						ON	ARE.copyId = AR.copyId
		INSERT	INTO #VolJob
		SELECT	DISTINCT V.VolumeId, AF.jobId, ACM.archCopyId, ACM.commCellId,
				@now + (V.DaysBeforeAged + @i_daysInAdvance) * 24 * 3600,
				0, 0, 0, 0, 0
		FROM	#Vol V, archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK)
		WHERE	AC.volumeId = V.VolumeId AND V.QualifiedReason = 0
			AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
			AND AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1
		UPDATE	#VolJob
		SET		retentionFlags = J.retentionFlags , pinEndTime = (CASE WHEN J.manualRetentionEndTime  = -1 THEN @MAXINT ELSE J.manualRetentionEndTime END)
		FROM	#VolJob V, JMJobDataStats J WITH (NOLOCK)
		WHERE	J.jobId = V.jobId AND J.archGrpCopyId = V.archGrpCopyId AND J.commCellId = V.commCellId
		UPDATE	#VolJob
		SET		jobStartDate = J.servStartDate, appType = J.appType
		FROM	#VolJob V, JMBkpStats J WITH (NOLOCK)
		WHERE	J.jobId = V.jobId AND J.commCellId = V.commCellId
		UPDATE	#VolJob
		SET		jobStartDate = J.servStart, appType = 1000
		FROM	#VolJob V, JMAdminJobStatsTable J WITH (NOLOCK)
		WHERE	J.jobId = V.jobId AND J.commCellId = V.commCellId
		UPDATE	#VolJob
		SET		retentionDays = CASE WHEN IDA.isDMAppType = 1 THEN C.ArchiverRetDays ELSE C.RetentionDays END
		FROM	#VolJob V
				INNER JOIN #CopyAgingRule C ON V.archGrpCopyId = C.copyId
				LEFT OUTER JOIN APP_IDATypeHandlingInfo IDA WITH (NOLOCK) ON V.appType = IDA.appTypeId
		UPDATE	#VolJob
		SET		RetentionDays = T.ExtendedRetDays
		FROM	#VolJob V,
				(SELECT	J.jobId, J.archGrpCopyId, J.commCellId, MAX(C.ExtendedRetDays) AS ExtendedRetDays
				FROM	#VolJob J, #CopyAgingRule C
				WHERE	J.archGrpCopyId = C.copyId AND (J.retentionFlags & C.ExtendedRetRule) <> 0
				GROUP BY J.jobId, J.archGrpCopyId, J.commCellId) T
		WHERE	T.jobId = V.jobId AND T.archGrpCopyId = V.archGrpCopyId AND T.commCellId = V.commCellId
			AND T.ExtendedRetDays > V.RetentionDays
		DELETE	#Vol
		FROM	#Vol V LEFT OUTER JOIN
				(SELECT	DISTINCT VolumeId
				FROM	#VolJob
				WHERE	retentionDays = @MAXINT
					OR (jobStartDate + retentionDays*24*3600) > agingTime
					OR	pinEndTime > agingTime) T
			ON	V.VolumeId = T.VolumeId
		WHERE	T.VolumeId IS NULL AND V.QualifiedReason = 0
		DROP	TABLE #CopyAgingRule
		DROP	TABLE #VolJob
	END
	IF	@i_daysInAdvance = 0
	BEGIN
		-- Mark volumes as PICKED_FOR_REFRESHING
		-- New Media Refresh Changes
		-- April 2, 2012
		-- Verify that the selected volumes list satisfies, "Completeness Check" for media refresh. For, notes on "Completeness Check"
		-- please see notes section in archMediaRefreshGetDependentMedia.sp
		--IF  object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
		--IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
		--IF object_id('tempdb.dbo.#TmpSkippedVol') IS  NOT null DROP TABLE #TmpSkippedVol
		--
		--CREATE TABLE #TmpMRDepMediaUI(VolumeId INT)
		--CREATE TABLE #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT,
		--	MediaId INT, MediaLocation INT, MediaFlags INT)
		--CREATE TABLE #TmpSkippedVol(VolumeId INT)
		--
		--DECLARE	@depMediaOp		INT
		--INSERT INTO #TmpMRDepMediaUI
		--SELECT DISTINCT VolumeId
		--FROM #Vol
		--
		--EXEC @depMediaOp = archMediaRefreshGetDependentMedia
		--IF @depMediaOp =  0
		--BEGIN
		--
		--Filter out bad media
		--	INSERT INTO #TmpSkippedVol
		--	SELECT  DISTINCT V.VolumeId
		--	FROM	#TmpMRDepMediaResultSet	RS1
		--	JOIN	#TmpMRDepMediaResultSet	RS2
		--		ON	RS1.BucketId = RS2.BucketId
		--	JOIN	#Vol	V
		--		ON V.VolumeId = RS2.VolumeId
		--	WHERE	RS1.MediaFlags = 2
		--
		--	Filter out media whose dependent media is not in #Vol table and is not already marked for refresh.
		--	Add the conditions for picked and prevented
		--	INSERT INTO #TmpSkippedVol
		--	SELECT  DISTINCT V.VolumeId
		--	FROM	#TmpMRDepMediaResultSet	RS1
		--	JOIN	#TmpMRDepMediaResultSet	RS2
		--			ON	RS1.BucketId = RS2.BucketId
		--	JOIN	#Vol	V
		--		ON V.VolumeId = RS2.VolumeId
		--	LEFT OUTER JOIN	#Vol	V2
		--		ON V2.VolumeId = RS1.VolumeId
		--	WHERE	(RS1.VolumeAttributes & MMS2_VOLUME_PICKED_FOR_REFRESHING <> MMS2_VOLUME_PICKED_FOR_REFRESHING
		--				OR
		--			RS1.VolumeAttributes & MMS2_VOLUME_PREVENT_FOR_REFRESHING = MMS2_VOLUME_PREVENT_FOR_REFRESHING)
		--			AND	V2.VolumeId IS NULL
		--
		--	DELETE FROM #Vol
		--	WHERE VolumeId IN (SELECT VolumeId FROM #TmpSkippedVol)
		--	DROP TABLE 	#TmpMRDepMediaUI
		--	DROP TABLE	#TmpMRDepMediaResultSet
		--	DROP TABLE	#TmpSkippedVol
		--
		--END
		UPDATE	MMVolume
SET		Attributes = (V.Attributes | 8 | QualifiedReason)
		FROM	MMVolume V, #Vol T
		WHERE	V.VolumeId = T.VolumeId
	END
	ELSE
	BEGIN
		-- Return to be qualified volumes for report
		INSERT	INTO #VolForReport
SELECT  CopyId, Stream, MediaGroupId, VolumeId, MediaId, (8 | QualifiedReason)
		FROM	#Vol
	END
	DROP	TABLE #Vol
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archMediaRefreshingQualifyMedia')
	delete from GxQscripts where name = 'archMediaRefreshingQualifyMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingQualifyMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingQualifyMedia'
GO

insert into GXDBVersions values(2, 'archMediaRefreshingQualifyMedia',  '00010020000200030000', 'archMediaRefreshingQualifyMedia', '00010020000200030000')
GO

