

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMediaRefreshingPickUnpickMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------------------------------------------------------------------
--
--	This stored procedure computes verdict and
--
-- ------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMediaRefreshingPickUnpickMedia <<<'

IF EXISTS (select * from sysobjects where name='archMediaRefreshingPickUnpickMedia')
	drop procedure archMediaRefreshingPickUnpickMedia
IF EXISTS (select * from GxQscripts where name='archMediaRefreshingPickUnpickMedia')
	delete from GxQscripts where name = 'archMediaRefreshingPickUnpickMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingPickUnpickMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingPickUnpickMedia'
GO
print '... Creating Procedure: archMediaRefreshingPickUnpickMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMediaRefreshingPickUnpickMedia
--1= Pick, 2- UnPickandPrevent 3- Unpick only
  @refreshOpType INT,		
  @inMediaIdList VARCHAR(MAX)
AS
  DECLARE @o_bucketId INT;
  DECLARE @o_srcMediaId INT;
  DECLARE @o_srcMediaName VARCHAR(256); 
  DECLARE @o_reqdMediaId INT;
  DECLARE @o_reqdMediaName VARCHAR(256); 
  DECLARE @o_reason INT;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- New Media Refresh Changes
-- This stored procedure does the following:
--
-- 1. Given input media list, fetches dependent media list for the specified operation (PICK/UNPICK).
-- 2. Intended operation will be carried out on media which satisfy completeness check.
-- 3. Return media list to user over which either intended operation cannot be performed due to different prohibitory
--    conditions or needs user confirmation (in case of missing dependent media list from the input list).
-- Different error conditions
-- Operation 		ErrorCode		Notes
-- --------------------------------------------------------------------------------
-- PICK/UNPICK			-1			Media Refresh is not enabled. Operation will not be carried out.
-- PICK/UNPICK			-2			Media needs dependent media for refresh. Operation will not be carried out until dependent media is also picked.
-- PICK					-3			Source or dependent is bad. Operation will not be carried out
-- PICK					-4			Source or dependent media is not full. Operation will not be carried out.
-- UNPICK				-5			Media Refresh Job is running. Operation will not be carried out.
-- Returning result to the user.
-- Result set of this stored procedure will look like the following. Result will be sorted by BucketId ASC.
-- BucketId		SourceVolumeId		SourceMediaBarcode		ReqdVolumeId	ReqdMediaBarcode	Reason
-- Info containing real media will have BucketId >  0
--
-- BucketId =  0 is used to return addnl info :
--  1. whether or not the getDependentMedia SP was run successfully. Reason < 0. If set then there was an error.
--  2. Intended operation was run on complete input media list.		Reason  = 0.
--  3. Intended operation could not be run on either all or some of the selected media. Reason = 1
-- Define error constants
DECLARE @EC_OK					INT
DECLARE @EC_RefreshNotEnabled	INT
DECLARE @EC_NeedsAddnlMedia		INT
DECLARE	@EC_MediaBad			INT
DECLARE	@EC_MediaNotFull		INT
DECLARE	@EC_MRJobRunning		INT
DECLARE	@EC_MediaHasTranData	INT
DECLARE	@EC_InternalError		INT -- This error should never happen
SET @EC_OK					=  0
SET @EC_RefreshNotEnabled	= -1
SET @EC_NeedsAddnlMedia		= -2
SET @EC_MediaBad			= -3
SET @EC_MediaNotFull		= -4
SET @EC_MRJobRunning		= -5
SET @EC_MediaHasTranData	= -7   --  -6 is for exported data.
SET	@EC_InternalError		= -10
-- Create the input and result tables to run archMediaRefreshGetDependentMedia.
IF  object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
IF  object_id('tempdb.dbo.#TmpMRDepMediaVerdict') IS  NOT null DROP TABLE #TmpMRDepMediaVerdict
IF  object_id('tempdb.dbo.#TmpHasTranCopyInfoTbl') IS  NOT null DROP TABLE #TmpHasTranCopyInfoTbl
CREATE TABLE #TmpMRDepMediaUI(VolumeId INT)
CREATE TABLE #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT,
		MediaId INT, MediaLocation INT, MediaFlags INT)
--TODO: Create required indexes over #TmpMRDepMediaResultSet
-- This is the table that holds the result sets that will be sent to the user and to carry out operations.
CREATE TABLE #TmpMRDepMediaVerdict(BucketId INT, SelVolumeId INT, SelMediaName VARCHAR(255),ReqdVolumeId INT,
				ReqdMediaName VARCHAR(255), Reason INT, SrcMediaId INT, ReqdMediaId INT)
CREATE TABLE #TmpHasTranCopyInfoTbl (VolumeId INT, srcCopyId INT, tranCopyId INT)
DECLARE	@depMediaOp		INT
-- Fetch VolumeIds from the given input mediaIds .
INSERT INTO #TmpMRDepMediaUI
SELECT DISTINCT V.VolumeID
FROM	dbo.SplitIDs(@inMediaIdList) T
JOIN	MMVolume	V
	ON V.MediaId = T._ID
WHERE @refreshOpType <> 1 OR V.attributes & 8 = 0
INSERT INTO #TmpHasTranCopyInfoTbl
SELECT	MV.VolumeId, A.archGroupCopyId, ISNULL(MRP.targetCopyId, 0)
FROM	#TmpMRDepMediaUI T, MMVolume MV WITH (NOLOCK), archStream A LEFT OUTER JOIN  archCopyMediaRefreshProp MRP WITH (NOLOCK) ON A.archGroupCopyId = MRP.copyId
WHERE	T.VolumeId = MV.VolumeId
		AND MV.MediaGroupId = A.mediaGroupId
AND A.flags & 2 = 0 -- not to pick dependent copy stream. MR belongs to GACP.
UPDATE 	T
SET T.tranCopyId = 0
FROM #TmpHasTranCopyInfoTbl T, archGroupCopy AGC WITH (NOLOCK)
WHERE T.srcCopyId = AGC.id AND AGC.flags & 33554432 = 0
-- Remove those media from list that have data from a copy which does not have a transitive copy.
DELETE FROM #TmpMRDepMediaUI
WHERE	VolumeId IN ( SELECT DISTINCT VolumeId
					  FROM	#TmpHasTranCopyInfoTbl
					  WHERE	tranCopyId = 0 )
-- TODO: Add these deleted source volumes to #TmpMRDepMediaVerdict later with error code @EC_RefreshNotEnabled	= -1
-- Get dependent media list for input media.
EXEC @depMediaOp = archMediaRefreshGetDependentMedia
IF @depMediaOp <> 0
BEGIN
	SELECT 0,'',0,'',@depMediaOp, 0
END
ELSE
BEGIN
	ALTER TABLE #TmpMRDepMediaResultSet ADD ProcFlags INT, HasTranData INT
	UPDATE #TmpMRDepMediaResultSet SET ProcFlags  = 0,HasTranData = 0
	IF(@refreshOpType = 1) -- PICK
	BEGIN
		-- TODO: There is a common pattern to the way we are filtering out media. We can replace blocks of different
		--       cases by having just one filter column. Will do this in 10.0.
		-- CASE : Picked media or its dependent media has data from transitive copy.
		-- Mark volumes having data from transitive copy as such.
		UPDATE #TmpMRDepMediaResultSet SET HasTranData = 1
		WHERE  VolumeId IN (SELECT  DISTINCT V.VolumeId
							FROM	archChunkMapping	ACM
							JOIN	archChunk		AC
								ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
							JOIN	MMVolume	V
								ON V.VolumeId = AC.volumeId
							JOIN	#TmpMRDepMediaResultSet	RS
								ON  RS.VolumeId = V.VolumeId
							JOIN	archGroupCopy AGC
								ON AGC.id = ACM.archCopyId
							WHERE	AGC.type = 5  )
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CS.BucketId,CS.VolumeId, M.barcode, 0, '',@EC_MediaHasTranData,CS.MediaId,0
		FROM	#TmpMRDepMediaResultSet	CS
		JOIN	#TmpMRDepMediaUI		V
			ON CS.VolumeId = V.VolumeId
		JOIN	MMMedia	M
		ON	M.mediaId =  CS.MediaId
		WHERE	CS.HasTranData = 1 -- Media has data from transitive copy.
				AND CS.ProcFlags = 0
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId AND #TmpMRDepMediaResultSet.VolumeId = RS.SelVolumeId
				AND RS.Reason = @EC_MediaHasTranData
		-- If we have identified some source media from input list as having tran data and there are some more good media from the input list
		-- that depend on these media, then for these good media set the tran media as required media & reason for not picking
		-- as "has transitive data"
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT RS.BucketId, RS.VolumeId,M.BarCode,MV.SelVolumeId,MV.SelMediaName,@EC_MediaBad,RS.MediaId, MV.SrcMediaId
		FROM	#TmpMRDepMediaVerdict		MV
		JOIN	#TmpMRDepMediaResultSet		RS
		 ON MV.BucketId = RS.BucketId AND MV.SrcMediaId <> RS.MediaId AND RS.ProcFlags = 0
		JOIN	MMMedia	M
			ON M.MediaId = RS.MediaId
		WHERE MV.Reason = @EC_MediaHasTranData
				AND	EXISTS (SELECT * FROM #TmpMRDepMediaUI WHERE VolumeId = RS.VolumeId)
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_MediaHasTranData AND #TmpMRDepMediaResultSet.ProcFlags = 0
		-- Filter out dependent media that has transitive data
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CSSRC.BucketId, CSSRC.VolumeId, MSRC.barcode, CSDEP.VolumeId, MDEP.barcode,@EC_MediaHasTranData,CSSRC.MediaId,CSDEP.MediaId
		FROM	#TmpMRDepMediaResultSet	CSDEP
		JOIN	#TmpMRDepMediaResultSet	CSSRC
			ON CSSRC.BucketId = CSDEP.BucketId
		JOIN	MMMedia	MSRC
			ON	MSRC.mediaId = CSSRC.MediaId
		JOIN	MMMedia	MDEP
			ON MDEP.mediaId = CSDEP.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CSSRC.VolumeId
		LEFT OUTER JOIN	#TmpMRDepMediaUI DEPV
			ON DEPV.VolumeId = CSDEP.VolumeId
		WHERE	CSDEP.HasTranData = 1 -- Media has transitive data.
				AND CSDEP.ProcFlags = 0 AND CSSRC.ProcFlags = 0
				AND DEPV.VolumeId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_MediaHasTranData
				AND ProcFlags = 0
		-- End of media having transitive data
		-- CASE 1: Filter out bad source media.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CS.BucketId,CS.VolumeId, M.barcode, 0, '',@EC_MediaBad,CS.MediaId,0
		FROM	#TmpMRDepMediaResultSet	CS
		JOIN	#TmpMRDepMediaUI		V
			ON CS.VolumeId = V.VolumeId
		JOIN	MMMedia	M
		ON	M.mediaId =  CS.MediaId
		WHERE	CS.MediaFlags = 2 -- Media is marked bad
				AND CS.ProcFlags = 0
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId AND #TmpMRDepMediaResultSet.VolumeId = RS.SelVolumeId
				AND RS.Reason = @EC_MediaBad
		-- If we have identified some source media from input list as bad and there are some more good media from the input list
		-- that depend on these bad media, then for these good media set the bad media as required media & reason for not picking
		-- as "required media is bad"
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT RS.BucketId, RS.VolumeId,M.BarCode,MV.SelVolumeId,MV.SelMediaName,@EC_MediaBad,RS.MediaId, MV.SrcMediaId
		FROM	#TmpMRDepMediaVerdict		MV
		JOIN	#TmpMRDepMediaResultSet		RS
		 ON MV.BucketId = RS.BucketId AND MV.SrcMediaId <> RS.MediaId AND RS.ProcFlags = 0
		JOIN	MMMedia	M
			ON M.MediaId = RS.MediaId
		WHERE MV.Reason = @EC_MediaBad
				AND	EXISTS (SELECT * FROM #TmpMRDepMediaUI WHERE VolumeId = RS.VolumeId)
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_MediaBad AND #TmpMRDepMediaResultSet.ProcFlags = 0
	-- CASE 2: Filter out not-full source media.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CS.BucketId,CS.VolumeId, M.barcode, 0, '', @EC_MediaNotFull,CS.MediaId,0
		FROM	#TmpMRDepMediaResultSet	CS
		JOIN	#TmpMRDepMediaUI		V
			ON CS.VolumeId = V.VolumeId
		JOIN	MMMedia	M
			ON M.mediaId =  CS.MediaId
		WHERE	CS.VolumeFlags  <> 2 --Volume not full.
				AND CS.ProcFlags = 0
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId AND #TmpMRDepMediaResultSet.VolumeId = RS.SelVolumeId
				AND RS.Reason = @EC_MediaNotFull
		-- If we have identified some source media from input list as not full and there are some more good media from the input list
		-- that depend on these not-full media, then for these good media set the not-full media as required media & reason for not picking
		-- as "required media is not-full"
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT RS.BucketId, RS.VolumeId,M.BarCode,MV.SelVolumeId,MV.SelMediaName,@EC_MediaNotFull,RS.MediaId, MV.SrcMediaId
		FROM	#TmpMRDepMediaVerdict		MV
		JOIN	#TmpMRDepMediaResultSet		RS
		 ON MV.BucketId = RS.BucketId AND MV.SrcMediaId <> RS.MediaId AND RS.ProcFlags = 0
		JOIN	MMMedia	M
			ON M.MediaId = RS.MediaId
		WHERE MV.Reason = @EC_MediaNotFull
				AND	EXISTS (SELECT * FROM #TmpMRDepMediaUI WHERE VolumeId = RS.VolumeId)
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_MediaNotFull AND #TmpMRDepMediaResultSet.ProcFlags = 0
	-- CASE 3: Filter out bad dependent media.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CSSRC.BucketId, CSSRC.VolumeId, MSRC.barcode, CSDEP.VolumeId, MDEP.barcode,@EC_MediaBad,CSSRC.MediaId,CSDEP.MediaId
		FROM	#TmpMRDepMediaResultSet	CSDEP
		JOIN	#TmpMRDepMediaResultSet	CSSRC
			ON CSSRC.BucketId = CSDEP.BucketId
		JOIN	MMMedia	MSRC
			ON	MSRC.mediaId = CSSRC.MediaId
		JOIN	MMMedia	MDEP
			ON MDEP.mediaId = CSDEP.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CSSRC.VolumeId
		LEFT OUTER JOIN	#TmpMRDepMediaUI DEPV
			ON DEPV.VolumeId = CSDEP.VolumeId
		WHERE	CSDEP.MediaFlags = 2 -- Media is marked bad.
				-- CODE REVIEW - REDUNDANT because we have already verified source is full
				--AND CSSRC.VolumeFlags = 2
				AND CSDEP.ProcFlags = 0 AND CSSRC.ProcFlags = 0
				AND DEPV.VolumeId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_MediaBad
				AND ProcFlags = 0
	-- CASE 4: Filter out not-full dependent media.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CSSRC.BucketId, CSSRC.VolumeId, MSRC.barcode, CSDEP.VolumeId, MDEP.barcode,@EC_NeedsAddnlMedia,CSSRC.MediaId,CSDEP.MediaId
		FROM	#TmpMRDepMediaResultSet	CSDEP
		JOIN	#TmpMRDepMediaResultSet	CSSRC
			ON CSSRC.BucketId = CSDEP.BucketId
		JOIN	MMMedia	MSRC
			ON	MSRC.mediaId = CSSRC.MediaId
		JOIN	MMMedia	MDEP
			ON MDEP.mediaId = CSDEP.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CSSRC.VolumeId
		LEFT OUTER JOIN	#TmpMRDepMediaUI DEPV
			ON DEPV.VolumeId = CSDEP.VolumeId
		WHERE	CSDEP.VolumeFlags <> 2 -- Dependent media is not full
			-- CODE REVIEW - REDUNDANT because we have already verified source is full
			-- AND	CSSRC.VolumeFlags = 2
			AND CSDEP.ProcFlags = 0 AND CSSRC.ProcFlags = 0
			AND DEPV.VolumeId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
			AND RS.Reason = @EC_MediaNotFull
			AND ProcFlags = 0
	-- Unprocessed media is good media. Selected list could be complete or may need some dependent media.
	-- Get media that will need dependent media.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CSSRC.BucketId, CSSRC.VolumeId, MSRC.barcode, CSDEP.VolumeId, MDEP.barcode,@EC_NeedsAddnlMedia,CSSRC.MediaId,CSDEP.MediaId
		FROM	#TmpMRDepMediaResultSet	CSDEP
		JOIN	#TmpMRDepMediaResultSet	CSSRC
			ON CSSRC.BucketId = CSDEP.BucketId
		JOIN	MMMedia	MSRC
			ON	MSRC.mediaId = CSSRC.MediaId
		JOIN	MMMedia	MDEP
			ON MDEP.mediaId = CSDEP.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CSSRC.VolumeId
		LEFT OUTER JOIN	#TmpMRDepMediaUI DEPV
			ON DEPV.VolumeId = CSDEP.VolumeId
		WHERE	CSDEP.VolumeFlags = 2
				-- CODE REVIEW - Not picked or prevented should be shown in the UI for dependent list
AND (CSDEP.VolumeAttributes & 8 <> 8
OR CSDEP.VolumeAttributes & 16 = 16)
				AND CSSRC.VolumeFlags = 2
				AND CSDEP.ProcFlags = 0
				AND CSSRC.ProcFlags = 0
				AND DEPV.VolumeId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_NeedsAddnlMedia
				AND ProcFlags = 0
	-- Media that either do not have any dependency or the selected list is already complete.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CS.BucketId,CS.VolumeId,M.barcode,0,'',@EC_OK,CS.MediaId,0
		FROM	#TmpMRDepMediaResultSet	CS
		LEFT OUTER JOIN	#TmpMRDepMediaVerdict	RS
			ON RS.BucketId = CS.BucketId
		JOIN	MMMedia	M
			ON M.mediaId = CS.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CS.VolumeId
		WHERE	CS.ProcFlags = 0 AND
			RS.BucketId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_OK
				AND ProcFlags = 0
	END
	ELSE --UNPICK
	BEGIN
		-- Here for unpick, all the dependent media should either be in unpicked state or should be in the input list.
		-- Dont unpick media if there is a refresh job running.
		-- If there is a media refresh job running over a copy and we have media picked for refresh from this copy,
		-- then we dont allow unpick of such media.
		INSERT INTO #TmpMRDepMediaVerdict
			SELECT RS.BucketId,RS.VolumeId,M.BarCode,0,'',@EC_MRJobRunning,M.MediaId,0
			FROM	#TmpMRDepMediaResultSet	RS
			JOIN	#TmpHasTranCopyInfoTbl  T
				ON T.VolumeId = RS.VolumeId
			JOIN	archGroupCopy AGC WITH (NOLOCK)
				ON AGC.id = T.srcCopyId
			JOIN JMAdminJobInfoTable JM WITH (NOLOCK)
				ON JM.opType = 74 AND JM.archGrpID = AGC.archGroupId
					AND (JM.archGrpCopyID = 0 OR JM.archGrpCopyID = T.srcCopyId)
			JOIN	MMMedia	M
				ON M.MediaId = RS.MediaId
			WHERE	T.tranCopyId <> 0
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_MRJobRunning
				AND ProcFlags = 0
		-- Get media that will need dependent media.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CSSRC.BucketId, CSSRC.VolumeId, MSRC.barcode, CSDEP.VolumeId, MDEP.barcode,@EC_NeedsAddnlMedia,CSSRC.MediaId,CSDEP.MediaId
		FROM	#TmpMRDepMediaResultSet	CSDEP
		JOIN	#TmpMRDepMediaResultSet	CSSRC
			ON CSSRC.BucketId = CSDEP.BucketId
		JOIN	MMMedia	MSRC
			ON	MSRC.mediaId = CSSRC.MediaId
		JOIN	MMMedia	MDEP
			ON MDEP.mediaId = CSDEP.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CSSRC.VolumeId
		LEFT OUTER JOIN	#TmpMRDepMediaUI DEPV
			ON DEPV.VolumeId = CSDEP.VolumeId
		WHERE	CSDEP.VolumeFlags = 2
				-- Dependent media is in picked state.
AND CSDEP.VolumeAttributes & 8 = 8
				-- CODE REVIEW - Dependent media is already in prevented state then do not show for unpick confirmation.
AND CSDEP.VolumeAttributes & 16 <> 16
				AND CSSRC.VolumeFlags = 2
				AND CSDEP.ProcFlags = 0
				AND CSSRC.ProcFlags = 0
				AND DEPV.VolumeId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_NeedsAddnlMedia
				AND ProcFlags = 0
		-- Media that either dont have any dependency or the selected list is already complete.
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT  CS.BucketId,CS.VolumeId,M.barcode,0,'',@EC_OK,CS.MediaId,0
		FROM	#TmpMRDepMediaResultSet	CS
		LEFT OUTER JOIN	#TmpMRDepMediaVerdict	RS
			ON RS.BucketId = CS.BucketId
		JOIN	MMMedia	M
			ON M.mediaId = CS.MediaId
		JOIN	#TmpMRDepMediaUI	INV
			ON INV.VolumeId = CS.VolumeId
		WHERE	CS.ProcFlags = 0 AND
			RS.BucketId IS NULL
		UPDATE #TmpMRDepMediaResultSet SET	ProcFlags = 1
		FROM	#TmpMRDepMediaVerdict	RS
		WHERE	#TmpMRDepMediaResultSet.BucketId = RS.BucketId
				AND RS.Reason = @EC_OK
				AND ProcFlags = 0
	END
	-- Okay, if we filtered out media because there was no transitive copy defined over it then add them up here in #TmpMRDepMediaVerdict.
	DECLARE @maxBucketID INT
	IF EXISTS(SELECT * FROM #TmpMRDepMediaVerdict)
	BEGIN
			SELECT @maxBucketID = MAX(BucketId) + 1 FROM #TmpMRDepMediaVerdict
	END
	ELSE
		SET @maxBucketID = 1
	IF EXISTS (SELECT * FROM #TmpHasTranCopyInfoTbl  WHERE	tranCopyId = 0 )
	BEGIN
		INSERT INTO #TmpMRDepMediaVerdict
		SELECT DISTINCT @maxBucketID,T.VolumeId, M.Barcode,0,'',@EC_RefreshNotEnabled,M.MediaId,0
		FROM	#TmpHasTranCopyInfoTbl T
		JOIN	MMVolume	V
			ON V.VolumeId = T.VolumeId
		JOIN	MMMedia	M
			ON M.MediaId = V.MediaId
	END
	-- Okay, now check if we have any media that is okay to run desired operation on.
	IF EXISTS (SELECT * FROM #TmpMRDepMediaVerdict WHERE Reason IN (  @EC_OK, @EC_NeedsAddnlMedia ) )
	BEGIN
		--INSERT INTO #TmpMRDepMediaVerdict VALUES(0,0,'',0,'',0,0,0)
		IF(@refreshOpType = 1)-- PICK
		BEGIN
			UPDATE MMVolume
SET	 Attributes = (Attributes & ~16) | 8 | 64
			FROM	#TmpMRDepMediaUI , #TmpMRDepMediaVerdict
			WHERE	MMVolume.VolumeId  = #TmpMRDepMediaUI.VolumeId
				AND #TmpMRDepMediaVerdict.SelVolumeId = #TmpMRDepMediaUI.VolumeId
				AND #TmpMRDepMediaVerdict.Reason IN (  @EC_OK, @EC_NeedsAddnlMedia )
			-- Delete all rows with @EC_OK
			DELETE #TmpMRDepMediaVerdict
			WHERE	Reason  = @EC_OK
			IF NOT EXISTS(SELECT * FROM #TmpMRDepMediaVerdict)
			BEGIN
				INSERT INTO #TmpMRDepMediaVerdict VALUES(0,0,'',0,'',0,0,0)
			END
		END
		ELSE
		BEGIN
			-- During unpick we do the following.
			-- 1. Pick archFiles on media that are written by a transitive copy. Age such AFiles on transitive copy.
			-- 2. Mark media as unpicked.
			DECLARE @retVal	INT
			DECLARE @o_retVal INT
			DECLARE @nRows	INT
			DECLARE	@l_now	INT
			DECLARE @l_dateTime	datetime
			DECLARE	@magneticBytes	bigint
			SELECT @l_now = dbo.GetUnixTime(GETUTCDATE())
			CREATE TABLE #ToBeAgedMedia (
				MediaId		INT,
				VolumeId	INT,
				VolumeFlags	INT,
				archCopyId	INT,
				archTransCopyId	INT,
				errorCode	INT,
			)
			CREATE TABLE #ToBeAgedAFC (
				archFileId INT,
				commCellId INT,
				archCopyId INT,
			PRIMARY KEY (archFileId, commCellId, archCopyId))
			BEGIN TRANSACTION TRAN_FAILED_KILLED
			INSERT	INTO #ToBeAgedMedia
			SELECT DISTINCT SrcMediaId,0,0,0,0,0
			FROM #TmpMRDepMediaVerdict T, #TmpMRDepMediaUI I
			WHERE T.SelVolumeId = I.VolumeId
				-- Get the source and transitive copy id
			UPDATE	#ToBeAgedMedia
			SET		VolumeId = MV.VolumeId, VolumeFlags = MV.VolumeFlags, archCopyId = MRP.copyId, archTransCopyId = MRP.TargetCopyId
			FROM	MMVolume MV WITH (NOLOCK), archStream S WITH (NOLOCK), archCopyMediaRefreshProp MRP WITH (NOLOCK)
			WHERE	MV.MediaId = #ToBeAgedMedia.MediaId
					AND MV.MediaGroupId = S.MediaGroupId
					AND S.archGroupCopyId = MRP.copyId
			-- DO NOT PROCESS ANY MEDIA IF TargetCopyId not found
			UPDATE	#ToBeAgedMedia
			SET		errorCode = -3
			WHERE	archTransCopyId = 0 OR archTransCopyId IS NULL
			IF (EXISTS (SELECT * FROM #ToBeAgedMedia WHERE errorCode <> -3))
			BEGIN
				-- Populate the archive files for aging and pruning
				-- Basically if user unpicked any media and the selected media and dependent media  (which already picked for Media refresh) have common archfile
				-- it means as dependent media is still marked for refresh so we donot have clear those chunks from transivitive copy
				-- user may run the job again and refresh other media which share archfile with this selected media.
				INSERT INTO #ToBeAgedAFC
				SELECT T.*
				FROM  ( 				SELECT	DISTINCT TransCopy.archFileId, TransCopy.CommCellId, TransCopy.archCopyId
				FROM	archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archFileCopy TransCopy WITH (NOLOCK), #ToBeAgedMedia T, archGroupCopy AGC WITH (NOLOCK)
				WHERE	AC.volumeId = T.VolumeId
						AND AC.id = ACM.archChunkId
AND ((AGC.id = T.archCopyId AND AGC.extendedFlags & 2 = 0)
OR  (AGC.extendedFlags & 2 > 0 AND AGC.destMediaCopyId = T.archCopyId))
						AND AC.commCellId = ACM.chunkCommCellId
						AND ACM.archCopyId = AGC.id  -- T.archCopyId
						AND ACM.archFileId = TransCopy.archFileId
						AND ACM.CommCellId = TransCopy.commCellId
						AND TransCopy.archCopyId = T.archTransCopyId
						AND T.errorCode = 0	) T
				LEFT OUTER JOIN  ( SELECT DISTINCT ACM.archFileId, ACM.commCellId
				FROM #TmpMRDepMediaVerdict V, archChunk AC, archChunkMapping ACM  , MMVolume MV
				WHERE V.ReqdVolumeId = AC.volumeId
				AND AC.id = ACM.archchunkid AND AC.commcellid = ACM.chunkcommcellid
				AND AC.volumeId = MV.volumeId
AND MV.Attributes & 8 = 8  /* dependent picked media*/) NUP
				ON 	T.archfileid = NUP.archfileId AND T.commcellId = NUP.commcellId
					WHERE NUP.archFileId IS NULL
				SELECT @retVal = @@ERROR
				SELECT @nRows = COUNT(*) FROM #ToBeAgedAFC
				IF @retVal <> 0 GOTO CX_ERROR_EXIT1
EXEC @o_retVal = archFileSetAgedViaTable 134217728, @l_now
				SELECT	@retVal = @@ERROR
				IF @retVal = 0 SET @retVal = @o_retVal
				IF @retVal <> 0 GOTO CX_ERROR_EXIT1
				EXEC @o_retVal = archFileDeleteViaTable 0, @magneticBytes	OUTPUT
				SELECT	@retVal = @@ERROR
				IF @retVal = 0 SET @retVal = @o_retVal
				IF @retVal <> 0 GOTO CX_ERROR_EXIT1
				SELECT @retVal = @@ERROR
				IF @retVal <> 0 GOTO CX_ERROR_EXIT1
				-- Set the PREVENT FOR REFRESH flag based on unpick option as in 2 or 3.
				UPDATE	MMVolume
SET		Attributes = (Attributes & ~(8)) | (CASE WHEN @refreshOpType = 2 THEN 16 ELSE 0 END )
				FROM	#TmpMRDepMediaUI I
				WHERE	MMVolume.VolumeId = I.VolumeId
			END
			CX_ERROR_EXIT1:
				IF @retVal = 0
				BEGIN
					COMMIT TRANSACTION TRAN_FAILED_KILLED
					DELETE #TmpMRDepMediaVerdict
					IF NOT EXISTS(SELECT * FROM #TmpMRDepMediaVerdict)
					BEGIN
						INSERT INTO #TmpMRDepMediaVerdict VALUES(0,0,'',0,'',0,0,0)
					END
				END
				ELSE
					ROLLBACK TRANSACTION TRAN_FAILED_KILLED
			DROP TABLE #ToBeAgedMedia
			DROP TABLE #ToBeAgedAFC
		END
	END
	IF EXISTS (SELECT * FROM #TmpMRDepMediaVerdict WHERE Reason <> 0 )
	BEGIN
		INSERT INTO #TmpMRDepMediaVerdict VALUES(0,0,'',0,'',1,0,0)
	END
	IF (OBJECT_ID('tempdb.dbo.#TmpPickUnpickResult') IS NOT NULL)
	BEGIN
		INSERT #TmpPickUnpickResult
		SELECT BucketId,SrcMediaId,SelMediaName,ReqdMediaId,ReqdMediaName,Reason
		FROM	#TmpMRDepMediaVerdict
		ORDER BY BucketId,SelVolumeId
	END
	ELSE
	SELECT BucketId,SrcMediaId,SelMediaName,ReqdMediaId,ReqdMediaName,Reason
	FROM	#TmpMRDepMediaVerdict
	ORDER BY BucketId,SelVolumeId
END
DROP TABLE #TmpMRDepMediaUI
DROP TABLE #TmpMRDepMediaResultSet
DROP TABLE #TmpMRDepMediaVerdict
GO

IF EXISTS (select * from GxQscripts where name = 'archMediaRefreshingPickUnpickMedia')
	delete from GxQscripts where name = 'archMediaRefreshingPickUnpickMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingPickUnpickMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingPickUnpickMedia'
GO

insert into GXDBVersions values(2, 'archMediaRefreshingPickUnpickMedia',  '00000000000000000000', 'archMediaRefreshingPickUnpickMedia', '00000000000000000000')
GO

