

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMediaRefreshingMoveRefreshedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMediaRefreshingMoveRefreshedMedia.sp,v $ $Id: archMediaRefreshingMoveRefreshedMedia.sp,v 1.4.50.5 2018/09/29 18:26:16 daruloli Exp $";
-- -----------------------------------------------------------------------------------
--
--	This stored procedure moves volumes from the transitive copy to the original copy.
--	It can be executed at the beginning and the end of a Media Refreshing job.
--
-- -----------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMediaRefreshingMoveRefreshedMedia <<<'

IF EXISTS (select * from sysobjects where name='archMediaRefreshingMoveRefreshedMedia')
	drop procedure archMediaRefreshingMoveRefreshedMedia
IF EXISTS (select * from GxQscripts where name='archMediaRefreshingMoveRefreshedMedia')
	delete from GxQscripts where name = 'archMediaRefreshingMoveRefreshedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingMoveRefreshedMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingMoveRefreshedMedia'
GO
print '... Creating Procedure: archMediaRefreshingMoveRefreshedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMediaRefreshingMoveRefreshedMedia
  @i_archGroupId INTEGER,
  @i_targetCopyId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- VolumeFlags: 2-FULL, 8-VOL_ACTIVE_REFRESH, 7-VOL_ACTIVE_APPEND
-- Mark the active append refreshed media full also
UPDATE	MMVolume
SET		VolumeFlags = (CASE WHEN V.VolumeFlags = 2 OR V.VolumeFlags = 7
                                         THEN 2
                                    ELSE
(CASE WHEN P.flags & 2 <> 0 AND TD.VolumeId IS NULL
                                              	THEN 7
                                              ELSE ( CASE WHEN V.RecordingFormatId <> 10001 THEN 8 ELSE V.VolumeFlags END) END)
                               END),
		MediaGroupId = S1.MediaGroupId,
		VolumeFullReason = (CASE WHEN V.VolumeFlags = 2 OR V.VolumeFlags = 7
						THEN VolumeFullReason
					   ELSE
(CASE WHEN P.flags & 2 <> 0 AND TD.VolumeId IS NULL
THEN 42043
						 ELSE VolumeFullReason END)
						END)
FROM	(SELECT	A.stream, A.mediaGroupId, B.sourceCopyId, B.id
		FROM	archStream A, archGroupCopy B
		WHERE	A.archGroupCopyId = B.id
			AND B.archGroupId = @i_archGroupId
			AND (@i_targetCopyId = 0 OR B.id = @i_targetCopyId)
AND B.type = 5) S2
		JOIN  archStream S1
			ON S2.stream = S1.stream  AND S1.archGroupCopyId = S2.sourceCopyId
		JOIN MMVolume V
			ON V.MediaGroupId = S2.MediaGroupId
		JOIN archCopyMediaRefreshProp P
			ON S1.archGroupCopyId = P.copyId
		LEFT OUTER JOIN
			(SELECT DISTINCT  V.VolumeId,  AGC.id, AGC.sourceCopyId
			FROM archGroupCopy AGC , archChunkMapping ACM, archChunk AC, MMVolume V
			WHERE AGC.id = ACM.archCopyId AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
				AND AC.volumeId = V.VolumeId
				AND AGC.archGroupId = @i_archGroupId
				AND (@i_targetCopyId = 0 OR AGC.id = @i_targetCopyId)
AND AGC.type = 5) TD
			ON  V.VolumeId = TD.VolumeId AND TD.id = S2.id AND TD.sourceCopyId = S2.sourceCopyId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DELETE	archFileCopy
FROM	archFileCopy AFC
	INNER JOIN archGroupCopy AGC
	ON	AFC.archCopyId = AGC.id AND AGC.archGroupId = @i_archGroupId
		AND (@i_targetCopyId = 0 OR AGC.id = @i_targetCopyId)
AND AGC.type = 5
	LEFT OUTER JOIN archChunkMapping ACM
	ON	AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId
	AND AFC.archCopyId = ACM.archCopyId
WHERE	ACM.archFileId IS NULL
SET	@retVal = @@ERROR
FINISH:
SELECT  @retVal
RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archMediaRefreshingMoveRefreshedMedia')
	delete from GxQscripts where name = 'archMediaRefreshingMoveRefreshedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingMoveRefreshedMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingMoveRefreshedMedia'
GO

insert into GXDBVersions values(2, 'archMediaRefreshingMoveRefreshedMedia',  '00010004005000050000', 'archMediaRefreshingMoveRefreshedMedia', '00010004005000050000')
GO

