

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMediaRefreshingMoveActiveMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMediaRefreshingMoveActiveMedia.sp,v $ $Id: archMediaRefreshingMoveActiveMedia.sp,v 1.2.274.5 2018/06/29 02:42:58 daruloli Exp $";
-- -----------------------------------------------------------------------------------
--
--	This stored procedure moves active volumes from the original copy to the transitive copy.
--	It should be executed at the beginning of a Media Refreshing job.
--
-- -----------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMediaRefreshingMoveActiveMedia <<<'

IF EXISTS (select * from sysobjects where name='archMediaRefreshingMoveActiveMedia')
	drop procedure archMediaRefreshingMoveActiveMedia
IF EXISTS (select * from GxQscripts where name='archMediaRefreshingMoveActiveMedia')
	delete from GxQscripts where name = 'archMediaRefreshingMoveActiveMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingMoveActiveMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingMoveActiveMedia'
GO
print '... Creating Procedure: archMediaRefreshingMoveActiveMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMediaRefreshingMoveActiveMedia
  @i_archGroupId INTEGER,
  @i_targetCopyId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- VolumeFlags: 2-VOL_FULL, 8-VOL_ACTIVE_REFRESH, 1-VOL_ACTIVE
DECLARE @tblCopyMap TABLE (stream int,mediaGroupId int,sourceCopyId int,targetCopyId int)
DECLARE @tblNonActiveVols TABLE (volId int)
INSERT INTO @tblCopyMap
SELECT	A.stream, A.mediaGroupId, B.sourceCopyId,B.id
		FROM	archStream A WITH (READUNCOMMITTED), archGroupCopy B WITH (READUNCOMMITTED)
		WHERE	A.archGroupCopyId = B.id
			AND B.archGroupId = @i_archGroupId
			AND (@i_targetCopyId = 0 OR B.id = @i_targetCopyId)
AND B.type = 5
-- For Tape refresh
INSERT INTO @tblNonActiveVols
SELECT DISTINCT V.VolumeId FROM
@tblCopyMap C, archFileCopy AFC WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED), archChunk AC WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
WHERE C.targetCopyId = AFC.archCopyId
AND ACM.archCopyId = C.sourceCopyId
AND AFC.archFileId = ACM.archFileId
AND AFC.commCellId = ACM.commCellId
AND ACM.archChunkId = AC.id
AND ACM.chunkCommCellId = AC.commCellId
AND AC.volumeId = V.VolumeId
AND V.VolumeFlags <> 2
AND V.VolumeFlags = 8
AND V.Attributes & 8 = 0
UPDATE	MMVolume
SET		VolumeFlags = 1,
		MediaGroupId = S2.MediaGroupId
FROM	MMVolume V, archStream S1,
		@tblCopyMap S2
WHERE	V.MediaGroupId = S1.MediaGroupId AND V.VolumeFlags = 8
	AND S1.archGroupCopyId = S2.sourceCopyId
	AND S2.stream = S1.stream
	AND V.VolumeId NOT IN (SELECT volId FROM @tblNonActiveVols)
SET	@retVal = @@ERROR
FINISH:
SELECT  @retVal
RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archMediaRefreshingMoveActiveMedia')
	delete from GxQscripts where name = 'archMediaRefreshingMoveActiveMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingMoveActiveMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingMoveActiveMedia'
GO

insert into GXDBVersions values(2, 'archMediaRefreshingMoveActiveMedia',  '00010002027400050000', 'archMediaRefreshingMoveActiveMedia', '00010002027400050000')
GO

