

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMediaRefreshingAddArchFileCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMediaRefreshingAddArchFileCopy.sp,v $ $Id: archMediaRefreshingAddArchFileCopy.sp,v 1.14.42.14 2020/01/28 09:27:07 daruloli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archMediaRefreshingAddArchFileCopy')
BEGIN
	print '>>> Drop Stored Procedure: archMediaRefreshingAddArchFileCopy <<<'
	drop procedure archMediaRefreshingAddArchFileCopy
END
IF EXISTS (select * from GxQscripts where name='archMediaRefreshingAddArchFileCopy')
	delete from GxQscripts where name = 'archMediaRefreshingAddArchFileCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingAddArchFileCopy')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingAddArchFileCopy'
GO
print '... Creating Procedure: archMediaRefreshingAddArchFileCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMediaRefreshingAddArchFileCopy
  @i_copyId INTEGER,
  @i_stream INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @retCode INTEGER;
  DECLARE @retString VARCHAR(256);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
CREATE	TABLE #Vol (VolumeId INT)
CREATE	TABLE #SkippedVol (VolumeId INT, rCode INT, barcode VARCHAR(256)) -- Also used to hold return result set.
CREATE	TABLE #AFCopy (archFileId INT, commCellId INT, minPhysicalOffset BIGINT, minLogicalOffset BIGINT, lastChunkNumber INT, archFileFlags int, flags int, passPhraseProtected bit, SIDBStoreId INT)
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE TABLE #JobsList( jobId INT, commCellId INT, status INT, appType INT)
DECLARE @PickedArchFile TABLE( archfileID INT, commCellId INT)
DECLARE @l_targetArchGroupId	INTEGER
DECLARE @l_targetCopyFlags	INTEGER
DECLARE @max_stream		INTEGER
DECLARE @isMagRefresh INT = 0;
DECLARE	@now INT
DECLARE @ignoreBadJobs INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED)
                                            WHERE name = 'MM_CONFIG_IGNORE_BAD_JOB_FOR_MEDIA_REFRESH'), 0)
DECLARE @l_copyDedupeFlags	INTEGER
DECLARE @l_copyFlags INTEGER
SET		@now = dbo.GetUnixTime(GetUTCDate())
IF OBJECT_ID('tempdb..#lt_SourceCopies') IS NOT NULL DROP TABLE #lt_SourceCopies
CREATE TABLE #lt_SourceCopies (copyId int)
DECLARE	@l_targetCopyId	INT
SELECT	@l_targetCopyId = targetCopyId
FROM	archCopyMediaRefreshProp MR WITH (NOLOCK)
WHERE	copyId = @i_copyId
SELECT	@l_targetArchGroupId	= archGroupId, @l_targetCopyFlags	= flags,
		@max_stream		= maxStreamNum,
		@l_copyDedupeFlags	= dedupeFlags,
		@l_copyFlags = flags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @l_targetCopyId
IF	(@l_targetCopyFlags & 4) = 0 OR @max_stream = 0
	SELECT	@max_stream = maxStreams
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @l_targetArchGroupId
IF EXISTS (SELECT 1 FROM JMJobDataStats WITH (READUNCOMMITTED) where archGrpCopyId = @l_targetCopyId AND status <> 1000 AND disabled & 1 = 0)
AND ((@l_copyDedupeFlags & 262144) > 0)
BEGIN
	SET @isMagRefresh = 1
	INSERT #JobsList
	SELECT DISTINCT jobid,commCellId,status,A.appTypeId
	FROM JMJobDataStats WITH (READUNCOMMITTED), APP_Application A WITH (READUNCOMMITTED)
	WHERE archGrpCopyId = @l_targetCopyId
	AND status IN (101,102,103)
AND disabled & 1 = 0
	AND A.id = appId
END
-- Change: skip volumes that are prevented for refresh
-- Change: skip volume that is exported and is also picked for refresh.
-- TODO: In release 10.0 return such skipped volumes and let user know that these have been skipped for refresh as these are exported.
--Get source copies
INSERT 	INTO #lt_SourceCopies
SELECT	id
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_copyId AND (extendedFlags & 1) = 0
UNION
SELECT	id
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	destMediaCopyId = @i_copyId AND (extendedFlags & 2) > 0
IF @isMagRefresh = 0
BEGIN
INSERT	INTO #Vol
SELECT	V.VolumeId
FROM	archStream S WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	S.archGroupCopyId = @i_copyId AND (@i_stream = 0 OR S.stream = @i_stream)
	AND V.MediaGroupId = S.mediaGroupId
	AND V.VolumeFlags = 2 /*VOL_FULL*/
	AND V.RecordingFormatId <> 10001
AND (V.Attributes & (8 | 16)) = 8
IF	@@ROWCOUNT = 0
BEGIN
	INSERT INTO #SkippedVol VALUES(0,0,'')
	GOTO FINISH
END
INSERT @PickedArchFile
SELECT DISTINCT ACM.archFileId, ACM.commCellId
FROM #Vol V, archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), #lt_SourceCopies SC
WHERE AC.volumeId = V.VolumeId
	AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	AND ACM.archCopyId = SC.copyId
IF (@ignoreBadJobs = 1)
BEGIN
	DELETE FROM PAF
	FROM    @PickedArchFile PAF
				INNER JOIN  archFile AF ON PAF.archFileId = AF.id AND PAF.commcellId = AF.commCellId
				INNER JOIN  JMJobDataStats JDS ON AF.jobId = JDS.jobiD AND AF.commCellId = JDS.commCellId AND JDS.archGrpCopyId = @i_copyId
	WHERE   ((JDS.disabled & 64) > 0 /*CVA_BAD_JOB_FLAG*/ OR JDS.archCheckStatus = 6 /*ACS_FAILED*/)
	DELETE FROM PAF
	FROM    @PickedArchFile PAF
				INNER JOIN  archChunkMapping ACM ON PAF.archFileId = ACM.archFileId AND PAF.commcellId = ACM.commCellId AND ACM.archCopyId = @i_copyId
	WHERE   ACM.flags & (8192 | 4) > 0 /*CVA_CHUNK_IS_BAD | ACS_FAILED_FLAG*/
END
-- New Media Refresh Changes
-- April 2, 2012
-- Verify that the selected volumes list satisfies, "Completeness Check" for media refresh. For, notes on "Completeness Check"
-- please see notes section in archMediaRefreshGetDependentMedia.sp
IF object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
CREATE TABLE #TmpMRDepMediaUI(VolumeId INT)
CREATE TABLE #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT,
		MediaId INT, MediaLocation INT, MediaFlags INT)
DECLARE	@depMediaOp		INT
INSERT INTO #TmpMRDepMediaUI
SELECT DISTINCT VolumeId
FROM #Vol
EXEC @depMediaOp = archMediaRefreshGetDependentMedia
IF @depMediaOp <> 0
BEGIN
	INSERT INTO #SkippedVol VALUES(0,1,'') -- Internal error.
	GOTO FINISH
END
-- Okay we are returned dependent media list. Check if we are good to run MR on all picked media.
-- Rules to let a media go through re-fresh.
-- 1. All dependent media must be in picked-for-refresh state.
-- 2. All dependent media must be good.
-- Exported or bad media cannot be refreshed. Skip those and their dependent media.
-- Skipped reasons :
-- -2 = Requires additional media
-- -3 = Bad Media
-- -4 = Media Not Full
-- -6 =  Exported Media,
INSERT #Vol
SELECT T.VolumeId
FROM	#TmpMRDepMediaResultSet T
LEFT OUTER JOIN		#Vol V
	ON T.VolumeId = V.VolumeId
WHERE V.VolumeId IS NULL
INSERT INTO #SkippedVol
SELECT  DISTINCT V.VolumeId,-3,M.barcode
FROM	#TmpMRDepMediaResultSet	RS1
JOIN	#TmpMRDepMediaResultSet	RS2
	ON	RS1.BucketId = RS2.BucketId
JOIN	#Vol	V
	ON V.VolumeId = RS2.VolumeId
JOIN	MMMedia	M
	ON M.MediaId = RS2.MediaId
WHERE	RS1.MediaFlags = 2 -- Bad media
--We do not have to check Media Full
-- During picking Media should be full and for dependent we need not required full media we are just reading.
--INSERT INTO #SkippedVol
--SELECT  DISTINCT V.VolumeId,-4,M.barcode
--FROM	#TmpMRDepMediaResultSet	RS1
--JOIN	#TmpMRDepMediaResultSet	RS2
--	ON	RS1.BucketId = RS2.BucketId
--JOIN	#Vol	V
--	ON V.VolumeId = RS2.VolumeId
--JOIN	MMMedia	M
--	ON M.MediaId = RS2.MediaId
--LEFT OUTER JOIN #SkippedVol	SKP
--	ON SKP.VolumeId = V.VolumeId
--WHERE	RS1.VolumeFlags <> 2 --Volume not full
--		AND SKP.VolumeId IS null
--INSERT INTO #SkippedVol
--SELECT  DISTINCT V.VolumeId,-6,M.barcode
--FROM	#TmpMRDepMediaResultSet	RS1
--JOIN	#TmpMRDepMediaResultSet	RS2
--	ON	RS1.BucketId = RS2.BucketId
--JOIN	#Vol	V
--	ON V.VolumeId = RS2.VolumeId
--JOIN	MMMedia	M
--	ON M.MediaId = RS2.MediaId
--LEFT OUTER JOIN #SkippedVol	SKP
--	ON SKP.VolumeId = V.VolumeId
--WHERE	RS1.MediaLocation  = 3 -- Exported
--		AND SKP.VolumeId IS NULL
--INSERT INTO #SkippedVol
--SELECT  DISTINCT V.VolumeId,-2,M.barcode
--FROM	#TmpMRDepMediaResultSet	RS1
--JOIN	#TmpMRDepMediaResultSet	RS2
--	ON	RS1.BucketId = RS2.BucketId
--JOIN	#Vol	V
--	ON V.VolumeId = RS2.VolumeId
--JOIN	MMMedia	M
--	ON M.MediaId = RS2.MediaId
--LEFT OUTER JOIN #SkippedVol	SKP
--	ON SKP.VolumeId = V.VolumeId
--WHERE	(RS1.VolumeAttributes & (MMS2_VOLUME_PICKED_FOR_REFRESHING | MMS2_VOLUME_PREVENT_FOR_REFRESHING)) <> MMS2_VOLUME_PICKED_FOR_REFRESHING
--	AND SKP.VolumeId IS NULL
DELETE #Vol
WHERE VolumeId IN (SELECT DISTINCT VolumeId FROM #SkippedVol)
IF NOT EXISTS(SELECT * FROM #Vol)
BEGIN
	INSERT INTO #SkippedVol VALUES(0,2,'') -- All selected media are skipped.
	GOTO FINISH
END
ELSE
BEGIN
	INSERT INTO #SkippedVol VALUES(0,3,'') -- Some media may have been skipped. There are other media that can be refreshed.
END
INSERT INTO #ToBeAgedAFC
SELECT	AFC.archFileId, AFC.CommCellId, AFC.archCopyId
FROM	archFileCopy AFC
WHERE	AFC.archCopyId = @l_targetCopyId
AND AFC.flags & 256 = 256
IF EXISTS (SELECT * FROM #ToBeAgedAFC)
BEGIN
	DECLARE	@magneticBytes integer = 0
	EXEC @retCode  = archFileDeleteViaTable 0, @magneticBytes OUTPUT
	SET @retVal = @@ERROR
	IF  @retVal = 0 SET @retVal = @retCode
	IF @retVal <> 0
	BEGIN
		INSERT INTO #SkippedVol VALUES(0,4,'')
		GOTO FINISH
	END
END
INSERT	INTO #AFCopy
SELECT	ACM.archFileId, ACM.commCellId, MIN(ACM.physicalOffset), MIN(ACM.logicalOffset), MIN(ACM.chunkNumber),0,0, 0, 0
FROM	#Vol V, archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), @PickedArchFile PAF
WHERE	AC.volumeId = V.VolumeId
	AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	AND ACM.archFileId = PAF.archfileID AND ACM.commCellId = PAF.commCellId
AND (AC.flags & 256) = 0 AND (ACM.flags & 256) = 0
GROUP BY ACM.archFileId, ACM.commCellId
END
ELSE -- For Magnetic refresh
BEGIN
	INSERT  INTO #AFCopy
	SELECT  ACM.archFileId, ACM.commCellId, MIN(ACM.physicalOffset), MIN(ACM.logicalOffset), MIN(ACM.chunkNumber),A.flags ,
(case when JL.appType in (24, 48) then 8 else 0 end), 0, CSD.SIDBStoreID
	FROM    archChunkMapping ACM WITH (NOLOCK), archFile A WITH (NOLOCK), #JobsList JL, #lt_SourceCopies SC, archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED)
	WHERE   ACM.archFileId = A.id AND ACM.commCellId = A.commCellId
		 AND ACM.jobId = JL.jobId AND ACM.commCellId = JL.commCellId
		 AND ACM.archCopyId = SC.copyId
		 AND JL.status = 101
AND (ACM.flags & 256) = 0
		AND A.AppId = CSD.AppId
		AND ACM.archCopyId = CSD.CopyId
	GROUP BY ACM.archFileId, ACM.commCellId,A.flags,JL.appType, CSD.SIDBStoreID
IF ((@l_copyDedupeFlags & 262144) > 0)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tempArchFileSIDBKeys') IS NOT NULL DROP TABLE #tempArchFileSIDBKeys
	CREATE TABLE #tempArchFileSIDBKeys
	(
		archFileId 		INT,
		commCellId 		INT,
		encRSA 			INT,
		encKeyType 		INT,
		encKey 			VARCHAR(1024),
		RowNumber 		INT,
		primary key(archFileId, commCellId, RowNumber)
	)
	CREATE TABLE #tempMMDeletedAfiles (
		archFileId int, commCellId int
	)
	CREATE INDEX Idx_tempMMDeletedAfiles_1 ON #tempMMDeletedAfiles (archFileId, commCellId)
	CREATE TABLE #muxJobs (
		jobId int, commCellId int
	)
	INSERT INTO #tempArchFileSIDBKeys
	SELECT 	K.archFileId, K.commCellId, ISNULL(keys.encRSA, K.encRSA), ISNULL(keys.encKeyType, K.encKeyType), ISNULL(keys.encKey, K.encKey),
			ROW_NUMBER() OVER (PARTITION BY K.archFileId, K.commCellId, T.SIDBStoreId ORDER BY K.archCopyId DESC) AS RowNumber
	FROM 	archFileSIDBKeys K WITH (NOLOCK)
			INNER JOIN #AFCopy T ON K.archFileId = T.archFileId AND K.CommCellid = T.CommCellid AND K.SIDBStoreId = T.SIDBStoreId
			LEFT JOIN archEncKeys keys WITH (NOLOCK) ON K.encKeyId = keys.encKeyId
	UPDATE	A
SET		Status = A.Status | 2
	OUTPUT INSERTED.archFileId, INSERTED.CommCellId INTO #tempMMDeletedAfiles
	FROM   MMDeletedAF A, #AFCopy B, IdxSIDBStore C WITH (NOLOCK)
	WHERE  A.archFileId = B.archFileId
		AND A.CommCellId = B.CommCellId
		AND A.SIDBStoreID = B.SIDBStoreID
		AND A.SIDBStoreId = C.SIDBStoreId
AND (C.flags & 2097152) = 0
AND	(A.Status & 2) = 0
	-- Hold on recopy until the old chunks have been deleted
	DELETE	B
	FROM	#tempMMDeletedAfiles A, #AFCopy B
	WHERE	A.archFileId = B.archFileId
			AND A.CommCellId = B.CommCellId
	IF EXISTS (SELECT 1 FROM MMDeletedArchFileTracking WITH (READUNCOMMITTED))
	BEGIN
		-- Hold on recopy until the old chunks have been deleted
		DELETE	#AFCopy
		FROM	MMDeletedArchFileTracking A WITH (NOLOCK), #AFCopy B, IdxSIDBStore C WITH (NOLOCK)
		WHERE	A.archFileId = B.archFileId
				AND A.CommCellId = B.CommCellId
				AND A.SIDBStoreID = B.SIDBStoreID
				AND A.SIDBStoreId = C.SIDBStoreId
AND (C.flags & 2097152) = 0
	END
	-- Hold on recopy until the DDB backup runs
	DELETE	#AFCopy
	FROM	MMTempDeletedAF A WITH (NOLOCK), #AFCopy B, IdxSIDBStore C WITH (NOLOCK)
	WHERE	A.archFileId = B.archFileId
			AND A.CommCellId = B.CommCellId
			AND A.SIDBStoreID = B.SIDBStoreID
			AND C.SIDBStoreId = A.SIDBStoreId
AND (C.flags & 2097152) = 0
		/*
		 * If destination copy has sealed stores then
		 * Reuse same key across all stores of a copy, for gdsp reuse same key across all copies of a store also.
		 * 1. If a store is sealed and archFile gets recopied with active store then reuse key from sealed store.
		 * 2. For GDSP if a copy is deleted and created a new copy then reuse key from deleted copy.
		 * If found entry in archFileSIDBKeys for above cases and there is no row with current active store
		 * then insert row for current active store so that archFileCopy table gets populated properly in below insert.
		 */
		DECLARE @l_KeyCopyId INT = @l_targetCopyId
IF (@l_copyDedupeFlags & 134217728) > 0
		BEGIN
			SELECT	@l_KeyCopyId = AG.defaultCopy
			FROM	archCopyToGlobalPolicy GP, archGroup AG
			WHERE	GP.copyId = @l_targetCopyId
					AND GP.globalPolicyId = AG.id
AND ((AG.flags & 256) > 0)
		END
		INSERT INTO archFileSIDBKeys
		SELECT 	B.archFileId, B.commCellId, @l_targetCopyId,
				case when B.encKeyId > 0 then 0 else B.encKeyType end,
				case when B.encKeyId > 0 then '' else B.encKey end,
				B.afSIDBStoreId,
				B.encRSA,
				B.encKeyId
		FROM	(SELECT K.*, T.SIDBStoreId afSIDBStoreId, ROW_NUMBER() OVER (PARTITION BY K.archFileId, K.commCellId ORDER BY K.SIDBStoreId DESC, K.archCopyId DESC) AS RowNumber
					FROM 	archFileSIDBKeys K
						INNER JOIN #AFCopy T ON K.archFileId = T.archFileId AND K.commCellId = T.commCellId
						INNER JOIN archCopySIDBStore S WITH (NOLOCK) ON K.SIDBStoreId = S.SIDBStoreId AND S.copyId = @l_KeyCopyId
						LEFT OUTER JOIN archFileSIDBKeys SK ON T.archFileId = SK.archFileId AND T.commCellId = SK.commCellId AND SK.SIDBStoreId = T.SIDBStoreId
					WHERE 	SK.archFileId IS NULL
				) B
		WHERE	B.RowNumber = 1
		-- Use Picked CommCellID to choose only those jobs with this CommCellID.
		/*
		 * Prasad Nara March 21, 2018
		 *
		 * Copy keys from source when
		 * 1. DestCopy is set to "Preserve encryption mode as in source"  OR
		 * 2. Passphrase is enabled on client.
		 *	  We can't decrypt or re-encrypt data since keys are encrypted using the user passphrase which won't be available at the time of auxcopy.  OR
		 * 3. Source encKey is encrypted using company RSA.
		 *	  Company level KeyManagementServer is set then we shouldn't decrypt or re-encrypt data.
		 *
		 * If we copy keys from source and source encKey is encrypted using copy RSA then we need to adjust the key.
		 * Decrypt using source copy RSA and encrypt back using dest copy RSA.
		 * if no key is copied for no encryption or passphrase or company RSA then set a flag CVA_AFC_COMPUTED_DEST_ENC_KEY to skip calling key adjustment code.
		 */
		 DELETE	#AFCopy
		FROM	archFileCopy AFC WITH (NOLOCK)
		WHERE	#AFCopy.archFileId = AFC.archFileId AND #AFCopy.commCellId = AFC.commCellId AND AFC.archCopyId = @l_targetCopyId
		IF NOT EXISTS (SELECT * FROM #AFCopy)
			GOTO FINISH
		INSERT INTO archFileCopy
		SELECT	A.archFileId, A.commCellId, @l_targetCopyId,
(case when A.flags & (32 + 128) = 0 then B.flags else B.flags | 32 end)
| (case when (@l_copyFlags & 1048576) > 0 AND B.passPhraseProtected <> 1 AND (ISNULL(B.encRSA, A.encRSA) & 16) = 0 AND A.encKeyType > 0 then 0 else 4096 end),
(case when (B.archFileFlags & 2) = 0 and A.physicalSize = 0 then A.isValid else 0 end),
				(1 + (A.streamNum - 1)%@max_stream),
				0, 0, 0, 0,
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then
(case when B.encRSA is null then (case when (A.encRSA & 2) > 0 then ((A.encRSA & ~2) | 4) else A.encRSA end) else B.encRSA end) else ISNULL(B.encRSA, 0) end),
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then ISNULL(B.encKeyType, A.encKeyType) else ISNULL(B.encKeyType, 0) end),
(case when (@l_copyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (ISNULL(B.encRSA, A.encRSA) & 16) > 0 then ISNULL(B.encKey, A.encKey) else ISNULL(B.encKey, '') end),
				@now, 0, 0,
				B.encKeyId, -1
		FROM	archFileCopy A,
				(SELECT DISTINCT T.*, ISNULL(keys.encRSA, K.encRSA), ISNULL(keys.encKeyType, K.encKeyType), ISNULL(keys.encKey, K.encKey), keys.encKeyId,
						ROW_NUMBER() OVER (PARTITION BY T.archFileId, T.commCellId, T.SIDBStoreID ORDER BY K.archCopyId DESC) AS RowNumber
				FROM	#AFCopy T LEFT OUTER JOIN archFileSIDBKeys K WITH (NOLOCK)
					ON	K.archFileId = T.archFileId AND K.commCellId = T.commCellId AND K.SIDBStoreId = T.SIDBStoreId
						LEFT JOIN archEncKeys keys WITH (NOLOCK) ON K.encKeyId = keys.encKeyId
				) B
		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @i_copyId AND RowNumber = 1
		-- Populate keys in archFileSIDBKeys when no key adjustment is needed
		INSERT INTO archFileSIDBKeys
		SELECT	DISTINCT T.archFileId, T.commCellId, T.archCopyId,
				case when T.encKeyId > 0 then 0 else T.encKeyType end,
				case when T.encKeyId > 0 then '' else T.encKey end,
				T.SIDBStoreId,
				T.encRSA,
				T.encKeyId
		FROM	(
					SELECT	A.archFileId, A.commCellId, A.archCopyId, A.encKeyType, A.encKey, A.encRSA, B.SIDBStoreId, A.encKeyId
					FROM	archFileCopy A, #AFCopy B
					WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = @l_targetCopyId
							AND (A.encRSA & (4 | 1)) = 0 AND A.encKeyType > 0
				) T LEFT OUTER JOIN archFileSIDBKeys K
			ON	K.archFileId = T.archFileId AND K.commCellId = T.commCellId AND K.SIDBStoreId = T.SIDBStoreId
		WHERE	K.archFileId Is Null
		-- If the recopy option was selected then we should delete the rows from archFileSubStore otherwise primary and secondary obj count will get duplicated
		-- Since the recopy is not populating MMDeletedAF table with original archive file id, we are not removing the row.
		-- DELETE FROM archFileSubStore
		-- FROM	archFileSubStore SS, #AFCopy AF
		-- WHERE	SS.archFileId = AF.archFileId
		-- 		AND SS.CommCellId = AF.CommCellId
		-- 		AND SS.SIDBStoreId = @l_SIDBStoreId
		DELETE FROM	#AFCopy
		FROM	#AFCopy T LEFT OUTER JOIN archFileCopy AFC
			ON	T.archFileId = AFC.archFileId
				AND T.CommCellId = AFC.CommCellId
				AND AFC.archCopyId = @l_targetCopyId
		WHERE AFC.archFileID IS NULL
		INSERT	INTO archFileCopyDedup(archFileId, commCellId, archCopyId, SIDBStoreId,
										primaryObjects, secondaryObjects, primaryObjSize, secondaryObjSize,
										primaryMetaDataSize, secondaryMetaDataSize, transDataSize, savedDataSize)
		SELECT  T.archFileId, T.CommCellId, @l_targetCopyId, T.SIDBStoreId,
				0, 0, 0, 0,
				0, 0, 0, 0
		FROM	#AFCopy T
		INSERT INTO archFileSubStore(archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
		SELECT	T.archFileId, T.CommCellId, S.SIDBStoreId, S.SubStoreId, 0, 0
		FROM	IdxSIDBSubStore S WITH (NOLOCK) INNER JOIN #AFCopy T ON S.SIDBStoreId = T.SIDBStoreId
					LEFT OUTER JOIN archFileSubStore AFS ON T.archFileId = AFS.archFileId AND T.CommCellId = AFS.CommCellId AND AFS.SIDBStoreId = S.SIDBStoreId AND AFS.SIDBSubStoreId = S.SubStoreId
		WHERE	AFS.archFileId IS NULL
	END
END
DECLARE @l_EnableReEnc INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED)
											WHERE name = 'MM_CONFIG_ENABLE_RE_ENCRYPTION_FOR_MEDIA_REFRESH'), 0)
IF @l_EnableReEnc > 0
BEGIN
	--If encKeys on source copy are protected with user pass phrase then we ignore dest copy encryption settings and copy data as is
	--So we should preserve source copy encryption keys on dest copy regardless of options selected on dest copy.
	UPDATE 	TAF
	SET 	passPhraseProtected = 1
	FROM	#AFCopy TAF, archFile AF WITH (READUNCOMMITTED),
			App_Application App WITH(READUNCOMMITTED), App_ClientProp CP WITH(READUNCOMMITTED)
	WHERE	TAF.archFileId = AF.id
			AND TAF.commCellId = AF.commCellId
			AND AF.appId = App.id
			AND App.clientId = CP.componentNameId
			AND CP.attrName = N'Encrypt: restoreAccess'
			AND CP.attrVal = '1'  /*ENC_RESTORE_PASSPHRASE*/
			AND CP.modified = 0
END
ELSE
BEGIN
	--If re-encryption support for MediaRefresh is not enabled then copy keys from source as is
	--Setting passPhraseProtected to 1 in this case since we do pass through when this is set
	UPDATE 	TAF
	SET 	passPhraseProtected = 1
	FROM	#AFCopy TAF
END
-- Readjust encKeys for uncopied/partially copied archive Files
UPDATE	Dest
SET		encRSA = (case when (@l_targetCopyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (Src.encRSA & 16) > 0
						then Src.encRSA
else (case when (@l_targetCopyFlags & 8388608) > 0 then Dest.encRSA else 0 end)
					end),
encKeyType = (case when (@l_targetCopyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (Src.encRSA & 16) > 0
							then Src.encKeyType
else (case when (@l_targetCopyFlags & 8388608) > 0 then Dest.encKeyType else 0 end)
						end),
encKey = (case when (@l_targetCopyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (Src.encRSA & 16) > 0
						then Src.encKey
else (case when (@l_targetCopyFlags & 8388608) > 0 then Dest.encKey else '' end)
					end),
encKeyid = (case when (@l_targetCopyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (Src.encRSA & 16) > 0
						then Src.encKeyId
else (case when (@l_targetCopyFlags & 8388608) > 0 then Dest.encKeyId else 0 end)
					end)
FROM	#AFCopy TAF
		INNER JOIN archFileCopy Dest WITH (READUNCOMMITTED) ON TAF.archFileId = Dest.archFileId AND TAF.CommCellId = Dest.CommCellId
				AND Dest.archCopyId = @l_targetCopyId
		INNER JOIN archFileCopy Src WITH (READUNCOMMITTED) ON Dest.archFileId = Src.archFileId AND Dest.CommCellId = Src.CommCellId
		INNER JOIN #lt_SourceCopies SC ON Src.archCopyId = SC.copyId
WHERE	(Dest.Flags & 256) = 0
		AND Dest.isValid = 0
		AND
		(
			(
				--Uncopied AF
				Dest.physicalSize = 0
				AND Dest.logicalSize = 0
				AND Dest.lastChunkNumber = 0
			)
			OR
			(
				--Partially copied AF
((@l_targetCopyFlags & 1048576) > 0 OR TAF.passPhraseProtected = 1 OR (Src.encRSA & 16) > 0)
				AND Src.encKeyType > 0 AND Dest.encKeyType = 0
				AND Dest.lastChunkNumber > 0
			)
		)
DELETE	#AFCopy
FROM	archFileCopy AFC WITH (NOLOCK)
WHERE	#AFCopy.archFileId = AFC.archFileId AND #AFCopy.commCellId = AFC.commCellId AND AFC.archCopyId = @l_targetCopyId
IF NOT EXISTS (SELECT * FROM #AFCopy)
	GOTO FINISH
INSERT INTO archFileCopy
SELECT	A.archFileId, A.commCellId, @l_targetCopyId, A.flags | 4096, 0, (1 + (A.streamNum - 1)%@max_stream),
		(B.lastChunkNumber - 1), B.minPhysicalOffset, B.minLogicalOffset, 0,
(case when (@l_targetCopyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encRSA else 0 end),
(case when (@l_targetCopyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encKeyType else 0 end),
(case when (@l_targetCopyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encKey else '' end),
		@now, 0, 0,
(case when (@l_targetCopyFlags & 1048576) > 0 OR B.passPhraseProtected = 1 OR (A.encRSA & 16) > 0 then A.encKeyId else 0 end), -1
FROM	archFileCopy A, #AFCopy B, #lt_SourceCopies SC
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
		AND A.archCopyId = SC.copyId
FINISH:
SELECT VolumeId,rCode,barcode
FROM #SkippedVol
ORDER BY VolumeId ASC
DROP TABLE #Vol
DROP TABLE #AFCopy
DROP TABLE #ToBeAgedAFC
IF  object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
DROP TABLE #SkippedVol
--SELECT   @retVal
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archMediaRefreshingAddArchFileCopy')
	delete from GxQscripts where name = 'archMediaRefreshingAddArchFileCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshingAddArchFileCopy')
	delete from GXDBVersions where aliasname = 'archMediaRefreshingAddArchFileCopy'
GO

insert into GXDBVersions values(2, 'archMediaRefreshingAddArchFileCopy',  '00010014004200140000', 'archMediaRefreshingAddArchFileCopy', '00010014004200140000')
GO

