

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMediaRefreshGetDependentMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMediaRefreshGetDependentMedia.sp,v $ $Id: archMediaRefreshGetDependentMedia.sp,v 1.5.2.2 2018/03/22 01:10:32 jiechen Exp $";
-- ------------------------------------------------------------------------------------------------------------------------------------
--
--	This stored procedure computes dependent media list for given input media.
--	This stored procedure is called at places when completeness check for media refresh is required.
-- ------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMediaRefreshGetDependentMedia <<<'

IF EXISTS (select * from sysobjects where name='archMediaRefreshGetDependentMedia')
	drop procedure archMediaRefreshGetDependentMedia
IF EXISTS (select * from GxQscripts where name='archMediaRefreshGetDependentMedia')
	delete from GxQscripts where name = 'archMediaRefreshGetDependentMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshGetDependentMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshGetDependentMedia'
GO
print '... Creating Procedure: archMediaRefreshGetDependentMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMediaRefreshGetDependentMedia
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--  Notes:
--  What is Completeness check of media ?
--	ArchiveFiles on list of media that is selected for refresh MUST be complete. In other words,  media having partial archive files
--	cannot be refreshed in isolation. A couple of examples will drive home the point:
--	Ex1: We have an archiveFile AF1 that spanned multiple media M1 & M2. We cannot refresh M1 alone. For refresh to work on M1,
--	 	 M2 must also be picked.
--	Ex2: Say we have 2 ArchiveFiles AF1 & AF2 that have spanned media M1,M2 and M3. ArchiveFiles are laid out as follows:
--		 M1 [AF1], M2 [AF1,AF2] & M3 [AF2]
--		 So if we want to refresh M1 then M2 & M3 should also be picked to satisfy the completeness check.
-- Why is completeness check enforced?
-- Without completeness check (till 9.0 SP6), the user could pick any media for refresh that may have a partial archive file.
-- Due to this, it is possible that chunks from an archive file may get refreshed out-of-order resulting in lower chunks (wtih lower
-- chunk numbers) having higher chunkIds. Such a chunk ordering is not favourable for restores and could cause auxCopy failures too in case
-- out-of-order chunks reside on the same volume.
-- ====================================================== TODOs ======================================================
-- 1. Write a recursive CTE.
-- ================================================ Tricky Scenarios:==============================================================
-- 1. It perhaps is possible that a volume may have Afiles from multiple copies (possibly from multiple SPs). And, the newly picked
--    media may belong to a copy where refresh is not enabled. [This is not possible till 11.0 and until GACP feature is enabled.]
-- =================================================================================================================================
-- This stored procedure expects the following 2 temp tables to be created before it is invoked.
-- [This is the input table where the user fills out VolumeIds for which dependent is desired. ]
-- #TmpMRDepMediaUI(VolumeId INT)
-- [This is the output table and the result set goes into this table. All dependent media are grouped by BucketId. Also returned are
--  volume & media info that is necessary for various refresh operations.]
-- #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT,
--		MediaId INT, MediaLocation INT, MediaFlags INT)
IF  object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  null OR
	object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  null
BEGIN
	SET @retVal = -1 -- required temp tables not present.
	GOTO SCRIPT_EXIT
END
IF object_id('tempdb.dbo.#TmpInVoldIds') IS  NOT null DROP TABLE #TmpInVoldIds
IF object_id('tempdb.dbo.#TmpSelectedAFIds') IS  NOT null DROP TABLE #TmpSelectedAFIds
CREATE TABLE #TmpInVoldIds(AID INT IDENTITY (1,1),VolumeId INT, iteration INT,reqdVolumeId INT, BucketId INT)
CREATE TABLE #TmpSelectedAFIds (archFileId INT, CommCellId INT, VolumeId INT, srcCopyID INT,iteration INT)
CREATE INDEX TmpSelectedAFIds_idx1 ON #TmpSelectedAFIds (archFileId, CommCellId, srcCopyID)
CREATE INDEX TmpSelectedAFIds_idx2 ON #TmpSelectedAFIds (archFileId, CommCellId , srcCopyID,VolumeId)
CREATE INDEX TmpSelectedAFIds_idx3 ON #TmpSelectedAFIds (iteration)
CREATE INDEX TmpInVoldIds_idx1 ON #TmpInVoldIds(VolumeId)
CREATE INDEX TmpInVoldIds_idx2 ON #TmpInVoldIds(iteration)
CREATE INDEX TmpInVoldIds_idx3 ON #TmpInVoldIds(AID)
CREATE INDEX TmpInVoldIds_idx4 ON #TmpInVoldIds(reqdVolumeId)
CREATE TABLE #TmpVolumeBuckets(BID INT, VolumeId INT)
CREATE INDEX TmpVolumeBuckets_idx1 ON #TmpVolumeBuckets(VolumeId)
CREATE INDEX TmpVolumeBuckets_idx2 ON #TmpVolumeBuckets(BID)
CREATE INDEX TmpVolumeBuckets_idx3 ON #TmpVolumeBuckets(BID,VolumeId)
DECLARE @level INT
DECLARE @maxLoopCount bigint
DECLARE @curLoopCount bigint
SELECT @maxLoopCount = COUNT(*) FROM MMVolume WITH (NOLOCK)
SET  @level = 1
INSERT INTO #TmpInVoldIds
SELECT DISTINCT *,0,0,0
FROM #TmpMRDepMediaUI
-- Get all archFiles from selected vols.
INSERT INTO #TmpSelectedAFIds
SELECT ACM.archFileId,ACM.CommCellId, AC.VolumeId,ACM.archCopyId,0
FROM	archChunkMapping  ACM	WITH(NOLOCK)
JOIN	archChunk			AC	WITH(NOLOCK)
	ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
JOIN	MMVolume	V	WITH(NOLOCK)
	ON AC.VolumeId = V.VolumeId AND AC.commCellId= V.origCCcommCellID
JOIN	#TmpInVoldIds	TV
	ON TV.VolumeId = V.VolumeId
JOIN	archFileCopy	AFC
	ON AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId
WHERE	(AC.flags & 256) = 0
AND (ACM.flags & 256) = 0
AND (AFC.flags & 256) = 0
GROUP BY ACM.archCopyId, ACM.CommCellId, ACM.archFileId, AC.VolumeId
SET @curLoopCount  = 0
--WHILE (@curLoopCount < @maxLoopCount)
BEGIN
	-- Fetch other volumes where archFiles from #TmpSelectedAFIds may reside.
	INSERT INTO #TmpInVoldIds
	SELECT	DISTINCT  AC.VolumeId,@level,T.VolumeId,0
	FROM	archChunkMapping	ACM	WITH(NOLOCK)
	JOIN	archChunk			AC	WITH(NOLOCK)
		ON AC.id = ACM.archChunkId	AND AC.commCellId = ACM.chunkCommCellId
	JOIN	MMVolume	V	WITH(NOLOCK)
		ON AC.VolumeId = V.VolumeId AND AC.commCellId= V.origCCcommCellID
	JOIN	#TmpSelectedAFIds T
		ON T.srcCopyID = ACM.archCopyId AND T.archFileId = ACM.archFileId AND T.CommCellId = ACM.CommCellId
		AND T.VolumeId <> AC.VolumeId AND T.iteration = @level - 1
	--IF @@ROWCOUNT = 0
	--  break
	-- We just added one or more new volumes. Pick new archive files from these newly added volumes.
	-- Should we be filtering out data from transitive copies ??
	--INSERT INTO #TmpSelectedAFIds
	--SELECT	DISTINCT ACM.archFileId,ACM.commCellId,AC.VolumeId,ACM.archCopyId,@level
	--FROM	archChunkMapping	ACM	WITH(NOLOCK)
	--JOIN	archChunk			AC	WITH(NOLOCK)
	--	ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	--JOIN	MMVolume	V	WITH(NOLOCK)
	--	ON AC.VolumeId = V.VolumeId  AND AC.commCellId= V.origCCcommCellID
	--JOIN	#TmpInVoldIds	TV
	--	ON TV.VolumeId = V.VolumeId
	--JOIN	archFileCopy	AFC
	--	ON AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId
	--WHERE	AFC.isValid = 1
	--		AND (AC.flags & CVA_AGED_DATA_FLAG) = 0
	--		AND (ACM.flags & CVA_AGED_DATA_FLAG) = 0
	--		AND (AFC.flags & CVA_AGED_DATA_FLAG) = 0
	--		AND		TV.iteration = @level
	--		AND NOT EXISTS (SELECT * FROM #TmpSelectedAFIds SAF
	--						WHERE	SAF.archFileId = ACM.archFileId AND
	--								SAF.VolumeId = AC.VolumeId AND
	--								SAF.srcCopyID = ACM.archCopyId AND
	--								SAF.CommCellId  = ACM.CommCellId
	--								)
	--GROUP BY ACM.archCopyId,ACM.commCellId, ACM.archFileId, AC.VolumeId
	--
	--IF @@ROWCOUNT = 0
	--  break
	--SET @level = @level + 1
	--SET @curLoopCount = @curLoopCount + 1
END
--IF(@curLoopCount >=  @maxLoopCount)
--BEGIN
--	SET @retVal = -2 -- stuck in a loop.
--	GOTO SCRIPT_EXIT
--END
-- Group dependent volumes into common buckets.
-- Here is what we are trying to do. Say we have dependecy (based on AFiles) over volumes as shown in [INPUT].  This input is held in
-- #TmpInVoldIds table.
-- We would group the dependent volumes into buckets as shown in [OUTPUT] by running the following code. The [OUTPUT] is space efficient.
-- [INPUT]											[OUTPUT]
--	VolumeId	reqdVolumeId						BID	VolumeId
-- ---------------------------						--------------
--	100			0									1	100
--	100			101									1	101
--	101			0									1	102
--	101			100									1	103
--	101			102									1	104
--	102			101									2	105
--	102			103									3	106
--	102			104									3	107
--	103			102									4	113
--	104			102
--	105			0
--	106			0
--	106			107
--	107			0
--	107			106
--	113			0
-- Note that dependent volumes have the same BucketId
DECLARE @tmpAID INT
DECLARE @tmpVolId INT
DECLARE @tmpReqdVolId INT
DECLARE @tmpBucketId INT
DECLARE	@tmpNewBucketId INT
DECLARE FillBucketNewCur CURSOR DYNAMIC FOR
SELECT VolumeId, reqdVolumeId,AID  --,BucketId
FROM	#TmpInVoldIds
WHERE BucketId = 0
ORDER BY AID
OPEN FillBucketNewCur
FETCH NEXT FROM FillBucketNewCur INTO
@tmpVolId, @tmpReqdVolId, @tmpAID --,@tmpBucketId
WHILE @@FETCH_STATUS = 0
BEGIN
	SELECT @tmpNewBucketId  = MAX(BucketId) + 1
	FROM	#TmpInVoldIds
	SELECT @tmpBucketId = BucketId FROM	#TmpInVoldIds
	WHERE	AID = @tmpAID
	IF(@tmpBucketId = 0)
	BEGIN
		UPDATE #TmpInVoldIds 	SET BucketId = @tmpNewBucketId
		WHERE	VolumeId = @tmpVolId OR reqdVolumeId = @tmpVolId
				AND BucketId = 0
		IF(@tmpReqdVolId > 0 )
		UPDATE #TmpInVoldIds 	SET BucketId = @tmpNewBucketId
		WHERE	VolumeId = @tmpReqdVolId  OR reqdVolumeId = @tmpReqdVolId
				AND BucketId = 0
		WHILE(1 = 1)
		BEGIN
			DECLARE @tblVoldIds TABLE ( AID int)
			INSERT @tblVoldIds
			SELECT T2.AID
			FROM #TmpInVoldIds  T1, #TmpInVoldIds  T2
			WHERE	T1.BucketId = @tmpNewBucketId  AND T2.BucketId = 0
				AND	(T1.VolumeId = T2.VolumeId OR T1.VolumeId = T2.reqdVolumeId)
			UNION
			SELECT  T2.AID
			FROM #TmpInVoldIds  T1, #TmpInVoldIds  T2
			WHERE	T1.BucketId = @tmpNewBucketId  AND T2.BucketId = 0 AND T1.reqdVolumeId > 0
				AND	(T1.reqdVolumeId = T2.VolumeId OR T1.reqdVolumeId = T2.reqdVolumeId)
			UPDATE #TmpInVoldIds  SET BucketId = @tmpNewBucketId
			FROM #TmpInVoldIds T, @tblVoldIds D
			  WHERE T.AID = D.AID AND BucketId  = 0
			IF(@@ROWCOUNT = 0)
			   BREAK
		END
	END
	FETCH NEXT FROM FillBucketNewCur INTO
	@tmpVolId, @tmpReqdVolId, @tmpAID --,@tmpBucketId
END
CLOSE		FillBucketNewCur
DEALLOCATE	FillBucketNewCur
INSERT INTO #TmpVolumeBuckets
SELECT DISTINCT BucketId,VolumeId
FROM	#TmpInVoldIds
WHERE	BucketId > 0
INSERT INTO #TmpVolumeBuckets
SELECT DISTINCT BucketId,reqdVolumeId
FROM	#TmpInVoldIds	T
LEFT OUTER JOIN	#TmpVolumeBuckets	TB
	ON	TB.VolumeId = T.reqdVolumeId
WHERE	T.reqdVolumeId > 0 AND  BucketId > 0
		AND TB.VolumeId IS NULL
DELETE #TmpMRDepMediaResultSet
INSERT INTO #TmpMRDepMediaResultSet
SELECT TB.BID,V.VolumeId,V.VolumeFlags,V.Attributes,M.MediaId,M.MediaLocation, M.MediaFlags
FROM	#TmpVolumeBuckets  TB
JOIN	MMVolume			V
	ON V.VolumeId = TB.VolumeId
JOIN	MMMedia	M
	ON M.MediaId = V.MediaId
SET	@retVal = @@ERROR
SCRIPT_EXIT:
DROP TABLE #TmpInVoldIds
DROP TABLE #TmpSelectedAFIds
DROP TABLE #TmpVolumeBuckets
RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archMediaRefreshGetDependentMedia')
	delete from GxQscripts where name = 'archMediaRefreshGetDependentMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMediaRefreshGetDependentMedia')
	delete from GXDBVersions where aliasname = 'archMediaRefreshGetDependentMedia'
GO

insert into GXDBVersions values(2, 'archMediaRefreshGetDependentMedia',  '00010005000200020000', 'archMediaRefreshGetDependentMedia', '00010005000200020000')
GO

