

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMaterializeSnapshotUnpickJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMaterializeSnapshotUnpickJobs.sp,v $ $Id: archMaterializeSnapshotUnpickJobs.sp,v 1.6.54.2 2020/01/24 17:15:07 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archMaterializeSnapshotUnpickJobs')
BEGIN
	print '>>> Drop Stored Procedure: archMaterializeSnapshotUnpickJobs <<<'
	drop procedure archMaterializeSnapshotUnpickJobs
END
IF EXISTS (select * from GxQscripts where name='archMaterializeSnapshotUnpickJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotUnpickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotUnpickJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotUnpickJobs'
GO
print '... Creating Procedure: archMaterializeSnapshotUnpickJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archMaterializeSnapshotUnpickJobs
  @i_archGroupId integer,
  @i_jobIdsXml xml,
  @i_unPickReason integer,
  @i_userId integer
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
SET @retVal = 0
CREATE TABLE #tempJobIds (jobId int, commCellId int)
INSERT	INTO #tempJobIds
SELECT	T.c.value('@jobId', 'int'), T.c.value('@commCellId', 'int')
FROM	@i_jobIdsXml.nodes('/r/h') T(c)
--Do not unpick jobs when backup copy job is running on the storage policy
IF EXISTS(SELECT 1 FROM #tempJobIds A INNER JOIN JMJobWF JWF WITH(NOLOCK) ON A.jobId = JWF.processedJobId AND A.commCellId = JWF.processedCommcellId
INNER JOIN JMJobInfo J WITH(NOLOCK) ON J.jobId = JWF.childJobId AND J.commCellId = JWF.commcellId AND J.opType = 60) --enum CVOpType{ SNAPTOTAPE = 60
BEGIN
SET @retVal = 147
    GOTO PROC_EXIT
END
UPDATE	JMJobSnapShotStats
SET		disabled = (J.disabled | 1), unPickReason = @i_unPickReason
FROM	JMJobSnapShotStats J, #tempJobIds T
WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
	AND J.archGrpId = @i_archGroupId
	AND (J.disabled & 1) = 0
IF(@@ROWCOUNT > 0)
BEGIN
	DECLARE @opMsgId            INTEGER
	DECLARE @opEvMsgId      INTEGER
	DECLARE @opId               INTEGER
	DECLARE @paramMsgId     INTEGER
	DECLARE @jobIdList VARCHAR(MAX)
	DECLARE @GUISPName NVARCHAR(256)
	IF(@i_userId = 0)
		SET @i_userId = 1
SET @opMsgId = (188 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 17, @i_archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
	SELECT @GUISPName = name FROM archGroup WITH (NOLOCK) WHERE Id = @i_archGroupId
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @GUISPName, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	WHILE(EXISTS(SELECT 1 FROM #tempJobIds))
	BEGIN
		SET @jobIdList = NULL
		SELECT TOP 50 @jobIdList = COALESCE(@jobIdList + ',', '') + CAST(jobId as varchar(10))
		FROM #tempJobIds
		ORDER BY jobId
SET @paramMsgId = (3 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @jobIdList, 1
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		;WITH CTE
	     AS (SELECT TOP 50 *
	         FROM   #tempJobIds
	         ORDER  BY jobId)
		DELETE FROM CTE
	END
END
PROC_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempJobIds') IS NOT NULL
    DROP TABLE #tempJobIds
SELECT  @retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMaterializeSnapshotUnpickJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotUnpickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotUnpickJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotUnpickJobs'
GO

insert into GXDBVersions values(2, 'archMaterializeSnapshotUnpickJobs',  '00010006005400020000', 'archMaterializeSnapshotUnpickJobs', '00010006005400020000')
GO

