

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMaterializeSnapshotPickNewJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMaterializeSnapshotPickNewJob.sp,v $ $Id: archMaterializeSnapshotPickNewJob.sp,v 1.23.54.4 2018/10/13 06:17:59 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archMaterializeSnapshotPickNewJob')
BEGIN
	print '>>> Drop Stored Procedure: archMaterializeSnapshotPickNewJob <<<'
	drop procedure archMaterializeSnapshotPickNewJob
END
IF EXISTS (select * from GxQscripts where name='archMaterializeSnapshotPickNewJob')
	delete from GxQscripts where name = 'archMaterializeSnapshotPickNewJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotPickNewJob')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotPickNewJob'
GO
print '... Creating Procedure: archMaterializeSnapshotPickNewJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMaterializeSnapshotPickNewJob
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_today integer
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
DECLARE	@i_commCellId   INTEGER
SET	@i_commCellId = 2
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
SET @retVal = 0
-- Check if backup of snapshot is applicable
IF NOT EXISTS (
	SELECT * FROM JMOpTable
	WHERE	appTypeType = @i_appType AND operation = 60)
	GOTO RETURN_PROC
DECLARE	@l_archGroupId	INT = 0
DECLARE	@l_enabled		INT = 0
DECLARE	@l_type			INT = 0
DECLARE	@l_flags		INT = 0
DECLARE	@l_startTime	INT = 0
DECLARE	@l_sourceCopyId	INT = 0
DECLARE	@l_numPeriod	INT = 0
DECLARE	@l_dayNumber	INT = 0
DECLARE	@l_currPeriodBegin	INT = 0
DECLARE	@l_currPeriodEnd	INT = 0
DECLARE	@l_prevPeriodBegin	INT = 0
DECLARE	@l_nextPeriodEnd	INT = 0
DECLARE @l_inlineBackupCopyType INT = 0
DECLARE @l_operationType INT = 0
DECLARE @l_bkpAttributesEx BIGINT = 0
DECLARE @isVSAV2Parent INT = 0
if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
CREATE TABLE #archGroupToAppId (
archGroupId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
IF EXISTS
(
		SELECT 1
		FROM JMJobDataLink JDL WITH (NOLOCK)
		WHERE JDL.parentJobId = @i_jobId
		AND JDL.commcellId = @i_commCellId
AND JDL.linkType = 7
)
BEGIN
	SET @isVSAV2Parent = 1
END
SELECT	@l_archGroupId = J.archGrpId, @l_flags =  SnapProp.flags
FROM	JMJobDataStats J WITH (NOLOCK), archGroupCopy C WITH (NOLOCK), ArchMaterializeSnapshotProp SnapProp WITH (NOLOCK), ArchGroup AG WITH (NOLOCK)
WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId AND J.dataType IN (1, 4)
	AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
	AND J.archGrpCopyId = C.id AND C.isSnapCopy = 1 AND J.archGrpId = SnapProp.archGroupId AND J.archGrpId = AG.id
	AND ((SnapProp.sourceCopyId > 0 AND J.archGrpCopyId = SnapProp.sourceCopyId) OR (SnapProp.sourceCopyId <=0 AND J.archGrpCopyId = AG.defaultSnapCopy))
IF @l_archGroupId = 0
	GOTO RETURN_PROC
SELECT @l_bkpAttributesEx = bkpAttributesEx
FROM JMBkpStats WITH (NOLOCK)
WHERE jobId = @i_jobId AND commCellId = @i_commCellId
-- Check for selective subclient association for Backup copy
SET @l_operationType = 1
IF EXISTS (SELECT 1 FROM archGroupToApp WITH (NOLOCK) WHERE archGroupId = @l_archGroupId AND OperationType = @l_operationType AND assocType <> 2)
BEGIN
	INSERT INTO #archGroupToAppId
	SELECT @l_archGroupId, @i_appId
	exec archGetArchGroupToAppAssociations @l_archGroupId, @l_operationType
	IF NOT EXISTS (
	    SELECT	1
			FROM	#archGroupToAppId t
			WHERE t.archGroupId = @l_archGroupId  AND t.AppId = @i_appId
	) AND @isVSAV2Parent = 0
	BEGIN
		GOTO RETURN_PROC
	END
END
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags, @l_startTime = startTime,
		@l_sourceCopyId = sourceCopyId, @l_numPeriod = numPeriod, @l_dayNumber = dayNumber,
		@l_currPeriodBegin = currPeriodBegin, @l_currPeriodEnd = currPeriodEnd,
		@l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	ArchMaterializeSnapshotProp
WHERE	archGroupId = @l_archGroupId
IF @l_sourceCopyId = 0
	SELECT @l_sourceCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @l_archGroupId
	--If parent job is a non-snap job pick child job here, else pick child job when parent job actually gets picked
	DECLARE @vsaAppawareIsSnapJob int = -1
	SELECT @vsaAppawareIsSnapJob = CASE WHEN ISNULL(RJ.opType, JBKP.opType) IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
	FROM JMVSAAppJobLink JVJ WITH(NOLOCK)
	/*Parent job doesn't complete until all child jobs complete, so check running job table*/
	LEFT OUTER JOIN JMJobInfo RJ WITH(NOLOCK) ON JVJ.parentJobId = RJ.jobId AND JVJ.commcellId = RJ.commcellId
	LEFT OUTER JOIN JMBkpStats JBKP WITH(NOLOCK) ON JVJ.parentJobId = JBKP.jobId AND JVJ.commcellId = JBKP.commcellId
	WHERE JVJ.childJobId = @i_jobId AND JVJ.commcellId = @i_commCellId AND (RJ.jobId IS NOT NULL OR JBKP.jobId IS NOT NULL)
	IF @vsaAppawareIsSnapJob = 0
		GOTO PICK_JOB
	--Earlier we were skipping processing child jobs by themselves. Now we do process them (Yea, requirements changed!).
	--ELSE IF @vsaAppawareIsSnapJob = 1
	--    GOTO RETURN_PROC
	--If this is a parent VSA job and child is already picked go ahead and pick this job
	IF EXISTS
	(
SELECT 1 FROM JMVSAAppJobLink JVJ WITH(NOLOCK) INNER JOIN JMJobSnapShotStats JSS WITH(NOLOCK) ON JVJ.childJobId = JSS.jobId AND JVJ.commcellId = JSS.commcellId
WHERE JVJ.parentJobId = @i_jobId AND JVJ.commcellId = @i_commCellId AND JSS.materializationStatus IN(101, 102, 103) AND JSS.disabled & 1 = 0
	)
		GOTO SELECT_JOB
	--If this is a parent VSA V2 job and child VM job is already picked, then go ahead and pick this job
	IF @isVSAV2Parent = 1
	BEGIN
		IF EXISTS
		(
			SELECT 1
FROM JMJobDataLink JDL WITH (NOLOCK) INNER JOIN JMJobSnapShotStats JSS WITH(NOLOCK)
			ON 	JDL.childJobId = JSS.jobId
			AND JDL.commcellId = JSS.commcellId
			WHERE JDL.parentJobId = @i_jobId
			AND JDL.commcellId = @i_commCellId
AND JDL.linkType = 7
AND JSS.materializationStatus IN (101, 102, 103)
			AND JSS.disabled & 1 = 0
		)
		BEGIN
			GOTO PICK_JOB
		END
		ELSE
		BEGIN
			GOTO RETURN_PROC
		END
	END
/*
If the snap backup job option to backup copy only latest cycle is enabled and the backup level is full backup we will unpick all the snap jobs
that are pending backup copy (and not currently being backup copied) and set the unpick reason and pick this job for backup copy.
With this option we are overriding the storage policy rules for backup copy selection.
*/
IF (@i_backupLevel IN (1, 64, 128, 1024, 32768) OR dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_CommCellId, @l_sourceCopyId) = 1) AND @l_enabled <> 0
BEGIN
SELECT @l_inlineBackupCopyType = dbo.getjobOption(@i_jobId, 1730122864)
IF @l_inlineBackupCopyType = 2
	BEGIN
UPDATE JMJobSnapshotStats SET disabled = (disabled | 1), unPickReason = 2
		FROM JMJobSnapshotStats jss left outer join
		--enum CvOptype{ SNAPTOTAPEWORKFLOW = 61,
		--enum CvOptype{ SNAPTOTAPE = 60,
		(SELECT jwf.* FROM JMJobWF jwf WITH (NOLOCK) inner join JMJobInfo rj WITH (NOLOCK) ON jwf.childJobId = rj.jobId AND jwf.commcellId = rj.commCellId AND rj.opType = 60) T
		ON
		jss.jobId = T.processedJobId AND jss.commcellId = T.processedCommcellId
		WHERE T.jobId is null AND jss.appId = @i_appId AND jss.materializationStatus in (101, 102,103, 104) AND (jss.disabled & 1) = 0 --AND jss.archGrpId = @l_archGroupId
		GOTO SELECT_JOB
	END
END
IF	@l_enabled = 0
OR @l_type = 9
 OR (
@l_type <> 0
 			AND (
	 					(@i_backupLevel NOT IN (1, 64, 128, 1024, 32768) AND dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_CommCellId, @l_sourceCopyId) <> 1)
 						OR
 						(@l_bkpAttributesEx & @EX_APPAWARE_CHILD_JOB > 0 AND @l_bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE = 0)
 					)
 		)
 OR @i_startDate < @l_startTime
 GOTO RETURN_PROC
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
	GOTO SELECT_JOB
-- Apply selection rules.
IF	@l_type IN (1, 10, 3, 2, 4, 6)
BEGIN
	DECLARE @l_startDate	INT = 0
	DECLARE @l_fullCycleNum	INT = 0
	SELECT	TOP 1 @l_startDate = J.servStartDate, @l_fullCycleNum = J.fullCycleNum
	FROM	JMBkpStats J WITH (NOLOCK),
JMJobSnapShotStats S WITH (NOLOCK)
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId
AND S.appId = @i_appId AND ((S.materializationStatus IN (101, 102, 103) AND S.disabled & (1+256) = 0) OR S.materializationStatus = 100)
	ORDER BY J.servStartDate DESC
IF	@l_type = 1
	BEGIN
		IF	@i_fullCycleNum < (@l_numPeriod + @l_fullCycleNum)
			GOTO RETURN_PROC
	END
	ELSE
IF	@l_type IN (10, 3, 2, 4, 6)
	BEGIN
		DECLARE	@l_nextFullTime	INTEGER
		DECLARE @tblNextFullTime TABLE (nextFullTime int)
		INSERT  INTO @tblNextFullTime
		EXEC @l_nextFullTime = TM_GetNextScheduleRunTime @i_appId, 1/*BackupLvl- Full*/, 1/*countDisabled*/, 0/*countRunningJob*/
		/*
		If option to consider incremental as full is set on the policy and this appId fits for that setting and if there is an incremental schedule coming up
		before full schedule use that as the nex full time for job selection decision
		*/
		IF (dbo.GetBkpLevelForSnapCopy(@i_appId, 2, @l_sourceCopyId) = 1)
		BEGIN
			DECLARE @l_nextFullTimeForSnap INTEGER
    		INSERT INTO @tblNextFullTime
    		EXEC @l_nextFullTimeForSnap = TM_GetNextScheduleRunTime @i_appId, 2/*BackupLvl- Incr*/, 1/*countDisabled*/, 0/*countRunningJob*/
    		IF (@l_nextFullTimeForSnap <> 0 AND (@l_nextFullTimeForSnap < @l_nextFullTime OR @l_nextFullTime = 0))
          		SET @l_nextFullTime = @l_nextFullTimeForSnap
		END
		DECLARE	@l_clientId int
		SELECT	@l_clientId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId
		DECLARE	@l_TimeZone varchar(255)
		SET		@l_TimeZone = dbo.ArchGroupTimeZone(@l_archGroupId, @l_clientId)
		DECLARE	@now INT
		SET		@now = dbo.GetUnixTime(GETUTCDATE())
		IF @l_TimeZone <> ''
		BEGIN
			DECLARE	@l_csTimeZone varchar(255)
			SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
			IF	@l_TimeZone <> @l_csTimeZone
			BEGIN
				SET @now = @now + dbo.GetDiffFromCSTimeZone(@now, @l_TimeZone, @l_csTimeZone)
				SET	@i_startDate = @i_startDate + dbo.GetDiffFromCSTimeZone(@i_startDate, @l_TimeZone, @l_csTimeZone)
				IF	@l_startDate > 0
					SET	@l_startDate = @l_startDate + dbo.GetDiffFromCSTimeZone(@l_startDate, @l_TimeZone, @l_csTimeZone)
IF	@l_nextFullTime > 0 AND (@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0
					SET	@l_nextFullTime = @l_nextFullTime + dbo.GetDiffFromCSTimeZone(@l_nextFullTime, @l_TimeZone, @l_csTimeZone)
			END
		END
		IF	@l_startDate > 0 AND
			(	@i_startDate >= @l_prevPeriodBegin AND @l_startDate >= @l_prevPeriodBegin AND @i_startDate < @l_currPeriodBegin AND @l_startDate < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @l_startDate >= @l_currPeriodBegin AND @i_startDate < @l_currPeriodEnd   AND @l_startDate < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @l_startDate >= @l_currPeriodEnd   AND @i_startDate < @l_nextPeriodEnd   AND @l_startDate < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd   AND @l_startDate >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0 AND @l_nextFullTime > 0 AND
			(	@i_startDate <  @l_prevPeriodBegin AND @l_nextFullTime <  @l_prevPeriodBegin
			OR	@i_startDate >= @l_prevPeriodBegin AND @l_nextFullTime >= @l_prevPeriodBegin AND @i_startDate < @l_currPeriodBegin AND @l_nextFullTime < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @l_nextFullTime >= @l_currPeriodBegin AND @i_startDate < @l_currPeriodEnd   AND @l_nextFullTime < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @l_nextFullTime >= @l_currPeriodEnd   AND @i_startDate < @l_nextPeriodEnd   AND @l_nextFullTime < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd   AND @l_nextFullTime >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) <> 0 AND
			(	@i_startDate >= @l_prevPeriodBegin AND @now < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @now < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @now < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
	END
END
SELECT_JOB:
IF (@i_backupLevel NOT IN (1, 64, 128, 1024, 32768))
BEGIN
		DECLARE @fullJobId int = 0
		DECLARE @fullJobCommCellId int = 0
		DECLARE @fullJobStartDate int = 0
		DECLARE @fullJobArchGroupId int = 0
		DECLARE @isFullBackupSnapJob int = 0
		SELECT top 1 @fullJobId = jbkp.jobID, @fullJobCommCellId = jbkp.commCellId, @fullJobStartDate = jbkp.servStartDate, @fullJobArchGroupId = jbkp.dataArchGrpId, @isFullBackupSnapJob = CASE WHEN jbkp.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
		FROM JMBkpStats jbkp WITH (NOLOCK)
		WHERE jbkp.fullCycleNum = @i_fullCycleNum
		AND jbkp.appId = @i_appId AND jbkp.bkpLevel in (1, 64, 128, 1024, 32768)
		AND jbkp.status in (1, 3, 14) --typedef enum CVJobStatus{ JMSUCCESS=1, PARTIALSUCCESS=3, JMSUCCESSWITHWARNINGS = 14,
		ORDER BY jbkp.servStartDate asc
		IF @@ROWCOUNT = 0 --We have an incremental/differential that we are going to pick for snap to tape but we did not find its corresponding full, so do not pick up
			GOTO RETURN_PROC
IF NOT EXISTS(SELECT 1 FROM JMJobSnapShotStats WITH (NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCommCellId/* AND archGrpId = @l_archGroupId*/)
		AND NOT EXISTS(SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.jobId = @fullJobId AND JDS.CommcellId = @fullJobCommCellId AND JDS.ArchGrpCopyId = AGC.id AND AGC.isSnapCopy = 0)
		BEGIN
			DECLARE @l_fullJobSourceCopyId int = 0
			SELECT	@l_fullJobSourceCopyId = ISNULL(sourceCopyId, 0)
FROM	ArchMaterializeSnapshotProp WITH(NOLOCK)
			WHERE	archGroupId = @fullJobArchGroupId
			IF @l_fullJobSourceCopyId = 0
				SELECT @l_fullJobSourceCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @fullJobArchGroupId
			--Pick up the corresponding full job in this cycle
			IF EXISTS(SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.jobId = @fullJobId AND JDS.commcellId = @fullJobCommCellId
AND archGrpCopyId = @l_fullJobSourceCopyId AND (disabled & 256) = 0) AND @isFullBackupSnapJob = 1
      BEGIN
INSERT INTO JMJobSnapShotStats
				SELECT	@fullJobId, @fullJobCommCellId, 101, 0, 0, @i_appId, @fullJobArchGroupId, 0, 0
				IF EXISTS
				(
					SELECT 1
					FROM JMJobDataLink JDL WITH (NOLOCK)
					WHERE JDL.childJobId = @fullJobId
					AND JDL.commcellId = @fullJobCommCellId
AND JDL.linkType = 7
				)
				BEGIN
					--Insert VSA V2 Parent job
INSERT INTO JMJobSnapShotStats
					SELECT	DISTINCT JDS.jobId, JDS.commCellId, 101, 0, 0, JDS.appId, JDS.archGrpId, 0, 0
					FROM	JMJobDataLink JDL WITH (NOLOCK) INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
					ON 		JDL.parentJobId = JDS.jobId
					AND 	JDL.commcellId = JDS.commcellId
					AND		JDL.childJobId = @fullJobId
					AND 	JDL.commcellId = @fullJobCommCellId
AND 	JDL.linkType = 7
LEFT OUTER JOIN JMJobSnapShotStats S
					ON 		JDS.jobId = S.jobId
					AND 	JDS.commCellId = S.commcellId
					WHERE JDS.archGrpCopyId = @l_fullJobSourceCopyId
					AND		JDS.status IN (100, 101, 102, 103)
					AND 	JDS.disabled & (1 + 256) = 0
					AND 	S.jobId IS NULL
				END
			END
		END
END
PICK_JOB:
	IF EXISTS(
							SELECT 1
							FROM JMJobDataStats JDS WITH (NOLOCK)
							WHERE JDS.jobId = @i_jobId
							AND 	JDS.commcellId = @i_commCellId
	            AND 	JDS.archGrpCopyId = @l_sourceCopyId
AND 	(JDS.disabled & 256) = 0
            )
  BEGIN
INSERT	INTO JMJobSnapShotStats
		SELECT	@i_jobId, @i_commCellId, 101, 0, 0, @i_appId, @l_archGroupId, 0, 0
WHERE NOT EXISTS (SELECT 1 FROM JMJobSnapShotStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commCellId)
		IF EXISTS
		(
			SELECT 1
			FROM JMJobDataLink JDL WITH (NOLOCK)
			WHERE JDL.childJobId = @i_jobId
			AND JDL.commcellId = @i_commCellId
AND JDL.linkType = 7
		)
		BEGIN
INSERT INTO JMJobSnapShotStats
			SELECT	DISTINCT JDS.jobId, JDS.commCellId, 101, 0, 0, JDS.appId, JDS.archGrpId, 0, 0
			FROM	JMJobDataLink JDL WITH (NOLOCK) INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
			ON 		JDL.parentJobId = JDS.jobId
			AND 	JDL.commcellId = JDS.commcellId
			AND		JDL.childJobId = @i_jobId
			AND 	JDL.commcellId = @i_commCellId
AND 	JDL.linkType = 7
LEFT OUTER JOIN JMJobSnapShotStats S
			ON 		JDS.jobId = S.jobId
			AND 	JDS.commCellId = S.commcellId
			WHERE JDS.archGrpCopyId = @l_sourceCopyId
			AND		JDS.status IN (100, 101, 102, 103)
			AND 	JDS.disabled & (1 + 256) = 0
			AND 	S.jobId IS NULL
		END
	END
IF(@i_appType = 106)
  BEGIN
	  --For VSA Appaware if the parent job is picked pick the child jobs too if they are valid and available in snap copy
	  DECLARE @childJobList table(jobId int, commcellId int, appId int, archGroupId int, sourceCopyId int)
	  INSERT INTO @childJobList
	  SELECT JINFO.childJobId, JINFO.commcellId, JBKP.appId, AG.id, CASE WHEN PROP.sourceCopyId > 0 THEN PROP.sourceCopyId ELSE AG.defaultSnapCopy END
	  FROM JMVSAAppJobLink JINFO WITH(NOLOCK) INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON JINFO.childJobId = JBKP.jobId AND JINFO.commcellId = JBKP.commcellId
INNER JOIN ArchMaterializeSnapshotProp PROP WITH(NOLOCK) ON JBKP.dataArchGrpId = PROP.archGroupId AND PROP.enabled = 1
	  INNER JOIN ArchGroup AG WITH(NOLOCK) ON JBKP.dataArchGrpId = AG.id
	  WHERE JINFO.parentJobId = @i_jobId AND JINFO.commcellId = @i_commCellId
	  IF @@ROWCOUNT > 0
INSERT INTO JMJobSnapShotStats
		  SELECT CJOBS.jobId, CJOBS.commcellId, 101, 0, 0, CJOBS.appId, CJOBS.archGroupId, 0, 0
		  FROM @childJobList CJOBS INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON CJOBS.jobId = JDS.jobId AND CJOBS.commcellId = JDS.commcellId AND CJOBS.sourceCopyId = JDS.archGrpCopyId
LEFT OUTER JOIN JMJobSnapShotStats S WITH(NOLOCK) ON CJOBS.jobId = S.jobId AND CJOBS.commcellId = S.commcellId
		  WHERE S.jobId IS NULL
		  GROUP BY CJOBS.jobId, CJOBS.commcellId, CJOBS.appId, CJOBS.archGroupId
HAVING MIN(JDS.status) = 100 AND MAX(JDS.status) = 100 AND MAX(JDS.disabled & 256) = 0
  END
SET @retVal = @@ERROR
RETURN_PROC:
if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
SELECT   @retVal
RETURN   @retVal;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMaterializeSnapshotPickNewJob')
	delete from GxQscripts where name = 'archMaterializeSnapshotPickNewJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotPickNewJob')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotPickNewJob'
GO

insert into GXDBVersions values(2, 'archMaterializeSnapshotPickNewJob',  '00010023005400040000', 'archMaterializeSnapshotPickNewJob', '00010023005400040000')
GO

