

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMaterializeSnapshotPickJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMaterializeSnapshotPickJobs.sp,v $ $Id: archMaterializeSnapshotPickJobs.sp,v 1.26.54.4 2018/10/13 06:18:08 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archMaterializeSnapshotPickJobs')
BEGIN
	print '>>> Drop Stored Procedure: archMaterializeSnapshotPickJobs <<<'
	drop procedure archMaterializeSnapshotPickJobs
END
IF EXISTS (select * from GxQscripts where name='archMaterializeSnapshotPickJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotPickJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotPickJobs'
GO
print '... Creating Procedure: archMaterializeSnapshotPickJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archMaterializeSnapshotPickJobs
  @i_archGroupId integer,
  @i_jobIdsXml xml
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
DECLARE	@FULL_BITS		INT
SET		@FULL_BITS		= (1+64+128+1024+32768)
DECLARE @DIFFERENTIAL_BIT INT
SET @DIFFERENTIAL_BIT = 4
CREATE TABLE #tempJobIds (jobId int, commCellId int, appId int, bkpLevel int, fullCycleNum int, startDate int, hasSource int, isForeignSnap int, archGroupId int, isVSAV2Parent int)
CREATE CLUSTERED INDEX Idx_tempJobIds_jobId_commCellId ON #tempJobIds (jobId, commcellId)
INSERT	INTO #tempJobIds
SELECT	T.c.value('@jobId', 'int'), T.c.value('@commCellId', 'int'), 0, 0, 0, 0, 0, 0, 0, 0
FROM	@i_jobIdsXml.nodes('/r/h') T(c)
	/*
		For all the child jobs in #notselectedJob add their parents too. Note that child jobs are always full and parent jobs can be full and incremental.
		If we populate here then the parent jobs will go through the logic of picking their full jobs along with if required.
		Eventually all parents while getting picked will have their child jobs picked.
	*/
	INSERT INTO #tempJobIds
	SELECT JVJ.parentJobId, JVJ.commcellId, 0, 0, 0, 0, 0, 0, 0, 0
	FROM #tempJobIds J1 INNER JOIN JMVSAAppJobLink JVJ WITH(NOLOCK) ON J1.jobId = JVJ.childJobId AND J1.commcellId = JVJ.commcellId
	LEFT OUTER JOIN #tempJobIds J2 ON JVJ.parentJobId = J2.jobId AND JVJ.commcellId = J2.commcellId
	WHERE J2.jobId IS NULL
UPDATE	#tempJobIds SET isForeignSnap = 1
WHERE	commCellId IN (SELECT id FROM APP_CommCell WHERE id IN (SELECT DISTINCT commCellId FROM #tempJobIds) AND type > 1)
DECLARE	@l_sourceCopyId INT
SET		@l_sourceCopyId = 0
SET		@retVal = 0
SELECT	@l_sourceCopyId = sourceCopyId
FROM	ArchMaterializeSnapshotProp WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
IF	@l_sourceCopyId = 0
	SELECT	@l_sourceCopyId = defaultSnapCopy
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
IF	@l_sourceCopyId = 0
SET @retVal = 80
ELSE
BEGIN
	UPDATE	#tempJobIds
	SET		appId = J.appId, hasSource = 1, archGroupId = J.archGrpId
	FROM	JMJobDataStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
AND J.dataType IN (1, 4)
		AND (J.archGrpId = @i_archGroupId AND J.archGrpCopyId = @l_sourceCopyId OR isForeignSnap = 1)
		AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
	UPDATE #tempJobIds
	SET appId = b.appId, bkpLevel = b.bkpLevel, fullCycleNum = b.fullCycleNum, startDate = b.servStartDate
	FROM #tempJobIds a inner join JMBkpStats b WITH (NOLOCK) ON a.jobId = b.jobId AND a.commcellId = b.commcellId
	UPDATE #tempJobIds
	SET isVSAV2Parent = 1
	FROM #tempJobIds T INNER JOIN JMJobDataLink JDL WITH (NOLOCK)
	ON T.appId = JDL.parentAppId
AND JDL.linkType = 7
	DELETE	#tempJobIds
FROM	JMJobSnapShotStats J, #tempJobIds T
	WHERE	J.jobId > T.jobId AND J.commCellId = T.commCellId
		--AND J.archGrpId = @i_archGroupId
		AND J.appId = T.appId
AND J.materializationStatus IN (100, 102, 103)
		AND	T.isVSAV2Parent = 0
	IF	@@ROWCOUNT > 0
	BEGIN
SET @retVal = 88
	END
	/*
	For backup copy both incremental and differential has dependency with full in the cycle.
	For deferred catalog incrementals need any previous job in the cycle with catalog.
	For deferred catalog differentials have dependency with full in the cycle.
	*/
	IF(OBJECT_ID('tempdb.dbo.#fullIncrMap') is not null)
		DROP TABLE #fullIncrMap
	CREATE TABLE #fullIncrMap (incrJobId int, incrJobCCId int, fullJobId int, fullJobCCId int, fullJobArchGroupId int, sourceCopyId int, appId int, bkpLevel int, fullCycleNum int, startDate int, isFullBackUpSnapJob int)
	CREATE INDEX Idx_fullIncrMap_fullJobId_fullJobCCId ON #fullIncrMap(fullJobId, fullJobCCId)
	CREATE INDEX Idx_fullIncrMap_incrJobId_incrJobCCId ON #fullIncrMap(incrJobId, incrJobCCId)
	IF(OBJECT_ID('tempdb..#incrJobsWithCatalogInCurrentCycle') is not null)
		DROP TABLE #incrJobsWithCatalogInCurrentCycle
	CREATE TABLE #incrJobsWithCatalogInCurrentCycle (jobId int, commcellId int, primary key(jobId, commcellId))
	/*
		We can ignore incr jobs from list #incrJobsWithCatalogInCurrentCycle as we don't need to look for full jobs for them
		Note that #fullIncrMap maps full jobs with incremental jobs that do not have any previously cataloged job in their cycle and differential jobs
	*/
	INSERT INTO #fullIncrMap
	SELECT incrJobId , incrJobCCId , fullJobId , fullJobCCId, fullJobArchGroupId, 0, appId, bkpLevel, fullCycleNum, servStartDate, isFullBackUpSnapJob
	FROM
	(
	SELECT a.jobId as incrJobId, a.commcellId as incrJobCCId, b.jobId as fullJobId, b.commcellId as fullJobCCId, b.dataArchGrpId as fullJobArchGroupId,
	b.appId, b.bkpLevel, b.fullCycleNum, b.servStartDate, (CASE WHEN b.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END) as isFullBackUpSnapJob,
	row_number() OVER (partition by a.JobId, a.commcellId order by b.servStartDate asc) as rn
	FROM #tempJobIds a inner join JMBkpStats b WITH (NOLOCK) ON a.fullCycleNum = b.fullCycleNum AND a.appId = b.appId
	AND b.bkpLevel & @FULL_BITS <> 0 AND a.bkpLevel & @FULL_BITS = 0 AND b.status IN (1, 3, 14)
	left outer join #incrJobsWithCatalogInCurrentCycle d ON a.jobId = d.jobId AND a.commcellId = d.commcellId
	WHERE d.jobId is null
	AND		a.isVSAV2Parent = 0
	) C
	WHERE rn = 1
	UPDATE #fullIncrMap SET sourceCopyId = CASE WHEN PROP.SourceCopyId > 0 THEN PROP.SourceCopyId ELSE AG.defaultSnapCopy END
FROM #fullIncrMap T INNER JOIN ArchMaterializeSnapshotProp PROP WITH(NOLOCK) ON T.fullJobArchGroupId = PROP.ArchGroupId
	INNER JOIN ArchGroup AG WITH(NOLOCK) ON PROP.ArchGroupId = AG.id
	DELETE #fullIncrMap
	FROM #fullIncrMap a left outer join JMJobDataStats jds WITH (NOLOCK)
	ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId
	AND jds.archGrpCopyId = a.sourceCopyId
AND jds.status IN (100, 101, 102, 103) AND jds.disabled & (256) = 0
left outer join JMJobSnapShotStats J WITH(NOLOCK) ON a.fullJobId = J.jobId AND a.fullJobCCId = J.commcellId
WHERE jds.jobId is null AND (J.jobId is null OR J.materializationStatus IN (101, 102, 103)) AND a.isFullBackUpSnapJob = 1
	-- Do not fail for VSA V2 parent jobs without corresponding Full. Its not required
	DELETE #tempJobIds
	FROM #tempJobIds a
	left outer join #fullIncrMap b
	ON a.jobId = b.incrJobId AND a.commcellId = b.incrJobCCId
	left outer join #incrJobsWithCatalogInCurrentCycle c
	ON a.jobId = c.jobId AND a.commcellId = c.commcellId
	WHERE b.fullJobId is null AND a.bkpLevel & @FULL_BITS = 0
	AND 	c.jobId is null
	AND		a.isVSAV2Parent = 0
	IF	@@ROWCOUNT > 0 AND @retVal = 0
	BEGIN
SET @retVal = 117
	END
	--delete the jobs for deleted subclients
	DELETE #tempJobIds
	FROM #tempJobIds t LEFT JOIN APP_Application aa WITH (NOLOCK) ON t.appId = aa.id
WHERE aa.id IS NULL OR (aa.subclientStatus & 0x00004 > 0)
	IF	@@ROWCOUNT > 0 AND @retVal = 0
	BEGIN
SET @retVal = 198
	END
	/*If deferred catalog let us make sure the full job that we are going to pick doesn't have bcd index already*/
	INSERT INTO #tempJobIds
	SELECT fullJobId, fullJobCCId, appId, bkpLevel, fullCycleNum, startDate, 1, 0, fullJobArchGroupId, 0
	FROM #fullIncrMap WHERE isFullBackUpSnapJob = 1
	IF EXISTS(SELECT 1 FROM #tempJobIds WHERE hasSource = 0 AND isForeignSnap = 0 AND isVSAV2Parent = 0) AND @retVal = 0
	BEGIN
SET @retVal = 119
	END
	--Migrated jobs belonging to simpana commcell are not supported for backup copy and deferred catalog
	DELETE #tempJobIds
	FROM #tempJobIds a inner join App_Commcell b
ON a.CommCellId = b.id AND a.CommCellId > 2 AND b.type = 1
	IF	@@ROWCOUNT > 0 AND @retVal = 0
	BEGIN
SET @retVal = 121
	END
	BEGIN TRY
	BEGIN TRAN
	IF(OBJECT_ID('tempdb..#pickedJobs') IS NOT NULL)
		DROP TABLE #pickedJobs
	CREATE TABLE #pickedJobs (jobId int, commcellId int, primary key(jobId, commcellId) with(ignore_dup_key = ON))
UPDATE	JMJobSnapShotStats
	SET		disabled = (J.disabled & ~1)
	OUTPUT DELETED.jobId, DELETED.commcellId INTO #pickedJobs
FROM	JMJobSnapShotStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
		--AND J.archGrpId = @i_archGroupId
		AND (J.disabled & 1) = 1
		AND (T.hasSource = 1 OR isForeignSnap = 1)
	DELETE	#tempJobIds
FROM	JMJobSnapShotStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
		--AND J.archGrpId = @i_archGroupId
INSERT INTO JMJobSnapShotStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId INTO #pickedJobs
	SELECT	DISTINCT jobId, commCellId, 101, 0, 0, appId, archGroupId, 0, 0
	FROM	#tempJobIds
	WHERE	hasSource = 1 OR isForeignSnap = 1
INSERT INTO JMJobSnapShotStats
		SELECT	DISTINCT JDS.jobId, JDS.commCellId, 101, 0, 0, JDS.appId, JDS.archGrpId, 0, 0
		FROM	#pickedJobs PJ INNER JOIN JMVSAAppJobLink JVJ WITH(NOLOCK) ON PJ.jobId = JVJ.parentJobId AND PJ.commcellId = JVJ.commcellId
		INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JVJ.childJobId = JDS.jobId AND JVJ.commcellId = JDS.commcellId
INNER JOIN ArchMaterializeSnapshotProp PROP WITH(NOLOCK) ON JDS.archGrpId = PROP.ArchGroupId
		INNER JOIN ArchGroup AG WITH(NOLOCK) ON PROP.ArchGroupId = AG.id
LEFT OUTER JOIN JMJobSnapShotStats S ON JDS.jobId = S.jobId AND JDS.commCellId = S.commcellId
		WHERE JDS.status IN (100, 101, 102, 103) AND JDS.disabled & (1+256) = 0 AND S.jobId IS NULL
		AND ((JDS.archGrpCopyId = PROP.SourceCopyId) OR (PROP.SourceCopyId = 0 AND JDS.archGrpCopyId = AG.defaultSnapCopy))
		--Pick VSA V2 parent job if VM level job is picked
UPDATE	JMJobSnapShotStats
		SET		disabled = (S.disabled & ~1)
FROM	JMJobSnapShotStats S INNER JOIN JMJobDataLink JDL WITH (NOLOCK)
		ON 		S.jobId = JDL.parentJobId
		AND 	S.commcellId = JDL.commcellId
AND 	JDL.linkType = 7
		INNER JOIN #pickedJobs PJ
		ON 		PJ.jobId = JDL.childJobId
		AND 	PJ.commcellId	= JDL.commcellId
		INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
		ON 		JDL.parentJobId = JDS.jobId
		AND 	JDL.commcellId = JDS.commcellId
INNER JOIN ArchMaterializeSnapshotProp PROP WITH (NOLOCK)
		ON 		JDS.archGrpId = PROP.ArchGroupId
		INNER JOIN ArchGroup AG WITH (NOLOCK)
		ON 		PROP.ArchGroupId = AG.id
		WHERE JDS.status IN (100, 101, 102, 103)
		AND 	JDS.disabled & (1 + 256) = 0
AND 	S.materializationStatus IN (101, 102, 103)
		AND		S.disabled & 1 > 0
		AND 	(
						(JDS.archGrpCopyId = PROP.SourceCopyId)
						OR
						(PROP.SourceCopyId = 0 AND JDS.archGrpCopyId = AG.defaultSnapCopy)
					)
INSERT INTO JMJobSnapShotStats
		SELECT	DISTINCT JDS.jobId, JDS.commCellId, 101, 0, 0, JDS.appId, JDS.archGrpId, 0, 0
		FROM	#pickedJobs PJ INNER JOIN JMJobDataLink JDL WITH (NOLOCK)
		ON 		PJ.jobId = JDL.childJobId
		AND 	PJ.commcellId = JDL.commcellId
AND 	JDL.linkType = 7
		INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
		ON 		JDL.parentJobId = JDS.jobId
		AND 	JDL.commcellId = JDS.commcellId
INNER JOIN ArchMaterializeSnapshotProp PROP WITH (NOLOCK)
		ON 		JDS.archGrpId = PROP.ArchGroupId
		INNER JOIN ArchGroup AG WITH (NOLOCK)
		ON 		PROP.ArchGroupId = AG.id
LEFT OUTER JOIN JMJobSnapShotStats S
		ON 		JDS.jobId = S.jobId
		AND 	JDS.commCellId = S.commcellId
		WHERE JDS.status IN (100, 101, 102, 103)
		AND 	JDS.disabled & (1 + 256) = 0
		AND 	S.jobId IS NULL
		AND 	(
						(JDS.archGrpCopyId = PROP.SourceCopyId)
						OR
						(PROP.SourceCopyId = 0 AND JDS.archGrpCopyId = AG.defaultSnapCopy)
					)
		IF(OBJECT_ID('tempdb..#pickedJobs') IS NOT NULL)
			  DROP TABLE #pickedJobs
	COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRAN
    SET @retVal = ERROR_NUMBER()
    END CATCH
END
SELECT	@retVal
IF OBJECT_ID('tempdb.dbo.#tempJobIds') is not null DROP TABLE #tempJobIds
IF OBJECT_ID('tempdb.dbo.#fullIncrMap') is not null DROP TABLE #fullIncrMap
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMaterializeSnapshotPickJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotPickJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotPickJobs'
GO

insert into GXDBVersions values(2, 'archMaterializeSnapshotPickJobs',  '00010026005400040000', 'archMaterializeSnapshotPickJobs', '00010026005400040000')
GO

