

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMaterializeSnapshotPickForeignJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMaterializeSnapshotPickForeignJobs.sp,v $ $Id: archMaterializeSnapshotPickForeignJobs.sp,v 1.12.32.3 2018/03/22 01:00:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archMaterializeSnapshotPickForeignJobs <<<'

IF EXISTS (select * from sysobjects where name='archMaterializeSnapshotPickForeignJobs')
	drop procedure archMaterializeSnapshotPickForeignJobs
IF EXISTS (select * from GxQscripts where name='archMaterializeSnapshotPickForeignJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotPickForeignJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotPickForeignJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotPickForeignJobs'
GO
print '... Creating Procedure: archMaterializeSnapshotPickForeignJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archMaterializeSnapshotPickForeignJobs
  @i_appId integer,
  @i_today integer
AS
  DECLARE @r_archGroupId integer;
  DECLARE @r_jobId integer;
  DECLARE @r_commCellId integer;
  DECLARE @r_startDate integer;
  DECLARE @r_selected integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@FULL_BITS		INT
SET		@FULL_BITS		= (1+64+128+1024+32768)
DECLARE	@l_clientId		INT
DECLARE	@l_archGroupId	INT
DECLARE	@l_enabled		INT
DECLARE	@l_type			INT
DECLARE	@l_flags		INT
DECLARE	@l_startTime	INT
DECLARE	@l_numPeriod	INT
DECLARE @l_lastArchGrpId	INT
DECLARE @l_maxMovedJobId	INT
DECLARE	@l_maxPickedJobId	INT
DECLARE @l_order		INT
DECLARE @l_appTypeId INT
CREATE TABLE #notSelectedJob (jobId INT, commCellId INT, startDate INT, selected INT)
SELECT	@l_clientId = clientId, @l_archGroupId = dataArchGrpId, @l_appTypeId = appTypeId
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @i_appId
IF	@l_archGroupId <= 1
	GOTO OUTPUT_EXIT
SET @l_enabled	= 0
SET @l_order	= 0
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags, @l_startTime = startTime, @l_numPeriod = numPeriod
FROM	archMaterializeSnapshotProp WITH (NOLOCK)
WHERE	archGroupId = @l_archGroupId
IF	@l_enabled = 0 OR @l_type = 9 OR @l_startTime > @i_today
	GOTO OUTPUT_EXIT
--Deferred catalog is not supported on all AppTypes
IF @l_enabled = 2 AND dbo.IsDeferredCatalogSupported(@i_appId) = 0
	GOTO OUTPUT_EXIT
SET @l_lastArchGrpId	= 0
SET @l_maxMovedJobId	= 0
SELECT	TOP 1 @l_maxMovedJobId = jobId, @l_lastArchGrpId = archGrpId
FROM	JMJobSnapshotStats WITH (NOLOCK)
WHERE	appId = @i_appId AND commCellId = 2
	AND materializationStatus = 100
ORDER BY jobId DESC
-- If the imported subclient has been re-associated to a different storage policy,
-- jobs before the last moved job in the previous SP will not be moved to the new policy.
IF	@l_lastArchGrpId > 0 AND @l_lastArchGrpId <> @l_archGroupId
BEGIN
	CREATE TABLE #cleanPreparedJob (jobId INT, commCellId INT)
	SELECT	@l_maxPickedJobId = jobId
	FROM	JMPreparedJob WITH (NOLOCK)
	WHERE	appId = @i_appId AND preparedJobId = @l_maxMovedJobId AND preparedJobCCId = 2
	INSERT	INTO #cleanPreparedJob
	SELECT	preparedJobId, preparedJobCCId
	FROM	JMPreparedJob WITH (NOLOCK)
	WHERE	appId = @i_appId AND preparedJobId > @l_maxMovedJobId AND preparedJobCCId = 2
	DELETE	JMJobSnapshotStats
	FROM	JMJobSnapshotStats J, APP_CommCell C WITH (NOLOCK)
	WHERE	J.appId = @i_appId AND J.jobId > @l_maxPickedJobId
		AND J.commCellId = C.id AND C.type > 1
	DELETE	JMJobSnapshotStats
	FROM	JMJobSnapshotStats J, #cleanPreparedJob T
	WHERE	J.jobId = T.JobId AND J.commCellId = T.commCellId
	DELETE	JMPreparedJob
	FROM	JMPreparedJob J, #cleanPreparedJob T
	WHERE	J.preparedJobId = T.JobId AND J.preparedJobCCId = T.commCellId
	UPDATE	JMBkpStats
	SET		status = 4
	FROM	JMBkpStats J, #cleanPreparedJob T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
	UPDATE	archFile
	SET		isValid = -1
	FROM	archFile AF, #cleanPreparedJob T
	WHERE	AF.jobId = T.jobId AND AF.commCellId = T.commCellId
	DROP TABLE #cleanPreparedJob
END
SELECT	@l_maxPickedJobId = ISNULL(MAX(J.jobId), 0)
FROM	JMJobSnapshotStats J WITH (NOLOCK), APP_CommCell C WITH (NOLOCK)
WHERE	J.appId = @i_appId AND J.commCellId = C.id AND C.type > 1
INSERT INTO #notSelectedJob
SELECT	J.jobId, J.commCellId, J.servStartDate, 0
FROM	JMBkpStats J WITH (NOLOCK), APP_CommCell C
WHERE	J.appId = @i_appId AND J.commCellId = C.id AND C.type > 1
	AND J.status IN (1, 3, 14) AND J.opType IN (59, 65) AND J.jobId > @l_maxPickedJobId
AND (@l_type = 0 OR J.bkpLevel & @FULL_BITS <> 0)
	AND J.servStartDate >= @l_startTime
IF @l_enabled = 2
BEGIN
	--If delayed catalog do not consider jobs that have bcd index created already
	DELETE #notSelectedJob
FROM #notSelectedJob J inner join ArchFile AF WITH(NOLOCK) ON J.jobId = AF.jobId AND J.commcellId = AF.commcellId AND AF.fileType = 6
END
-- Go to set CI flag if it's for all backups or for all full backups
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
BEGIN
	DECLARE	@flagsForSnapShotStats int
	SET @flagsForSnapShotStats = 0
IF @l_enabled = 2
SET @flagsForSnapShotStats = @flagsForSnapShotStats | 1
	INSERT INTO JMJobSnapshotStats
	SELECT	jobId, commCellId, 101, 0, 0, @i_appId, @l_archGroupId, 0, @flagsForSnapShotStats
	FROM	#notSelectedJob
	TRUNCATE TABLE #notSelectedJob
END
IF	@l_type IN (10, 3, 2, 4, 6)
BEGIN
	IF @l_maxPickedJobId > 0
		INSERT INTO #notSelectedJob
		SELECT	jobId, commCellId, servStartDate, 1
		FROM	JMBkpStats WITH (NOLOCK)
		WHERE	appId = @i_appId AND jobId = @l_maxPickedJobId
	DECLARE	@l_TimeZoneType	INT
	DECLARE @l_TimeZone		VARCHAR(255)
	DECLARE @l_csTimeZone	VARCHAR(255)
	SELECT	@l_TimeZoneType = TimeZoneType, @l_TimeZone = TimeZone
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @l_archGroupId
	IF	@l_TimeZoneType > 0
		SET @l_csTimeZone = dbo.GetClientTimeZone(2)
	IF	@l_TimeZoneType = 1
		SET	@l_TimeZone = dbo.ArchGroupTimeZone(@l_archGroupId, @l_clientId)
	IF	@l_TimeZoneType IN (1, 2) AND @l_TimeZone <> @l_csTimeZone
		UPDATE	#notSelectedJob
		SET		startDate = startDate + dbo.GetDiffFromCSTimeZone(startDate, @l_TimeZone, @l_csTimeZone)
IF (@l_flags & 4096) <> 0
		SET @l_order = 1
END
OUTPUT_EXIT:
-- Output for selective copies
IF	@l_order = 0
	SELECT	@l_archGroupId, jobId, commCellId, startDate, selected
	FROM	#notSelectedJob
	ORDER BY jobId ASC
ELSE
	SELECT	@l_archGroupId, jobId, commCellId, startDate, selected
	FROM	#notSelectedJob
	ORDER BY selected DESC, jobId DESC
DROP TABLE #notSelectedJob
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMaterializeSnapshotPickForeignJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotPickForeignJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotPickForeignJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotPickForeignJobs'
GO

insert into GXDBVersions values(2, 'archMaterializeSnapshotPickForeignJobs',  '00010012003200030000', 'archMaterializeSnapshotPickForeignJobs', '00010012003200030000')
GO

