

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMaterializeSnapshotCheckPickedJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMaterializeSnapshotCheckPickedJobs.sp,v $ $Id: archMaterializeSnapshotCheckPickedJobs.sp,v 1.2.54.2 2018/10/13 06:18:11 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archMaterializeSnapshotCheckPickedJobs')
BEGIN
	print '>>> Drop Stored Procedure: archMaterializeSnapshotCheckPickedJobs <<<'
	drop procedure archMaterializeSnapshotCheckPickedJobs
END
IF EXISTS (select * from GxQscripts where name='archMaterializeSnapshotCheckPickedJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotCheckPickedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotCheckPickedJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotCheckPickedJobs'
GO
print '... Creating Procedure: archMaterializeSnapshotCheckPickedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archMaterializeSnapshotCheckPickedJobs
  @i_archGroupId integer
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
DECLARE	@l_sourceCopyId INT
SET		@l_sourceCopyId = 0
SET		@retVal = 0
SELECT	@l_sourceCopyId = sourceCopyId
FROM	ArchMaterializeSnapshotProp WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
IF	@l_sourceCopyId = 0
	SELECT	@l_sourceCopyId = defaultSnapCopy
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
IF	@l_sourceCopyId = 0
SET @retVal = 80
ELSE
BEGIN
	if OBJECT_ID('tempdb.dbo.#tempJobIds') IS NOT NULL DROP TABLE #tempJobIds
	CREATE TABLE #tempJobIds(jobId int, commCellId int)
	CREATE CLUSTERED INDEX Idx_tempJobIds ON #tempJobIds (JobId, CommCellId)
	INSERT	INTO #tempJobIds
	SELECT	DISTINCT A.jobId, A.commCellId
FROM	JMJobSnapShotStats A WITH (NOLOCK) LEFT JOIN JMJobDataStats B WITH (NOLOCK)
		ON	A.jobId = B.jobId AND A.commCellId = B.commCellId
AND B.archGrpCopyId = @l_sourceCopyId AND B.status IN (100, 101, 102, 103) AND B.disabled & (1+256 ) = 0
	WHERE	B.jobId IS NULL
AND A.archGrpId = @i_archGroupId AND A.materializationStatus IN (101, 102, 103) AND A.disabled & 1 = 0
UPDATE	JMJobSnapShotStats
SET		disabled = (disabled | 1),
unPickReason = 6
FROM	JMJobSnapShotStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId
		AND J.commCellId = T.commCellId
		AND J.archGrpId = @i_archGroupId
AND J.disabled & 1 = 0
	TRUNCATE TABLE #tempJobIds
	--Unpick Parent VSA V2 jobs if no child VMs are in picked state
	INSERT	INTO #tempJobIds
	SELECT	DISTINCT A.jobId, A.commCellId
FROM	JMJobSnapShotStats A WITH (NOLOCK), JMJobDataLink JDL WITH (NOLOCK)
	WHERE A.archGrpId = @i_archGroupId
AND 	A.materializationStatus IN (101, 102, 103)
AND 	A.disabled & 1 = 0
	AND		A.jobId = JDL.parentJobId
	AND		A.commCellId = JDL.commCellId
AND 	JDL.linkType = 7
	AND 	NOT EXISTS (SELECT SS.jobId
FROM JMJobSnapShotStats SS WITH (NOLOCK)
										WHERE SS.jobId = JDL.childJobId
										AND		SS.commCellId = JDL.commCellId
AND		SS.materializationStatus IN (101, 102, 103)
AND 	SS.disabled & 1 = 0
									)
UPDATE	JMJobSnapShotStats
SET		disabled = (disabled | 1),
unPickReason = 6
FROM	JMJobSnapShotStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId
		AND J.commCellId = T.commCellId
		AND J.archGrpId = @i_archGroupId
AND J.disabled & 1 = 0
	DROP TABLE #tempJobIds
END
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archMaterializeSnapshotCheckPickedJobs')
	delete from GxQscripts where name = 'archMaterializeSnapshotCheckPickedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeSnapshotCheckPickedJobs')
	delete from GXDBVersions where aliasname = 'archMaterializeSnapshotCheckPickedJobs'
GO

insert into GXDBVersions values(2, 'archMaterializeSnapshotCheckPickedJobs',  '00010002005400020000', 'archMaterializeSnapshotCheckPickedJobs', '00010002005400020000')
GO

