

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMaterializeCheckJobValidity.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archMaterializeCheckJobValidity.sp						  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archMaterializeCheckJobValidity.sp,v $ $Id: archMaterializeCheckJobValidity.sp,v 1.11.54.4 2020/12/28 18:27:20 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archMaterializeCheckJobValidity')
BEGIN
	print '>>> Drop Stored Procedure: archMaterializeCheckJobValidity <<<'
	drop procedure archMaterializeCheckJobValidity
END
IF EXISTS (select * from GxQscripts where name='archMaterializeCheckJobValidity')
	delete from GxQscripts where name = 'archMaterializeCheckJobValidity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeCheckJobValidity')
	delete from GXDBVersions where aliasname = 'archMaterializeCheckJobValidity'
GO
print '... Creating Procedure: archMaterializeCheckJobValidity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archMaterializeCheckJobValidity
  @i_jobId integer,
  @i_commCellId integer,
  @i_archGroupId integer
AS
  DECLARE @o_retCode INTEGER;
  DECLARE @o_validStatus INTEGER;
SET NOCOUNT ON
/*
o_validStatus  0 - Error,
							 1 - valid,
							 2 - job is unpicked or already backup copied,
							 3 - job to be processed is aged on source,
							 4 - job is incremental and the corresponding full of the cycle is not available (in primary copy for backup copy/in sourceCopy for deferred catalog)
							 5 - required operation not enabled on storage policy
							 6 - This is incremental and previous jobs in the same cycle are not available in the primary(classic) copy
							 7 - This job is to be cataloged/backup copied but we found a job later than this job already cataloged/backupcopied
							 8 - catalog/backup copy job is already running for this subclient
							 9 - subclient deconfigured
							 10 - VSA app aware child job. Parent is not moved yet
							 11 - VSA app aware child job. Parent job info not found in DB
							 12 - VSA app aware child job. Parent has not backed up the child VM successfully
							 13 - Max parallel backup copy jobs for the storage policy exceeded. Cannot submit any more backup copy jobs
							 14 - This job is to be cataloged/backup copied but we found an older job that is pending to be cataloged/backupcopied
*/
DECLARE @l_enabled int = 0
DECLARE @l_srcCopyId int = 0
DECLARE @l_bkpLevel int = 0
DECLARE @l_appType int = 0
DECLARE @l_fullCycleNum int = 0
DECLARE @l_appId int = 0
DECLARE @l_clientId int = 0
DECLARE @l_servStartDate int = 0
DECLARE @l_servEndDate int = 0
DECLARE @l_isVSAV2Parent int = 0
SET @o_retCode = 0
SET @o_validStatus = 1
SELECT @l_bkpLevel = bkpLevel, @l_appId = appId, @l_appType = appType, @l_fullCycleNum = fullCycleNum, @l_servStartDate = servStartDate, @l_servEndDate = servEndDate
FROM JMBkpStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commcellId
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
SELECT @l_clientId = clientId
FROM App_Application WITH (NOLOCK) WHERE id = @l_appId
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF EXISTS (SELECT TOP 1 1
					 FROM JMJobDataLink J WITH (NOLOCK)
					 WHERE	J.parentAppId = @l_appId
AND		J.linkType IN (7, 8)
					)
BEGIN
	SET @l_isVSAV2Parent = 1
END
IF EXISTS ( SELECT * FROM JMJobInfo JI
			INNER JOIN JMBkpJobInfo BI ON BI.jobId = JI.jobId AND BI.commcellId = JI.commCellId
			WHERE BI.applicationId = @l_appId
			AND JI.opType = 60 -- SNAPTOTAPE
		)
BEGIN
	SET @o_validStatus = 8
	GOTO RETURN_PROC
END
DECLARE @l_maxJobsAllowed INT = 0
SELECT @l_maxJobsAllowed = intVal FROM MMEntityProp WITH(NOLOCK) WHERE EntityId = @i_archGroupId AND EntityType = 1 /*#define MM_STORAGE_POLICY_TYPE 1*/ AND propertyName = 'MaxParallelBackupCopyJobs' AND CommcellId = 2
IF(@l_maxJobsAllowed > 0)
BEGIN
	IF((SELECT COUNT(distinct JI.jobId) FROM JMJobInfo JI INNER JOIN JMBkpJobInfo BI ON JI.jobId = BI.jobId AND JI.commcellId = BI.commCellId
	WHERE BI.currentPolicy = @i_archGroupId AND JI.opType = 60 /*SNAPTOTAPE*/) >= @l_maxJobsAllowed)
	BEGIN
		SET @o_validStatus = 13
		GOTO RETURN_PROC
	END
END
SELECT @l_srcCopyId = CASE WHEN sourceCopyId <> 0 THEN sourceCopyId ELSE (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId) END,
@l_enabled = enabled
FROM ArchMaterializeSnapshotProp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF @l_enabled = 0
BEGIN
	SET @o_validStatus = 5
	GOTO RETURN_PROC
END
IF NOT EXISTS (SELECT 1 FROM JMJobSnapShotStats WITH(NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commCellId AND (disabled & 1) = 0 AND materializationStatus IN (101, 102, 103))
BEGIN
	SET @o_validStatus = 2
	GOTO RETURN_PROC
END
DECLARE @validAFTypes table(afType int)
INSERT @validAFTypes
SELECT dataType FROM JMJobDataStats WITH(NOLOCK)
WHERE jobId = @i_jobId AND commCellId = @i_commCellId
AND archGrpCopyId = @l_srcCopyId AND dataType IN (1, 4)
AND (disabled & 256 = 0)
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF NOT EXISTS(SELECT 1 FROM @validAFTypes)
BEGIN
UPDATE JMJobSnapShotStats SET disabled = disabled | 1, unPickReason = 6
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
	SET @o_validStatus = 3
	GOTO RETURN_PROC
END
IF @l_bkpLevel NOT IN (1, 64, 128, 1024, 32768) --It is an incremental
BEGIN
	/*
	--If it is backup copy matDestCopy is the copy to which we are going copy the snap job else if it is deferred catalog it is the copy on which the catalog is going to be created
	DECLARE @matDestCopy int
	SELECT @matDestCopy = defaultCopy FROM archGroup WITH(NOLOCK) WHERE id = @i_archGroupId
	SELECT @o_retCode = @@ERROR
	IF @o_retCode <> 0
	BEGIN
		SET @o_validStatus = 0
		GOTO RETURN_PROC
	END
    */
	DECLARE @fullJobId int = 0
	DECLARE @fullJobCCId int = 0
	DECLARE @isFullBackUpSnapJob int = 0
	SELECT  top 1 @fullJobId = a.jobId, @fullJobCCId = a.commcellId, @isFullBackUpSnapJob = CASE WHEN a.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
	FROM JMBkpStats a WITH(NOLOCK) INNER JOIN JMBkpStats b WITH(NOLOCK) ON b.jobId = @i_jobId AND b.commcellId = @i_commcellId AND a.appId = b.appId
	AND a.fullCycleNum = b.fullCycleNum AND a.status IN (1, 3, 14) AND a.bkpLevel IN (1, 64, 128, 1024, 32768) ORDER BY a.servStartDate
	SELECT @o_retCode = @@ERROR
	IF @o_retCode <> 0
	BEGIN
		SET @o_validStatus = 0
		GOTO RETURN_PROC
	END
	--If it is backup copy tape copy should have the corresponding full with all the datatypes that current incremental has and going to be moved
	--Skip this check for VSA V2 parent jobs
	IF (@l_isVSAV2Parent = 0
			AND
			NOT EXISTS(
									SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.ArchGrpCopyId = AGC.id
									WHERE JDS.jobId = @fullJobId AND JDS.commcellId = @fullJobCCId AND AGC.isSnapCopy = 0 AND AGC.type <> 5
									AND JDS.dataType IN (SELECT afType FROM @validAFTypes)
AND (JDS.disabled & 256) = 0
									AND status = 100
								)
	)
	BEGIN
		--If fulljob is disabled for backup copy then disable the incr job too
		--If full job is already moved but it is aged disable the incr job
		--If full job is non-snap job disable the incr job as we didn't find unaged data in tape copies
		IF @isFullBackUpSnapJob = 0
		OR
EXISTS (SELECT 1 FROM JMJobSnapShotStats WITH(NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCCId AND (disabled & 1) = 1)
	    OR
EXISTS (SELECT 1 FROM JMJobSnapShotStats WITH(NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCCId AND materializationStatus = 100)
	    BEGIN
UPDATE JMJobSnapShotStats SET disabled = disabled | 1, unPickReason = 5
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
		END
		SET @o_validStatus = 4
		GOTO RETURN_PROC
	END
	/*
	--Now check the dependency between incrementals for non-(NAS/VSA) appTypes
IF @l_appType NOT IN (13, 106)
	BEGIN
		--If this is non-(NAS/VSA) appType and incremental we have to make sure all the incrementals before this in this same cycle are backupCopied and available
		IF EXISTS(
		SELECT 1 FROM
		JMBkpStats jbkp1 WITH (NOLOCK) INNER JOIN JMBkpStats jbkp2 WITH (NOLOCK) ON jbkp1.jobId = @i_jobId AND jbkp1.commcellId = @i_commcellId
		AND jbkp2.fullCycleNum = jbkp1.fullCycleNum AND jbkp2.appId = jbkp1.appId AND jbkp2.servStartDate < jbkp1.servStartDate AND jbkp2.status IN (1, 3, 14)
		LEFT OUTER JOIN JMJobDataStats jds WITH (NOLOCK) ON jbkp2.jobId = jds.jobId AND jbkp2.commcellId = jds.commcellId AND jds.archGrpCopyId = @matDestCopy	AND dataType IN (SELECT afType FROM @validAFTypes)
AND (jds.disabled & 256) = 0 AND jds.status = 100
		WHERE jds.jobId is null
		)
		BEGIN
UPDATE JMJobSnapShotStats SET disabled = disabled | 1, unPickReason = 7
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
			SET @o_validStatus = 6
			GOTO RETURN_PROC
		END
	END
	*/
END
--When backup copying\cataloging a job there cannot be a job that is older than this and pending to be backup copied\cataloged
--Skip this check for VSA V2 parent jobs
IF (@l_isVSAV2Parent = 0
		AND
		EXISTS(
						SELECT 1
						FROM JMBkpStats JBKP1 WITH (NOLOCK) INNER JOIN JMBkpStats JBKP2 WITH (NOLOCK)
						ON 	JBKP1.jobId = @i_jobId
						AND JBKP1.commCellId = @i_commCellId
						AND JBKP1.appId =JBKP2.appId
						AND jbkp1.servStartDate > JBKP2.servStartDate
						AND JBKP2.status IN (1, 3, 14)
INNER JOIN JMJobSnapShotStats JSS WITH (NOLOCK)
						ON 	JSS.jobId = JBKP2.jobId
						AND JSS.commcellId = JBKP2.commcellId
						AND JSS.appId = JBKP2.appId
AND JSS.materializationStatus IN (101, 102, 103)
						AND JSS.disabled & 1 = 0
				)
)
BEGIN
	SET @o_validStatus = 14
	GOTO RETURN_PROC
END
--Check if we have a newer job than current job for this subclient that was already completely/partially processed for backup copy
	--Skip this check for VSA V2 parent jobs
	IF (@l_isVSAV2Parent = 0
			AND
			EXISTS (SELECT 1
							FROM JMBkpStats jbkp1 WITH (NOLOCK) INNER JOIN JMBkpStats jbkp2 WITH (NOLOCK)
							ON 	jbkp1.jobId = @i_jobId AND jbkp1.commCellId = @i_commCellId AND jbkp2.appId =jbkp1.appId
							AND jbkp2.servStartDate > jbkp1.servStartDate AND jbkp2.status IN (1, 3, 14)
INNER JOIN JMJobSnapShotStats jss WITH (NOLOCK)
							ON jss.jobId = jbkp2.jobId AND jss.commcellId = jbkp2.commcellId AND jss.appId = jbkp2.appId
AND jss.materializationStatus IN(100,102,103) AND jss.flags = 0
						 )
	)
	BEGIN
UPDATE JMJobSnapShotStats SET disabled = disabled | 1, unPickReason = 9
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
		SET @o_validStatus = 7
		GOTO RETURN_PROC
	END
DECLARE @vsaAppawareParentJob int = 0
SELECT @vsaAppawareParentJob = JVJ.parentJobId
FROM JMVSAAppJobLink JVJ WITH(NOLOCK)
 WHERE JVJ.childJobId = @i_jobId AND JVJ.commcellId = @i_commCellId
IF @vsaAppawareParentJob > 0
BEGIN
	--Check if parent job is completely available in tape copy
	IF NOT EXISTS
	(
		SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.ArchGrpCopyId = AGC.id
		WHERE JDS.jobId = @vsaAppawareParentJob AND JDS.commcellId = @i_commCellId AND AGC.isSnapCopy = 0 AND AGC.type <> 5
		GROUP BY JDS.jobId, JDS.commcellId, JDS.archGrpCopyId
HAVING MAX(JDS.disabled & 256) = 0 AND MAX(JDS.status) = 100 AND MIN(JDS.status) = 100
	)
	BEGIN
		/*
		If it is a streaming job that has gone through archive index phase successfully we will still allow child backup copy.
		This is to support inline backup copy of child snap jobs while parent could still be processing more child snap jobs.
		Since parent is streaming it is still ok to allow if it has completed its backup and archive index phases and is up only for other child snaps to complete.
		*/
		IF NOT EXISTS(
		SELECT 1
		FROM JMBkpJobInfo JB WITH(NOLOCK)
		INNER JOIN JMJobInfo J WITH(NOLOCK) ON JB.jobId = J.jobId AND JB.commcellId = J.commCellId
		INNER JOIN JMBkpAttemptInfo JBA WITH(NOLOCK) ON JB.jobId = JBA.jobId AND JB.commcellId = JBA.commCellId
		INNER JOIN APP_Application APP WITH(NOLOCK) ON JB.applicationId = APP.id
		INNER JOIN JMOpTable OP WITH(NOLOCK) ON APP.appTypeId = OP.appTypeType AND J.opType = OP.operation
		INNER JOIN JMPhase P WITH(NOLOCK) ON OP.id = P.opTableId AND P.phaseType & 0x200000 = 0x200000 -- Archive Index Phase - JM_PHASE_TYPE_ARCHIVE_INDEX
		WHERE J.jobId = @vsaAppawareParentJob AND J.commcellId = @i_commCellId AND J.opType NOT IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/
		AND JBA.status = 1 -- Successfull
		)
		BEGIN
			DECLARE @l_appAwareParentIsSnap INT = -1
			DECLARE @l_disableJob INT = 0
			SELECT @l_appAwareParentIsSnap = CASE WHEN opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
			FROM JMBkpStats WITH(NOLOCK) WHERE jobId = @vsaAppawareParentJob AND commcellId = @i_commCellId
			IF (@l_appAwareParentIsSnap = 1)
			BEGIN
				/*
					If we have a parent snap job row in JMBkpStats, check if there is a pending backup copy
				*/
				IF NOT EXISTS(
SELECT 1 FROM JMJobSnapShotStats WITH (NOLOCK)
					WHERE jobId = @vsaAppawareParentJob
AND commcellId = @i_commCellId AND materializationStatus IN (101, 102, 103)
					AND disabled & 1 = 0
					)
						SET @l_disableJob = 1
			END
			ELSE IF(@l_appAwareParentIsSnap = 0)
				SET @l_disableJob = 1
			IF(@l_disableJob = 1)
UPDATE JMJobSnapShotStats SET disabled = disabled | 1, unPickReason = 15
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
			SET @o_validStatus = 10
			GOTO RETURN_PROC
		END
	END
	--Check if parent has successfully processed the child VM
	DECLARE @isParentSnapJob int = -1
	DECLARE @l_parentSnapBackupCopyJobId int = 0
	DECLARE @l_childClientId int = 0
	DECLARE @isParentVMLevelJob int = 0
	SELECT @isParentSnapJob = CASE WHEN JBKP.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END,
@isParentVMLevelJob = CASE WHEN JBKP.bkpAttributesEx & 0x4000000 > 0 THEN 1 ELSE 0 END
	FROM JMBkpStats JBKP WITH(NOLOCK) WHERE JBKP.jobId = @vsaAppawareParentJob AND JBKP.commcellId = @i_commCellId
	--Query running jobs table if it is not found in JMBkpStats
	IF @@ROWCOUNT = 0
	BEGIN
		SELECT @isParentSnapJob = CASE WHEN JI.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
		FROM JMJobInfo JI WITH(NOLOCK) WHERE JI.jobId = @vsaAppawareParentJob AND JI.commcellId = @i_commCellId
SELECT @isParentVMLevelJob = CASE WHEN bkpAttributesEx & 0x4000000 > 0 THEN 1 ELSE 0 END
		FROM JMBkpJobInfo WITH(NOLOCK) WHERE jobId = @vsaAppawareParentJob AND commcellId = @i_commCellId
	END
	--We need to query status of child VM only if the app aware's parent job is NOT a VM level job. With V2 this will be a VM level job so this validation is not required
	IF(@isParentVMLevelJob = 0)
	BEGIN
		SELECT @l_childClientId = clientId FROM App_Application APP WITH(NOLOCK) WHERE APP.id = @l_appId
		IF(@isParentSnapJob = 1)
SELECT @l_parentSnapBackupCopyJobId = JSS.materializationJobId
FROM JMJobSnapShotStats JSS WITH(NOLOCK)
			WHERE JSS.jobId = @vsaAppawareParentJob AND JSS.commcellId = @i_commCellId
		ELSE IF(@isParentSnapJob = 0)
			SET @l_parentSnapBackupCopyJobId = @vsaAppawareParentJob
		ELSE --This means we did not find parent job in JMBkpStats. Snomething is wrong. Fail it.
		BEGIN
			SET @o_validStatus = 11
			GOTO RETURN_PROC
		END
		IF EXISTS(SELECT 1 FROM App_VMProp WITH(NOLOCK) WHERE jobId = @l_parentSnapBackupCopyJobId AND CommcellId = @i_commcellId)
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM App_VMProp WITH(NOLOCK) WHERE jobId = @l_parentSnapBackupCopyJobId AND CommcellId = @i_commcellId AND VMClientId = @l_childClientId AND attrName = 'vmStatus' AND (attrVal = N'0' OR attrVal = N'3') /*success*/)
				SET @o_validStatus = 12
		END
		ELSE
		BEGIN --BackupCopy History could have been pruned. Let's look up the archive file table
			--Find VMGUID from App_VMProp first. If doesn't exist then go for App_ClientProp
			DECLARE @VMClientGUID NVARCHAR(2048)
			SELECT @VMClientGUID = VMP.attrVal
			FROM App_VMProp VMP WITH(NOLOCK)
			WHERE VMP.jobId = @vsaAppawareParentJob AND VMP.commcellId = @i_commcellId AND VMP.VMClientId = @l_childClientId AND VMP.attrName = N'vmGUID'
			IF(@VMClientGUID IS NULL)
			BEGIN
				--GUID gets updated for a VM client and so modified timestamp is set on previous GUID. Pick GUID based on the job time we have for the VM.
				SELECT @VMClientGUID = attrVal FROM App_ClientProp WITH(NOLOCK) WHERE attrName = N'Virtual Machine Instance UUID' AND componentNameId = @l_childClientId AND @l_servEndDate >= created AND (@l_servEndDate < modified OR modified = 0)
			END
			DECLARE @checkSumAFName INT = CHECKSUM(@VMClientGUID)
			--Check if the parent job has an archive file with the VM name
IF NOT EXISTS(SELECT 1 FROM ArchFile WITH(NOLOCK) WHERE name = @VMClientGUID AND cs_afname = @checkSumAFName AND jobId = @vsaAppawareParentJob AND commcellId = @i_commCellId AND flags & 4 > 0 AND isValid = 1)
				SET @o_validStatus = 12
		END
		IF(@o_validStatus = 12)
		BEGIN
UPDATE JMJobSnapShotStats SET disabled = disabled | 1, unPickReason = 15
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
			GOTO RETURN_PROC
		END
	END
END
SET @o_retCode = 0
SET @o_validStatus = 1
RETURN_PROC:
SELECT @o_retCode, @o_validStatus
GO

IF EXISTS (select * from GxQscripts where name = 'archMaterializeCheckJobValidity')
	delete from GxQscripts where name = 'archMaterializeCheckJobValidity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMaterializeCheckJobValidity')
	delete from GXDBVersions where aliasname = 'archMaterializeCheckJobValidity'
GO

insert into GXDBVersions values(2, 'archMaterializeCheckJobValidity',  '00010011005400040000', 'archMaterializeCheckJobValidity', '00010011005400040000')
GO

