

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archMarkJobsDoNotCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archMarkJobsDoNotCopy')
BEGIN
	print '>>> Drop Stored Procedure: archMarkJobsDoNotCopy <<<'
	drop procedure archMarkJobsDoNotCopy
END
IF EXISTS (select * from GxQscripts where name='archMarkJobsDoNotCopy')
	delete from GxQscripts where name = 'archMarkJobsDoNotCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMarkJobsDoNotCopy')
	delete from GXDBVersions where aliasname = 'archMarkJobsDoNotCopy'
GO
print '... Creating Procedure: archMarkJobsDoNotCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archMarkJobsDoNotCopy
  @i_CommCellId integer,
  @i_reserveParam integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRY
	DECLARE			@errCode INTEGER
	SET				@errCode = 0
	DECLARE			@spName VARCHAR(1024)
	DECLARE			@spArgs VARCHAR(MAX)
	DECLARE			@procId INTEGER
	DECLARE			@lastAttemptTime BIGINT
	DECLARE			@lastRunOutput VARCHAR(MAX)
	SET @spName = OBJECT_NAME (@@PROCID)
	SET @spArgs = CONVERT(VARCHAR,@i_CommCellId) +','+ CONVERT(VARCHAR, @i_reserveParam)
	SET @procId = isnull (checksum(@spName, @spArgs), 0)
	SELECT	@lastAttemptTime = ISNULL(lastAttemptTime, -1),
			@lastRunOutput = ISNULL(lastRunOut, '')
	FROM	MMProcsToRun WITH (READUNCOMMITTED) WHERE
			ProcId = @procId
	SET @lastRunOutput = ( case when (@lastRunOutput = '') then '' else (LEFT(@lastRunOutput, LEN(@lastRunOutput) - 1)) end ) -- remove the last comma
	---------------------------------------------------
	-- Is it already time for me to run?
	---------------------------------------------------
	DECLARE		@currentTime INT = dbo.getUnixTime(GETUTCDATE())
	DECLARE		@intervalForMarkJobsDoNotCopySeconds INT = 0
	SET			@intervalForMarkJobsDoNotCopySeconds = 24 * 3600 -- Default Once a day
	SELECT	@intervalForMarkJobsDoNotCopySeconds = value * 3600
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MM_CONFIG_MARKJOBSDONOTCOPY_INTERVAL_HOURS'
	IF ( (@lastAttemptTime = -1) OR (@intervalForMarkJobsDoNotCopySeconds <= 0) OR ((@currentTime - @intervalForMarkJobsDoNotCopySeconds) <= @lastAttemptTime) )
	BEGIN
		-- nope
		GOTO PROC_EXIT
	END
	ELSE
	-- Update the attempt time before starting the main logic in the proc.. if any failure, it wont be tried again till interval has passed
	BEGIN
		UPDATE	MMProcsToRun
		SET		lastAttemptTime = [dbo].[GetUnixTime](GETUTCDATE())
		WHERE	ProcId = @procId
	END
	--
	-- Use this currentRunOutput variable to set a string in the mmprocstorun table after SP finishes so that
	-- next run of this can either undo the damage done in previous run or act according to what was done last
	--
	DECLARE			@curRunOutput VARCHAR(1024) = ''
	---------------------------------------------------
	-- Ok, let's get on with the logic now...
	---------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#tblSecondaryCopiesInfo') IS NOT NULL DROP TABLE #tblSecondaryCopiesInfo
	CREATE TABLE #tblSecondaryCopiesInfo
	(	spId		INTEGER,
		policyName		NVARCHAR(144),
		copyId		INTEGER,
copyName	NVARCHAR(64)
		PRIMARY KEY (copyId)
	)
	IF OBJECT_ID('tempdb.dbo.#tblSrcCopiesMap') IS NOT NULL DROP TABLE #tblSrcCopiesMap
	CREATE TABLE #tblSrcCopiesMap
	(
		copyId		INTEGER,
		sourceCopyId	INTEGER
	)
	IF OBJECT_ID('tempdb.dbo.#tblJDS') IS NOT null DROP TABLE #tblJDS
	CREATE TABLE #tblJDS
	(
		jobId		INTEGER,
		commCellId	INTEGER,
		dataType	INTEGER,
		archCopyId	INTEGER,
		archGrpId	INTEGER
		PRIMARY KEY(jobId, commCellId, dataType, archCopyId)
	)
	IF OBJECT_ID('tempdb.dbo.#tblJDSDoNotCopy') IS NOT null DROP TABLE #tblJDSDoNotCopy
	CREATE TABLE #tblJDSDoNotCopy
	(
		jobId		INTEGER,
		commCellId	INTEGER,
		dataType	INTEGER,
		archCopyId	INTEGER
		PRIMARY KEY(jobId, commCellId, dataType, archCopyId)
	)
	IF OBJECT_ID('tempdb..#jobsToProcess') IS NOT NULL DROP TABLE #jobsToProcess
	CREATE TABLE #jobsToProcess
	(
		jobId 			INTEGER,
		commCellId		INTEGER,
		archGrpCopyId	INTEGER,
		Primary Key (jobId, commCellId, archGrpCopyId) WITH (ignore_dup_key = ON)
	)
    IF OBJECT_ID('tempdb.dbo.#QS_MarkJobsOnCopy_Output') IS NOT NULL DROP TABLE #QS_MarkJobsOnCopy_Output
    CREATE TABLE #QS_MarkJobsOnCopy_Output
	(
		Msg NVARCHAR(MAX)
	)
	IF OBJECT_ID('tempdb..#archSourceCopyListResultTable') IS NOT NULL DROP TABLE #archSourceCopyListResultTable
	CREATE TABLE #archSourceCopyListResultTable
	(
		copyId			INT,
		sourceCopyId	INT,
		defaultCopyId	INT,
		archGroupId		INT,
		copyFlags		INT,
		dedupeFlags		INT,
		maxMultiplex	INT,
		isSnapCopy		INT,
		isMirrorCopy	INT,
		SIBlockSize		INT
	)
	DECLARE @jobId INTEGER = 0
	DECLARE @l_copyId INT = 0
	DECLARE @policyName NVARCHAR(144) = ''
DECLARE @copyName NVARCHAR(64) = ''
	INSERT INTO #tblSecondaryCopiesInfo
	SELECT	AG.id PolicyId, AG.name, AGC.id CopyId, AGC.name
	FROM	archGroup AG WITH (READUNCOMMITTED)
			INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AG.id = AGC.archGroupId
	WHERE	AGC.id != AG.defaultCopy
			AND AGC.id != AG.defaultSnapCopy
AND AGC.type != 5
	INSERT INTO #tblSrcCopiesMap
	SELECT	TC.copyId, (CASE WHEN (AGC.SourceCopyId = AG.defaultCopy OR AGC.SourceCopyId = AG.defaultSnapCopy) THEN AGC.sourceCopyId
							WHEN (AGC.SourceCopyId = 0 AND AGC.isSnapCopy > 0) THEN AG.defaultSnapCopy
							WHEN (AGC.SourceCopyId = 0) THEN AG.defaultCopy
							ELSE 0
						END)
	FROM	archGroup AG WITH (READUNCOMMITTED)
			INNER JOIN #tblSecondaryCopiesInfo TC ON AG.id = TC.spId
			INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON TC.copyId = AGC.id
	DELETE FROM #tblSrcCopiesMap
	WHERE	sourceCopyId = 0
	--Batching by copy
	DECLARE SRC_COPYLIST_CURSOR CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
	SELECT DISTINCT copyId FROM #tblSecondaryCopiesInfo
	EXCEPT
	SELECT DISTINCT copyId FROM #tblSrcCopiesMap
	OPEN SRC_COPYLIST_CURSOR
	FETCH NEXT FROM SRC_COPYLIST_CURSOR INTO @l_copyId
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		DELETE FROM #archSourceCopyListResultTable
		EXEC archSourceCopyList @l_copyId
		INSERT INTO #tblSrcCopiesMap
		SELECT	@l_copyId, T.CopyId
		FROM	#archSourceCopyListResultTable T
		WHERE	T.copyId != @l_copyId
				AND NOT EXISTS (SELECT 1 FROM #tblSrcCopiesMap S WHERE S.CopyId = @l_copyId AND S.SourceCopyId = T.CopyId)
		FETCH NEXT FROM SRC_COPYLIST_CURSOR INTO @l_copyId
	END
	CLOSE SRC_COPYLIST_CURSOR
	DEALLOCATE SRC_COPYLIST_CURSOR
	WHILE (1 = 1)
	BEGIN
		DELETE FROM #tblJDS
		INSERT INTO #tblJDS
		SELECT	TOP 10000 JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.archGrpId
		FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
		WHERE	JDS.status IN (101, 102, 103) /*NODATACOPIED,NODATAVALID,PARTIALDATA*/
AND (JDS.disabled & (256|1)) = 0
				AND JDS.jobId > @jobId
		ORDER BY jobId
		IF @@ROWCOUNT = 0
			BREAK
		SELECT @jobId = MAX(jobId)
		FROM	#tblJDS
		DELETE T
		FROM	#tblJDS T
				INNER JOIN #tblSrcCopiesMap S ON T.archCopyId  = S.CopyId
				INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED)
					ON	T.jobId = JDS.jobId AND T.commCellId = JDS.commCellId AND T.dataType = JDS.dataType
						AND S.sourceCopyId = JDS.archGrpCopyId AND JDS.Status = 100 /*READY*/
		INSERT INTO #tblJDSDoNotCopy
		SELECT	jobId, commCellId, dataType, archCopyId
		FROM	#tblJDS
	END
	IF EXISTS (SELECT 1 FROM #tblJDSDoNotCopy)
	BEGIN
		TRUNCATE TABLE #jobsToProcess
		--Pick jobs to retain and mark bad
		;WITH CTE
		AS (
					SELECT TOP 10000 *
					FROM #tblJDSDoNotCopy
					ORDER BY archCopyId, jobId
				)
		DELETE FROM CTE
		OUTPUT DELETED.jobId, DELETED.commCellId, DELETED.archCopyId INTO #jobsToProcess
		--Batching by copy
		DECLARE COPYLIST_CURSOR CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
		SELECT DISTINCT archGrpCopyId FROM #jobsToProcess
		OPEN COPYLIST_CURSOR
		FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
		WHILE (@@FETCH_STATUS = 0)
		BEGIN
			SELECT @policyName = policyName, @copyName = copyName
			FROM   #tblSecondaryCopiesInfo T
			WHERE  T.copyId = @l_copyId
			DECLARE @jobList nvarchar(max) = NULL
			SELECT @jobList = COALESCE(@jobList+', ' ,'') + CAST(jobId as VARCHAR(10))
			FROM #jobsToProcess
			WHERE archGrpCopyId = @l_copyId
			EXEC QS_MarkJobsOnCopy @policyName, @copyName, 'donotcopy', @jobList
			--SELECT @policyName, @copyName, 'donotcopy', @jobList
			FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
		END
		CLOSE COPYLIST_CURSOR
		DEALLOCATE COPYLIST_CURSOR
	END
	--
	-- update the table with the damage done.
	-- There is nothing to update now
	-- SELECT
	--	@curRunOutput = COALESCE(@curRunOutput + ',', '') + cast (DDBs.DDBId as varchar(32))
	-- FROM @l_DefragJobStores DDBs
	update MMProcsToRun
	set lastRunOut = @curRunOutput
	where ProcId = @procId
END TRY
BEGIN CATCH
	IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= -1) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= -1)
	BEGIN
		IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= 0) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= 0)
		BEGIN
			CLOSE COPYLIST_CURSOR
		END
		DEALLOCATE COPYLIST_CURSOR
	END
	IF (CURSOR_STATUS('global', 'SRC_COPYLIST_CURSOR') >= -1) OR (CURSOR_STATUS('local', 'SRC_COPYLIST_CURSOR') >= -1)
	BEGIN
		IF (CURSOR_STATUS('global', 'SRC_COPYLIST_CURSOR') >= 0) OR (CURSOR_STATUS('local', 'SRC_COPYLIST_CURSOR') >= 0)
		BEGIN
			CLOSE SRC_COPYLIST_CURSOR
		END
		DEALLOCATE SRC_COPYLIST_CURSOR
	END
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 ;THROW
END CATCH
PROC_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblSecondaryCopiesInfo') IS NOT NULL DROP TABLE #tblSecondaryCopiesInfo
IF OBJECT_ID('tempdb.dbo.#tblJDS') IS NOT null DROP TABLE #tblJDS
IF OBJECT_ID('tempdb.dbo.#tblJDSDoNotCopy') IS NOT null DROP TABLE #tblJDSDoNotCopy
IF OBJECT_ID('tempdb.dbo.#jobsToProcess') IS NOT NULL DROP TABLE #jobsToProcess
IF OBJECT_ID('tempdb.dbo.#QS_MarkJobsOnCopy_Output') IS NOT NULL DROP TABLE #QS_MarkJobsOnCopy_Output
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archMarkJobsDoNotCopy')
	delete from GxQscripts where name = 'archMarkJobsDoNotCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archMarkJobsDoNotCopy')
	delete from GXDBVersions where aliasname = 'archMarkJobsDoNotCopy'
GO

insert into GXDBVersions values(2, 'archMarkJobsDoNotCopy',  '00000000000000000000', 'archMarkJobsDoNotCopy', '00000000000000000000')
GO

