

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archLREPGetInfoForNewSnapDataSet.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archLREPGetInfoForNewSnapDataSet							  */
/*                                                                            */
/*  Description :  Stored proc to get LREP storage policy info to use during  */
/*				   dataset creation					  						  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archLREPGetInfoForNewSnapDataSet.sp,v $ $Id: archLREPGetInfoForNewSnapDataSet.sp,v 1.6.60.3 2018/03/20 20:00:20 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archLREPGetInfoForNewSnapDataSet <<<'

IF EXISTS (select * from sysobjects where name='archLREPGetInfoForNewSnapDataSet')
	drop procedure archLREPGetInfoForNewSnapDataSet
IF EXISTS (select * from GxQscripts where name='archLREPGetInfoForNewSnapDataSet')
	delete from GxQscripts where name = 'archLREPGetInfoForNewSnapDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archLREPGetInfoForNewSnapDataSet')
	delete from GXDBVersions where aliasname = 'archLREPGetInfoForNewSnapDataSet'
GO
print '... Creating Procedure: archLREPGetInfoForNewSnapDataSet'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archLREPGetInfoForNewSnapDataSet
  @archGroupId integer,
  @archGroupCopyId integer
-- Following are the "columns" returned, in the order in which they are returned
AS
  DECLARE @retCode integer;
  DECLARE @appId integer;
  DECLARE @controlHostId integer;
  DECLARE @SMRelationId integer;
  DECLARE @extRelationId NVARCHAR(512);
  DECLARE @CommCellName NVARCHAR(256);
SET @retCode = 0
SET @controlHostId = 0
SET @SMRelationId = 0
SET @extRelationId = ''
SET @CommcellName = ''
--SET @StoragePolicyName = ''
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @rowCount int = 0
SET @appId = 0 --For LREP we will create a default dataset with appId 0 when the snap copy's resource pool and provisioning policy are set
SELECT @SMRelationId = SMR.SMRelationId, @extRelationId = SMR.ExtRelationId/*(CASE WHEN ISNUMERIC(SMR.ExtRelationId) = 1 THEN CAST(SMR.ExtRelationId AS INTEGER) ELSE 0 END)*/, @controlHostId = SMR.controlHostId
FROM SMRelation SMR WITH(NOLOCK) inner join SMCopyToRelationMap SMCR WITH(NOLOCK) ON SMR.SMRelationId = SMCR.SMRelationId AND SMCR.archGroupCopyId = @archGroupCopyId
SELECT @retCode = @@ERROR, @rowCount = @@ROWCOUNT
IF @rowCount = 0 --No relation found
BEGIN
SET @retCode = 128
	GOTO PROC_EXIT
END
IF @retCode <> 0
	GOTO PROC_EXIT
/*
SELECT @StoragePolicyName = name FROM ArchGroup WITH(NOLOCK) WHERE id = @archGroupId
SET @retCode = @@ERROR
IF @retCode <> 0
	GOTO PROC_EXIT
*/
SELECT @CommCellName = aliasName FROM App_Commcell WITH(NOLOCK) WHERE id = 2
SET @retCode = @@ERROR
IF @retCode <> 0
	GOTO PROC_EXIT
SET @retCode = 0
PROC_EXIT:
SELECT @retCode, @appId, @controlHostId, @smRelationId, @extRelationId, @commcellName
GO

IF EXISTS (select * from GxQscripts where name = 'archLREPGetInfoForNewSnapDataSet')
	delete from GxQscripts where name = 'archLREPGetInfoForNewSnapDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archLREPGetInfoForNewSnapDataSet')
	delete from GXDBVersions where aliasname = 'archLREPGetInfoForNewSnapDataSet'
GO

insert into GXDBVersions values(2, 'archLREPGetInfoForNewSnapDataSet',  '00010006006000030000', 'archLREPGetInfoForNewSnapDataSet', '00010006006000030000')
GO

