

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archJobDataStatsCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archJobDataStatsCreate.sp,v $ $Id: archJobDataStatsCreate.sp,v 1.54.12.37 2020/12/31 00:31:25 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archJobDataStatsCreate')
BEGIN
	print '>>> Drop Stored Procedure: archJobDataStatsCreate <<<'
	drop procedure archJobDataStatsCreate
END
IF EXISTS (select * from GxQscripts where name='archJobDataStatsCreate')
	delete from GxQscripts where name = 'archJobDataStatsCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobDataStatsCreate')
	delete from GXDBVersions where aliasname = 'archJobDataStatsCreate'
GO
print '... Creating Procedure: archJobDataStatsCreate'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archJobDataStatsCreate
  @i_jobId integer,
  @i_commCellId integer,
  @i_appType integer,
  @i_jobState integer,
  @i_modifiedTime integer,
  @i_origJobXML XML = NULL
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @retVal integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #tempArchFile (
		archFileId int, archGroupId int, appId int, fileType int, isValid int, flags int)
CREATE TABLE #tempArchFileCopy (
		archFileId int, commCellId int, archCopyId int, isSnapCopy int, archGroupId int, defaultCopy int,
		isValid int, streamNum int, physicalSize bigint,
encRSA int, encKeyType int, encKey varchar(1024), unCompSize bigint)
CREATE TABLE #tempDataStats (
		archGroupId int, archCopyId int, defaultCopy int, appId int, fileType int, status int,
		minIsValid int, maxIsValid int, physicalSize bigint, sizeOnMedia bigint, flags int, unCompSize bigint)
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
SET	@retVal = 0
DECLARE	@l_appId		int = 0
DECLARE	@l_nRows		int = 0
DECLARE	@l_isSiloBackup	int = 0
DECLARE	@l_sizeOfBackup	bigint = 0
DECLARE	@l_MatJobId 	int = 0
DECLARE	@l_disabled 	int = 0
DECLARE @l_isDDBBackupToSec	int = 0
DECLARE @l_OpType		int = 0
DECLARE @l_origJobId	int = 0
DECLARE @l_origJobCommCellId	int = 0
DECLARE @l_origJobState	int = 0
DECLARE @l_origIsSnapJob	int = 0
DECLARE @tblJobCopyToRetain TABLE (jobId INTEGER, commCellId INTEGER, archGroupId INTEGER, archCopyId INTEGER, retainUntil BIGINT)
IF OBJECT_ID('tempdb..#archDestinationCopyListResultTable') IS NOT NULL DROP TABLE #archDestinationCopyListResultTable
CREATE TABLE #archDestinationCopyListResultTable (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
DECLARE @fileTypes TABLE(fileType INT, invalidate INT)
SELECT @l_MatJobId = ISNULL(max(WF.childJobId),0)
FROM JMJobWF WF WITH (NOLOCK) INNER JOIN JMJobInfo J WITH (NOLOCK) ON WF.childJobId = J.jobId AND J.opType = 60  --SNAPTOTAPE = 60,
WHERE WF.processedJobId = @i_jobId AND WF.commcellId = @i_commcellId
-- Check whether the job is manually retained or not
DECLARE	@retentionEndTime BIGINT
DECLARE @successJob 		SMALLINT
SET		@successJob 		= 1
DECLARE @onlyInvalidArchFilesExist 		SMALLINT
SET		@onlyInvalidArchFilesExist 		= 0
DECLARE	@retentionJobType INTEGER
SET			@retentionJobType = 2
DECLARE	@applyRetentionOn INTEGER
SET			@applyRetentionOn = 0
DECLARE	@retentionDays INTEGER
SET 		@retentionDays = -1
--Get retention XML blob from Job Options
DECLARE @retentionXML XML
SELECT @retentionXML = attributeValue
FROM JMJobOptions WITH (NOLOCK)
WHERE jobId = @i_jobId
AND		commcellId = @i_commCellId
AND		attributeId = 66
-- If retention XML blob is not set in Job Options, then default it to SP\copy retention
IF @retentionXML IS NULL
BEGIN
	SET	@retentionJobType = 2
END
ELSE
BEGIN
	SELECT @retentionJobType = ISNULL(T.item.value('@retentionJobType', 'INTEGER'), 2),
				 @applyRetentionOn = ISNULL(T.item.value('@applyJobRetentionOn', 'INTEGER'), 0),
				 @retentionDays = ISNULL(T.item.value('@numberofDays', 'INTEGER'), -1)
	FROM	 @retentionXML.nodes('/TMMsg_MediaBkpOption') T(item)
END
IF (@retentionJobType = 0 OR @retentionDays < 0) -- INFINITE RETENTION
BEGIN
	SET @retentionDays = -1
	SET @retentionEndTime = -1
END
ELSE IF @retentionJobType = 1 -- RETAIN UNTIL
BEGIN
	DECLARE @jobStartTime	INTEGER
IF	@i_appType <> 1000
	BEGIN
		SELECT @jobStartTime = servStartDate FROM JMBkpStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId
	END
IF	@i_appType = 1000 OR @jobStartTime IS NULL
	BEGIN
		SELECT @jobStartTime = servStart FROM JMAdminJobStatsTable WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId
	END
	IF @jobStartTime IS NULL
		SET @retentionEndTime = -1
	ELSE
		SET @retentionEndTime = (@jobStartTime + cast(@retentionDays as bigint) * 24 * 3600)
END
ELSE
BEGIN
	SET @retentionEndTime = 0
END
--If there is valid entry in the archFile table and no entry in the archFileCopy table, create dummy entry so the auxcopy job can mark the status
-- on destination copy correctly
IF (EXISTS (SELECT *
	FROM archFile AF WITH (NOLOCK)
		LEFT OUTER JOIN  archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commcellid = AFC.commcellId
	WHERE AF.JobID = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1
	     AND AFC.archFileID IS NULL))
BEGIN
	DECLARE	@archFileCopyTemp TABLE (archFileId INTEGER, CommCellId INTEGER, archCopyId INTEGER, SIDBStoreId INTEGER)
	INSERT INTO @archFileCopyTemp
SELECT	AF.id, AF.CommCellId, (CASE WHEN (AF.flags & 2 <> 0) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END), ISNULL(SCD.SIDBStoreId, 0)
	FROM	archFile AF
			INNER JOIN archGroup AG ON AF.archGroupId = AG.id
INNER JOIN archGroupCopy AGC ON AGC.id = (CASE WHEN (AF.flags & 2 <> 0) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END)
			LEFT OUTER JOIN archSubclientCopyDDBMap SCD WITH (READUNCOMMITTED) ON SCD.appId = AF.appId AND SCD.copyId = AGC.id
			LEFT OUTER JOIN  archFileCopy AFC ON AF.id = AFC.archFileId AND AF.commcellid = AFC.commcellId
	WHERE AF.JobID = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1
	     AND AFC.archFileID IS NULL
	INSERT INTO archFileCopy
	SELECT	AF.archFileId, AF.CommCellId, AF.archCopyId,
			0, 1, 0, 0, 0, 0, 0, ISNULL(AFK.encRSA, 0), ISNULL(AFK.encKeyType,0), ISNULL(AFK.encKey,''), @i_modifiedTime, 0, 0, ISNULL(encKeyId,0), -1
	FROM	@archFileCopyTemp AF
			LEFT OUTER JOIN
			(
				SELECT 	K.archFileId, K.commCellId, K.SIDBStoreId, ISNULL(keys.encRSA, K.encRSA) encRSA, ISNULL(keys.encKeyType, K.encKeyType) encKeyType, ISNULL(keys.encKey, K.encKey) encKey,
						K.encKeyid encKeyId,
						ROW_NUMBER() OVER (PARTITION BY K.archFileId, K.commCellId, K.SIDBStoreId ORDER BY K.archCopyId DESC) AS RowNumber
				FROM 	archFileSIDBKeys K WITH (NOLOCK) LEFT JOIN ArchEncKeys keys WITH (NOLOCK) ON K.encKeyId = keys.encKeyId,
						@archFileCopyTemp T
				WHERE 	K.archFileId = T.archFileId AND K.CommCellId = T.CommCellId AND K.SIDBStoreId = T.SIDBStoreId
			) AS AFK ON AF.archFileId = AFK.archFileId AND AF.commcellid = AFK.commcellId AND AF.SIDBStoreId = AFK.SIDBStoreId AND AFK.RowNumber = 1
	INSERT	INTO archFileCopyDedup(archFileId, commCellId, archCopyId, SIDBStoreId,
										primaryObjects, secondaryObjects, primaryObjSize, secondaryObjSize,
										primaryMetaDataSize, secondaryMetaDataSize, transDataSize, savedDataSize)
	SELECT  T.archFileId, T.CommCellId, T.archCopyId, T.SIDBStoreId,
			0, 0, 0, 0,
			0, 0, 0, 0
	FROM	@archFileCopyTemp T
	WHERE	T.SIDBStoreId > 0
	INSERT INTO archFileSubStore(archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
	SELECT	T.archFileId, T.CommCellId, S.SIDBStoreId, S.SubStoreId, 0, 0
	FROM	IdxSIDBSubStore S INNER JOIN @archFileCopyTemp T ON S.SIDBStoreId = T.SIDBStoreId
				LEFT OUTER JOIN archFileSubStore AFS ON T.archFileId = AFS.archFileId AND T.CommCellId = AFS.CommCellId AND AFS.SIDBStoreId = S.SIDBStoreId AND AFS.SIDBSubStoreId = S.SubStoreId
	WHERE	AFS.archFileId IS NULL
			AND T.SIDBStoreId > 0
END
DECLARE @hasValidOrigJob bit = 0
DECLARE @l_jobIdtoUseinDataStats int = @i_jobId
DECLARE @l_commCellIdtoUseinDataStats int = @i_commCellId
IF (@i_origJobXML IS NOT NULL)
BEGIN
	SELECT	@l_origJobId = ISNULL(ref.value('@jobId','INTEGER'), 0),
			@l_origJobCommCellId = ISNULL(ref.value('@commCellId','INTEGER'), 0),
			@l_origJobState = ISNULL(ref.value('@jobState','INTEGER'), 0),
			@l_origIsSnapJob = ISNULL(ref.value('@isSnapJob','INTEGER'), 0)
	FROM	@i_origJobXML.nodes ('/OrigJobInfo') R(ref)
END
IF (@l_origJobId > 0)
BEGIN
	SELECT	@l_OpType = subOpType
	FROM	JMJobStats WITH (READUNCOMMITTED)
	WHERE	jobId = @i_jobId
			AND CommCellId = @i_commCellId
	IF (@l_OpType = 112 /*DATA_ANALYTICS2*/)
	BEGIN
		SELECT	TOP 1 @l_appId = appId
		FROM	ArchFile AF WITH (READUNCOMMITTED)
		WHERE	jobId = @l_origJobId AND commCellId = @l_origJobCommCellId
		INSERT INTO @fileTypes
		SELECT	DISTINCT fileType, 1
		FROM	archFile AF WITH (READUNCOMMITTED)
		WHERE	AF.jobId = @i_jobId
				AND AF.commCellId = @i_commCellId
				AND AF.AppId = @l_AppId
IF (@i_appType = 106 /*106*/) --VSA
		BEGIN
			UPDATE	@fileTypes
			SET		invalidate = 0
WHERE	fileType NOT IN (2, 6, 7)
		END
		ELSE
		BEGIN
			UPDATE	@fileTypes
			SET		invalidate = 0
WHERE	fileType NOT IN (2, 6)
		END
	END
END
ELSE IF EXISTS (SELECT  * FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND subOpType = 96) --enum CVOpType {DELAYEDCATALOG = 96,};
BEGIN
	SELECT @l_origJobId = processedJobId, @l_origJobCommCellId = processedCommcellId, @l_OpType = 96 /*DELAYEDCATALOG*/, @l_origIsSnapJob = 1
	FROM JMJobWF WITH (READUNCOMMITTED) WHERE childJobId = @i_jobId AND commcellId = @i_commCellId
	SELECT	TOP 1 @l_appId = appId
	FROM	ArchFile AF WITH (READUNCOMMITTED)
	WHERE	jobId = @l_origJobId AND commCellId = @l_origJobCommCellId
	INSERT INTO @fileTypes
SELECT	6, 1
END
IF (@l_origJobId > 0)
BEGIN
    /*
		  Validate the status of data of the original snap.
		  If the original job data is marked as aged or bcd index exists on original snap job as aged (V2 indexing) invalidate the archive file created during deferred catalog/Data Analytics2
		  so the data is not reassociated to snap job. Instead they will stay associated with processed job (deferred catalog/Data Analytics2 job) and get processed for aging.
    */
	SET @l_nRows = 0
	UPDATE AFC SET isValid = -1
	FROM ArchFile AF WITH(NOLOCK)
		INNER JOIN ArchFileCopy AFC ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId
		INNER JOIN ArchAgingRule AR WITH (READUNCOMMITTED) ON AFC.archCopyId = AR.CopyId AND (AR.retentionDays != 0 OR AR.fullCycles != 0 OR (@l_OpType != 112 /*DATA_ANALYTICS2*/))
		LEFT OUTER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDS.jobId = @l_origJobId AND JDS.commcellId = @l_origJobCommCellId AND AFC.archCopyId = JDS.archGrpCopyId
AND JDS.dataType IN (1, 4) AND JDS.status = 100 /*READY*/ AND JDS.disabled & 256 = 0
	WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AF.appId = @l_appId
		AND (JDS.jobId IS NULL)
	SET @l_nRows += @@ROWCOUNT
	UPDATE AFC SET isValid = -1
	FROM ArchFile AF WITH(NOLOCK)
		INNER JOIN ArchFileCopy AFC ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId
		INNER JOIN ArchAgingRule AR WITH (READUNCOMMITTED) ON AFC.archCopyId = AR.CopyId AND (AR.retentionDays != 0 OR AR.fullCycles != 0 OR (@l_OpType != 112 /*DATA_ANALYTICS2*/))
		INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDS.jobId = @l_origJobId AND JDS.commcellId = @l_origJobCommCellId AND AFC.archCopyId = JDS.archGrpCopyId
AND JDS.dataType = AF.fileType AND (JDS.disabled & 256 > 0 OR JDS.status = 1000 /*PRUNED*/),
		@fileTypes FT
	WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AF.appId = @l_appId
			AND AF.fileType = FT.fileType
	SET @l_nRows += @@ROWCOUNT
	IF ((@l_OpType = 112 /*DATA_ANALYTICS2*/) AND @l_nRows > 0)
	BEGIN
		SET	@retVal = 1
		GOTO NO_INSERT_EXIT
	END
	IF NOT EXISTS(SELECT 1 FROM ArchFile AF WITH(NOLOCK) INNER JOIN ArchFileCopy AFC WITH(NOLOCK) ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId
				 WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AFC.isValid = 1 AND AF.appId = @l_appId)
	BEGIN
		UPDATE	AF
		SET		isValid = -1
		FROM	ArchFile AF
				LEFT OUTER JOIN ArchFileCopy AFC WITH(NOLOCK) ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId AND AFC.isValid = 1,
				@fileTypes FT
		WHERE	AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AF.isValid <> -1 AND AF.appId = @l_appId
				AND AF.fileType = FT.fileType
				AND AFC.archFileId IS NULL
	END
	IF EXISTS (SELECT 1 FROM ArchFile AF WITH (NOLOCK) WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AF.isValid = 1 AND AF.appId = @l_appId)
		OR (@l_OpType = 112 /*DATA_ANALYTICS2*/)
	BEGIN
		SET @hasValidOrigJob = 1
		SET @l_jobIdtoUseinDataStats  = @l_origJobId
		SET @l_commCellIdtoUseinDataStats = @l_origJobCommCellId
	END
END
--get manual retention end time for @l_jobIdtoUseinDataStats
IF (@retentionJobType = 0 OR @retentionJobType = 1)
BEGIN
	--Retain job on selected list of copies
	IF @applyRetentionOn = 2
	BEGIN
		INSERT INTO @tblJobCopyToRetain
		SELECT 	DISTINCT @l_jobIdtoUseinDataStats, @l_commCellIdtoUseinDataStats, AGC.archGroupId, AGC.id, @retentionEndTime
		FROM 		archFile AF WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), (	SELECT T.item.value('@storagePolicyId', 'INTEGER') AS archGrpId,
																																								 T.item.value('@copyId', 'INTEGER')	AS archGrpCopyId
																																					FROM	 @retentionXML.nodes('/TMMsg_MediaBkpOption/selectedCopyList') T(item) ) TMP
		WHERE AF.jobId = @l_jobIdtoUseinDataStats
		AND		AF.commCellId = @l_commCellIdtoUseinDataStats
		AND		AF.archGroupId = AGC.archGroupId
		AND		AGC.archGroupId = TMP.archGrpId
		AND		AGC.id = TMP.archGrpCopyId
		--If copies are not valid then set retention on Primary Copy
		IF @@ROWCOUNT = 0
			SET @applyRetentionOn = 0 --Retain job on Primary Copy
	  --Raise event if SP\copy list is not valid
	  /*
	  IF EXISTS (SELECT TMP.*
	  					 FROM (SELECT T.item.value('@storagePolicyId', 'INTEGER') AS archGrpId,
														 T.item.value('@copyId', 'INTEGER')	AS archGrpCopyId
											FROM	 @retentionXML.nodes('/TMMsg_MediaBkpOption/selectedCopyList') T(item)
										 ) TMP LEFT OUTER JOIN @tblJobCopyToRetain T
							 ON  TMP.archGrpId = T.archGroupId
							 AND TMP.archGrpCopyId = T.archCopyId
							 WHERE T.archGroupId IS NULL OR T.archCopyId IS NULL
							)
	  BEGIN
	  	--TODO Add event code here
	  	--"One or more selected copies is not applicable for job retention"
	  END
	  */
	END
	--Retain job on all copies
	IF @applyRetentionOn = 1
	BEGIN
		INSERT INTO @tblJobCopyToRetain
		SELECT 	DISTINCT @l_jobIdtoUseinDataStats, @l_commCellIdtoUseinDataStats, AGC.archGroupId, AGC.id, @retentionEndTime
		FROM archFile AF WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE AF.jobId = @l_jobIdtoUseinDataStats
		AND		AF.commCellId = @l_commCellIdtoUseinDataStats
		AND		AF.archGroupId = AGC.archGroupId
	END
	--Retain job only on Primary copy
	IF (@applyRetentionOn = 0	OR @applyRetentionOn NOT IN (1, 2))
	BEGIN
		INSERT INTO @tblJobCopyToRetain
		SELECT 	DISTINCT @l_jobIdtoUseinDataStats, @l_commCellIdtoUseinDataStats, AG.Id, AG.defaultCopy, @retentionEndTime
		FROM archFile AF WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE AF.jobId = @l_jobIdtoUseinDataStats
		AND		AF.commCellId = @l_commCellIdtoUseinDataStats
		AND		AF.archGroupId = AG.Id
		UNION
		SELECT 	DISTINCT @l_jobIdtoUseinDataStats, @l_commCellIdtoUseinDataStats, AG.Id, AG.defaultSnapCopy, @retentionEndTime
		FROM archFile AF WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE AF.jobId = @l_jobIdtoUseinDataStats
		AND		AF.commCellId = @l_commCellIdtoUseinDataStats
		AND		AF.archGroupId = AG.Id
	END
	--If a part of job is already created then copy the manualRetentionEndTime from existing partial job
	UPDATE @tblJobCopyToRetain
	SET retainUntil = JDS.manualRetentionEndTime
	FROM @tblJobCopyToRetain T, JMJobDataStats JDS WITH (NOLOCK)
	WHERE T.jobId = JDS.jobId
	AND		T.commcellId = JDS.commcellId
	AND		T.archCopyId = JDS.archGrpCopyId
END
if (@hasValidOrigJob > 0)
BEGIN
	UPDATE	FT
	SET		FT.invalidate = 0
	FROM	@fileTypes FT
			LEFT OUTER JOIN (SELECT AF.fileType FROM ArchFile AF WITH (NOLOCK) WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AF.isValid = 1 AND AF.appId = @l_appId) T
					ON FT.fileType = T.fileType
	WHERE	T.fileType IS NULL
	/*
	With V2 indexing there will be a BCD index archive file created during snap job and then a BCD index archive file created during deferred catalog again.
	When we commit the deferred catalog job we will age the older ones.
	*/
	IF EXISTS (SELECT 1 FROM JMJobDataStats WITH (NOLOCK), @fileTypes FT WHERE jobId = @l_origJobId AND commCellId = @l_origJobCommCellId AND dataType = FT.fileType)
	BEGIN
		DECLARE @l_processedSourceCopy int = 0
		DECLARE @l_processedCopies table(copyId int)
		--Get all the copies on which the deferred catalog job created archive files
		INSERT @l_processedCopies
		SELECT DISTINCT AFC.ArchCopyId
		FROM ArchFileCopy AFC WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON AFC.ArchfileId = AF.id AND AFC.CommcellId = AF.CommcellId
		AND AF.jobId = @i_jobId AND AF.CommcellId = @i_commCellId AND AF.isValid = 1 AND AFC.isValid = 1 AND AF.appId = @l_appId
		--Invalidate the archive file
		UPDATE	AF
		SET		isValid = -1
		FROM	ArchFile AF, @fileTypes FT
		WHERE	AF.jobid = @l_origJobId AND commCellId = @l_origJobCommCellId AND AF.appId = @l_appId AND AF.fileType = FT.fileType AND FT.invalidate = 1
		DECLARE COPYLISTCURSOR CURSOR FOR
		SELECT copyId FROM @l_processedCopies
		OPEN COPYLISTCURSOR
		FETCH NEXT FROM COPYLISTCURSOR INTO @l_processedSourceCopy
		WHILE(@@FETCH_STATUS = 0)
		BEGIN
    		EXEC ArchDestinationCopyList @l_processedSourceCopy
    		FETCH NEXT FROM COPYLISTCURSOR INTO @l_processedSourceCopy
		END
		CLOSE COPYLISTCURSOR
		DEALLOCATE COPYLISTCURSOR
		--Set the status as partial if the snap metadata is already copied to other copies, so that auxcopy will process the new archive file
   		UPDATE JMJobDataStats SET status = 103 /*PARTIALDATA*/, auxCopyStatus = 103 /*PARTIALDATA*/
   		FROM JMJobDataStats JDS WITH(NOLOCK) INNER JOIN (SELECT distinct CopyId FROM #archDestinationCopyListResultTable) T ON JDS.ArchGrpCopyId = T.copyId,
			@fileTypes FT
		WHERE JDS.jobId = @l_origJobId AND JDS.commcellId = @l_origJobCommCellId AND JDS.datatype = FT.fileType
AND JDS.disabled & 256 = 0 AND JDS.status = 100 /*READY*/ AND JDS.archGrpCopyId NOT IN (SELECT copyId FROM @l_processedCopies)
	END
	/*Update the jobIds from delayed catalog jobId to actual snap jobId if the archive files are valid*/
	IF  @l_origJobId > 0 AND @hasValidOrigJob = 1
	BEGIN
		UPDATE	archChunkMapping SET jobId = @l_origJobId, commCellId = @l_origJobCommCellId
		FROM	archChunkMapping ACM WITH (NOLOCK)
				INNER JOIN archFile AF WITH (NOLOCK) ON ACM.archFileId = AF.id and ACM.commCellId = AF.commCellId
								AND AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND (AF.isValid = 1 OR (@l_OpType = 112 /*DATA_ANALYTICS2*/)) AND AF.AppId = @l_AppId
		UPDATE	AF
		SET		jobId = @l_origJobId, commCellId = @l_origJobCommCellId
		FROM	archFile AF
		WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND (AF.isValid = 1 OR (@l_OpType = 112 /*DATA_ANALYTICS2*/)) AND AF.AppId = @l_AppId
	END
END
/*
If it is delayed catalog job, jump to NO_INSERT_EXIT if a job row exists with data type 6 (bcd index) only
else jump to NO_INSERT_EXIT without checking data type
*/
IF @l_MatJobId = 0 AND @l_origJobId = 0 AND EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK) WHERE jobId = @l_jobIdtoUseinDataStats AND commCellId = @l_commCellIdtoUseinDataStats )
   GOTO NO_INSERT_EXIT
 /*
 If delayed cataloging job and valid bcd index AFs were created then we use the actual snap jobId to pick up the archive files
 (as only in that case we would have updated the jobId above)
 if it is regular backup job or delayed catalog job that did not create valid archive files use the
 current job id
 If delayed cataloging job we are going to process only bcd index AFs
 */
 if (@hasValidOrigJob = 1 )
 BEGIN
	INSERT	INTO #tempArchFile
	SELECT	AF.id, AF.archGroupId, AF.appId, AF.fileType, AF.isValid, AF.flags
	FROM	archFile AF WITH (NOLOCK), @fileTypes FT
	WHERE	AF.jobId = @l_origJobId
			AND AF.commCellId = @l_origJobCommCellId
			AND AF.fileType = FT.fileType
 END
 ELSE
 BEGIN
	INSERT	INTO #tempArchFile
	SELECT	id, archGroupId, appId, fileType, isValid, flags
	FROM	archFile WITH (NOLOCK)
	WHERE	jobId = @i_jobId
			AND commCellId = @i_commCellId
END
IF	EXISTS (SELECT 1 FROM archGroupCopy AGC, (SELECT DISTINCT appId, archGroupId FROM #tempArchFile) T
			WHERE AGC.archGroupId = T.archGroupId AND AGC.siloAppId = T.appId)
	SET	@l_isSiloBackup = 1
IF NOT EXISTS (SELECT 1 FROM #tempArchFile)
BEGIN
	-- Add dummy entry for datamigrator. This will tell DataAging to not remove this successful job
	-- even if the job does not have any data.
	IF @i_jobState = 1 AND EXISTS (SELECT * FROM APP_iDATypeHandlingInfo WHERE appTypeId = @i_appType AND isDMAppType = 1)
	BEGIN
		INSERT INTO #tempDataStats
SELECT	AG.id, AG.defaultCopy, AG.defaultCopy, J.appId, 1, 2 /*NODATA*/, 0, 0, 0, 0, 0, 0 --J.flags @@TODO remove it
		FROM	JMBkpStats J WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId
			AND AG.id = J.dataArchGrpId
	   GOTO INSERT_EXIT
	END
	IF @i_jobState IN (4, 9) /*KILLED, DROPPED*/
	BEGIN
		SET	@l_nRows = 0
IF	@i_appType <> 1000
		BEGIN
			/*Failed jobs that did not create any valid AFs - use dataType 1(data AF) for regular jobs, dataType 6(bcd index AF) for delayed cataloging job*/
			INSERT INTO #tempDataStats
			SELECT	AG.id, AG.defaultCopy, AG.defaultCopy, J.appId,
CASE WHEN @l_origJobId > 0 THEN (SELECT ISNULL(MIN(fileType), 1)  FROM	@fileTypes)	ELSE 1 END,
					2 /*NODATA*/, 0, 0, 0, 0, 0, 0 --J.flags @@TODO Remove it
			FROM	JMBkpStats J WITH (NOLOCK), archGroup AG WITH (NOLOCK)
			WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId
				AND AG.id = J.dataArchGrpId AND J.status IN (4, 9)
				SET	@l_nRows = @@ROWCOUNT
		END
IF	@i_appType = 1000 OR @l_nRows = 0
		BEGIN
			INSERT INTO #tempDataStats
SELECT	AG.id, AG.defaultCopy, AG.defaultCopy, J.appId, 1, 2 /*NODATA*/, 0, 0, 0, 0, 0, 0
			FROM	JMAdminJobStatsTable J WITH (NOLOCK), archGroup AG WITH (NOLOCK)
			WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId
				AND AG.id = J.ArchGrpId AND J.status IN (4, 9) /*KILLED, DROPPED*/
				SET	@l_nRows = @@ROWCOUNT
		END
		GOTO INSERT_EXIT
	END
	GOTO NO_INSERT_EXIT
END
SELECT	TOP 1 @l_appId = appId FROM #tempArchFile
IF EXISTS (SELECT 1 FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @l_appId
					AND cs_attrName = CheckSum(N'DDB Backup CopyId') AND attrName = N'DDB Backup CopyId' AND Modified = 0
					AND attrVal > 0)
	SET @l_isDDBBackupToSec = 1
INSERT INTO #tempArchFileCopy
SELECT	B.archFileId, B.commCellId, B.archCopyId, AGC.isSnapCopy,
		A.archGroupId, (CASE WHEN @l_isSiloBackup <> 0 THEN B.archCopyId
		WHEN @l_isDDBBackupToSec > 0 THEN B.archCopyId
		WHEN AGC.isSnapCopy = 0 THEN AG.defaultCopy
		ELSE AG.defaultSnapCopy END
		),
		B.isValid, B.streamNum, B.physicalSize, B.encRSA, B.encKeyType, B.encKey, B.unCompSize
FROM   #tempArchFile as A, archFileCopy as B WITH (NOLOCK), archGroupCopy AGC WITH(NOLOCK), archGroup AG WITH (NOLOCK)
WHERE  A.archFileId = B.archFileId AND B.commCellId = @i_commCellId AND B.archCopyId = AGC.id AND AG.id = A.archGroupId
AND (@l_MatJobId = 0 OR AGC.isSnapCopy = 0) AND AGC.type <> 5
IF NOT EXISTS (SELECT * FROM #tempArchFile WHERE isValid = 1)
BEGIN
	SET		@onlyInvalidArchFilesExist 		= 1
	--For BACKUP data: All entries in archFile table are invalid.
	INSERT INTO #tempDataStats
	SELECT	A.archGroupId, B.archCopyId, 0, A.appId, A.fileType, 3, 0, 0, 0, 0, 0, 0
	FROM	#tempArchFile A, #tempArchFileCopy B
	WHERE	A.archFileId = B.archFileId
	GROUP BY A.archGroupId, B.archCopyId, A.appId, A.fileType
	--For a failed or killed job, size of backup is the total size of all (invalid) archive files.
	IF	EXISTS (SELECT * FROM #tempArchFileCopy WHERE isSnapCopy = 1)
		SELECT	@l_sizeOfBackup = SUM(physicalSize)
		FROM	#tempArchFileCopy
		WHERE	archCopyId = (SELECT TOP 1 archCopyId FROM #tempArchFileCopy WHERE isSnapCopy = 1)
	ELSE
		SELECT	@l_sizeOfBackup = SUM(physicalSize)
		FROM	#tempArchFileCopy
		WHERE	archCopyId = defaultCopy
	GOTO INSERT_EXIT
END
-- Verify job data stats for inline copies
IF	@l_isSiloBackup = 0
AND @l_isDDBBackupToSec = 0
AND EXISTS (SELECT * FROM #tempArchFileCopy WHERE archCopyId <> defaultCopy)
--AND NOT EXISTS (SELECT * FROM #tempArchFileCopy WHERE isSnapCopy = 1)
--AND @l_origJobId = 0 --Not required for deferred catalog job
BEGIN
	CREATE TABLE #tempCopy (archCopyId int, archGroupId int, defaultCopy int)
	CREATE TABLE #tempAFCopy (archFileId int, archCopyId int, copyFlags int, SIDBStoreId int)
	CREATE TABLE #tempAFC (
		archFileId int, commCellId int, archCopyId int, isSnapCopy int, archGroupId int, defaultCopy int,
		isValid int, streamNum int, physicalSize bigint,
encRSA int, encKeyType int, encKey varchar(1024), unCompSize bigint)
   -- Find then insert missing archFileCopy table entries for inline copies
   --Get non-default copies that has archive files of this job partially or fully copied
   INSERT INTO #tempCopy
   SELECT DISTINCT archCopyId, archGroupId, defaultCopy
   FROM   #tempArchFileCopy
   WHERE  archCopyId <> defaultCopy
	--Get archive files valid and available in default copy
   INSERT INTO #tempAFCopy
   SELECT A.archFileId, B.archCopyId, AGC.flags, ISNULL(SCD.SIDBStoreId, 0)
   FROM   #tempArchFileCopy A, #tempCopy B, ArchGroupCopy AGC WITH (READUNCOMMITTED)
			LEFT OUTER JOIN archSubclientCopyDDBMap SCD WITH (READUNCOMMITTED) ON SCD.appId = @l_appId AND SCD.copyId = AGC.id
   WHERE  A.archCopyId = B.defaultCopy AND A.isValid = 1 AND A.archGroupId = B.archGroupId
			AND B.archCopyId = AGC.id
   --Need not worry about archive file entries that already exist in the non-defaultcopies
   DELETE #tempAFCopy
   FROM   #tempAFCopy A, #tempArchFileCopy B
   WHERE  A.archFileId= B.archFileId AND A.archCopyId = B.archCopyId
   --Entries we are left with are archive files that are missing in non-default copies which had at least one archive file of the job
   IF EXISTS (SELECT * FROM #tempAFCopy)
   BEGIN
		INSERT INTO archFileCopy
		SELECT 	A.archFileId, @i_commCellId, A.archCopyId, 0, 0, B.streamNum, 0, 0, 0, 0, 0, 0, '', @i_modifiedTime, 0, 0, 0, -1
FROM   	#tempAFCopy A INNER JOIN #tempArchFileCopy B ON A.archFileId = B.archFileId AND B.archCopyId = B.defaultCopy AND A.copyFlags & 1024 = 1024
		IF EXISTS(SELECT 1 FROM #tempAFCopy WHERE SIDBStoreId > 0)
		BEGIN
			INSERT	INTO archFileCopyDedup(archFileId, commCellId, archCopyId, SIDBStoreId,
												primaryObjects, secondaryObjects, primaryObjSize, secondaryObjSize,
												primaryMetaDataSize, secondaryMetaDataSize, transDataSize, savedDataSize)
			SELECT  B.archFileId, B.CommCellId, A.archCopyId, A.SIDBStoreId,
					0, 0, 0, 0,
					0, 0, 0, 0
			FROM   	#tempAFCopy A, #tempArchFileCopy B
			WHERE	A.SIDBStoreId > 0
					AND A.archFileId = B.archFileId AND B.archCopyId = B.defaultCopy
AND A.copyFlags & 1024 = 1024
			INSERT INTO archFileSubStore(archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
			SELECT	T.archFileId, T.CommCellId, T.SIDBStoreId, T.SubStoreId, 0, 0
			FROM	(
						SELECT B.archFileId, B.CommCellid, A.SIDBStoreId, S.SubStoreId
						FROM #tempAFCopy A, #tempArchFileCopy B, IdxSIDBSubStore S
						WHERE A.SIDBStoreId > 0 AND A.SIDBStoreId = S.SIDBStoreId
								AND A.archFileId = B.archFileId AND B.archCopyId = B.defaultCopy
AND A.copyFlags & 1024 = 1024
					) AS T	LEFT OUTER JOIN archFileSubStore AFS
					ON T.archFileId = AFS.archFileId AND T.CommCellId = AFS.CommCellId AND T.SIDBStoreId = AFS.SIDBStoreId AND T.SubStoreId = AFS.SIDBSubStoreId
			WHERE	AFS.archFileId IS NULL
		END
      INSERT INTO #tempArchFileCopy
      SELECT A.archFileId, @i_commCellId, A.archCopyId, B.isSnapCopy,
      B.archGroupId, B.defaultCopy, 0, B.streamNum, 0, B.encRSA, B.encKeyType, B.encKey, 0
      FROM   #tempAFCopy A, #tempArchFileCopy B
      WHERE  A.archFileId= B.archFileId AND B.archCopyId = B.defaultCopy
   END
   -- Update isValid flag of archFileCopy table for inline copies
   INSERT INTO #tempAFC
   SELECT * FROM #tempArchFileCopy WHERE archCopyId <> defaultCopy AND isValid = 0
   IF EXISTS (SELECT * FROM #tempAFC)
   BEGIN
      UPDATE archFileCopy SET streamNum = C.StreamNum
      FROM   archFileCopy A INNER JOIN #tempAFC B ON A.archFileId = B.archFileId AND A.archCopyId = B.archCopyId
      INNER JOIN #tempArchFileCopy C ON B.ArchFileId = C.ArchFileId AND C.ArchCopyId = B.defaultCopy
      WHERE   A.commCellId = @i_commCellId AND A.streamNum = 0
      UPDATE #tempAFC SET isValid = 1
      FROM   #tempAFC A, #tempArchFileCopy B
      WHERE  A.archFileId = B.archFileId AND A.defaultCopy = B.archCopyId AND A.physicalSize >= B.physicalSize
		AND B.isValid = 1
      DELETE #tempAFC
      FROM   #tempAFC A, #tempArchFileCopy B
      WHERE  A.archFileId = B.archFileId AND A.archCopyId = B.archCopyId AND A.isValid = B.isValid
      UPDATE archFileCopy SET isValid = B.isValid
      FROM   archFileCopy A, #tempAFC B
      WHERE  A.archFileId = B.archFileId AND A.archCopyId = B.archCopyId AND A.commCellId = @i_commCellId
      UPDATE #tempArchFileCopy SET isValid = B.isValid
      FROM   #tempArchFileCopy A, #tempAFC B
      WHERE  A.archFileId = B.archFileId AND A.archCopyId = B.archCopyId
   END
   DROP TABLE #tempAFC
   DROP TABLE #tempCopy
   DROP TABLE #tempAFCopy
END
IF (EXISTS (SELECT	*
			FROM	#tempArchFile
WHERE	(flags & (524288)) > 0))
BEGIN
	UPDATE	AFC
	SET		isValid = 0
	FROM	#tempArchFile AF, #tempArchFileCopy AFC, archFileCopy DEST, archFileCopy SRC
	WHERE	AF.archFileId = AFC.archFileId
AND (AF.flags & (524288)) > 0
			AND AFC.archFileId = DEST.archFileId
			AND DEST.commCellId = @i_commCellId
			AND AFC.archCopyId = DEST.archCopyId
			AND DEST.archFileId = SRC.archFileId
			AND DEST.CommCellId = SRC.CommCellId
			AND SRC.archCopyId = AFC.DefaultCopy
			AND DEST.physicalSize < SRC.physicalSize
			AND DEST.isValid = 1
END
INSERT INTO #tempDataStats
SELECT	B.archGroupId, B.archCopyId, B.defaultCopy, A.appId, A.fileType, 100 /*READY*/,
		MIN(B.isValid), MAX(B.isValid), SUM(B.physicalSize),
		SUM(B.physicalSize - ISNULL(C.secondaryObjSize, 0) + ISNULL(C.secondaryMetaDataSize, 0) + ISNULL(C.primaryMetaDataSize, 0)), 0,
		(CASE WHEN MIN(B.unCompSize) = -1 THEN -1 ELSE SUM(B.unCompSize) END)
FROM	#tempArchFile A
		INNER JOIN #tempArchFileCopy B ON A.archFileId = B.archFileId AND A.isValid = 1
		LEFT OUTER JOIN archFileCopyDedup C ON C.archFileId = B.archFileId AND C.commCellId = @i_commCellId AND C.archCopyId = B.archCopyId
GROUP BY B.archGroupId, B.archCopyId, B.defaultCopy, A.appId, A.fileType
--For BACKUP data: All entries in archFileCopy table are invalid for a fileType.
INSERT INTO #tempDataStats
SELECT	B.archGroupId, B.archCopyId, B.defaultCopy, A.appId, A.fileType, 3,
MIN(CASE WHEN A.isValid = -1 THEN -1 ELSE B.isValid END), MAX(CASE WHEN A.isValid = -1 THEN -1 ELSE B.isValid END), SUM(B.physicalSize),
	SUM(B.physicalSize - ISNULL(C.secondaryObjSize, 0) + ISNULL(C.secondaryMetaDataSize, 0) + ISNULL(C.primaryMetaDataSize, 0)), 0,
	(CASE WHEN MIN(B.unCompSize) = -1 THEN -1 ELSE SUM(B.unCompSize) END)
FROM	#tempArchFile A inner join #tempArchFileCopy B
ON A.archFileId = B.archFileId
LEFT OUTER JOIN archFileCopyDedup C ON C.archFileId = B.archFileId AND C.commCellId = @i_commCellId AND C.archCopyId = B.archCopyId
LEFT OUTER JOIN #tempDataStats D
ON B.archCopyId = D.archCopyId AND A.fileType = D.fileType
WHERE D.archCopyId is null
GROUP BY B.archGroupId, B.archCopyId, B.defaultCopy, A.appId, A.fileType
HAVING (MAX(CASE WHEN A.isValid = -1 THEN -1 ELSE B.isValid END) < 1 AND SUM(B.physicalSize) > 0)
IF	EXISTS (SELECT * FROM #tempArchFileCopy WHERE isSnapCopy = 1)
AND EXISTS (SELECT * FROM JMBkpStats WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND (bkpAttributesEx & 0x800000 ) = 0)
	SELECT	@l_sizeOfBackup = SUM(physicalSize)
	FROM	#tempDataStats T
	WHERE	archCopyId = (SELECT TOP 1 archCopyId FROM #tempArchFileCopy WHERE isSnapCopy = 1)
ELSE
BEGIN
	SELECT	@l_sizeOfBackup = SUM(physicalSize)
	FROM	#tempDataStats
	WHERE	archCopyId = defaultCopy
END
--IF (@l_origJobId = 0) --Not required for deferred catalog job
BEGIN
	--For AUXCOPY data: No data were copied at all.
	UPDATE #tempDataStats SET status = 101 /*NODATACOPIED*/
	WHERE  minIsValid = 0 AND physicalSize = 0 AND archCopyId <> defaultCopy
	--For AUXCOPY data: All entries in archFileCopy table are invalid.
	UPDATE #tempDataStats SET status = 102 /*NODATAVALID*/
	WHERE  minIsValid = 0 AND maxIsValid = 0 AND physicalSize > 0 AND archCopyId <> defaultCopy
	--For AUXCOPY data: Part of archive files are valid.
	UPDATE #tempDataStats SET status = 103 /*PARTIALDATA*/
	WHERE  minIsValid = 0 AND maxIsValid = 1 AND physicalSize > 0 AND archCopyId <> defaultCopy
END
IF	EXISTS (SELECT id FROM APP_Application WHERE id = @l_appId AND (subclientStatus & 0x80000) <> 0)
BEGIN
	UPDATE	JMJobMiningStats
	SET		miningStatus = 1
	WHERE	miningJobId = @i_jobId AND miningCommCellId = @i_commCellId AND miningAppId = @l_appId
END
INSERT_EXIT:
IF	@i_jobState = 3
AND EXISTS (SELECT * FROM APP_iDAType WITH (NOLOCK) WHERE type = @i_appType AND isCWEjobValid = 0)
	SET @successJob = 0
-- if the job is oracle or oracle RAC and snap to tape job status is partially completed then set the job status as 102 in JMJobDataStats table
-- By doing this, job will not be considered for extended retention, aux copy etc
IF (@i_appType IN (22, 80) AND @i_jobState = 3 AND @l_MatJobId > 0)
BEGIN
	SET @l_disabled	= 1
	UPDATE #tempDataStats
	SET status = 102 /*NODATAVALID*/
END
--If V2 deferred catalog there can be entry existing already in which case we have to update the size columns based on recalculation done with the new archive file
IF EXISTS (SELECT 1 FROM JMJobDataStats WITH (NOLOCK), @fileTypes FT WHERE jobId = @l_origJobId AND commCellId = @l_origJobCommCellId AND dataType = FT.fileType AND @hasValidOrigJob > 0)
BEGIN
	UPDATE JDS
	SET sizeOnMedia = T.sizeOnMedia, copiedTime = @i_modifiedTime, modifiedTime = @i_modifiedTime, unCompSize = T.unCompSize,
		Status = (CASE WHEN ((@l_OpType = 112 /*DATA_ANALYTICS2*/) AND (T.archCopyId = T.defaultCopy)) THEN 100 /*READY*/
					   ELSE JDS.Status END),
disabled = (CASE WHEN ((@l_OpType = 112 /*DATA_ANALYTICS2*/) AND (T.archCopyId = T.defaultCopy)) THEN JDS.disabled & ~(1 + 256)
						ELSE JDS.disabled END)
	FROM #tempDataStats T
		INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDS.jobId = @l_origJobId AND JDS.commcellId = @l_origJobCommCellId
														AND T.archCopyId = JDS.ArchGrpCopyId AND T.fileType = JDS.dataType
		INNER JOIN @fileTypes FT ON JDS.dataType = FT.fileType
END
BEGIN
	/*If this is a delayed cataloging job that created valid bcd index AFs
	then @l_jobIdtoUseindATaStats would be actual snap jobId otherwise it would be the current job Id*/
	/*If it is DDB Backup job, then mark it as Do Not Copy*/
	INSERT INTO JMJobDataStats
SELECT	@l_jobIdtoUseinDataStats, T.archGroupId, T.archCopyId, T.fileType, CASE WHEN @l_MatJobId > 0 THEN 61 WHEN T.archCopyId <> T.defaultCopy AND AGC.flags &1024 = 0 AND @l_MatJobId = 0 THEN 13 ELSE 4 END,
(CASE WHEN @l_MatJobId > 0 THEN @l_MatJobId WHEN T.archCopyId <> T.defaultCopy AND AGC.flags &1024 = 0 AND @l_MatJobId = 0 THEN @l_jobIdtoUseinDataStats ELSE 0 END), T.status, 		-- SNAPTOTAPEWORKFLOW =61
(CASE ISNULL(TMP.retainUntil, 0) WHEN 0 THEN 0 ELSE 2 END) | (CASE WHEN @l_MatJobId > 0 THEN @l_disabled ELSE 0 END) | (CASE WHEN T.status IN (2 /*NODATA*/, 3 /*INVALIDDATA*/) THEN 1 ELSE 0 END),
			T.appId, @l_commCellIdtoUseinDataStats, 0, 0, CASE @successJob WHEN 0 THEN 0 ELSE ISNULL(J.retentionFlags, 0) END,
			ISNULL(TMP.retainUntil, 0), @i_modifiedTime, 0, 0, @i_modifiedTime, T.sizeOnMedia, 0, T.flags, @i_modifiedTime, T.status, T.unCompSize
	FROM	#tempDataStats T
			INNER JOIN  APP_Application A WITH (READUNCOMMITTED)
ON T.appId = A.id AND (@SkipTransactionalLogs = 0 OR T.fileType != 4 OR A.appTypeId != 81 OR T.archCopyId = T.defaultCopy)
			LEFT OUTER JOIN @tblJobCopyToRetain TMP
			ON TMP.jobId = @l_jobIdtoUseinDataStats
			AND	TMP.commCellId = @l_commCellIdtoUseinDataStats
			AND	TMP.archGroupId = T.archGroupId
			AND	TMP.archCopyId = T.archCopyId
			LEFT OUTER JOIN
				(SELECT	archGrpCopyId, retentionFlags
				FROM	JMJobCopyInfo WITH (NOLOCK)
				WHERE	jobId = @i_jobId AND commCellId = @i_commCellId) J
			ON	T.archCopyId = J.archGrpCopyId, archGroupCopy AGC WITH (NOLOCK)
	WHERE T.archCopyID = AGC.id
		AND	NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WHERE JDS.JobID = @l_jobIdtoUseinDataStats AND JDS.commCellId = @l_commCellIdtoUseinDataStats AND JDS.dataType = T.fileType AND JDS.archGrpCopyId = T.archCopyId)
END
/*
Currently both backup copy job and delayed catalog job uses this table JMJobSnapshotStats to determine
which jobs to be delayed cataloged or backup copied. This would work with the current design to support only one of those 2 operations
on a storage policy - So update the materializationStatus here if the snap job is successfully cataloged.
This approach has to be modified in the future when we support both the operations.
*/
IF  @l_origJobId > 0 AND @hasValidOrigJob = 1 AND @l_OpType = 96 /*DELAYEDCATALOG*/
	UPDATE JMJobSnapDeferredCatalogStats SET catalogStatus = 100/*enum CVCopyDataState{ READY = 100}*/, catalogJobId = @i_jobId
	WHERE jobId =  @l_origJobId AND commcellId = @l_origJobCommCellId
	AND EXISTS (
	SELECT 1 FROM JMJobDataStats WITH (NOLOCK) WHERE jobId = @l_origJobId AND commcellId = @l_origJobCommCellId
AND dataType = 6 AND status = 100 /*enum CVCopyDataState{ READY = 100}*/
	)
--If log only part on a storage policy copy, then do not set extended retention flags
UPDATE JMJobDataStats
SET retentionFlags = 0
FROM (SELECT J.archGrpCopyId, MIN(J.dataType) AS dataType
			FROM 	 JMJobDataStats J
			WHERE  J.JobId = @i_jobId
			AND		 J.CommCellId = @i_commCellId
			GROUP  BY J.archGrpCopyId) T
WHERE JMJobDataStats.jobId = @i_jobId
AND  	JMJobDataStats.commCellId = @i_commCellId
AND		JMJobDataStats.archGrpCopyId = T.archGrpCopyId
AND		T.dataType != 1
AND 	JMJobDataStats.retentionFlags > 0
--For a succeeded job, size of backup is the total size of all valid archive files.
IF	ISNULL(@l_sizeOfBackup, 0) > 0 AND @l_MatJobId = 0
BEGIN
	SET	@l_nRows = 0
IF	@i_appType <> 1000
	BEGIN
		/*If delayed cataloging job we have to update the totalBackupSize for both snap job and delayed cataloging job*/
		UPDATE JMBkpStats SET totalBackupSize = @l_sizeOfBackup
		WHERE  jobId = @i_jobId
		AND commCellId = @i_commCellId AND status IN (1, 3, 14) /*JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
		SET	@l_nRows = @@ROWCOUNT
		--Do not update totalBackupSize of snap job after deferred catalog if snap job is already backup copied and has updated the totalBackupSize
		IF (@l_origJobId > 0) AND (@onlyInvalidArchFilesExist = 0) AND (@l_OpType = 96 /*DELAYEDCATALOG*/)
		BEGIN
			IF NOT EXISTS (	SELECT 1
											FROM JMJobSnapShotStats WITH (NOLOCK)
											WHERE jobId = @l_origJobId
											AND commCellId = @l_origJobCommCellId
											AND materializationStatus = 100 /*READY*/)
			BEGIN
				UPDATE JMBkpStats SET totalBackupSize = @l_sizeOfBackup
				WHERE  jobId = @l_origJobId
				AND commCellId = @l_origJobCommCellId AND status IN (1, 3, 14) /*JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
				SET @l_nRows = @l_nRows + @@ROWCOUNT
			END
		END
		ELSE IF (@l_origJobId > 0) AND (@onlyInvalidArchFilesExist = 0)
		BEGIN
			UPDATE	JMBkpStats
			SET		totalBackupSize = @l_sizeOfBackup
			WHERE	jobId = @l_origJobId
			AND		commCellId = @l_origJobCommCellId AND status IN (1, 3, 14) /*JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
			SET @l_nRows = @l_nRows + @@ROWCOUNT
		END
	END
IF	@i_appType = 1000 OR @l_nRows = 0
		UPDATE JMAdminJobStatsTable SET totalBackupSize = @l_sizeOfBackup
		WHERE  jobId = @i_jobId AND commCellId = @i_commCellId
			AND status IN (1, 3, 14) /*JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/ AND opType IN (11, 64) /*CSDRBKP, INFOMGMT*/
END
NO_INSERT_EXIT:
IF OBJECT_ID('tempdb..#tempArchFile') IS NOT NULL DROP TABLE #tempArchFile
IF OBJECT_ID('tempdb..#tempArchFileCopy') IS NOT NULL DROP TABLE #tempArchFileCopy
IF OBJECT_ID('tempdb..#tempDataStats') IS NOT NULL DROP TABLE #tempDataStats
IF OBJECT_ID('tempdb..#archDestinationCopyListResultTable') IS NOT NULL DROP TABLE #archDestinationCopyListResultTable
IF OBJECT_ID('tempdb..#archJobDataStatsCreateResultTable') IS NOT NULL
BEGIN
	INSERT INTO #archJobDataStatsCreateResultTable
	SELECT @retVal
END
ELSE
BEGIN
	SELECT @retVal
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archJobDataStatsCreate')
	delete from GxQscripts where name = 'archJobDataStatsCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobDataStatsCreate')
	delete from GXDBVersions where aliasname = 'archJobDataStatsCreate'
GO

insert into GXDBVersions values(2, 'archJobDataStatsCreate',  '00010054001200370000', 'archJobDataStatsCreate', '00010054001200370000')
GO

