

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archJobCopyStatsUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archJobCopyStatsUpdate.sp,v $ $Id: archJobCopyStatsUpdate.sp,v 1.35.12.29.4.1 2021/03/28 03:57:05 kjaiswal Exp $";
--
--  +========================================================================+
--  | Stored Precedure: archJobCopyStatsUpdate
--  |
--  | Description:
--  |  Mark status = 100 for fully copied jobs in JMJobDataStats table.
--  |  Mark status = 103 for partially copied jobs in JMJobDataStats table.
--  |  Mark status = 102 for jobs that has chunks but has no valid archive file.
--  |  Mark status = 1000 for fully copied refresh magnetic jobs in JMJobDataStats table.
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jun Lu   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archJobCopyStatsUpdate')
BEGIN
	print '>>> Drop Stored Procedure: archJobCopyStatsUpdate <<<'
	drop procedure archJobCopyStatsUpdate
END
IF EXISTS (select * from GxQscripts where name='archJobCopyStatsUpdate')
	delete from GxQscripts where name = 'archJobCopyStatsUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobCopyStatsUpdate')
	delete from GXDBVersions where aliasname = 'archJobCopyStatsUpdate'
GO
print '... Creating Procedure: archJobCopyStatsUpdate'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archJobCopyStatsUpdate
  @i_commCellId integer,
  @i_archGroupId integer,
  @i_copyId integer,
  @i_sourceCopyId integer,
  @i_auxCopyJobId integer,
  @i_now integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @retVal INTEGER
SET @retVal = 0
DECLARE @updateArchCheckStatus INTEGER = 0
DECLARE @tempInpTablePrepopulated BIT = 0
DECLARE @xmlJobsList XML = NULL
DECLARE @it_auxCopyJobId INTEGER = 0
DECLARE @it_copyId INTEGER = 0
DECLARE @prev_auxCopyJobId INTEGER = 0
IF object_id('tempdb.dbo.#tblInputCopiesAndJobs') IS null-- DROP TABLE #tblInputCopiesAndJobs
BEGIN
	CREATE TABLE #tblInputCopiesAndJobs(commCellId  integer, archGroupId integer,copyId integer, sourceCopyId integer, auxCopyJobId integer, copyFlags integer, copyType integer, isSnapCopy integer, isMagRefresh integer)
	INSERT INTO #tblInputCopiesAndJobs
	SELECT @i_commCellId, @i_archGroupId, @i_copyId, @i_sourceCopyId, @i_auxCopyJobId, AGC.flags, AGC.type, AGC.isSnapCopy, 0
	FROM	ArchGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE AGC.id = @i_copyId
	SET @tempInpTablePrepopulated = 0
END
ELSE
	SET @tempInpTablePrepopulated = 1
IF object_id('tempdb.dbo.#SnapArchFiles') IS NOT null DROP TABLE #SnapArchFiles
IF object_id('tempdb.dbo.#tblJDS') IS NOT null DROP TABLE #tblJDS
IF object_id('tempdb.dbo.#tblAFC') IS NOT null DROP TABLE #tblAFC
IF object_id('tempdb.dbo.#tblJobAggr') IS NOT null DROP TABLE #tblJobAggr
IF object_id('tempdb.dbo.#tblJDSTemp') IS NOT null DROP TABLE #tblJDSTemp
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
CREATE TABLE #tempJobsToProcess (archCopyId INTEGER, jobId INTEGER, commCellId INTEGER PRIMARY KEY(archCopyId, jobId, CommCellId))
CREATE TABLE #SnapArchFiles (archFileId int, commCellId int, JobId int, SnapShotEngineId int, copyId int,srcCopyId int PRIMARY KEY(JobId, CommCellId, archFileId, copyId) )
DELETE #tblInputCopiesAndJobs
WHERE copyId = sourceCopyId
IF NOT EXISTS(SELECT 1 FROM #tblInputCopiesAndJobs)
	GOTO CX_EXIT
CREATE TABLE #tblJDS(jobId int, dataType int, commCellId int, status int, archCheckStatus int, flag int, sizeOnMedia bigint, AuxCopyEncrypted int, AppId int, copyID INT, unCompSize bigint PRIMARY KEY (jobId, commCellId, copyID, dataType))
CREATE TABLE #tblJDSTemp(jobId int, dataType int, commCellId int, status int, archCheckStatus int, flag int, sizeOnMedia bigint, AuxCopyEncrypted int, AppId int, copyID INT, unCompSize bigint, maxLastCN INT, maxSnapFlag INT, maxIsValid INT  PRIMARY KEY (jobId,copyID,  commCellId,  dataType))
CREATE TABLE #tblAFC(archFileId int, dataType int, jobId int, commCellId int, isValid int, sizeOnMedia bigint, flags int, PhysicalSize bigint, unCompSize bigint, afFlags int, copyID int,
	PRIMARY KEY (archFileId, commCellId, copyID))
CREATE TABLE #tblJobAggr(jobId int, dataType int, commCellId int, copyID INT, minV int, maxV int, size bigint, AuxCopyEncrypted int, unCompSize bigint,
	PRIMARY KEY (jobId, commCellId, dataType, copyID))
UPDATE #tblInputCopiesAndJobs
SET isMagRefresh = 1
FROM #tblInputCopiesAndJobs t, JMJobDataStats jds WITH (READUNCOMMITTED)
WHERE t.copyId = jds.archGrpCopyId AND jds.opType = 74 AND jds.status = 101 AND disabled & 1 = 0
DELETE #tblInputCopiesAndJobs
WHERE isMagRefresh <> 1 AND copyType = 5
IF NOT EXISTS(SELECT 1 FROM #tblInputCopiesAndJobs)
	GOTO CX_EXIT
IF EXISTS (SELECT 1 FROM sys.sysprocesses WHERE program_name = 'JobMgr.exe' AND spid = @@SPID)
BEGIN
	-- We are going with a cursor to avoid too many rows from JMJobDataStats being joined and avoid too many intermediate rows from nested subqueries when fetching jobs in the current batch for each auxCopy job.
	DECLARE AuxCopyCursor CURSOR
	FOR SELECT auxCopyJobId, copyID FROM #tblInputCopiesAndJobs ORDER BY auxCopyJobId
	OPEN AuxCopyCursor
	FETCH FROM AuxCopyCursor INTO @it_auxCopyJobId, @it_copyId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS (SELECT 1 FROM JMAdminJobInfoTable WITH (READUNCOMMITTED) WHERE jobID = @it_auxCopyJobId AND optype = 104)
		BEGIN
			IF @prev_auxCopyjobId = 0 OR @prev_auxCopyJobId <> @it_auxCopyjobId
			BEGIN
				SET @xmlJobsList = NULL
				TRUNCATE TABLE #tempJobsToProcess
				SELECT  @xmlJobsList = CAST(attributeValue AS XML)
				FROM    JMJobOptions WITH (READUNCOMMITTED)
				WHERE   jobId = @it_auxCopyJobId
						AND CommCellId = 2
AND attributeId = 70
						AND LEN(attributeValue) > 0
				IF (@xmlJobsList IS NOT NULL)
				BEGIN
					INSERT INTO #tempJobsToProcess
					SELECT  Jobs.Node.value('@cp', 'INTEGER') archCopyIdId,
							Jobs.Node.value('@j', 'INTEGER') jobId,
							Jobs.Node.value('@c', 'INTEGER') CommCellId
					FROM    @xmlJobsList.nodes('//JobIds/I') Jobs(Node)
				END
			END
			IF (@xmlJobsList IS NOT NULL) AND EXISTS (SELECT 1 FROM #tempJobsToProcess WHERE archCopyId = @it_copyId)
			BEGIN
				INSERT INTO #tblJDS
				SELECT jds.jobId, jds.dataType, jds.commCellId, jds.status, jds.archCheckStatus, 0, CASE WHEN jds.status  IN (102,103) THEN sizeOnMedia ELSE 0 END, 0,  jds.AppId, JDS.archGrpCopyId, -1
				FROM   JMJobDataStats jds WITH (NOLOCK) INNER JOIN #tempJobsToProcess t ON t.jobId = jds.jobId AND t.commCellId = jds.commcellId AND jds.archGrpCopyId = t.archCopyId
WHERE   JDS.archGrpCopyId = @it_copyId AND status IN (101, 102, 103) AND (disabled & (256| 1)) = 0
			END
			ELSE -- we are in last batch or batching was not enabled at all, either ways we are limiting the number of jobs per batch
			BEGIN
DECLARE @l_totalJobsToProcess INTEGER = ISNULL(dbo.GetOptionInt(1654993746, @it_auxCopyJobId, 0, 0), 1000)
				IF @l_totalJobsToProcess = 0
						SET @l_totalJobsToProcess  = 10000
				INSERT INTO #tblJDS
				SELECT TOP (@l_totalJobsToProcess*3) jds.jobId, jds.dataType, jds.commCellId, jds.status, jds.archCheckStatus, 0, CASE WHEN jds.status  IN (102,103) THEN sizeOnMedia ELSE 0 END, 0,  jds.AppId, JDS.archGrpCopyId, -1
				FROM   JMJobDataStats jds WITH (NOLOCK)
WHERE   JDS.archGrpCopyId = @it_copyId AND status IN (101, 102, 103) AND (disabled & (256| 1)) = 0
			END
		END
		ELSE -- old AuxCopyMgr doesn't process jobs in batches howevver we are making an assumption that it would never process more than 10,000 jobs within an hour
		BEGIN
				INSERT INTO #tblJDS
				SELECT TOP (10000) jds.jobId, jds.dataType, jds.commCellId, jds.status, jds.archCheckStatus, 0, CASE WHEN jds.status  IN (102,103) THEN sizeOnMedia ELSE 0 END, 0,  jds.AppId, JDS.archGrpCopyId, -1
				FROM   JMJobDataStats jds WITH (NOLOCK)
WHERE   JDS.archGrpCopyId = @it_copyId AND status IN (101, 102, 103) AND (disabled & (256| 1)) = 0
		END
		SET @prev_auxCopyJobId = @it_auxCopyJobId
	   FETCH FROM AuxCopyCursor INTO @it_auxCopyJobId, @it_copyId
	END
	CLOSE AuxCopyCursor
	DEALLOCATE AuxCopyCursor
END
ELSE
BEGIN
	INSERT INTO #tblJDS
	SELECT jds.jobId, jds.dataType, jds.commCellId, MIN(jds.status), MIN(jds.archCheckStatus), 0, CASE WHEN MIN(jds.status ) IN (102,103) THEN MIN(sizeOnMedia) ELSE 0 END, 0,  MIN(jds.AppId), jds.archGrpCopyId, -1
	FROM   JMJobDataStats jds WITH (NOLOCK) INNER JOIN #tblInputCopiesAndJobs t ON jds.archGrpCopyId = t.copyId INNER JOIN archFile AF  WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobId AND AF.commCellId = JDS.commCellId AND AF.fileType = JDS.dataType INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = JDS.archGrpCopyId
WHERE   status IN (101, 102, 103) AND (disabled & (256| 1)) = 0
AND (AFC.lastChunkNumber > 0 OR (AF.flags & 2) > 0 OR AFC.isValid = 1)
	GROUP BY jds.jobId, jds.dataType, jds.commCellId, jds.archGrpCopyId
END
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
INSERT INTO #tblAFC
SELECT	AF.id, AF.fileType, J.jobId, J.commCellId, 0, 0, 0, 0, 0, AF.flags, t.copyID
FROM	archFile AF WITH (NOLOCK), #tblJDS J, #tblInputCopiesAndJobs t
WHERE	AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.fileType = J.dataType AND j.copyID = t.copyId
	AND AF.archGroupId = t.archGroupId AND AF.isValid = 1
AND ((t.isSnapCopy = 1 AND (AF.fileType IN (6, 7) OR (AF.flags &  (2|4194304)) = 2))
OR (t.isSnapCopy = 0 AND AF.fileType <> 6 AND ((AF.flags & 2) = 0 OR ((AF.flags & (2|4194304)) = (2|4194304)))))
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
-- Different CVA_DATATYPE_COMPONENT_INDEX archive files can be in both snap and classic copies and can not be distinguished by ArchFile.flags.
DELETE	#tblAFC
FROM	#tblAFC T INNER JOIN #tblInputCopiesAndJobs copies ON copies.copyId = T.copyId LEFT OUTER JOIN archFileCopy AFC WITH (NOLOCK)
	ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = copies.sourceCopyId
WHERE	T.dataType = 7 AND AFC.archFileId IS NULL
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
IF EXISTS (	SELECT	1
			FROM	MMDataPath DP WITH (READUNCOMMITTED), MMDrivePool P WITH (READUNCOMMITTED), APP_Client C WITH (READUNCOMMITTED), #tblInputCopiesAndJobs t
			WHERE	DP.CopyId = t.copyId
				AND	DP.DrivePoolId = P.DrivePoolId
				AND p.ClientId =  C.id
				AND C.releaseId < 16)
BEGIN
	UPDATE	AFC
	SET		PhysicalSize = A.PhysicalSize, unCompSize = A.unCompSize
	FROM	#tblAFC AFC,
			(SELECT	ACM.archFileId, ACM.commCellId, copies.copyId, SUM(ACM.physicalSize) PhysicalSize, SUM(ACM.unCompSize) unCompSize
			FROM	archChunkMapping ACM WITH (NOLOCK), #tblAFC T, #tblInputCopiesAndJobs copies
			WHERE	ACM.archFileId = T.archFileId
					AND ACM.commCellId = T.commCellId
					AND copies.copyId = t.copyId
					AND ACM.archCopyId = copies.sourceCopyId
			GROUP BY ACM.archFileId, ACM.commCellId, copies.copyId) A
	WHERE	AFC.archFileId = A.archFileId
			AND AFC.commCellId = A.commCellId
			AND A.copyId = AFC.copyId
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
	UPDATE	ACM
	SET		unCompSize = (CASE WHEN T.physicalSize > 0 THEN (ACM.physicalSize*1.0/T.physicalSize) * T.unCompSize ELSE ACM.physicalSize END)
	FROM	archChunkMapping ACM, #tblAFC T, archFileCopy AFC WITH (NOLOCK)
	WHERE	ACM.archFileId = T.archFileId
			AND ACM.commCellId = T.commCellId
			AND ACM.archCopyId = T.copyId
			AND ACM.chunkNumber > 0
			AND ACM.unCompSize = -1
			AND ACM.archCopyId = AFC.archCopyId
			AND ACM.archFileId = AFC.archFileId
			AND ACM.commCellId = AFC.commCellId
			AND AFC.isValid = 1
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
	UPDATE	AFC
	SET		unCompSize = T.unCompSize
	FROM	archFileCopy AFC, #tblAFC T
	WHERE	AFC.archFileId = T.archFileId
			AND AFC.commCellId = T.commCellId
			AND AFC.archCopyId = T.copyId
			AND AFC.unCompSize = -1
			AND AFC.isValid = 1
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
END
IF (EXISTS (SELECT	1
			FROM	#tblAFC AF
-- WHERE	(AF.afFlags & (32768|2097152)) > 0
			))
BEGIN
	-- Mark fully copied archFiles valid status as 1 for none snap archive files
	UPDATE	AFCD
	SET		isValid = 1
	FROM	#tblAFC AF, archFileCopy AFCD, archFileCopy AFCS WITH (READUNCOMMITTED),  #tblInputCopiesAndJobs copies
	WHERE	AF.archFileId = AFCD.archFileId
			AND AF.commCellId = AFCD.commCellId
-- AND (AF.afFlags & (32768|2097152)) > 0
AND AF.afFlags & 2 = 0
			AND AFCD.isValid = 0
			AND	AF.archFileId = AFCS.archFileId
			AND AF.commCellId = AFCS.commCellId
			AND AFCS.isValid = 1
			AND AFCS.physicalSize = AFCD.physicalSize
			AND AFCS.logicalSize = AFCD.logicalSize
			AND AFCS.archCopyId = copies.sourceCopyId
			AND AFCD.archCopyId = copies.copyId
			AND (AFCS.physicalSize > 0 OR AFCS.logicalSize > 0)
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
END
BEGIN
	--Populate #SnapArchFiles
	INSERT INTO #SnapArchFiles
	SELECT	AFC.archFileId, AFC.CommCellId, AF.JobId, MAX(S.SnapShotEngineId), AFC.archCopyId, MAX(copies.sourceCopyId)
	FROM	#tblInputCopiesAndJobs copies
					INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED)  ON AFC.archCopyId = copies.copyId
					INNER JOIN SMVolume SrcV WITH (READUNCOMMITTED) ON AFC.archFileId = SrcV.ArchFileId AND AFC.commCellId = SrcV.CommCellId AND SrcV.CopyId = copies.sourceCopyId
					INNER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED) ON VS.SMVolumeId = SrcV.SMVolumeId
					INNER JOIN SMSnap S WITH (READUNCOMMITTED) ON S.SMSnapId = VS.SMSnapId
					LEFT OUTER JOIN SMVolume SMV WITH (READUNCOMMITTED) ON AFC.archFileId = SMV.ArchFileId AND AFC.commCellId = SMV.CommCellId AND AFC.archCopyId = SMV.CopyId INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AFC.archFileId = AF.Id AND AFC.CommCellId = AF.CommCellId
	WHERE	AFC.isValid = 0
AND (AF.Flags & 2) = 2
AND (((copies.isSnapCopy = 0) AND S.SnapShotEngineId = 53) OR (S.SnapShotEngineId = 48))
			AND SMV.ArchFileId IS NULL
	GROUP BY AFC.archFileId, AFC.CommCellId, AF.JobId, AFC.archCopyId
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
	DELETE  SAF
	FROM	#tblInputCopiesAndJobs copies INNER JOIN #SnapArchFiles SAF ON SAF.copyId = copies.copyId INNER JOIN archFile AF WITH (READUNCOMMITTED) ON SAF.archFileId = AF.id
			AND SAF.CommCellId = AF.CommCellId
			AND SAF.JobId = AF.JobId LEFT OUTER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId AND AFC.archCopyId = SAF.copyId
	WHERE	AFC.isValid = 0
AND (AF.Flags & 2) = 0
AND ((copies.isSnapCopy = 0) AND SAF.SnapShotEngineId = 53)
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
	-- Mark the Child archFile as copied when parent is copied for VSA App aware
	/*
	DELETE  SAF
	FROM	#SnapArchFiles SAF,
			JMVSAAppJobLink JC LEFT OUTER JOIN JMJobDataStats JDS
				ON JC.parentJobId = JDS.JobId	AND JC.commCellId = JDS.CommCellId AND JDS.archGrpCopyId = @i_copyId AND JDS.dataType = 1 AND JDS.Status = 100
	WHERE	SAF.CommCellId = JC.CommCellId
			AND SAF.JobId = JC.childJobId
			AND JDS.JobId IS NULL
	*/
	DELETE  SAF
	FROM	#SnapArchFiles SAF INNER JOIN
			JMVSAAppJobLink JC WITH (READUNCOMMITTED) ON SAF.CommCellId = JC.CommCellId
			AND SAF.JobId = JC.childJobId INNER JOIN archFile AF WITH (READUNCOMMITTED) ON JC.parentJobId = AF.JobId
			AND JC.commCellId = AF.CommCellId LEFT OUTER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId AND AFC.archCopyId = SAF.copyId
	WHERE	AFC.isValid = 0
AND (SAF.SnapShotEngineId = 48)
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
	IF (EXISTS (SELECT 1 FROM #SnapArchFiles))
	BEGIN
		BEGIN TRAN POPULATE_SNAP_INFO
		EXEC @retVal = MM_SMPopulateSnapInfo 1, 1
		IF (@retVal = 0)
		BEGIN
			UPDATE	AFC
			SET		isValid = 1
			FROM	archFileCopy AFC, #SnapArchFiles SAF
			WHERE	AFC.archFileId = SAF.archFileId
					AND AFC.CommCellId = SAF.CommCellId
					AND AFC.archCopyId = SAF.copyId
					AND AFC.isValid = 0
			SET @retVal = @@ERROR
			IF	@retVal <> 0
			BEGIN
				ROLLBACK TRAN	POPULATE_SNAP_INFO
				GOTO CX_EXIT
			END
			DELETE FROM SAF
			FROM	archVSAAppAFLink L WITH (READUNCOMMITTED), #SnapArchFiles SAF
			WHERE	L.childAFID = SAF.archFileId
					AND L.CommCellId = SAF.CommCellId
					AND L.copyId = SAF.copyId
			SET @retVal = @@ERROR
			IF	@retVal <> 0
			BEGIN
				ROLLBACK TRAN	POPULATE_SNAP_INFO
				GOTO CX_EXIT
			END
			INSERT INTO archVSAAppAFLink (ParentIndexAFId, childAFId, commCellId, flags, VMGUID, mountVMGUID, copyId)
			SELECT	L.ParentIndexAFId, L.childAFId, L.commCellId, L.flags, L.VMGUID, NULL, SAF.copyId
			FROM	archVSAAppAFLink L WITH (READUNCOMMITTED), #SnapArchFiles SAF
			WHERE	L.childAFID = SAF.archFileId
					AND L.CommCellId = SAF.CommCellId
					AND L.copyId = SAF.srcCopyId
			SET @retVal = @@ERROR
			IF	@retVal <> 0
			BEGIN
				ROLLBACK TRAN	POPULATE_SNAP_INFO
				GOTO CX_EXIT
			END
			COMMIT TRAN POPULATE_SNAP_INFO
		END
		ELSE
		BEGIN
			ROLLBACK TRAN	POPULATE_SNAP_INFO
			GOTO CX_EXIT
		END
	END
END
UPDATE	T
SET		isValid = AFC.isValid, sizeOnMedia = AFC.physicalSize, flags = AFC.flags, unCompSize = AFC.unCompSize
FROM	archFileCopy AFC WITH (NOLOCK), #tblAFC T
WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = T.copyId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
IF (EXISTS (SELECT	1
			FROM	#tblAFC AF
WHERE	(AF.afFlags & (524288)) > 0
			))
BEGIN
	-- Mark partially copied archFiles valid status as 0 for reused archive files
	UPDATE	#tblAFC
	SET		isValid = 0
	FROM	#tblAFC AF, archFileCopy AFCD WITH (READUNCOMMITTED), archFileCopy AFCS WITH (READUNCOMMITTED), #tblInputCopiesAndJobs t
	WHERE	AF.archFileId = AFCD.archFileId
			AND AF.commCellId = AFCD.commCellId
AND (AF.afFlags & (524288)) > 0
AND AF.afFlags & 2 = 0
			AND AFCD.isValid = 1
			AND	AF.archFileId = AFCS.archFileId
			AND AF.commCellId = AFCS.commCellId
			AND AFCS.isValid = 1
			AND AFCS.physicalSize > AFCD.physicalSize
			AND AFCS.logicalSize > AFCD.logicalSize
			AND t.copyId = AF.copyId
			AND AFCS.archCopyId = t.sourceCopyId
			AND AFCD.archCopyId = t.copyId
			AND (AFCS.physicalSize > 0 OR AFCS.logicalSize > 0)
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
END
UPDATE	#tblAFC
SET		sizeOnMedia = (T.sizeOnMedia - ISNULL(A.secondaryObjSize, 0) + ISNULL(A.secondaryMetaDataSize, 0) + ISNULL(A.primaryMetaDataSize, 0))
FROM	archFileCopyDedup A WITH (NOLOCK), #tblAFC T
WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.copyId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
-- Only count archive files existing on the source copy. Zero-byte archFileCopy entries can be deleted by pruning invalid chunks.
INSERT INTO #tblJobAggr
SELECT	jobId, dataType, commCellId, copyId, MIN(isValid), MAX(isValid), SUM(sizeOnMedia), MAX(flags & 1024),
		(CASE WHEN MIN(unCompSize) = -1 THEN -1 ELSE SUM(unCompSize) END)
FROM	#tblAFC T
GROUP BY jobId, dataType, commCellId, copyId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
DELETE	#tblJobAggr
FROM	#tblJobAggr A, JMJobDataStats B WITH (NOLOCK), #tblInputCopiesAndJobs t
WHERE	B.jobId = A.jobId AND B.dataType = A.dataType AND B.commCellId = A.commCellId AND B.archGrpCopyId = t.sourceCopyId AND A.copyId = t.copyId
	AND B.status IN (101, 102, 103)
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
--Mark fully copied jobs as READY (=100)
UPDATE	#tblJDS SET status = CASE WHEN C.isMagRefresh = 1 THEN 1000 ELSE 100 END, flag = 1, sizeOnMedia = B.size,
AuxCopyEncrypted = (case when B.AuxCopyEncrypted > 0 then 128 else 0 end), unCompSize = B.unCompSize
FROM	#tblJDS A, #tblJobAggr B, #tblInputCopiesAndJobs C
WHERE	A.jobId = B.jobId AND A.dataType = B.dataType AND A.commCellId = B.commCellId AND minV > 0 AND A.copyId = B.copyId
		AND C.copyId = A.copyId
IF @@ROWCOUNT > 0
	SET @updateArchCheckStatus = 1
IF EXISTS (SELECT TOP 1 * FROM APP_Application A WITH (NOLOCK), #tblJDS T WHERE A.id = T.appId and (A.subclientStatus & 0x20000) = 0x20000 )
BEGIN
	--Mark fully copied jobs as READY (=100) if there is no archive file associated with job
	UPDATE	#tblJDS SET status = 100, flag = 1
FROM	#tblJDS A INNER JOIN #tblInputCopiesAndJobs T ON T.copyId = A.copyId INNER JOIN APP_Application App WITH (NOLOCK) ON App.id = A.appId and (App.subclientStatus & 0x20000) = 0x20000
				LEFT OUTER JOIN ArchFile AF WITH (READUNCOMMITTED)
				ON	A.jobId = AF.jobId AND A.commCellId = AF.commCellId AND AF.appId = A.appId
					AND A.dataType = AF.fileType AND AF.isValid = 1
					AND AF.archGroupId = T.archGroupId
	WHERE	AF.id IS NULL
	IF @@ROWCOUNT > 0
		SET @updateArchCheckStatus = 1
END
IF	@updateArchCheckStatus > 0
BEGIN
	UPDATE	#tblJDS SET archCheckStatus = 3 /*ACS_TOBECHECKED */
	FROM #tblJDS j, #tblInputCopiesAndJobs c
	WHERE	status = 100 AND flag = 1
AND c.copyID = j.copyId AND c.copyFlags & 128 <> 0
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
	UPDATE	#tblJDS SET archCheckStatus = 3 /*ACS_TOBECHECKED */
	FROM	#tblJDS a, JMBkpStats b WITH (NOLOCK) , #tblInputCopiesAndJobs c
	WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
		AND a.status = 100 AND a.flag = 1 AND b.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
AND c.copyID = a.copyId AND c.copyFlags & 256 <> 0
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT
END
--Mark jobs that has at least one valid archive file as PARTIALDATA (=103)
UPDATE	#tblJDS SET status = 103, flag = 1, sizeOnMedia = B.size, unCompSize = B.unCompSize
FROM	#tblJDS A, #tblJobAggr B
WHERE	A.jobId = B.jobId AND A.dataType = B.dataType AND A.commCellId = B.commCellId AND maxV > 0 AND (A.status IN (101, 102) OR ( A.status = 103 AND A.SizeOnMedia != B.Size)) AND A.copyId = B.copyId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO CX_EXIT
--Mark jobs that has chunks but has not valid archive file as NODATAVALID (=102)
UPDATE	#tblJDS SET status = 102, flag = 1, sizeOnMedia = B.size, unCompSize = B.unCompSize
FROM	#tblJDS A, #tblJobAggr B
WHERE	A.jobId = B.jobId AND A.dataType = B.dataType AND A.commCellId = B.commCellId AND size > 0 AND ( A.status = 101 OR (A.status = 102 AND A.SizeOnMedia != B.Size)) AND A.copyId = B.copyId
SET @retVal = @@ERROR
IF	@retVal <> 0
	GOTO CX_EXIT
DELETE  #tblJDS WHERE flag = 0
DELETE #tblInputCopiesAndJobs
WHERE NOT EXISTS (SELECT 1 FROM #tblJDS B WHERE B.copyID = #tblInputCopiesAndJobs.copyId)
IF NOT EXISTS (SELECT 1 FROM #tblInputCopiesAndJobs)
	GOTO CX_EXIT
-------------------
BEGIN TRY
BEGIN TRANSACTION
	UPDATE	JMJobDataStats SET status = B.status, archCheckStatus = B.archCheckStatus,
disabled = ((CASE WHEN B.Status = (CASE WHEN c.isMagRefresh = 1 THEN 1000 ELSE 100 END) AND (disabled & (8192 + 256 + 4096 + 64 + 16 + 1 ) = (8192 + 1)) THEN (disabled & ~1) ELSE disabled END) | B.AuxCopyEncrypted),
			auxCopyJobId = c.auxCopyJobId, copiedTime = @i_now, modifiedTime = @i_now, sizeOnMedia = B.sizeOnMedia,	auxCopyStatus = B.status, unCompSize = B.unCompSize
	FROM	JMJobDataStats A, #tblJDS B, #tblInputCopiesAndJobs c
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
		AND A.archGrpCopyId = B.copyId AND A.dataType = B.dataType AND B.flag = 1  AND c.copyId = B.copyId
		AND (A.status <> B.status or
				A.archCheckStatus <> B.archCheckStatus or
				A.disabled <> (A.disabled | B.AuxCopyEncrypted) or
				A.sizeOnMedia <> B.sizeOnMedia)
	-- Set fully copied jobs as to-be-verified if Data Verification is enabled for the destination copy
IF EXISTS (SELECT 1 FROM #tblInputCopiesAndJobs WHERE copyFlags & (128|256) <> 0)
	BEGIN
		IF object_id('tempdb.dbo.#MinRowsNeeded') IS NOT null DROP TABLE #MinRowsNeeded
		CREATE TABLE #MinRowsNeeded( JobId BIGINT, commCellId INT, dataType INT, copyId INT  PRIMARY KEY (jobId, commCellId, copyID, dataType))
		INSERT INTO #MinRowsNeeded
		SELECT B.jobId,  B.commCellId, B.DataType,  B.copyID
		FROM #tblInputCopiesAndJobs T
			   INNER JOIN #tblJDS B ON
T.copyFlags &  (128|256) <> 0
					  AND B.copyId = T.copyId
					  AND B.archCheckStatus = 3 /*ACS_TOBECHECKED */
		UPDATE	archChunkMapping
SET flags = ((ACM.flags & (~255)) | 1)
		FROM	archChunkMapping ACM, archFile AF WITH (NOLOCK), #MinRowsNeeded R
		WHERE	ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND ACM.archCopyId = R.copyID
				AND AF.jobId = R.jobId AND AF.commCellId = R.commCellId AND AF.fileType = R.DataType
				AND AF.isValid = 1
		IF object_id('tempdb.dbo.#MinRowsNeeded') IS NOT null DROP TABLE #MinRowsNeeded
	END
	UPDATE archAgingRule
	SET flags = (flags | 2)
	FROM archAgingRule AR WITH (NOLOCK), archAgingRuleExtended arx WITH (NOLOCK),#tblJDS a, JMBkpStats b WITH (NOLOCK), #tblInputCopiesAndJobs c
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId	AND a.status = 100 AND a.flag = 1 AND b.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
		  AND a.copyId = c.copyId AND AR.copyId = c.copyId AND ar.flags & 2 = 0 AND arx.copyId = c.copyId
COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = ERROR_NUMBER()
	ROLLBACK TRANSACTION
	IF ERROR_NUMBER() = 1205		--deadlock error
		THROW; -- Re-Throw the execption
	GOTO CX_EXIT
END CATCH
------------------------
-- Set the copied jobs on the source copy as verified. This is not critical.
IF	EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK)
			WHERE	id IN( SELECT sourceCopyId FROM #tblInputCopiesAndJobs)
AND flags & (128|256) <> 0
			)
BEGIN
	UPDATE	JMJobDataStats SET archCheckStatus = 5/*ACS_CHECKED*/, archCheckEndTime = @i_now, modifiedTime = @i_now
	FROM	JMJobDataStats A, #tblJDS B, archGroupCopy agc WITH (NOLOCK) , #tblInputCopiesAndJobs t
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId  AND B.copyId = t.copyId
		AND A.archGrpCopyId = t.sourceCopyId AND A.dataType = B.dataType AND AGC.id = t.sourceCopyId
		AND B.status = 100 AND B.flag = 1 AND A.archCheckStatus <> 5/*ACS_CHECKED*/ AND A.archCheckEndTime <> @i_now
AND AGC.flags & (128|256) <> 0
	UPDATE ACM
SET flags = (ACM.flags & (~255)) | 2
	FROM #tblJDS J, archFile AF WITH (READUNCOMMITTED), archChunkMapping ACM, archGroupCopy agc WITH (NOLOCK) , #tblInputCopiesAndJobs t
	WHERE J.jobId = AF.jobId AND J.dataType = AF.fileType AND J.commCellId = AF.commCellId
		AND AF.id = ACM.archFileId AND AF.jobId = ACM.jobId AND AF.commCellId = ACM.commcellId
		AND	 ACM.archCopyId = t.sourceCopyId AND AGC.id = t.sourceCopyId AND J.copyId = t.copyId
		AND J.status = 100 AND J.flag = 1
AND  ACM.flags & (1 | 4 | 8) > 0
AND AGC.flags & (128|256) <> 0
END
CX_EXIT:
IF object_id('tempdb.dbo.#SnapArchFiles') IS NOT null DROP TABLE #SnapArchFiles
IF object_id('tempdb.dbo.#tblJDS') IS NOT null DROP TABLE #tblJDS
IF object_id('tempdb.dbo.#tblAFC') IS NOT null DROP TABLE #tblAFC
IF object_id('tempdb.dbo.#tblJobAggr') IS NOT null DROP TABLE #tblJobAggr
IF object_id('tempdb.dbo.#tempJobsToProcess') IS NOT null DROP TABLE #tempJobsToProcess
IF @tempInpTablePrepopulated = 0
	IF object_id('tempdb.dbo.#tblInputCopiesAndJobs') IS NOT null DROP TABLE #tblInputCopiesAndJobs
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archJobCopyStatsUpdate')
	delete from GxQscripts where name = 'archJobCopyStatsUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobCopyStatsUpdate')
	delete from GXDBVersions where aliasname = 'archJobCopyStatsUpdate'
GO

insert into GXDBVersions values(2, 'archJobCopyStatsUpdate',  'v1.35.12.29.4.1', 'archJobCopyStatsUpdate', 'v1.35.12.29.4.1')
GO

