

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archJobCopyRetentionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archJobCopyRetentionInfo.sp,v $ $Id: archJobCopyRetentionInfo.sp,v 1.9.76.1 2018/03/22 01:10:11 jiechen Exp $";
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archJobCopyRetentionInfo <<<'

IF EXISTS (select * from sysobjects where name='archJobCopyRetentionInfo')
	drop procedure archJobCopyRetentionInfo
IF EXISTS (select * from GxQscripts where name='archJobCopyRetentionInfo')
	delete from GxQscripts where name = 'archJobCopyRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobCopyRetentionInfo')
	delete from GXDBVersions where aliasname = 'archJobCopyRetentionInfo'
GO
print '... Creating Procedure: archJobCopyRetentionInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archJobCopyRetentionInfo
  @i_jobId integer,
  @i_commCellId integer
AS
  DECLARE @xmlText XML 
BEGIN
DECLARE @tblCopyRetention TABLE
(
	appId			int,
	archGrpId		int,
	archGrpCopyId	int,
	retentionFlags	int,
	retentionDays	bigint,
	manuallyPinned	int,
	manualRetentionEndTime bigint
)
DECLARE @tblExtRetention TABLE
(
	archGrpCopyId	int,
	retentionFlags	int,
	retentionDays	int
)
DECLARE	@l_isArchiver int
SET		@l_isArchiver = 0
DECLARE @jobStartTime bigint
SET		@jobStartTime = 0
DECLARE @MAXINT		integer
SET		@MAXINT = 0x7FFFFFFF
--First get retention information from JMJobDataStats table
INSERT	INTO @tblCopyRetention
SELECT	DISTINCT appId, archGrpId, archGrpCopyId, retentionFlags, 0, 0, 0
FROM	JMJobDataStats WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
AND (	status = 100 AND disabled & 256 = 0 OR status IN (101, 102, 103) AND disabled & (1+256) = 0)
--Then get retention information from JMJobCopyInfo table (for running jobs)
INSERT	INTO @tblCopyRetention
SELECT	JI.appId, JI.archGrpId, JI.archGrpCopyId, JI.retentionFlags, 0, 0, 0
FROM	JMJobCopyInfo JI WITH (NOLOCK)
WHERE	JI.jobId = @i_jobId AND JI.commCellId = @i_commCellId
AND NOT EXISTS (SELECT *
								FROM @tblCopyRetention T
								WHERE	T.appId = JI.appId
								AND 	T.archGrpId = JI.archGrpId
								AND		T.archGrpCopyId = JI.archGrpCopyId)
SELECT	@l_isArchiver = IDA.isDMAppType
FROM	APP_IDATypeHandlingInfo IDA WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
WHERE	IDA.appTypeId = APP.appTypeId AND APP.id = (SELECT TOP 1 appId FROM @tblCopyRetention)
UPDATE	@tblCopyRetention
SET		retentionDays = CASE WHEN @l_isArchiver = 0 THEN AR.retentionDays ELSE AR.archiverRetDays END
FROM	@tblCopyRetention CR, archAgingRule AR WITH (NOLOCK)
WHERE	AR.copyId = CR.archGrpCopyId
INSERT	INTO @tblExtRetention
SELECT	CR.archGrpCopyId, CR.retentionFlags, MAX(CASE WHEN ARE.retentionDays < 0 THEN @MAXINT ELSE ARE.retentionDays END)
FROM	@tblCopyRetention CR, archAgingRuleExtended ARE WITH (NOLOCK)
WHERE	CR.archGrpCopyId = ARE.copyId
	AND CR.retentionFlags & ARE.retentionRule <> 0
GROUP BY CR.archGrpCopyId, CR.retentionFlags
UPDATE	@tblCopyRetention
SET		retentionDays = ER.retentionDays
FROM	@tblCopyRetention CR, @tblExtRetention ER
WHERE	CR.archGrpCopyId = ER.archGrpCopyId
	AND CR.retentionDays < ER.retentionDays
	AND CR.retentionDays <> -1
-- Computing jobStartTime
IF EXISTS( SELECT * FROM jmjobinfo WITH (READUNCOMMITTED) where jobId = @i_jobId AND commCellId = @i_commCellId)
BEGIN
	SET		@jobStartTime =  (SELECT jobStartTime FROM jmjobinfo WITH (READUNCOMMITTED) where jobId = @i_jobId AND commCellId = @i_commCellId)
END
ELSE IF EXISTS( SELECT * FROM JmBkpStats WITH (READUNCOMMITTED) where jobId = @i_jobId AND commCellId = @i_commCellId)
BEGIN
	SET		@jobStartTime =  (SELECT servStartDate FROM JMBkpStats WITH (READUNCOMMITTED) where jobId = @i_jobId AND commCellId = @i_commCellId)
END
ELSE IF EXISTS( SELECT * FROM JMAdminJobStatsTable WITH (READUNCOMMITTED) where jobId = @i_jobId AND commCellId = @i_commCellId)
BEGIN
	SET		@jobStartTime =  (SELECT servStart FROM JMAdminJobStatsTable WITH (READUNCOMMITTED) where jobId = @i_jobId AND commCellId = @i_commCellId)
END
-- Computing the pinned status and manual retention time
UPDATE	@tblCopyRetention
SET		manuallyPinned = (select ISNULL(MAX(disabled), 0)
						  FROM	JMJobDataStats WITH (NOLOCK)
						  WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
						  AND  archgrpId = T.archGrpId and archGrpCopyId = T.archGrpCopyId),
		manualRetentionEndTime = (select ISNULL(MAX(manualRetentionEndTime), 0)
						  FROM	JMJobDataStats WITH (NOLOCK)
						  WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
						  AND  archgrpId = T.archGrpId and archGrpCopyId = T.archGrpCopyId)
FROM @tblCopyRetention T
--Updating manually pinned status and job retention time
UPDATE @tblCopyRetention
SET manuallyPinned = (case when manuallyPinned& 2>0 then 1 ELSE 0 END),
    retentionDays = (case
						  when retentionDays = @MAXINT then -1
						  when retentionDays = -1 then -1
						  when manualRetentionEndTime > (@jobStartTime + retentionDays*24*60*60) then manualRetentionEndTime else (@jobStartTime + retentionDays*24*60*60)
					 end)
----------------------------
--CONSTRUCT THE XML---------
----------------------------
select 1 as tag,
	null as parent,
	null as [EVGui_GetJobRetentionInfoResp!1!],
	null as [storagePolicyRetentionInfoList!2!storagePolicyId],
	null as [storagePolicyRetentionInfoList!2!storagePolicyName],
	null as [copyRetentionInfoList!3!storagePolicyCopyId],
	null as [copyRetentionInfoList!3!storagePolicyCopyName],
	null as [copyRetentionInfoList!3!retentionDays],
	null as [copyRetentionInfoList!3!retentionRules],
	null as [copyRetentionInfoList!3!manuallyPinned],
	null as [copyRetentionInfoList!3],
	null as [storagePolicyRetentionInfoList!2]
union all
select 2 as tag,
	1 as parent,
	null,
	AG.id ,
	AG.name,
	null,
	null,
	null,
	null,
	null,
	null,
	null
FROM	archGroup AG WITH (NOLOCK), (SELECT DISTINCT archGrpId FROM @tblCopyRetention) T
WHERE	AG.id = T.archGrpId
union all
select 3 as tag,
	2 as parent,
	null,
	AG.id,
	AG.name,
	AGC.id,
	AGC.name,
	CR.retentionDays,
	CR.retentionFlags,
	CR.manuallyPinned,
	null,
	null
FROM	archGroup AG with (NOLOCK), archGroupCopy AGC WITH (NOLOCK), @tblCopyRetention CR
WHERE	AG.id = CR.archGrpId
AND AGC.id = CR.archGrpCopyId
ORDER BY [storagePolicyRetentionInfoList!2!storagePolicyId],[copyRetentionInfoList!3!storagePolicyCopyId]
FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'archJobCopyRetentionInfo')
	delete from GxQscripts where name = 'archJobCopyRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobCopyRetentionInfo')
	delete from GXDBVersions where aliasname = 'archJobCopyRetentionInfo'
GO

insert into GXDBVersions values(2, 'archJobCopyRetentionInfo',  '00010009007600010000', 'archJobCopyRetentionInfo', '00010009007600010000')
GO

