

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archJobCopyInfoInsert.sp] ---------- 

--#include "DBaccess.h"
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archJobCopyInfoInsert.sp,v $ $Id: archJobCopyInfoInsert.sp,v 1.41.46.9 2019/07/18 16:01:18 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archJobCopyInfoInsert')
BEGIN
	print '>>> Drop Stored Procedure: archJobCopyInfoInsert <<<'
	drop procedure archJobCopyInfoInsert
END
IF EXISTS (select * from GxQscripts where name='archJobCopyInfoInsert')
	delete from GxQscripts where name = 'archJobCopyInfoInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobCopyInfoInsert')
	delete from GXDBVersions where aliasname = 'archJobCopyInfoInsert'
GO
print '... Creating Procedure: archJobCopyInfoInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archJobCopyInfoInsert
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_archGroupId integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_nextFullTime integer,
  @i_today integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
	DECLARE	@tblRetCode TABLE(
			retCode 	INTEGER
			)
DECLARE @tmpJMJobCopyInfo TABLE (
	jobId						INTEGER,
	appId						INTEGER,
	archGrpId				INTEGER,
	archGrpCopyId		INTEGER,
	commCellId			INTEGER,
	retentionFlags	INTEGER,
	retentionDays		INTEGER
)
DECLARE @tmpFullJobCopyInfo TABLE (
	jobId						INTEGER,
	appId						INTEGER,
	archGrpId				INTEGER,
	archGrpCopyId		INTEGER,
	commCellId			INTEGER,
	retentionFlags	INTEGER
)
DECLARE @errorCode INTEGER
SET 		@errorCode = 0
DECLARE @ORACLE_RMAN_CUSTOMSCRIPT_BKP		BIGINT
SET			@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
DECLARE 	@IgnoreCWEJobOption 	INTEGER
SET		@IgnoreCWEJobOption 			= 0
DECLARE @l_isCWEjobValid	INTEGER
SET		@l_isCWEjobValid	= 1
DECLARE @HonorExtRetForRegularFull 	INTEGER
SET			@HonorExtRetForRegularFull 	= 1
DECLARE	@l_opType		INTEGER
DECLARE	@l_isSnap		INTEGER
DECLARE	@l_clientId	INTEGER
DECLARE @l_localStartTime INTEGER
DECLARE @defaultCCId INT = 2
-------------------------------------------------------------------------------
-------- Consider CWE jobs for extended retention based on param value --------
-------------------------------------------------------------------------------
SELECT @IgnoreCWEJobOption = isnull(value, 0)
FROM mmconfigs
WHERE name = 'DA_CONFIG_IGNORE_CWE_OPTION_FOR_EXT_RET'
SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT
SELECT @HonorExtRetForRegularFull = isnull(value, 1)
FROM mmconfigs
WHERE name = 'DA_CONFIG_HONOR_EXTENDED_RETENTION_FOR_ORACLE_SAP_REGULAR_FULL_JOBS'
SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT
IF	@IgnoreCWEJobOption = 0
BEGIN
	SELECT	@l_isCWEjobValid = isnull(isCWEjobValid, 0)
	FROM	APP_iDAType WITH(NOLOCK)
	WHERE	type = @i_appType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
END
SELECT @l_clientId = clientId
FROM APP_Application WITH(NOLOCK)
WHERE id = @i_appId
SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT
SELECT @l_opType = optype
FROM JMJobInfo WITH(NOLOCK)
WHERE jobId = @i_jobId
and commCellId = @defaultCCId
SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT
IF	@l_opType IS NULL
BEGIN
	SELECT @l_opType = optype
	FROM JMBkpStats WITH(NOLOCK)
	WHERE jobId = @i_jobId
	AND 	commCellId = 2
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
END
IF	@l_opType IS NULL
BEGIN
	SET	@errorCode = -1
	GOTO CX_EXIT
END
IF	@l_opType IN (59, 65)
	SET @l_isSnap = 1
ELSE
	SET @l_isSnap = 0
DECLARE @nextSchedFullTime	INTEGER
SET @nextSchedFullTime = @i_nextFullTime
IF	@i_nextFullTime <= 0
	SET @i_nextFullTime = 0x7FFFFFFF
CREATE TABLE #CopiesForJob
(
	copyId 					INTEGER
)
EXEC archCopiesForJob @i_jobId, @i_appId, @i_appType, @i_archGroupId, @i_startDate, @i_backupLevel, @i_fullCycleNum, @i_nextFullTime, @i_today, @l_isSnap, @errorCode OUTPUT
IF	@errorCode != 0 GOTO CX_EXIT
IF EXISTS (	SELECT jobId
						FROM JMJobCopyInfo WITH(NOLOCK)
						WHERE jobId = @i_jobId
						AND 	archGrpId = @i_archGroupId
						and commCellId = @defaultCCId)
BEGIN
	DELETE FROM JMJobCopyInfo
	WHERE jobId = @i_jobId
	AND 	archGrpId = @i_archGroupId
	and commCellId = @defaultCCId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
END
-- JM will pass correct backupLevel when it is incremental snap job of FS like iDA, NAS or VSA and SP flags is set to "Consider Incrementals as Full"
-- Set Extended Retention flags for full backup
IF @i_backupLevel NOT IN (1, 64, 128, 1024, 16384, 32768, 131072, 262144)
	OR NOT EXISTS (SELECT * FROM #CopiesForJob C, archAgingRuleExtended ARE WITH(NOLOCK) WHERE ARE.copyId = C.copyId)
	OR EXISTS (	SELECT jobId
													FROM JMBkpJobInfo WITH (NOLOCK)
													WHERE jobId = @i_jobId
													AND commcellId = 2
													AND (bkpattributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP) > 0
AND (bkpattributes & 0x1000) = 0
						)
	OR (
@i_appType IN (128)
				AND NOT EXISTS (	SELECT jobId
													FROM JMBkpJobInfo WITH (NOLOCK)
													WHERE jobId = @i_jobId
													AND commcellId = 2
AND (bkpattributes & 0x1000) > 0
												)
		 )
OR @i_appType IN (124, 131, 126)
	-- Only include SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle, SAP, Informix, Sybase and DB2
	OR 	(
				@i_backupLevel NOT IN (1024, 32768)
				AND @i_appType IN (
2,
22,
23,
80,
61,
79
													)
				AND NOT EXISTS (SELECT jobId
													FROM JMBkpJobInfo WITH (NOLOCK)
													WHERE jobId = @i_jobId
													AND commcellId = 2
AND (bkpattributes & 0x1000) > 0
													AND (@HonorExtRetForRegularFull = 1)
												)
			)
	-- Exclude Archiver iDAs
	OR	EXISTS (	SELECT appTypeId
								FROM APP_IDATypeHandlingInfo WITH(NOLOCK)
								WHERE appTypeId = @i_appType
								AND isDMAppType = 1
							)
	-- Exclude Turbo subclients with "Honor Archiver Agent Retention" option enabled
	OR EXISTS (	SELECT	componentNameId
							FROM 		APP_SubClientProp WITH (NOLOCK)
							WHERE		componentNameId = @i_appId
							AND			attrName = 'Honor Archiver Agent Retention'
							AND			attrVal = '1'
							AND			modified = 0
						)
	-- Only include the default subclient for SQL iDAs
	OR (
				@i_appType IN (
4,
16,
70
											)
			AND NOT EXISTS (	SELECT *
												FROM APP_Application WITH (NOLOCK)
												WHERE id  = @i_appId
												AND (subclientStatus & 8) <> 0
										)
		)
	-- Exclude command line jobs for Sybase, DB2 and Informix
	OR (
				@i_appType IN (
5,
37,
62,
3,
103
											)
			AND EXISTS 	(	SELECT id
										FROM APP_Application WITH (NOLOCK)
										WHERE id  = @i_appId
AND (subclientStatus & 0x0040) <> 0
									)
		)
    -- Exclude SAP HANA log-only jobs
	OR (
@i_appType = 135
			AND EXISTS (	SELECT *
												FROM APP_Application WITH (NOLOCK)
												WHERE id  = @i_appId
AND (subclientStatus & 0x1000) <> 0
										)
		)
	-- Exclude FFG subclients for SQL iDAs from selective copies since 6.1
	OR (
@i_appType = 81
			AND EXISTS (	SELECT	componentNameId
										FROM APP_SubClientProp WITH (NOLOCK)
										WHERE	componentNameId = @i_appId
										AND attrName = N'mssql subclient type'
										AND attrVal = N'2'
										AND modified = 0
								)
		)
	-- Exclude DDB Backup subclients for extended retention
	OR EXISTS (	SELECT componentNameId
							FROM APP_SubClientProp WITH (NOLOCK)
							WHERE	componentNameId = @i_appId
							AND attrName = N'DDB Backup'
							AND attrVal = N'1'
							AND modified = 0
						)
	-- Exclude Reference Copy Subclient for extended retention
	OR EXISTS (	SELECT id
							FROM APP_Application WITH (NOLOCK)
							WHERE	id = @i_appId
							AND		subclientStatus & 0x10000 = 0x10000		--CV_STATUS_REFCOPY_SUB
						)
	-- Exclude Edge drive subclient jobs for extended retention
	OR EXISTS (	SELECT id
							FROM APP_Application WITH (NOLOCK)
							WHERE	id = @i_appId
AND		subclientStatus & 0x20000 = 0x20000
						)
	-- Exclude Index Copy jobs for extended retention
	OR EXISTS (	SELECT jobId
							FROM JMBkpJobInfo WITH (NOLOCK)
							WHERE jobId = @i_jobId
							AND commcellId = 2
							AND (bkpAttributesEx & CAST(0x1000000000000 AS BIGINT)) > 0 --JMBKP_EX_BLR_INDEX_COPY_JOB
						)
	-- Exclude App Aware App backups corresponding to incremental VSA for extended retention
	OR EXISTS (	SELECT jobId
							FROM JMBkpJobInfo WITH (NOLOCK)
							WHERE jobId = @i_jobId
							AND commcellId = 2
							AND (bkpAttributesEx & @EX_APPAWARE_CHILD_JOB) > 0
							AND (bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE) = 0
						)
BEGIN
	INSERT INTO @tmpJMJobCopyInfo
	SELECT	@i_jobId, @i_appId, @i_archGroupId, copyId, 2, 0, 0
	FROM	#CopiesForJob
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Extended retain all the jobs in a cycle for Full job that is extended retained on a copy where option is enabled
	IF (
				@i_backupLevel NOT IN (1, 64, 128, 1024, 16384, 32768, 131072, 262144)
		 		AND EXISTS (	SELECT E.EntityId
											FROM #CopiesForJob C, MMEntityProp E WITH (NOLOCK)
											WHERE	C.copyId = E.EntityId
											AND		E.EntityType = 2 	-- Copy Entity
											AND		E.propertyName = 'ExtendRetainAllJobsInCycle'
											AND		((E.intVal = 2)					--Extend Retain all jobs in cycle along with the Full job
															OR
													 	 (E.intVal = 1 AND @i_backupLevel = 4) --Extend Retain only differential jobs in cycle along with the Full job
														)
										)
			)
	BEGIN
		INSERT INTO @tmpFullJobCopyInfo (jobId, appId, archGrpId, archGrpCopyId, commCellId, retentionFlags)
		SELECT DISTINCT JDS.jobId, JDS.appId, JDS.archGrpId, JDS.archGrpCopyId, JDS.commCellId, JDS.retentionFlags
		FROM 	 JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBK WITH (NOLOCK)
	 	WHERE  JBK.appId = @i_appId
	 	AND    JBK.bkpLevel IN (1, 64, 128, 1024, 16384, 32768, 131072, 262144)
	 	AND		 JBK.fullCycleNum = @i_fullCycleNum
	 	AND		 JBK.jobId = JDS.jobId
	 	AND		 JBK.commCellId = JDS.commcellId
		AND		 JDS.dataType = 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @tmpFullJobCopyInfo (jobId, appId, archGrpId, archGrpCopyId, commCellId, retentionFlags)
		SELECT DISTINCT JDS.jobId, JDS.appId, JDS.archGrpId, JDS.archGrpCopyId, JDS.commCellId, JDS.retentionFlags
		FROM 	 JMJobDataStats JDS WITH (NOLOCK), JMAdminJobStatsTable JAS WITH (NOLOCK)
	 	WHERE  JAS.appId = @i_appId
	 	AND    JAS.ER_BkpLevel IN (1, 64, 128, 1024, 16384, 32768, 131072, 262144)
	 	AND		 JAS.fullCycleNum = @i_fullCycleNum
	 	AND		 JAS.jobId = JDS.jobId
	 	AND		 JAS.commCellId = JDS.commcellId
		AND		 JDS.dataType = 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Update the retentionFlags of INCRs\DIFFs with the retentionFlags of corresponding Full job
		UPDATE @tmpJMJobCopyInfo
		SET retentionFlags = TMP.retentionFlags
		FROM @tmpJMJobCopyInfo T, @tmpFullJobCopyInfo TMP, MMEntityProp E WITH (NOLOCK)
		WHERE	T.appId = TMP.appId
		AND		T.archGrpId = TMP.archGrpId
		AND		T.archGrpCopyId = TMP.archGrpCopyId
		AND		T.archGrpCopyId = E.EntityId
		AND		E.EntityType = 2 	-- Copy Entity
		AND		E.propertyName = 'ExtendRetainAllJobsInCycle'
		AND		((E.intVal = 2)					--Extend Retain all jobs in cycle along with the Full job
						OR
				 	 (E.intVal = 1 AND @i_backupLevel = 4) --Extend Retain only differential jobs in cycle along with the Full job
					)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	INSERT	INTO JMJobCopyInfo
	SELECT jobId, appId, archGrpId, archGrpCopyId, commCellId, retentionFlags, retentionDays
	FROM @tmpJMJobCopyInfo
	SET	@errorCode	=	@@ERROR
	GOTO CX_EXIT
END
ELSE
BEGIN
	CREATE TABLE #appCopyExtAgingRule
	(
			appId									INTEGER,
			jobId									INTEGER,
			archGrpId							INTEGER,
			copyId 								INTEGER,
			retentionRule		 			INTEGER,
			weekStart							INTEGER,
			monthStart						INTEGER,
			calendarId 						INTEGER,
			timeZoneStdName				VARCHAR(255),
			localStartTime				INTEGER,
			periodStartTime				INTEGER,
			periodEndTime					INTEGER,
			prevPeriodStartTime		INTEGER,
			EveryXHours						INTEGER,
			minutesSinceDayStarts	INTEGER
			PRIMARY KEY (appId, copyId, jobId, retentionRule)
	)
	CREATE TABLE #appCopyPeriodRange
	(
			appId								INTEGER,
			jobId								INTEGER,
			archGrpId						INTEGER,
			copyId 							INTEGER,
			calendarId 					INTEGER,
			timeZoneStdName			VARCHAR(255),
			periodStartTime			INTEGER,
			periodEndTime				INTEGER,
			prevPeriodStartTime	INTEGER,
			PRIMARY KEY (appId, copyId, jobId)
	)
	DECLARE @nextSchedTime	INTEGER
	SET 	@nextSchedTime		= 0
	DECLARE	@appNextSchedFullTime TABLE (
			nextSchedTime 		INTEGER
			)
	-- Create just the temp table
	SELECT	*
	INTO	#RJ_ArchJobCopyExtended
	FROM ArchJobCopyExtended
	WHERE 1 = 2
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_tmp_RJ_ArchJobCopyExtended_1 ON #RJ_ArchJobCopyExtended (AppId, CopyId)
	CREATE INDEX Idx_tmp_RJ_ArchJobCopyExtended_2 ON #RJ_ArchJobCopyExtended (jobId, copyId, dataType, commCellId)
	INSERT	INTO #appCopyExtAgingRule
	SELECT	@i_appId, @i_jobId, AGC.archGroupId, AGC.id, ISNULL(ARE.retentionRule, 0), 0, 0, AGC.calendarId, '', 0, 0, 0, 0, ISNULL(ARE.EveryXHours, 0), 0
	FROM	#CopiesForJob C
	INNER JOIN archGroupCopy AGC WITH(NOLOCK)
	ON C.copyId = AGC.id
	LEFT OUTER JOIN archAgingRuleExtended ARE WITH(NOLOCK)
	ON AGC.id = ARE.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update weekStart and monthStart info for copy
	UPDATE #appCopyExtAgingRule
	SET weekStart = AAR.weekStart, monthStart = AAR.monthStart, minutesSinceDayStarts = AAR.minutesSinceDayStarts
	FROM #appCopyExtAgingRule a, archAgingRule AAR WITH (NOLOCK)
	WHERE	a.copyId = AAR.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET timeZoneStdName = dbo.GetClientTimeZone(2)				-- ClientId for CommServ is 2
	FROM	#appCopyExtAgingRule a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
AND		b.TimeZoneType = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET timeZoneStdName = dbo.GetClientTimeZone(@l_clientId)
	FROM	#appCopyExtAgingRule a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
AND		b.TimeZoneType = 1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET timeZoneStdName = b.TimeZone
	FROM	#appCopyExtAgingRule a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
AND		b.TimeZoneType = 2
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET localStartTime = dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(@i_startDate), timeZoneStdName))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetHourlyStart(localStartTime, EveryXHours, minutesSinceDayStarts),
			periodEndTime = dbo.DAGetHourlyEnd(localStartTime, EveryXHours, minutesSinceDayStarts)
	WHERE retentionRule & 262144 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetDailyStart(localStartTime, minutesSinceDayStarts),
			periodEndTime = dbo.DAGetDailyEnd(localStartTime, minutesSinceDayStarts)
	WHERE retentionRule & 524288 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetWeekStart(localStartTime, weekStart),
			periodEndTime = dbo.DAGetWeekEnd(localStartTime, weekStart)
	WHERE retentionRule & 4 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetMonthStart(localStartTime, calendarId, monthStart),
			periodEndTime = dbo.DAGetMonthEnd(localStartTime, calendarId, monthStart)
	WHERE retentionRule & 8 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetQuarterStart(localStartTime, calendarId),
			periodEndTime = dbo.DAGetQuarterEnd(localStartTime, calendarId)
	WHERE retentionRule & 16 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetHalfYearStart(localStartTime, calendarId),
			periodEndTime = dbo.DAGetHalfYearEnd(localStartTime, calendarId)
	WHERE retentionRule & 32 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET periodStartTime = dbo.DAGetYearStart(localStartTime, calendarId),
			periodEndTime = dbo.DAGetYearEnd(localStartTime, calendarId)
	WHERE retentionRule & 64 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetHourlyStart((periodStartTime - 1 * 3600), EveryXHours, minutesSinceDayStarts)
	WHERE retentionRule & 262144 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetDailyStart((periodStartTime - 24 * 3600), minutesSinceDayStarts)
	WHERE retentionRule & 524288 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetWeekStart((periodStartTime - 24 * 3600), weekStart)
	WHERE retentionRule & 4 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetMonthStart((periodStartTime - 24 * 3600), calendarId, monthStart)
	WHERE retentionRule & 8 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetQuarterStart((periodStartTime - 24 * 3600), calendarId)
	WHERE retentionRule & 16 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetHalfYearStart((periodStartTime - 24 * 3600), calendarId)
	WHERE retentionRule & 32 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #appCopyExtAgingRule
	SET prevPeriodStartTime = dbo.DAGetYearStart((periodStartTime - 24 * 3600), calendarId)
	WHERE retentionRule & 64 <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #appCopyPeriodRange
	SELECT appId, jobId, archGrpId, copyId, calendarId, timeZoneStdName, min(periodStartTime), max(periodEndTime), min(prevPeriodStartTime)
	FROM #appCopyExtAgingRule
	GROUP BY appId, jobId, archGrpId, copyId, calendarId, timeZoneStdName
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Populate the running job for all candidate copies
	INSERT INTO #RJ_ArchJobCopyExtended
	SELECT DISTINCT AC.appId, AC.jobId, AC.copyId, 0, 2, @i_startDate, @i_startDate, 100, 1, 0, 0, 0, 0, '',
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM #appCopyPeriodRange AC
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Populate all FULL jobs for this appId on all listed copies from prevPeriodStartTime to periodEndTime and calculate extended retention flags
	-- Convert into UTC date time since the date time in database is in UTC Unix time
	INSERT INTO #RJ_ArchJobCopyExtended
	SELECT DISTINCT JBS.appId, JBS.jobId, JBS.archGrpCopyId, 0, JBS.commCellId, JBS.servStartDate, JBS.servEndDate, JBS.dataStatus, JBS.jobStatus, (JBS.disabled & 1), (JBS.disabled & 2),
	0, 0, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM	(	SELECT	JBK.jobId, JBK.commCellId, JBK.servStartDate, JBK.servEndDate, JBK.status AS jobStatus, JDS.appId, JDS.disabled, JDS.archGrpCopyId, JDS.status AS dataStatus
					FROM		JMBkpStats JBK WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
					WHERE		JBK.jobId = JDS.jobId
					AND 		JBK.commCellId = JDS.commCellId
					AND			JDS.appId = @i_appId
					AND			JDS.dataType = 1		--Do not pick log only jobs that are marked as Full
					AND			JBK.openChain = 0
					AND 		((@l_isCWEjobValid = 1 AND JBK.status IN (1, 3, 14)) OR (@l_isCWEjobValid <> 1 AND JBK.status IN (1, 14)))
					AND			(
										(
JBK.appType IN (2, 22, 23, 80, 61, 79)
												AND
												(
													JBK.bkpLevel IN (1024, 32768)
													OR
((@HonorExtRetForRegularFull = 1) AND (JBK.bkpLevel = 1) AND (JBK.bkpattributes & 0x1000) > 0)
												)
										)
										OR
										(
JBK.appType IN (128)
											AND
											(
JBK.bkpLevel = 1 AND (JBK.bkpattributes & 0x1000) > 0
											)
										)
										OR
										(
JBK.appType NOT IN (2, 22, 23, 80, 61, 79, 128)
												AND
												(
													JBK.bkpLevel IN (1, 64, 128, 1024, 16384, 32768, 131072, 262144)
													OR
													dbo.GetBkpLevelOfSnapJobs(JDS.jobId, JDS.commCellId, JDS.archGrpCopyId) = 1
												)
										)
									)
					UNION
					SELECT	JAS.jobId, JAS.commCellId, JAS.servStart, JAS.servEnd, JAS.status AS jobStatus, JDS.appId, JDS.disabled, JDS.archGrpCopyId, JDS.status AS dataStatus
					FROM		JMAdminJobStatsTable JAS WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
					WHERE		JAS.jobId = JDS.jobId
					AND 		JAS.commCellId = JDS.commCellId
					AND			JDS.appId = @i_appId
					AND			JDS.dataType = 1		--Do not pick log only jobs that are marked as Full
					AND			JAS.ER_bkpLevel IN (1, 64, 128, 1024, 16384, 32768, 131072, 262144)
					AND 		((@l_isCWEjobValid = 1 AND JAS.status IN (1, 3, 14)) OR (@l_isCWEjobValid <> 1 AND JAS.status IN (1, 14)))
				) AS JBS
	INNER JOIN #appCopyPeriodRange AC
		ON 	JBS.appId = AC.appId
		AND JBS.archGrpCopyId = AC.copyId
WHERE	JBS.disabled & 64 = 0
	AND		JBS.servStartDate >= dbo.getUnixTime(dbo.LocalToUTCTime(dbo.getDateTime(AC.prevPeriodStartTime), AC.timeZoneStdName))
	AND		JBS.servStartDate <= dbo.getUnixTime(dbo.LocalToUTCTime(dbo.getDateTime(AC.periodEndTime), AC.timeZoneStdName))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update jobStatus to Success (1) if Full job CWE but failed contents backed by by Incrs that are chained to Full
	UPDATE #RJ_ArchJobCopyExtended
	SET JobStatus = 1
	FROM #RJ_ArchJobCopyExtended RJ, JMBkpStats JBK WITH (NOLOCK), JMJobDataLink JDL WITH (NOLOCK)
	WHERE	RJ.jobId = JBK.jobId
	AND 	RJ.commCellId = JBK.commCellId
AND		JBK.appType IN (106, 53)
	AND		JBK.bkpLevel = 1
	AND		JBK.status = 3
	AND		JBK.openChain = 0
	AND		JBK.JobId = JDL.parentJobId
	AND		JBK.CommCellId = JDL.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update calendarId and TimeZoneToHonor Info
	UPDATE #RJ_ArchJobCopyExtended
	SET calendarId = AC.calendarId, timeZoneStdName = AC.timeZoneStdName
	FROM #RJ_ArchJobCopyExtended RJ,  #appCopyPeriodRange AC
	WHERE	RJ.appId = AC.appId
	AND 	RJ.copyId = AC.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update weekStart and monthStart info for copy
	UPDATE #RJ_ArchJobCopyExtended
	SET weekStart = AAR.weekStart, monthStart = AAR.monthStart, minutesSinceDayStarts = AAR.minutesSinceDayStarts
	FROM #RJ_ArchJobCopyExtended RJ, archAgingRule AAR WITH (NOLOCK)
	WHERE	RJ.copyId = AAR.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update EveryXHours
	UPDATE #RJ_ArchJobCopyExtended
	SET EveryXHours = AARE.EveryXHours
	FROM #RJ_ArchJobCopyExtended RJ, archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE	RJ.copyId = AARE.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Calculate the LocalTime based on the TimeZone selected for Storage Policy
	UPDATE #RJ_ArchJobCopyExtended
	SET localStartTime = dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(startTime), timeZoneStdName))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the period StartTime for each job based on their LocalTime
	UPDATE #RJ_ArchJobCopyExtended
	SET hourStartTime = dbo.DAGetHourlyStart(localStartTime, EveryXHours, minutesSinceDayStarts),
	dayStartTime = dbo.DAGetDailyStart(localStartTime, minutesSinceDayStarts),
	weekStartTime = dbo.DAGetWeekStart(localStartTime, weekStart),
	monthStartTime = dbo.DAGetMonthStart(localStartTime, calendarId, monthStart),
	quarterStartTime = dbo.DAGetQuarterStart(localStartTime, calendarId),
	halfYearStartTime = dbo.DAGetHalfYearStart(localStartTime, calendarId),
	yearStartTime = dbo.DAGetYearStart(localStartTime, calendarId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #RJ_ArchJobCopyExtended
	SET hourEndTime = dbo.DAGetHourlyEnd(localStartTime, EveryXHours, minutesSinceDayStarts),
	dayEndTime = dbo.DAGetDailyEnd(localStartTime, minutesSinceDayStarts),
	weekEndTime = dbo.DAGetWeekEnd(localStartTime, weekStart),
	monthEndTime = dbo.DAGetMonthEnd(localStartTime, calendarId, monthStart),
	quarterEndTime = dbo.DAGetQuarterEnd(localStartTime, calendarId),
	halfYearEndTime = dbo.DAGetHalfYearEnd(localStartTime, calendarId),
	yearEndTime = dbo.DAGetYearEnd(localStartTime, calendarId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
    /* This is already passed in. No need to recompute again.
	INSERT INTO @appNextSchedFullTime
	EXEC TM_GetNextScheduleRunTime @i_appId, 1, 0, 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT TOP 1 @nextSchedFullTime = nextSchedTime
	FROM @appNextSchedFullTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
    */
	--Get next backup time (Full or non-full only for FS like, NAS or VSA
	IF (@i_appType IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) -- APPGRP_FileSystemIDA
		  OR @i_appType IN (88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/) )
	BEGIN
		/*DELETE @appNextSchedFullTime*/
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @appNextSchedFullTime
		EXEC TM_GetNextScheduleRunTime @i_appId, 0, 0, 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SELECT TOP 1 @nextSchedTime = nextSchedTime
		FROM @appNextSchedFullTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	UPDATE #RJ_ArchJobCopyExtended
	SET nextFullTime = ISNULL(dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(@nextSchedFullTime), RJ.timeZoneStdName)), 0)
	FROM #RJ_ArchJobCopyExtended RJ, archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE RJ.appId = @i_appId
	AND		RJ.copyId = AGC.id
	AND		AGC.archGroupId = AG.id
AND		AGC.type <> 2
	AND		(		 (AGC.isSnapCopy = 0)
					OR (AGC.isSnapCopy = 1 AND AG.flags & 32768 = 0) -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
					OR (@i_appType NOT IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) AND @i_appType NOT IN (88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/))
				)
	AND		@nextSchedFullTime > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #RJ_ArchJobCopyExtended
	SET nextFullTime = ISNULL(dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(@nextSchedTime), RJ.timeZoneStdName)), 0)
	FROM #RJ_ArchJobCopyExtended RJ, archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE RJ.appId = @i_appId
	AND		RJ.copyId = AGC.id
	AND		AGC.archGroupId = AG.id
AND		AGC.type <> 2
	AND		AGC.isSnapCopy = 1
	AND 	AG.flags & 32768 > 0 -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
	AND 	(@i_appType IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) OR @i_appType IN (88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/))
	AND		@nextSchedTime > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Apply all extended retention filters
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedAllFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedHourlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedDailyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedWeeklyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedMonthlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedQuarterlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedHalfYearlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyExtendedYearlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyGraceExtendedWeeklyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyGraceExtendedMonthlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyGraceExtendedQuarterlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyGraceExtendedHalfYearlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblRetCode
	EXEC daRJApplyGraceExtendedYearlyFullRule 0, 0
	IF EXISTS (SELECT * FROM @tblRetCode WHERE retCode <> 0)
	BEGIN
		SELECT TOP 1 @errorCode = retCode FROM @tblRetCode WHERE retCode <> 0
		GOTO CX_EXIT
	END
	-- Only keep the running job entries
	DELETE #RJ_ArchJobCopyExtended
	WHERE jobId <> @i_jobId
	OR		commCellId <> 2
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Unset the retention flags if it is retained by candidate criteria
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 262144 | 1048576)
	WHERE retentionFlags & 1048576 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 524288 | 2097152)
	WHERE retentionFlags & 2097152 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 4 | 8192)
	WHERE retentionFlags & 8192 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Unset the retention flags if it is retained by candidate criteria
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 8 | 16384)
	WHERE retentionFlags & 16384 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Unset the retention flags if it is retained by candidate criteria
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 16 | 32768)
	WHERE retentionFlags & 32768 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Unset the retention flags if it is retained by candidate criteria
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 32 | 65536)
	WHERE retentionFlags & 65536 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Unset the retention flags if it is retained by candidate criteria
	UPDATE #RJ_ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(1 | 64 | 131072)
	WHERE retentionFlags & 131072 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Set the true extended retention flags on the running job
	INSERT	INTO JMJobCopyInfo
	SELECT DISTINCT jobId, appId, @i_archGroupId, copyId, 2, retentionFlags, 0
	FROM	#RJ_ArchJobCopyExtended
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
END
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#appCopyExtAgingRule') IS NOT null DROP TABLE #appCopyExtAgingRule
	IF OBJECT_ID('tempdb.dbo.#appCopyPeriodRange') IS NOT null DROP TABLE #appCopyPeriodRange
	IF OBJECT_ID('tempdb.dbo.#CopiesForJob') IS NOT null DROP TABLE #CopiesForJob
	IF OBJECT_ID('tempdb.dbo.#RJ_ArchJobCopyExtended') IS NOT null DROP TABLE #RJ_ArchJobCopyExtended
	SELECT   @errorCode
	RETURN   @errorCode;
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archJobCopyInfoInsert')
	delete from GxQscripts where name = 'archJobCopyInfoInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archJobCopyInfoInsert')
	delete from GXDBVersions where aliasname = 'archJobCopyInfoInsert'
GO

insert into GXDBVersions values(2, 'archJobCopyInfoInsert',  '00010041004600090000', 'archJobCopyInfoInsert', '00010041004600090000')
GO

