

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archIsSubClientValidForSynthFull.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archIsSubClientValidForSynthFull.sp						  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archIsSubClientValidForSynthFull.sp,v $ $Id: archIsSubClientValidForSynthFull.sp,v 1.4.54.4 2020/05/26 19:45:05 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archIsSubClientValidForSynthFull')
BEGIN
	print '>>> Drop Stored Procedure: archIsSubClientValidForSynthFull <<<'
	drop procedure archIsSubClientValidForSynthFull
END
IF EXISTS (select * from GxQscripts where name='archIsSubClientValidForSynthFull')
	delete from GxQscripts where name = 'archIsSubClientValidForSynthFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIsSubClientValidForSynthFull')
	delete from GXDBVersions where aliasname = 'archIsSubClientValidForSynthFull'
GO
print '... Creating Procedure: archIsSubClientValidForSynthFull'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archIsSubClientValidForSynthFull
  @i_appId integer,
  @i_reserveInt integer
AS
  DECLARE @o_retCode INTEGER;
  DECLARE @o_validStatus INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_retCode = 0
SET @o_validStatus = 1 --Last cycle is intact to run synthetic full
DECLARE @lastCycleNum int = 0
SELECT @lastCycleNum = ISNULL(CAST(attrval as Int), 0)
FROM APP_SubClientProp WITH(NOLOCK)
WHERE componentNameId = @i_appId and attrName = N'sys:full cycle num' and modified = 0
SET @o_retCode = @@ERROR
IF @o_retCode > 0 --DB Error. Return
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF @lastCycleNum = 0 --Full job has not been run for this subclient (or it has been run and we are missing the entry which is unexpected)
BEGIN
	SET @o_validStatus = 2
	GOTO RETURN_PROC
END
DECLARE @l_fullJobId INT = 0
DECLARE @l_fullJobCCId INT = 0
DECLARE @l_fullJobOpType INT = 0
/*Joining with JMJobDataStats to eliminate picking backup copy job or deferred catalog job. We have to pick a data bearing job*/
SELECT @l_fullJobId = JBKP.jobId, @l_fullJobCCId = JBKP.commcellId, @l_fullJobOpType = JBKP.opType
FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId
WHERE JBKP.appId = @i_appId and JBKP.fullCycleNum = @lastCycleNum AND JBKP.bkpLevel IN (1, 64, 128, 1024, 16384, 32768) --Full backup
AND JBKP.status IN(1, 3, 14)
IF NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK)
INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON JDS.archGrpCopyId = AGC.id AND AGC.isSnapCopy = 0
WHERE JDS.jobId = @l_fullJobId AND JDS.commcellId = @l_fullJobCCId AND JDS.status = 100 AND JDS.disabled & 256 = 0)
BEGIN
	IF (@l_fullJobOpType != 59) /*SNAPBACKUP = 59*/
		SET @o_validStatus = 3 --Full job has been aged
	ELSE IF EXISTS(SELECT 1 FROM JMJobSnapShotStats WITH(NOLOCK) WHERE jobId = @l_fullJobId AND commcellId = @l_fullJobCCId AND materializationStatus = 100)
		SET @o_validStatus = 5 --Full job has been backup copied and aged
ELSE IF NOT EXISTS(SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE jobId = @l_fullJobId AND commcellId = @l_fullJobCCId AND STATUS = 100 AND JDS.disabled & 256 = 0)
		SET @o_validStatus = 3 --Full snap job has not been backup copied and got aged in all copies
	ELSE
		SET @o_validStatus = 6 --Full job is snap and backup copy has not been run for the job
	GOTO RETURN_PROC
END
IF NOT EXISTS (SELECT 1 FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commCellId = JDS.commCellId
INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON JDS.archGrpCopyId = AGC.id AND AGC.isSnapCopy = 0
WHERE JBKP.appId = @i_appId AND JBKP.fullCycleNum = @lastCycleNum AND JBKP.bkpLevel IN (2, 4)
AND JDS.status = 100 AND JDS.disabled & 256 = 0 AND JDS.dataType = 1) /*Ignore log only backups*/
BEGIN
	SET @o_validStatus = 4 --No incremental or differential job ran after the last full job of the cycle
	GOTO RETURN_PROC
END
RETURN_PROC:
SELECT @o_retCode, @o_validStatus
GO

IF EXISTS (select * from GxQscripts where name = 'archIsSubClientValidForSynthFull')
	delete from GxQscripts where name = 'archIsSubClientValidForSynthFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIsSubClientValidForSynthFull')
	delete from GXDBVersions where aliasname = 'archIsSubClientValidForSynthFull'
GO

insert into GXDBVersions values(2, 'archIsSubClientValidForSynthFull',  '00010004005400040000', 'archIsSubClientValidForSynthFull', '00010004005400040000')
GO

