

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archIsDashDVSupported.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archIsDashDVSupported.sp,v $ $Id: archIsDashDVSupported.sp,v 1.1.2.6 2020/12/12 03:36:36 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archIsDashDVSupported')
BEGIN
	print '>>> Drop Stored Procedure: archIsDashDVSupported <<<'
	drop procedure archIsDashDVSupported
END
IF EXISTS (select * from GxQscripts where name='archIsDashDVSupported')
	delete from GxQscripts where name = 'archIsDashDVSupported'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIsDashDVSupported')
	delete from GXDBVersions where aliasname = 'archIsDashDVSupported'
GO
print '... Creating Procedure: archIsDashDVSupported'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archIsDashDVSupported
  @i_adminJobId BIGINT,
  @i_SIDBStoreId int,
  @i_policyId int,
  @i_copyId int
AS
  DECLARE @o_isDashDV2Supported int;
SET QUOTED_IDENTIFIER ON
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clientTable TABLE (ClientId INTEGER, PhysicalClientId INTEGER, ReleaseId INTEGER, SPMajor INTEGER, SPMinor INTEGER, DDBVerificationSupported INTEGER)
DECLARE @copyMountPathTable TABLE (archCopyId INTEGER, MountPathId INTEGER)
DECLARE @copyClientTable TABLE (archCopyId INTEGER, ClientId INTEGER)
DECLARE @l_srcMediaAgentId INTEGER = 0
SELECT  @l_srcMediaAgentId = ISNULL(VALUE,0)
FROM	dbo.GetAllJobOptions(@i_adminJobId)
WHERE	OptionId = 1564054677
IF @i_SIDBStoreId > 0
BEGIN
	INSERT INTO @copyMountPathTable(archCopyId, MountPathId)
	SELECT	DISTINCT S.archGroupCopyId,  MP.MountPathId
	FROM	MMVolume MV WITH (NOLOCK), archStream S WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	MV.SIDBStoreId = @i_SIDBStoreId
			AND MV.MediaGroupId = S.MediaGroupId
			AND MV.MediaSideId = MP.MediaSideId
	INSERT INTO @copyClientTable (archCopyId, ClientId)
	SELECT	DISTINCT CV.archCopyId, C.ClientId
	FROM	@copyMountPathTable CV, MMMountPathToStorageDevice SD WITH (NOLOCK), MMDeviceController C WITH (NOLOCK)
	WHERE	CV.MountPathId = SD.MountPathId
			AND SD.DeviceId = C.DeviceId AND (@l_srcMediaAgentId = 0 OR @l_srcMediaAgentId = C.ClientId)
	/* When we dont have any data written, lets fall back to MA on datapath*/
	IF NOT EXISTS (SELECT 1 FROM @copyClientTable)
	BEGIN
		INSERT INTO @copyClientTable
		SELECT DISTINCT dth.copyId, dp.ClientId
		FROM   archGroupCopy agc WITH (READUNCOMMITTED),MMDataPath dth WITH (READUNCOMMITTED), MMDrivePool dp WITH (READUNCOMMITTED)
		WHERE @i_policyId = AGC.archGroupId AND (@i_copyId = 0 OR @i_copyId = agc.ID)
					  AND AGC.id = dth.copyId AND dth.DrivePoolId = dp.drivePoolID AND (@l_srcMediaAgentId = 0 OR @l_srcMediaAgentId = dp.ClientId)
	END
END
ELSE
BEGIN
	INSERT INTO @copyClientTable
	SELECT DISTINCT dth.copyId, dp.ClientId
	FROM   archGroupCopy agc WITH (READUNCOMMITTED),MMDataPath dth WITH (READUNCOMMITTED), MMDrivePool dp WITH (READUNCOMMITTED)
	WHERE @i_policyId = AGC.archGroupId AND (@i_copyId = 0 OR @i_copyId = agc.ID)
				  AND AGC.id = dth.copyId AND dth.DrivePoolId = dp.drivePoolID AND (@l_srcMediaAgentId = 0 OR @l_srcMediaAgentId = dp.ClientId)
END
INSERT INTO @clientTable
SELECT DISTINCT ClientId, 0, 0, 0, 0, 0
FROM	@copyClientTable;
WITH ClientSPLevel AS (
        SELECT
            C.ClientId AS ClientId,
            CLIENT.ReleaseId AS ReleaseId,
            PKG.HighestSP AS SPMajor,
            PKG.SpMinorVersion AS SPMinor,
            ROW_NUMBER() OVER (PARTITION BY C.ClientId
            ORDER BY C.ClientId, CLIENT.ReleaseId, PKG.HighestSP, PKG.SpMinorVersion) AS RowNum
        FROM
			@clientTable C
			LEFT OUTER JOIN APP_VMToPMMap MAP WITH (NOLOCK) ON MAP.VMClientId = C.ClientId
			INNER JOIN SimInstalledPackages PKG WITH (NOLOCK) ON PKG.ClientId = ISNULL(MAP.PMClientId, C.ClientId)
			INNER JOIN APP_Client CLIENT WITH (NOLOCK) ON CLIENT.id = ISNULL(MAP.PMClientId, C.ClientId)
        WHERE
PKG.simPackageID in (51, 1301, 54, 1305))
UPDATE	@clientTable
SET		ReleaseId = SPL.ReleaseId,
		SPMajor = SPL.SPMajor,
		SPMinor = SPL.SPMinor
FROM	@clientTable C, ClientSPLevel SPL WITH (NOLOCK)
WHERE	SPL.RowNum = 1
		AND C.ClientId = SPL.ClientId
IF (@i_SIDBStoreId > 0 AND EXISTS ( SELECT 1 FROM @clientTable WHERE ReleaseId > 16 OR (ReleaseId = 16 AND SPMajor >= 22)))
	OR (@i_SIDBStoreId =  0 AND  EXISTS ( SELECT 1 FROM @clientTable WHERE ReleaseId > 15 ))
	SELECT 1
ELSE
	SELECT 0
GO
SET QUOTED_IDENTIFIER ON

IF EXISTS (select * from GxQscripts where name = 'archIsDashDVSupported')
	delete from GxQscripts where name = 'archIsDashDVSupported'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIsDashDVSupported')
	delete from GXDBVersions where aliasname = 'archIsDashDVSupported'
GO

insert into GXDBVersions values(2, 'archIsDashDVSupported',  '00010001000200060000', 'archIsDashDVSupported', '00010001000200060000')
GO

