

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archIsAuxCopyFallenBehindAlertEnabledForSp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: smekala
--	Date:   06/17/2013
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archIsAuxCopyFallenBehindAlertEnabledForSp.sp,v $ $Id: archIsAuxCopyFallenBehindAlertEnabledForSp.sp,v 1.10.12.3 2018/03/20 19:47:19 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archIsAuxCopyFallenBehindAlertEnabledForSp <<<'

IF EXISTS (select * from sysobjects where name='archIsAuxCopyFallenBehindAlertEnabledForSp')
	drop procedure archIsAuxCopyFallenBehindAlertEnabledForSp
IF EXISTS (select * from GxQscripts where name='archIsAuxCopyFallenBehindAlertEnabledForSp')
	delete from GxQscripts where name = 'archIsAuxCopyFallenBehindAlertEnabledForSp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIsAuxCopyFallenBehindAlertEnabledForSp')
	delete from GXDBVersions where aliasname = 'archIsAuxCopyFallenBehindAlertEnabledForSp'
GO
print '... Creating Procedure: archIsAuxCopyFallenBehindAlertEnabledForSp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archIsAuxCopyFallenBehindAlertEnabledForSp
  @i_xmlText XML
AS
  DECLARE @o_XMLText XML
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @isAllowed INT
DECLARE @targetSpId INT
DECLARE @configParam INT
DECLARE @errorCode INT
DECLARE @errorMessage Nvarchar(1048)
set @targetSpId  = ISNULL(( SELECT ref.value('@spId', 'INT')  FROM @i_xmlText.nodes ('App_CheckStoragePolicyAssociationToSubclientReq') R(ref)),0)
set @configParam  = ISNULL(( SELECT ref.value('@configParam', 'INT')  FROM @i_xmlText.nodes ('App_CheckStoragePolicyAssociationToSubclientReq') R(ref)),0)
IF (@configParam <= 0)
	SET @configParam = 3
SET @isAllowed=1
DECLARE  @auxCopyStats  table (idx INT identity(1,1), spId INT, copyId INT, toBeCopiedDataInBytes BIGINT, oldestJobEndDate INT, hoursForCopy INT )
DECLARE @tblAGC1 TABLE (archCopyId INT, archGroupId INT, commCellId INT, sourceCopyId INT)
DECLARE @tblAGC2 TABLE (archCopyId INT, archGroupId INT, oldestJobEndTime INT, toBeCopiedBytes BIGINT, thPut BIGINT)
IF (OBJECT_ID('tempdb.dbo.#tblJobDataType') IS NOT NULL) DROP TABLE #tblJobDataType
CREATE TABLE #tblJobDataType (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT, status INT, toBeCopiedBytes BIGINT, toBeCopiedPhysicalBytes BIGINT
					PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
IF (OBJECT_ID('tempdb.dbo.#tblJob') IS NOT NULL) DROP TABLE #tblJob
CREATE TABLE #tblJob (jobId INT, commCellId INT, archGrpCopyId INT, jobEndTime INT, toBeCopiedBytes BIGINT, toBeCopiedPhysicalBytes BIGINT
					PRIMARY KEY (jobId, commCellId, archGrpCopyId))
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo (
    JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
    PRIMARY KEY (JobId, CommCellId))
DECLARE @lastAuxJobs TABLE( archCopyId INT, jobId INT, bytesCopied BIGINT, writeTime INT)
DECLARE @l_now	INT
DECLARE @l_lastjobs INT = 10
DECLARE @l_REAL FLOAT
DECLARE @counter INT
DECLARE @maxCounter INT = 0
SET @l_REAL = 1.0
SET @l_now = dbo.GetUnixTime(GETDATE())
SET @counter = 1
--Minimum to be copied from MMConfig table
SELECT @l_lastjobs = ISNULL(value,10)
FROM MMConfigs  WITH (NOLOCK)
WHERE name = 'MMCONFIG_AUXCOPY_FALLEN_BEHIND_ALERT_NUMBER_OF_JOBS_FOR_THROUGHPUT'
-- Please refer archAuxCopyFallenBehindAlert.sp stored procedure for to be copied data logic.
INSERT INTO @tblAGC1
SELECT AGC.id , AGC.archGroupId, CASE WHEN AGC.origCCcommCellID = 0 THEN 2 ELSE AGC.origCCcommCellID END,   CASE WHEN AGC.sourceCopyId <> 0 THEN AGC.sourceCopyId ELSE AG.defaultCopy END
FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK), MMEntityProp MMEP WITH (NOLOCK)
WHERE AGC.archGroupId = AG.id AND AGC.id <> AG.defaultCopy  AND AGC.type  <> 5
AND AGC.archGroupId = @targetSpId
AND MMEP.EntityId = AGC.id
AND MMEP.EntityType = 2
AND MMEP.propertyName = 'auxCopyAlertEnabled'
AND MMEP.intVal = 1
INSERT #tblJobDataType
SELECT JD.jobId, JD.commCellId, JD.archGrpCopyId, JD.dataType, JD.status, 0, 0
FROM JMJobDataStats JD WITH (NOLOCK), JMJobDataStats JS WITH (NOLOCK), @tblAGC1 AGC
WHERE  JD.archGrpId = JS.archGrpId
	AND JD.jobId = JS.jobId
	AND JD.dataType = JS.dataType
	AND JD.commCellId = JS.commCellId
AND (JS.disabled & (1  + 256) = 0)
AND (JD.disabled & (1  + 256) = 0)
	AND JS.status = 100
	AND JD.status IN (101,102,103)
	AND JD.archGrpCopyId = AGC.archCopyId
	AND JS.archGrpCopyId = AGC.sourceCopyId
-- Populating UnCompSize and physicalSize for each Job data type from source copy
UPDATE	JT
SET		JT.toBeCopiedBytes = JS.UnCompSize, JT.toBeCopiedPhysicalBytes = JS.physicalSize
FROM	#tblJobDataType JT, ( SELECT J.archGrpCopyId, J.commCellId, J.jobId, J.dataType, CASE WHEN MIN(ACM.unCompSize) <= 0 THEN -1 ELSE SUM(ACM.unCompSize) END UnCompSize, SUM(physicalSize) physicalSize
FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), #tblJobDataType J, @tblAGC1 AGC
WHERE ACM.archFileId = AF.id
	AND ACM.commCellId = AF.commcellId
	AND ACM.jobId = AF.jobId
	AND ACM.commCellId = AF.commCellId
	 AND AF.jobId = J.jobId
	 AND AF.commCellId =  J.commCellId
	 AND  AF.fileType = J.dataType
	  AND J.archGrpCopyId = AGC.archCopyId
	  AND ACM.archCopyId = AGC.sourceCopyId
	  AND AF.isvalid = 1
	GROUP BY J.archGrpCopyId, J.jobId, J.commCellId, J.dataType ) JS
WHERE JT.jobId = JS.jobId
	AND JT.commCellId = JS.commCellId
	AND JT.dataType = JS.dataType
	AND JT.archGrpCopyId = JS.archGrpCopyId
UPDATE	JT
SET JT.toBeCopiedBytes =  CASE WHEN JT.toBeCopiedBytes = -1 OR ISNULL(S.UnCompCopiedBytes,0) = -1 THEN -1 ELSE JT.toBeCopiedBytes - ISNULL(S.UnCompCopiedBytes,0) END , JT.toBeCopiedPhysicalBytes = JT.toBeCopiedPhysicalBytes - ISNULL(S.physicalCopiedBytes, 0)
FROM #tblJobDataType JT
   LEFT OUTER JOIN
		(SELECT	J.JobId, J.commCellId, J.archGrpCopyId, J.dataType, CASE WHEN MIN(ACM.unCompSize) <= 0 THEN -1 ELSE SUM(ACM.unCompSize) END UnCompCopiedBytes, SUM(ACM.physicalSize) physicalCopiedBytes
		FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), #tblJobDataType J
		WHERE ACM.archFileId = AF.Id
			AND ACM.commCellId = AF.commCellId
			AND AF.jobId = J.jobId
			AND AF.fileType  = J.dataType
			AND ACM.archCopyId = J.archGrpCopyId
			AND ACM.commCellId = J.commCellId
		    AND J.status <> 101
		GROUP BY J.JobId, J.commCellId, J.archGrpCopyId, J.dataType) S
  ON JT.jobId = S.jobId
	AND JT.commCellId = S.commCellId
	AND JT.archGrpCopyId = S.archGrpCopyId
	AND JT.dataType = S.dataType
INSERT #tblJob
SELECT	jobId, commCellId, archGrpCopyId, 0 'jobEndTime', CASE WHEN MIN(J.toBeCopiedBytes) <= 0 THEN -1 ELSE SUM(J.toBeCopiedBytes) END, SUM(J.toBeCopiedPhysicalBytes)
FROM #tblJobDataType J
GROUP BY archGrpCopyId, jobId, commCellId
UPDATE	J
SET		J.jobEndTime = B.servEndDate
FROM	#tblJob J, JMBkpStats B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
UPDATE	J
SET		J.jobEndTime = B.servEnd
FROM	#tblJob J, JMadminJobStatsTable B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
INSERT #tmpJobSizeInfo
SELECT DISTINCT jobId, commCellId, 0, 0, 0 FROM  #tblJob
WHERE toBeCopiedBytes <= 0
EXEC archGetJobSizeInfo 0
UPDATE T
SET T.toBeCopiedBytes = CASE WHEN TS.totalBackupSize > 0 THEN  T.toBeCopiedPhysicalBytes*1.00*(TS.totalAppSize + TS.totalIndexSize)/TS.totalBackupSize ELSE (TS.totalAppSize + TS.totalIndexSize) END
FROM #tblJob T , #tmpJobSizeInfo TS
WHERE T.jobId = TS.JobId AND T.commCellId = TS.CommCellId
	AND toBeCopiedBytes <= 0
INSERT @lastAuxJobs
SELECT RN.archGrpCopyId, RN.jobId, RN.BytesXferred,  RN.totalWriteTime*@l_REAL*RN.BytesXferred/ RN.EX_TotalSuccess
FROM   @tblAGC1 A
		CROSS APPLY
	(SELECT TOP(@l_lastjobs) J.*, JA.totalWriteTime, JA.EX_TotalSuccess
	 FROM JMDataCopiedStatsTable J WITH (NOLOCK), JMAdminJobStatsTable JA WITH (NOLOCK)
	 WHERE J.archGrpCopyId = A.archCopyId
		AND J.jobId = JA.jobId
		AND JA.commCellId = J.commCellId
		AND J.commCellId = A.commCellId
		AND JA.opType IN (13, 104)
		AND JA.EX_TotalSuccess > 0
    ORDER BY J.jobId DESC) RN
INSERT @lastAuxJobs
SELECT J.archGrpCopyId, J.jobId, J.BytesXferred, elapsedTime*@l_REAL*J.BytesXferred/RAJ.ObjectsDone
FROM JMDataCopiedStatsTable J WITH (NOLOCK), @tblAGC1 A, RunningAdminJobs RAJ WITH (NOLOCK), @lastAuxJobs LA
WHERE J.jobId = RAJ.jobId
	AND J.commCellId = RAJ.commCellId
	AND A.archCopyId = J.archGrpCopyId
	AND RAJ.opType IN (13, 104)
	AND RAJ.ObjectsDone > 0
	AND J.archGrpCopyId NOT IN (SELECT DISTINCT archCopyId FROM @lastAuxJobs)
INSERT INTO @tblAGC2
SELECT J.archGrpCopyId, AG.archGroupId, J.jobEndTime, J.toBeCopiedBytes,
(CASE WHEN TP.wTime > 0 THEN  TP.BytesTransfer / TP.wTime ELSE  0 END)
FROM @tblAGC1 AG
JOIN (SELECT archGrpCopyId, COUNT(jobId) as numofToBeCopiedJobs, MIN(jobEndTime) as jobEndTime, SUM(toBeCopiedBytes) as toBeCopiedBytes
	FROM #tblJob GROUP BY archGrpCopyId) J
	ON AG.archCopyid = J.archGrpCopyId
LEFT OUTER JOIN
( SELECT archCopyId, SUM(bytesCopied) BytesTransfer, SUM(writeTime) wTime
FROM @lastAuxJobs
GROUP BY archCopyId ) TP
ON  AG.archCopyId = TP.archCopyId
INSERT INTO @auxCopyStats
SELECT	T.archgroupId, T.archCopyId, T.toBeCopiedBytes, T.oldestJobEndTime, (CASE WHEN T.thPut  <> 0 THEN ROUND((T.toBeCopiedBytes*@l_REAL/T.thPut/3600),0) ELSE 0 END)
FROM	@tblAGC2 T
WHERE T.archGroupId = @targetSpId
SELECT @maxCounter = MAX(idx)
FROM @auxCopyStats
WHILE(@counter <= @maxCounter)
BEGIN
	DECLARE @copyId INT
	SELECT @copyId = copyId FROM @auxCopyStats WHERE idx = @counter
	DECLARE  @toUserBytes BIGINT
	SET @toUserBytes=  (SELECT longlongVal*1024*1024*1024*1024 FROM MMEntityProp WHERE EntityId = @copyId AND EntityType=2 AND propertyName = 'AuxCopyAlertGB')
	DECLARE  @toBecopiedBytes BIGINT
	SET @toBecopiedBytes=  (SELECT toBeCopiedDataInBytes FROM @auxCopyStats WHERE copyId = @copyId)
	DECLARE  @hoursSetByUser INT
	SET @hoursSetByUser =(SELECT intVal FROM MMEntityProp WHERE EntityId = @copyId AND EntityType=2 AND propertyName ='AuxCopyAlertHours')
	DECLARE  @actualHoursForCopy INT
	SET  @actualHoursForCopy =  (SELECT hoursForCopy FROM @auxCopyStats WHERE copyId = @copyId)
	DECLARE  @daysSetByUser INT
	SET @daysSetByUser =  (SELECT intVal from MMEntityProp WHERE EntityId = @copyId AND EntityType=2 AND propertyName ='AuxCopyAlertDays')
	DECLARE @curTimeinsecs INT
	SET @curTimeinsecs = @l_now
	DECLARE @jobEndTimeinsecs INT
	SET @jobEndTimeinsecs = (SELECT oldestJobEndDate FROM @auxCopyStats WHERE copyId = @copyId)
	DECLARE @daysSinceLastJobRan INT
	SET @daysSinceLastJobRan =  ( (@curTimeinsecs  - @jobEndTimeinsecs )/(60*60*24) )
	IF (
		(@toBecopiedBytes > 0 AND @toUserBytes > 0 AND  (@toBecopiedBytes > @configParam*@toUserBytes )) OR
		( @actualHoursForCopy > 0 AND @hoursSetByUser > 0 AND  ( @actualHoursForCopy > @configParam * @hoursSetByUser )) OR
		( @daysSinceLastJobRan > 0 AND @daysSetByUser > 0 AND ( @daysSinceLastJobRan  > @configParam  *  @daysSetByUser ))
		 )
	BEGIN
		SET @isAllowed=0
		BREAK
	END
	SET @counter = @counter + 1
END
IF (OBJECT_ID('tempdb.dbo.#tblJobDataType') IS NOT NULL) DROP TABLE #tblJobDataType
IF (OBJECT_ID('tempdb.dbo.#tblJob') IS NOT NULL) DROP TABLE #tblJob
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
SET @o_XMLText = ( SELECT    @isAllowed             as isAllowed,
                                     @errorCode      as  errorCode,
                                      @errorMessage    as errorMessage
                                      FOR XML PATH(''), ROOT ('App_CheckStoragePolicyAssociationToSubclientResp')
                              );
      select @o_XMLText
GO

IF EXISTS (select * from GxQscripts where name = 'archIsAuxCopyFallenBehindAlertEnabledForSp')
	delete from GxQscripts where name = 'archIsAuxCopyFallenBehindAlertEnabledForSp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIsAuxCopyFallenBehindAlertEnabledForSp')
	delete from GXDBVersions where aliasname = 'archIsAuxCopyFallenBehindAlertEnabledForSp'
GO

insert into GXDBVersions values(2, 'archIsAuxCopyFallenBehindAlertEnabledForSp',  '00010010001200030000', 'archIsAuxCopyFallenBehindAlertEnabledForSp', '00010010001200030000')
GO

