

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archInlineCopyForApp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archInlineCopyForApp.sp,v $ $Id: archInlineCopyForApp.sp,v 1.12.48.15 2020/04/29 17:19:08 chandru Exp $";
--
--  +========================================================================+
--  |      Cursor:  archInlineCopyForApp
--  |
--  | Description:  Retrieves the jobs for an appId on a copy in desc order.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archInlineCopyForApp')
BEGIN
	print '>>> Drop Stored Procedure: archInlineCopyForApp <<<'
	drop procedure archInlineCopyForApp
END
IF EXISTS (select * from GxQscripts where name='archInlineCopyForApp')
	delete from GxQscripts where name = 'archInlineCopyForApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archInlineCopyForApp')
	delete from GXDBVersions where aliasname = 'archInlineCopyForApp'
GO
print '... Creating Procedure: archInlineCopyForApp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archInlineCopyForApp
  @i_appId integer,
  @i_backupLevel integer,
  @i_archGroupId integer,
  @i_today integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archCopyId integer
  DECLARE @o_flags integer
  DECLARE @o_selectionType integer
-- These lines represent the actual SQL code that will get executed.
--		FETCH ALL THE ALERT ACTION ROWS FOR WHICH THERE IS A USER ASSOCIATION
--		--------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @i_commCellId   INTEGER
SET @i_commCellId = 2
DECLARE @t_clientId 	INTEGER
DECLARE @t_appType 		INTEGER
DECLARE @t_lastCycleNum	INTEGER
DECLARE @t_backupSetId	INTEGER
DECLARE	@l_startDate	INT
SET		@l_startDate	= dbo.GetUnixTime(GETUTCDATE())
DECLARE @CountPartialSuccess INT
SET		@CountPartialSuccess = 1
DECLARE @l_rowCount INTEGER = 0
/*
DECLARE @isEdgeDriveSubClient INT = 0
DECLARE @isLogCmdLineSubclient INT = 0
SELECT @isEdgeDriveSubClient = CASE WHEN subclientStatus & 0x20000 = 0x20000 THEN 1 ELSE 0 END,
@isLogCmdLineSubclient = CASE WHEN subclientStatus & 0x1000 = 0x1000 THEN 1 ELSE 0 END
FROM App_Application WITH(NOLOCK) WHERE id = @i_appId
*/
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
	DROP TABLE #tmpAppIdList
CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
INSERT INTO #tmpAppIdList
SELECT @i_appId, 0, 0, 0, 0
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0) primary key 	(copyId))
--Set unsupported flag
EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
IF object_id('tempdb.dbo.#tempCopy') IS NOT NULL DROP TABLE #tempCopy
CREATE TABLE #tempCopy(archGroupId int, copyId int, type int, startTime int, flags int, SIDBStoreId int, extendedFlags BIGINT,
                       selectionType int, numPeriod int, dayNumber int, startPeriod int, nextPeriod int, prevPeriodBegin int, nextPeriodEnd int)
SELECT @t_clientId = clientId, @t_appType = appTypeId, @t_backupSetId = backupSet
FROM   APP_Application WITH (NOLOCK)
WHERE  id = @i_appId
SELECT	@CountPartialSuccess = isCWEjobValid
FROM	APP_iDAType WITH (NOLOCK)
WHERE	type = @t_appType
-- Ignore unSupportedAlways for VSA V2 parent subclient, as reservation is made on parent subclient job during backup.
UPDATE	T
SET		unSupportedAlways = 0
FROM	#tmpAppIdList T WITH (NOLOCK)
		JOIN APP_Application A WITH (NOLOCK) ON T.AppId = A.id
		JOIN APP_InstanceProp IPROP (NOLOCK) ON IPROP.componentNameId = A.instance AND IPROP.attrName = 'Virtual Server Instance Type'  AND IPROP.attrVal <> '' AND IPROP.modified = 0
		JOIN APP_ClientProp (NOLOCK) CP ON CP.componentNameId = A.clientId AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1' -- Indexing V2
WHERE	appId = @i_appId
		AND unSupportedAlways = 1
-- For DDB Backups do not insert into any destination copy for auxcopy
IF EXISTS (	SELECT	*
			FROM	#tmpAppIdList WITH (NOLOCK)
			WHERE	appId = @i_appId
					AND unSupportedAlways = 1)
	GOTO FINISH
DECLARE @isIndexSubclient INT = 0
DECLARE @l_checkSumIndexSubclient INT = CHECKSUM(N'Index SubClient')
SELECT @isIndexSubclient = 1 FROM
App_SubclientProp WITH(NOLOCK) WHERE componentNameId = @i_appId AND cs_attrName = @l_checkSumIndexSubclient
AND attrName = 'Index SubClient' AND attrVal = N'1' AND modified = 0
INSERT INTO #tempCopy
SELECT archGroupId, id, type, startTime, flags, 0, A.extendedFlags, 0, 0, 0, 0, 0, 0, 0
FROM   archGroupCopy A WITH (NOLOCK), #tmpAppIdList T
WHERE  archGroupId = @i_archGroupId AND isActive = 1 AND startTime <= @i_today AND endTime > @i_today
AND (flags & 1024) <> 0 AND (flags & 8192) = 0
AND ((type IN (1, 4) OR @isIndexSubclient = 1)
OR type = 2 AND ((@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768) OR dbo.GetBkpLevelForSnapCopy(@i_appId, @i_backupLevel, A.id) = 1)
		   AND T.unSupportedOnSelAlways = 0
		   -- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle, SAP, Informix and DB2
		   AND (@t_appType NOT IN (2, 3, 22, 23, 37, 61, 62, 79, 80) OR @i_backupLevel IN (1024, 32768))
		   -- Take jobs only from the default subclient for SQL iDAs
		   )
		   )
IF(@isIndexSubclient = 1)
BEGIN
    --If this is index subclient job treat selective copies as synchronous copy. Manual selective still stays as manual selective copy unless a config param is set
	DECLARE @pickIndexBackupToManualSelectiveCopy INT = 0
	SELECT @pickIndexBackupToManualSelectiveCopy = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'AUXCOPY_AUTOPICK_INDEXBACKUPS_ON_MANUAL_SELECTION_COPIES'
	UPDATE #tempCopy
SET		type = CASE WHEN B.type IN (9,8) AND @pickIndexBackupToManualSelectiveCopy = 0 THEN 2 ELSE 1 END
	FROM   #tempCopy A INNER JOIN archSelectiveCopy B WITH (NOLOCK) ON A.copyId = B.copyId
WHERE A.type = 2
END
IF ((@i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND
(EXISTS (SELECT 1 FROM archGroupCopy WITH (NOLOCK) where archGroupId = @i_archGroupId AND type = 2 AND ID IN (SELECT EntityId FROM MMEntityProp WITH (NOLOCK) WHERE propertyName = 'JobSelectionType' AND EntityType = 2 AND propDataType = 1 AND intVal <> 0)))))
BEGIN
	--Find full job id
	DECLARE @FullJobId INTEGER
	DECLARE @defCopyId INTEGER
	DECLARE @defSnapCopyId INTEGER = 0
	DECLARE @agroupType INTEGER
	DECLARE @agroupFlags INTEGER
	SELECT @t_lastCycleNum = ISNULL(MAX(fullCycleNum), 0)
	FROM   JMBkpStats WITH (NOLOCK)
	WHERE  appId = @i_appId AND commCellId = @i_commCellId
	  AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
	  AND bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
	  -- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle, SAP, Informix and DB2
	  -- Not used any more CV_APPTYPE_ORACLE, CV_APPTYPE_ORACLE8I
AND (@t_appType NOT IN (2, 22, 23, 80,
61, 79) OR bkpLevel IN (1024, 32768))
	SELECT @l_rowCount = @@ROWCOUNT
	IF @l_rowCount = 0 AND @t_appType = 1000
		SELECT @t_lastCycleNum = ISNULL(MAX(fullCycleNum), 0)
		FROM   JMAdminJobStatsTable WITH (NOLOCK)
		WHERE  appId = @i_appId AND commCellId = @i_commCellId
		  AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
		  AND ER_BkpLevel IN (1, 64, 128, 16384, 1024, 32768)
		  AND opType = 11 -- enum CVOpType{ CSDRBKP = 11
	SELECT @FullJobId = MAX(jobId)
	FROM JMBkpStats JBS WITH (NOLOCK)
	WHERE
	JBS.BkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND
	JBS.cycleSequence = 1 AND
	JBS.fullCycleNum = @t_lastCycleNum AND
	JBS.appId = @i_appId AND
	JBS.commcellId = @i_commCellId
	SELECT @l_rowCount = @@ROWCOUNT
	IF @l_rowCount = 0 AND @t_appType = 1000
		SELECT @FullJobId = MAX(jobId)
		FROM JMAdminJobStatsTable JBS WITH (NOLOCK)
		WHERE
		JBS.ER_BkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND
		JBS.fullCycleNum = @t_lastCycleNum AND
		JBS.appId = @i_appId AND
		JBS.commcellId = @i_commCellId AND
		JBS.opType = 11 -- enum CVOpType{ CSDRBKP = 11
	INSERT INTO #tempCopy
		SELECT A.archGroupId, A.id, A.type, A.startTime, A.flags, 0, A.extendedFlags, 0, 0, 0, 0, 0, 0, 0
		FROM   archGroupCopy A WITH (NOLOCK), MMEntityProp M
		WHERE
		M.EntityId = A.id
		AND M.propertyName = 'JobSelectionType'
AND M.propDataType = 1
		AND archGroupId = @i_archGroupId AND isActive = 1 AND startTime <= @i_today AND endTime > @i_today
AND (flags & 1024) <> 0 AND (flags & 8192) = 0
		AND NOT EXISTS (SELECT 1 from #tempCopy where copyId = A.id)
AND EXISTS (select 1 FROM JMJobDataStats JDS WITH (NOLOCK) WHERE jobid = @FullJobId and appId = @i_appId and commcellId = @i_commCellId and archgrpCopyId = A.id AND (JDS.disabled & (1 + 256)) = 0)
AND (type = 2 AND ( (M.intVal = 1 AND ((@i_backupLevel & 4) <> 0 )) OR (M.intVal = 2 and (@i_backupLevel not in (1, 64, 128, 16384, 1024, 32768)))))
END
UPDATE	TC
SET		SIDBStoreId = CSD.SIDBStoreID
FROM	#tempCopy TC, archSubclientCopyDDBMap CSD
WHERE	TC.copyId = CSD.copyId
		AND CSD.appId = @i_appId
UPDATE	#tempCopy SET selectionType=B.type, numPeriod=B.numPeriod, dayNumber=B.dayNumber,
		startPeriod=B.startPeriod, nextPeriod=B.nextPeriod, prevPeriodBegin=B.prevPeriodBegin, nextPeriodEnd=B.nextPeriodEnd
FROM	#tempCopy A, archSelectiveCopy B WITH (NOLOCK)
WHERE	A.type = 2 AND A.copyId = B.copyId
DELETE	#tempCopy
WHERE	selectionType IN (8, 9)
OR	selectionType IN (10, 3, 2, 4, 6)
AND (flags & (4096|8192)) = (4096|8192)
IF	(@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768)
		AND EXISTS (SELECT * FROM #tempCopy
WHERE selectionType IN (1, 10, 3, 2, 4, 6)))
	OR
		EXISTS (SELECT * FROM #tempCopy WHERE dbo.GetBkpLevelForSnapCopy(@i_appId, @i_backupLevel, CopyId) = 1
AND selectionType IN (10, 3, 2, 4, 6))
BEGIN
	CREATE	TABLE #tempLastJob (archGrpCopyId int, jobId int, startDate int, fullCycleNum int)
IF	EXISTS (SELECT * FROM #tempCopy WHERE selectionType = 1)
	BEGIN
		SELECT @t_lastCycleNum = ISNULL(MAX(fullCycleNum), 0)
		FROM   JMBkpStats WITH (NOLOCK)
		WHERE  appId = @i_appId AND commCellId = @i_commCellId
		  AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
		  AND bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
		  -- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle, SAP, Informix and DB2
		  AND (@t_appType NOT IN (2, 3, 22, 23, 37, 61, 62, 80) OR bkpLevel IN (1024, 32768))
	   	SELECT @l_rowCount = @@ROWCOUNT
	   	IF @l_rowCount = 0 AND @t_appType = 1000
			SELECT @t_lastCycleNum = ISNULL(MAX(fullCycleNum), 0)
			FROM   JMAdminJobStatsTable WITH (NOLOCK)
			WHERE  appId = @i_appId AND commCellId = @i_commCellId
			  AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
			  AND ER_BkpLevel IN (1, 64, 128, 16384, 1024, 32768)
			  AND opType = 11 -- enum CVOpType{ CSDRBKP = 11
	END
	INSERT	INTO #tempLastJob
	SELECT	archGrpCopyId, MAX(jobId), 0, 0
	FROM	JMJobDataStats WITH (NOLOCK)
	WHERE	appId = @i_appId AND commCellId = @i_commCellId
		--AND archGrpCopyId IN (SELECT copyId FROM #tempCopy WHERE type = CVA_AGCOPYTYPE_SPARSE)
AND archGrpCopyId IN (SELECT id FROM archGroupCopy WITH(NOLOCK) WHERE type = 2 AND archGroupId = @i_archGroupId)
		AND status >= 100
	GROUP BY archGrpCopyId
	UPDATE	#tempLastJob
	SET		startDate = J.servStartDate, fullCycleNum = J.fullCycleNum
	FROM	JMBkpStats J WITH (NOLOCK)
	WHERE	#tempLastJob.jobId = J.jobId AND J.commCellId = @i_commCellId
	IF EXISTS(SELECT 1 FROM #tempLastJob WHERE startDate = 0) AND @t_appType = 1000
	BEGIN
		UPDATE	#tempLastJob
		SET		startDate = J.servStart, fullCycleNum = J.fullCycleNum
		FROM	JMAdminJobStatsTable J WITH (NOLOCK)
		WHERE	#tempLastJob.jobId = J.jobId AND J.commCellId = @i_commCellId AND J.opType = 11 -- enum CVOpType{ CSDRBKP = 11
	END
	DELETE	#tempCopy
	FROM	#tempCopy A
	WHERE
(A.selectionType = 1 AND A.type = 2 AND (A.numPeriod <> 1) AND
(((A.flags & 4096) = 0 AND ((@t_lastCycleNum+1) % A.numPeriod) <> 1) OR ((A.flags & 4096) <> 0 AND ((@t_lastCycleNum+1) % A.numPeriod) <> 0)))
IF	EXISTS (SELECT * FROM #tempCopy WHERE selectionType IN (10, 3, 2, 4, 6))
	BEGIN
		DECLARE @l_TimeZone	VARCHAR(255)
		SET		@l_TimeZone = dbo.ArchGroupTimeZone(@i_archGroupId, @t_clientId)
		IF	@l_TimeZone <> ''
		BEGIN
			DECLARE @l_csTimeZone	VARCHAR(255)
			SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
			IF	@l_TimeZone <> @l_csTimeZone
			BEGIN
				SET	@l_startDate = @l_startDate + dbo.GetDiffFromCSTimeZone(@l_startDate, @l_TimeZone, @l_csTimeZone)
				UPDATE	#tempLastJob
				SET	startDate = startDate + dbo.GetDiffFromCSTimeZone(startDate, @l_TimeZone, @l_csTimeZone)
			END
		END
		--If option set to avoid duplicates among selective copies do not copy when there is any selective copy which has a job copied in this period already and the copy is for first full
IF EXISTS(SELECT 1 FROM ArchGroup WITH(NOLOCK) WHERE id = @i_archGroupId AND flags & 4194304 > 0)
			DELETE	#tempCopy
			FROM	#tempCopy A, #tempLastJob B	WHERE
A.selectionType IN (10, 3, 2, 4, 6)
			AND (   @l_startDate <  A.startPeriod		AND B.StartDate >= A.prevPeriodBegin
				OR @l_startDate >= A.startPeriod	AND B.StartDate >= A.startPeriod	AND @l_startDate < A.nextPeriod
				OR @l_startDate >= A.nextPeriod		AND B.StartDate >= A.nextPeriod	)
			AND
			(A.copyId = B.archGrpCopyId OR
				(
B.archGrpCopyId IN(SELECT copyId FROM archSelectiveCopy WITH(NOLOCK) WHERE type IN (10, 3, 2, 4, 6))
				AND (
(A.flags & 4096 = 0 AND B.StartDate <= @l_startDate)
						OR
(A.flags & 4096 > 0 AND B.StartDate >= @l_startDate)
					)
				)
			)
		ELSE
			DELETE	#tempCopy
			FROM	#tempCopy A, #tempLastJob B
WHERE	A.copyId = B.archGrpCopyId AND A.selectionType IN (10, 3, 2, 4, 6)
				AND (  @l_startDate <  A.startPeriod AND B.startDate >= A.prevPeriodBegin
					OR @l_startDate >= A.startPeriod AND B.startDate >= A.startPeriod AND @l_startDate < A.nextPeriod
					OR @l_startDate >= A.nextPeriod  AND B.startDate >= A.nextPeriod  )
		DECLARE	@nextFullTime	INT
		DECLARE	@tblNextFullTime TABLE (nextFullTime int)
		INSERT	INTO @tblNextFullTime
		EXEC	@nextFullTime = TM_GetNextScheduleRunTime @i_appId, 1/*BkpLevel Full*/, 1/*counDisabled*/, 0/*countRunnigJob*/
		IF	@nextFullTime > 0
			DELETE	#tempCopy
WHERE	selectionType IN (10, 3, 2, 4, 6)
AND (flags & (4096|8192)) = 4096
				AND (  @l_startDate <  startPeriod AND @nextFullTime <  startPeriod
					OR @l_startDate <  nextPeriod  AND @nextFullTime <  nextPeriod AND @l_startDate  >= startPeriod
					OR @l_startDate >= nextPeriod  AND @nextFullTime >= nextPeriod AND @nextFullTime <  nextPeriodEnd)
	END
	DROP TABLE #tempLastJob
END
INSERT INTO #copyIdToProcess(copyId)
SELECT DISTINCT copyId
FROM #tempCopy t
WHERE EXISTS (SELECT 1 FROM ArchCopyToApp A WITH (READUNCOMMITTED) WHERE A.copyId = t.copyId AND assocType <> 2)
INSERT INTO #archCopyToAppId
SELECT DISTINCT copyId, @i_appId
FROM #copyIdToProcess
EXEC archGetArchCopyToAppAssociations 0
DELETE #tempCopy
FROM   #tempCopy A INNER JOIN #copyIdToProcess C ON C.copyId = A.copyId LEFT JOIN #archCopyToAppId B WITH (NOLOCK) ON A.copyId = B.copyId
		AND B.appId = @i_appId
WHERE   B.appID IS NULL
-- Inline copy during SILO backup is supportted only for the SILO subset copy
IF EXISTS (SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND siloAppId = @i_appId)
BEGIN
	DELETE #tempCopy
	FROM   #tempCopy A LEFT OUTER JOIN archCopyToApp B WITH (NOLOCK)	-- do we need to change this?
		ON A.copyId = B.copyId AND B.backupSetId = @t_backupSetId
WHERE  ((A.extendedFlags& 1048576 = 0 AND B.copyId Is Null) OR (A.extendedFlags& 1048576 > 0 AND B.copyId Is NOT Null))
	GOTO FINISH
END
-- Filter out single-instanced inline copies if data will be encrypted with user defined pass phrase.
-- It is fine if primary copy is single instanced because the pass phrase will not be used to encrypt the key.
IF	EXISTS (SELECT copyId FROM #tempCopy WHERE SIDBStoreId > 0)
	AND
	EXISTS (SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE SIDBStoreId = 0 AND id =
			(SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId))
BEGIN
	IF object_id('tempdb.dbo.#EncProps') IS NOT NULL DROP TABLE #EncProps
	CREATE	TABLE #EncProps (
			clientId int, appTypeId int, encryption int, restoreAccess int, drToolAccess int, subclientEnc int,
			encType int, encKeyLen int, SIDBStoreId int, RSAPubKey varchar(1024), RSAPriKeyBPF varchar(1024), RSAPriKeyUPF varchar(1024),
			companyId int, companyGUID uniqueidentifier)
	DECLARE	@l_copyId int
	SELECT	TOP 1 @l_copyId = copyId FROM #tempCopy WHERE SIDBStoreId > 0
	INSERT	INTO #EncProps
	EXEC	archBackupEncryptionInfo @i_appId, @l_copyId
	IF	EXISTS (SELECT * FROM #EncProps WHERE encryption > 0 AND drToolAccess = 1)
		DELETE FROM #tempCopy WHERE SIDBStoreId > 0
	DROP TABLE #EncProps
END
FINISH:
/*
-- For DDB Backups do not return any destination copies
IF EXISTS (	SELECT	*
			FROM	APP_SubClientProp
			WHERE	componentNameId = @i_appId
					AND attrName = 'DDB Backup'
						AND attrVal = N'1'
						AND modified = 0)
	AND (@l_SelectDDBBackupJobForAuxCopy = 0)
BEGIN
	DELETE	#tempCopy
	FROM	#tempCopy T, archGroupCopy AGC, archGroup AG
	WHERE	T.copyId = AGC.id
			AND AGC.archGroupId = AG.id
			AND ((AGC.isSnapCopy = 0 AND T.copyId <> AG.defaultCopy) OR
				 (AGC.isSnapCopy = 1 AND T.copyId <> AG.defaultSnapCopy))
END
*/
--To avoid duplicates pick the job only for selective copy with highest duration
IF EXISTS(SELECT 1 FROM	#tempCopy
WHERE	selectionType IN (10, 3, 2, 4, 6))
AND EXISTS(SELECT 1 FROM ArchGroup WITH(NOLOCK) WHERE id = @i_archGroupId AND flags & 4194304 > 0)
BEGIN
	DECLARE @tmpSelectiveCopyOrder table(copyId int, periodDuration int, sourceCopyId int)
	INSERT INTO @tmpSelectiveCopyOrder
	SELECT copyId, nextPeriod-startPeriod, CASE WHEN AGC.sourceCopyId > 0 THEN sourceCopyId WHEN AGC.isSnapCopy > 0 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
	FROM #tempCopy C INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON C.copyId = AGC.id
	INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE selectionType IN (10, 3, 2, 4, 6)
	DECLARE @l_higherCopy int
	SELECT top 1 @l_higherCopy = copyId FROM @tmpSelectiveCopyOrder
	ORDER BY periodDuration desc, copyId asc
	--Fetch all the source copies recursively
	;WITH LinkedCopies (copyId, sourceCopyId)
	AS
	(
		SELECT copyId, sourceCopyId FROM @tmpSelectiveCopyOrder WHERE copyId = @l_higherCopy
		UNION ALL
		SELECT A.copyId, A.sourceCopyId FROM @tmpSelectiveCopyOrder A INNER JOIN LinkedCopies B ON A.copyId = B.sourceCopyId
	)
	DELETE #tempCopy WHERE copyId NOT IN (SELECT copyId FROM LinkedCopies)
AND selectionType IN (10, 3, 2, 4, 6)
END
SELECT copyId, flags, selectionType FROM #tempCopy
DROP TABLE #tempCopy
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archInlineCopyForApp')
	delete from GxQscripts where name = 'archInlineCopyForApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archInlineCopyForApp')
	delete from GXDBVersions where aliasname = 'archInlineCopyForApp'
GO

insert into GXDBVersions values(2, 'archInlineCopyForApp',  '00010012004800150000', 'archInlineCopyForApp', '00010012004800150000')
GO

