

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archIndexingStartAging.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +=======================================================================+
--  |                           archIndexingStartAging                      |
--  |  Procedure to initiate indexing aging process using workqueue mechanism|
--  +=======================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archIndexingStartAging')
BEGIN
	print '>>> Drop Stored Procedure: archIndexingStartAging <<<'
	drop procedure archIndexingStartAging
END
IF EXISTS (select * from GxQscripts where name='archIndexingStartAging')
	delete from GxQscripts where name = 'archIndexingStartAging'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIndexingStartAging')
	delete from GXDBVersions where aliasname = 'archIndexingStartAging'
GO
print '... Creating Procedure: archIndexingStartAging'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archIndexingStartAging
AS
SET NOCOUNT ON
INSERT INTO archIndexingAged (archFileId, commCellId, appId, backupSetGUID, currentIdxServer, pruneTime)
SELECT DISTINCT archTbl.archFileId, archTbl.commCellId, archTbl.appId, indexDB.backupSetGUID, indexDB.currentIdxServer, archTbl.pruneTime
FROM   archIndexingAgedTemp archTbl
INNER JOIN APP_Application subclient WITH (NOLOCK) ON subclient.id = archTbl.appId
INNER JOIN App_IndexDBInfo indexDB WITH (NOLOCK) ON indexDB.backupSetId	 = subclient.backupSet AND (dbo.isSubClientIndexEnabled(indexDB.backupSetId) = 0 OR indexDB.dbName = subclient.GUID)
delete archIndexingAgedTemp
update archIndexingAged set commCellId = CC.number
from archIndexingAged aged, APP_CommCell CC
where aged.commcellId = CC.id
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
                    (     serverURL NVARCHAR(512),
                            clientId INT,
                            clientName NVARCHAR(256),
                            cloudId INT,
                            hostName NVARCHAR(256),
                            basePort INT,
                            engineName  NVARCHAR(256),
                            serverType INT,
                            indexServerClientId INT,
                            internalCloudName NVARCHAR(256)
                    )
DECLARE @IdxServer INT
DECLARE MAListCursor CURSOR
FOR
select distinct currentIdxServer from archIndexingAged
OPEN MAListCursor
FETCH FROM MAListCursor INTO @IdxServer
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @params nvarchar(max) = '<Indexing_ArchIndexingAgingWorkTokenParam idxSrvrClientId="' + CAST(@IdxServer AS varchar) + '"></Indexing_ArchIndexingAgingWorkTokenParam>'
	DECLARE @clientId INT = @IdxServer
	IF EXISTS(SELECT 1 FROM App_IndexDBInfo IDB where IDB.currentIdxServer = @IdxServer AND IDB.idxDbEngineType = 2)
	BEGIN
		-- work token needs to be submitted on phyiscal client id.
		EXEC DM2GetIndexServers '', @IdxServer
		SELECT TOP 1 @clientId = clientId FROM #getIndexServers
		DELETE FROM #getIndexServers
	END
	EXEC AppWorkQueueSubmitRequest 20 /*WORK_TOKEN_AFILE_INDEXING_AGED*/, 0, 0, @clientId, 0, @params
	FETCH FROM MAListCursor INTO @IdxServer
END
CLOSE MAListCursor
DEALLOCATE MAListCursor
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'archIndexingStartAging')
	delete from GxQscripts where name = 'archIndexingStartAging'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIndexingStartAging')
	delete from GXDBVersions where aliasname = 'archIndexingStartAging'
GO

insert into GXDBVersions values(2, 'archIndexingStartAging',  '00000000000000000000', 'archIndexingStartAging', '00000000000000000000')
GO

