

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archIndexingGetAgedAfileList.sp] ---------- 

--  +========================================================================+
--  |                Name:  archIndexingGetAgedAfileList()
--  | Description:  Gets list of aged afile from indexing prune table
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archIndexingGetAgedAfileList')
BEGIN
	print '>>> Drop Stored Procedure: archIndexingGetAgedAfileList <<<'
	drop procedure archIndexingGetAgedAfileList
END
IF EXISTS (select * from GxQscripts where name='archIndexingGetAgedAfileList')
	delete from GxQscripts where name = 'archIndexingGetAgedAfileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIndexingGetAgedAfileList')
	delete from GXDBVersions where aliasname = 'archIndexingGetAgedAfileList'
GO
print '... Creating Procedure: archIndexingGetAgedAfileList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archIndexingGetAgedAfileList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0
AS
SET NOCOUNT ON
DECLARE @o_xmlText XML
DECLARE @o_errorCode        INT
DECLARE @idxServer VARCHAR(MAX) = ''
DECLARE @idxServerId INT
SET @o_errorCode = 0
SET @idxServer = @i_xmlText.value('(Indexing_archIndexingAgedReq/@idxServerName)[1]','VARCHAR(MAX)')
SET @idxServerId = ISNULL(@i_xmlText.value('(Indexing_archIndexingAgedReq/@idxSrvrClientId)[1]', 'INT'), 0)
-- if indexserver client id is not passed then check with name.
IF @idxServerId = 0
	SET @idxServerId = (SELECT	id from app_client where name = @idxServer)
-- Get list of the Dbs from agedafiles
DECLARE @tmpDbs TABLE (dbGroup varchar(36), dbName varchar(36), appId INT)
INSERT INTO @tmpDbs
SELECT DISTINCT AGED.backupSetGUID, IDX.dbName, APP.id
FROM archIndexingAged AGED WITH(NOLOCK)
JOIN APP_Application APP WITH (NOLOCK) ON APP.id = AGED.appId
JOIN App_IndexDBInfo IDX WITH(NOLOCK) ON APP.backupSet = IDX.backupSetId
WHERE IDX.currentIdxServer = @idxServerId AND (dbo.isSubClientIndexEnabled(IDX.backupSetId) = 0 OR IDX.dbName = APP.GUID)
SET @o_xmlText =
		(SELECT
			(SELECT IDX.type as '@appType',
					TDB.dbGroup AS '@backupSetGUID',
					TDB.dbName AS '@dbName',
					(SELECT
						archIndexingAgedTMP.archFileId AS '@afile',
						archIndexingAgedTMP.commCellId AS '@commcell'
						FROM archIndexingAged archIndexingAgedTMP
						WHERE archIndexingAgedTMP.appId = TDB.appId
						FOR XML PATH ('afiles'), TYPE),
					(SELECT idxDbEngineType AS '@val'
						FROM App_IndexDBInfo WITH (NOLOCK)
						WHERE dbName = TDB.dbName AND currentIdxServer = @idxServerId
						FOR XML PATH ('idxDbEngineTypes'), TYPE)
				FOR XML PATH ('agedArchive'), TYPE)
			FROM @tmpDbs TDB JOIN App_IndexDBInfo IDX WITH (NOLOCK) ON TDB.dbGroup = IDX.backupSetGUID AND TDB.dbName = IDX.dbName
		FOR XML PATH(''), ROOT('Indexing_archIndexingAgedList'))
SET @o_errorCode = @@error
IF (@o_errorCode = 0)
      select @o_xmlText
ELSE
      select '<ERROR />'
GO

IF EXISTS (select * from GxQscripts where name = 'archIndexingGetAgedAfileList')
	delete from GxQscripts where name = 'archIndexingGetAgedAfileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archIndexingGetAgedAfileList')
	delete from GXDBVersions where aliasname = 'archIndexingGetAgedAfileList'
GO

insert into GXDBVersions values(2, 'archIndexingGetAgedAfileList',  '00000000000000000000', 'archIndexingGetAgedAfileList', '00000000000000000000')
GO

