

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archHasToBeCopiedJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archHasToBeCopiedJobs.sp,v $ $Id: archHasToBeCopiedJobs.sp,v 1.1.2.1 2020/12/19 16:10:47 kjaiswal Exp $";
--
--  +========================================================================+
--  | Stored Procedure:  archHasToBeCopiedJobs
--	| Author:	Jun Lu
--  |
--  | Description:  For a given task ID, check if there are to be copied jobs if the copy has an MA that can use the populator framework for AuxCopy.
--	| Input:		task ID
--	| Output:		o_archGrpId, o_archGrpCopyId, o_errorCode, o_archGroupName, o_archGroupCopyName
--	|
--	|	o_errorCode									Action needed
--	|	---------------------------------------------------------------------
--	|  	E_ARCH_INVALID_AUXCOPY_TASK_ID				Invalidate task
--	|  	E_ARCH_NO_SP_COPY_FROM_ADMINTASK			Invalidate task
--	|	E_ARCH_COPY_IS_PRIMARY						Invalidate task
--	|	E_ARCH_INVALID_COPY_ID						Invalidate task
--	|	E_ARCH_NO_SECONDARY_COPY					Disable task?
--	|	E_ARCH_AUTOCOPY_FOR_RECENT_FULL_COPY		Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE						Disable task?
--	|	E_ARCH_COPY_NOT_EFFECTIVE					Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE_EFFECTIVE			Disable task?
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_SP				No action
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_COPY			No action
--	|	E_ARCH_NO_TO_BE_COPIED_DATA					No action
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archHasToBeCopiedJobs')
BEGIN
	print '>>> Drop Stored Procedure: archHasToBeCopiedJobs <<<'
	drop procedure archHasToBeCopiedJobs
END
IF EXISTS (select * from GxQscripts where name='archHasToBeCopiedJobs')
	delete from GxQscripts where name = 'archHasToBeCopiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archHasToBeCopiedJobs')
	delete from GXDBVersions where aliasname = 'archHasToBeCopiedJobs'
GO
print '... Creating Procedure: archHasToBeCopiedJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archHasToBeCopiedJobs
  @i_jobId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archGrpId integer
  DECLARE @o_archGrpCopyId integer
  DECLARE @o_errorCode integer
  DECLARE @o_archGroupName nvarchar(288)
  DECLARE @o_archGroupCopyName nvarchar(128)
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
DECLARE @tblCopy	TABLE (
	id				int,
	archGroupId		int,
	isActive		int,
	type			int,
	startTime		int,
	sourceCopyId	int,
	delayedDays		int,
	extendedFlags	bigint,
	assocId			int,
	error			int,
	assocCopyId		int,
	archGrpName		NVARCHAR(288),
	archGrpCopyName NVARCHAR(128) )
DECLARE @l_archGroupId	int = 0
DECLARE @l_archCopyId	int = 0
DECLARE @l_error		int = 0
DECLARE @l_rowcount		int = 0
DECLARE @nowUtcTime DATETIME = GETUTCDATE()
DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
DECLARE @i_today		integer = @nowUtcUnix
INSERT	INTO @tblCopy
SELECT	ISNULL(AGC.id, A.archGrpCopyID), ISNULL(AGC.archGroupId, A.archGrpID), AGC.isActive, AGC.type, AGC.startTime,
		(case when AGC.sourceCopyId > 0 then AGC.sourceCopyId when AGC.isSnapCopy = 1 then AG.defaultSnapCopy else AG.defaultCopy end),
		AGC.delayedDays,AGC.extendedFlags, 18 /*assoctype copy*/, (CASE
WHEN (AGC.id IS NULL) AND (A.archGrpCopyID > 0) THEN 9
WHEN (AGC.id IS NULL) AND (A.archGrpCopyID = 0) THEN 8
WHEN (A.archGrpCopyID > 0 AND (AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy)) THEN 16
WHEN (AGC.isActive = 0 AND AGC.startTime > @i_today) THEN 14
WHEN (AGC.isActive = 0) THEN 12
WHEN (AGC.startTime > @i_today) THEN 13
							ELSE 0 END),
		A.archGrpCopyID,AG.name, AGC.name
FROM	JMAdminJobInfoTable A WITH (READUNCOMMITTED)
			JOIN archGroup AG WITH (READUNCOMMITTED) ON A.archGrpID = AG.id
			JOIN archGroupCopy AGC WITH (READUNCOMMITTED)
				ON	A.archGrpID = AGC.archGroupId
					AND ((A.archGrpCopyID = 0 AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy) OR (A.archGrpCopyID > 0 AND A.archGrpCopyID = AGC.id))
					AND A.jobID = @i_jobId
IF NOT EXISTS (SELECT * FROM @tblCopy WHERE error = 0)
	GOTO CV_EXIT
--
-- BEGIN: archHasJobEligibleForCopy.spb
--
UPDATE	T
SET		error =	(CASE WHEN NOT EXISTS (SELECT TOP 1 D.JobId
									  FROM	JMJobDataStats D WITH (READUNCOMMITTED), JMJobDataStats S WITH (READUNCOMMITTED)
									  WHERE	D.archGrpCopyId = T.id
											AND D.status IN (101, 102, 103)
AND (D.disabled & (1 + 256)) = 0
											AND D.JobID = S.JobId
											AND D.commCellId = S.commCellId
											AND D.dataType = S.dataType
											AND S.archGrpCopyId = T.sourceCopyId
											AND S.status IN (100)
AND (S.disabled & (1 + 256)) = 0)
						 AND NOT EXISTS (SELECT TOP 1 JI.jobId
										 FROM JMJobInfo JI
												INNER JOIN JMJobCopyInfo JCI ON JI.JobId = JCI.JobID AND JI.commCellId = JCI.commCellId AND JCI.archGrpCopyId = T.id,
												archFile AF, archFileCopy src LEFT OUTER JOIN archFileCopy dest
													ON src.archFileId = dest.archFileId AND src.commCellId = dest.commCellId AND src.archCopyId <> dest.archCopyId
										 WHERE JI.jobId = AF.jobId AND JI.commCellId = AF.commCellId
										 AND AF.id = src.archFileId AND AF.commCellId = src.commCellId
										 AND src.archCopyId = T.sourceCopyId
										 AND src.mediaType = 10001
AND AF.flags & 32768 = 0
										 AND (dest.archCopyId IS NULL OR (dest.archCopyId = T.id AND dest.physicalSize < src.physicalSize))
										 AND JI.state NOT IN (4,9,10,11)
AND T.extendedFlags & 32768 > 0)	THEN 31
					ELSE 0
				END)
FROM	@tblCopy T
WHERE	T.error = 0
		AND T.delayedDays = 0
UPDATE	T
SET		error =	(CASE WHEN NOT EXISTS (SELECT TOP 1 D.JobId
									  FROM	JMJobDataStats D WITH (READUNCOMMITTED), JMBkpStats J WITH (READUNCOMMITTED), JMJobDataStats S WITH (READUNCOMMITTED)
									  WHERE	D.archGrpCopyId = T.id
											AND D.status IN (101, 102, 103)
AND (D.disabled & (1 + 256)) = 0
											AND D.jobId = J.JobId
											AND D.CommCellId = J.CommCellId
											AND (@i_today - J.servStartDate ) >= T.delayedDays*86400
											AND D.JobID = S.JobId
											AND D.commCellId = S.commCellId
											AND D.dataType = S.dataType
											AND S.archGrpCopyId = T.sourceCopyId
											AND S.status IN (100)
AND (S.disabled & (1 + 256)) = 0) THEN 31
					ELSE 0
				END)
FROM	@tblCopy T
WHERE	T.error = 0
		AND T.delayedDays > 0
--
-- END: archHasJobEligibleForCopy.spb
--
IF NOT EXISTS (SELECT 1 FROM JMJobOptions  WITH (READUNCOMMITTED)
						WHERE   jobId = @i_jobId
AND CommCellId = 2 AND attributeId = 99)
BEGIN
	INSERT INTO JMJobOptions
SELECT  DISTINCT @i_jobId, 2, 99, 'Using CVJobReplicatorPopulator', 0, 1
END
CV_EXIT:
IF (@l_error > 0)
	SELECT	0, 0, @l_error, '', ''
ELSE
	SELECT T.id, T.archgroupId, T.error,  ag.name archGroupName,  agc.name  archGroupCopyName
    FROM @tblCopy T ,  archGroup ag WITH (NOLOCK), archGroupCopy agc WITH (NOLOCK)
    WHERE ag.id = t.archgroupId AND agc.id = t.Id
GO

IF EXISTS (select * from GxQscripts where name = 'archHasToBeCopiedJobs')
	delete from GxQscripts where name = 'archHasToBeCopiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archHasToBeCopiedJobs')
	delete from GXDBVersions where aliasname = 'archHasToBeCopiedJobs'
GO

insert into GXDBVersions values(2, 'archHasToBeCopiedJobs',  '00010001000200010000', 'archHasToBeCopiedJobs', '00010001000200010000')
GO

