

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archHasJobsPendingMaterialize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archHasJobsPendingMaterialize')
BEGIN
	print '>>> Drop Stored Procedure: archHasJobsPendingMaterialize <<<'
	drop procedure archHasJobsPendingMaterialize
END
IF EXISTS (select * from GxQscripts where name='archHasJobsPendingMaterialize')
	delete from GxQscripts where name = 'archHasJobsPendingMaterialize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archHasJobsPendingMaterialize')
	delete from GXDBVersions where aliasname = 'archHasJobsPendingMaterialize'
GO
print '... Creating Procedure: archHasJobsPendingMaterialize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archHasJobsPendingMaterialize
  @i_appID integer,
  @i_archGroupID integer = 0,
  @i_flags integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_status integer
SET NOCOUNT ON
SET			@o_status	=	 0
IF @i_flags & 1 = 1
BEGIN
--	SET QUOTED_IDENTIFIER ON
	DECLARE @i_lastDataJobMatStatus int = 0
	DECLARE @i_lastDataJobTimeStamp int = 0
	DECLARE @i_openChain int = 0
	SELECT TOP 1 @i_lastDataJobTimeStamp = JBKP.ServStartDate, @i_openChain = JBKP.OpenChain, @i_lastDataJobMatStatus = JSS.materializationStatus
	FROM JMJobSnapshotStats JSS WITH(NOLOCK) INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON JSS.jobId = JBKP.jobId and JSS.commcellId = JBKP.commCellId
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.CommcellId = JDS.CommcellId AND JDS.dataType = 1
	WHERE JBKP.appId = @i_appID AND (JSS.archGrpId = @i_archGroupID OR	@i_archGroupID = 0)
	ORDER BY JBKP.servStartDate DESC
	IF @i_lastDataJobMatStatus <> 100
	BEGIN
		SET	@o_status = 1
		GOTO CX_EXIT
	END
	DECLARE @i_appTypeId int = 0
	DECLARE @instId int = 0
	DECLARE @diskbackupAttr  xml
	SELECT @i_appTypeId = appTypeId, @instId = instance
	FROM App_Application WITH(NOLOCK) WHERE id = @i_appID
	--Check if there is a successfull log archive file after last data job. Meaning chain is closed
IF @i_appTypeId IN (22, 80, 104, 125, 61, 135) AND (@i_openChain = 1)
	BEGIN
IF @i_appTypeId IN ( 22,  80 ) AND @i_lastDataJobTimeStamp <> 0
				SELECT  @diskbackupAttr = CAST (REPLACE(attrVal, 'utf-8', 'utf-16') AS XML) FROM app_instanceProp WHERE
						componentNameId = @instId AND attrName = N'Last Log Dump Info' AND attrVal IS NOT NULL
			IF @diskbackupAttr IS NOT NULL AND
				@diskbackupAttr.exist('(/Ida_OracleBackupMetadata/@completionTime)') = 1 AND
					@diskbackupAttr.value('(/Ida_OracleBackupMetadata/@completionTime)[1]', 'int') > @i_lastDataJobTimeStamp
			BEGIN
				SET @o_status = 0
				GOTO CX_EXIT
			END
			SET	@o_status = 2
			GOTO CX_EXIT
	END
END
ELSE
BEGIN
	IF EXISTS(
				SELECT	jobId
				FROM	JMJobSnapshotStats WITH (NOLOCK)
				WHERE	(archGrpId = @i_archGroupID OR	@i_archGroupID = 0)
					AND	appId = @i_appID
					AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
			)
			BEGIN
				SET	@o_status = 3
				GOTO CX_EXIT
			END
END
CX_EXIT:
SELECT @o_status
GO

IF EXISTS (select * from GxQscripts where name = 'archHasJobsPendingMaterialize')
	delete from GxQscripts where name = 'archHasJobsPendingMaterialize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archHasJobsPendingMaterialize')
	delete from GXDBVersions where aliasname = 'archHasJobsPendingMaterialize'
GO

insert into GXDBVersions values(2, 'archHasJobsPendingMaterialize',  '00000000000000000000', 'archHasJobsPendingMaterialize', '00000000000000000000')
GO

