

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupToAppInsertForDeferredCatalog.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGroupToAppInsertForDeferredCatalog.sp                           */
/*                                                                            */
/*  Description :  save storage policy and deferred catalog assocation        */
/*                 					                                         */
/*  Author      :  Hetal Kapadia \ KBora                                       */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupToAppInsertForDeferredCatalog.sp,v $ $Id: archGroupToAppInsertForDeferredCatalog.sp,v 1.1.2.4 2020/03/24 17:29:11 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupToAppInsertForDeferredCatalog')
BEGIN
	print '>>> Drop Stored Procedure: archGroupToAppInsertForDeferredCatalog <<<'
	drop procedure archGroupToAppInsertForDeferredCatalog
END
IF EXISTS (select * from GxQscripts where name='archGroupToAppInsertForDeferredCatalog')
	delete from GxQscripts where name = 'archGroupToAppInsertForDeferredCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupToAppInsertForDeferredCatalog')
	delete from GXDBVersions where aliasname = 'archGroupToAppInsertForDeferredCatalog'
GO
print '... Creating Procedure: archGroupToAppInsertForDeferredCatalog'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupToAppInsertForDeferredCatalog
  @i_xmlStr XML 
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@retVal = 0
DECLARE @i_archGroupId INTEGER
DECLARE @l_operationType INT = 0
DECLARE @l_isExclusionList INT = 0
DECLARE @countRows INT
DECLARE @sumAssocType INT
-- Check for selective subclient association for Deferred Catalog
SET @l_operationType = 2
SELECT @i_archGroupId = (doc.col.value('@archGroupId', 'INT'))
FROM @i_xmlStr.nodes('EVGui_DeferredCatalogProps') doc(col)
IF OBJECT_ID('tempdb.dbo.#AppToArchGroup') IS NOT NULL DROP TABLE #AppToArchGroup
CREATE TABLE #AppToArchGroup (
	clientId 		INTEGER,
	appTypeId 	INTEGER,
	instanceId 	INTEGER,
	backupSetId INTEGER,
	subClientId INTEGER,
	clientGroupId INTEGER,
	exclude INTEGER,
	assocType INTEGER
)
if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
CREATE TABLE #archGroupToAppId (
archGroupId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
IF OBJECT_ID('tempdb..#tmpDisabledJob') IS NOT NULL
	DROP TABLE #tmpDisabledJob
CREATE TABLE #tmpDisabledJob
(		jobId 				INT,
		commCellId 		INT,
		archGrpId 		INT,
		pickForCopy		INT,
    PRIMARY KEY (jobId, commCellId, archGrpId)
)
IF EXISTS(SELECT 1 FROM MMConfigs where name = 'MMS2_CONFIG_ENABLE_NEW_APP_COPY_ASSOC_VIEW' AND value > 0)
BEGIN
	INSERT INTO #AppToArchGroup
	SELECT
		ISNULL((doc.col.value('@clientId', 'INT')),0),
		ISNULL((doc.col.value('@applicationId', 'INT')),0),
		ISNULL((doc.col.value('@instanceId', 'INT')),0),
		ISNULL((doc.col.value('@backupsetId', 'INT')),0),
		ISNULL((doc.col.value('@subclientId', 'INT')),0),
		ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
		ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
		ISNULL((doc.col.value('@_type_', 'INT')),0)
	FROM @i_xmlStr.nodes('EVGui_DeferredCatalogProps/archGroupToAppListWithExclude') doc(col)
END
ELSE
BEGIN
	-- if the below query is picking up entities then the GUI is old
	INSERT INTO #AppToArchGroup
	SELECT
		(doc.col.value('@clientId', 'INT')),
		(doc.col.value('@applicationId', 'INT')),
		(doc.col.value('@instanceId', 'INT')),
		(doc.col.value('@backupsetId', 'INT')),
		(doc.col.value('@subclientId', 'INT')), 0, 0, 0
	FROM @i_xmlStr.nodes('EVGui_DeferredCatalogProps/archGroupToAppList/subClient') doc(col)
	WHERE (doc.col.value('@clientId', 'INT')) > 0
END
DELETE archGroupToApp
WHERE	archGroupId = @i_archGroupId
AND 	OperationType = 2
SELECT @countRows = COUNT(*), @sumAssocType = SUM(assocType)
FROM #AppToArchGroup
IF	EXISTS (SELECT 1 FROM #AppToArchGroup WHERE (subClientId|backupSetId|instanceId|appTypeId|clientId|clientGroupId)  <> 0)
		OR @countRows > 2 OR @sumAssocType NOT IN (2,29) -- we don't need to add anything in case of -> all CG and all clients, and just all clients
BEGIN
	INSERT INTO archGroupToApp
	SELECT @i_archGroupId, 2, clientId, appTypeId, instanceId, backupSetId, subClientId, clientGroupId, exclude, assocType
	FROM	#AppToArchGroup
	exec  archGetArchGroupToAppAssociations @i_archGroupId, @l_operationType
UPDATE	JMJobSnapDeferredCatalogStats
SET disabled = (disabled | 1), unPickReason = 1
	OUTPUT  INSERTED.JobId, INSERTED.commCellId, INSERTED.archGrpId, 0
	INTO #tmpDisabledJob
FROM JMJobSnapDeferredCatalogStats snap left join #archGroupToAppId t ON t.archGroupId = @i_archGroupId AND snap.appId = t.AppId
	WHERE	archGrpId = @i_archGroupId
AND catalogStatus IN (101, 102, 103)
AND disabled & 1 = 0
	AND t.AppId IS NULL
	--Repick linked VSA V2 parent jobs if VM jobs are picked
	UPDATE #tmpDisabledJob
	SET pickForCopy = 1
FROM 	#tmpDisabledJob T, JMJobDataLink JDL WITH (NOLOCK), JMJobSnapDeferredCatalogStats JSS WITH (NOLOCK)
	WHERE T.jobId = JDL.parentJobId
	AND		T.commcellId = JDL.commcellId
AND 	JDL.linkType IN (7, 8)
	AND		JDL.childJobId = JSS.jobId
	AND		JDL.commcellId = JSS.commcellId
AND 	((JSS.catalogStatus = 100) OR (JSS.catalogStatus IN (101, 102, 103) AND (JSS.disabled & 1 = 0)))
	IF (@@ROWCOUNT > 0)
	BEGIN
UPDATE	JMJobSnapDeferredCatalogStats
SET 		disabled = JSS.disabled & ~1, unPickReason = 0
FROM JMJobSnapDeferredCatalogStats JSS, #tmpDisabledJob T
		WHERE	JSS.jobId = T.jobId
		AND		JSS.commcellId = T.commcellId
AND 	JSS.catalogStatus IN (101, 102, 103)
AND 	JSS.disabled & 1 > 0
		AND		T.pickForCopy = 1
	END
END
FINISH:
IF object_id('tempdb.dbo.#archGroupToAppId') IS NOT NULL DROP TABLE #archGroupToAppId
IF object_id('tempdb..#tmpDisabledJob') IS NOT NULL DROP TABLE #tmpDisabledJob
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupToAppInsertForDeferredCatalog')
	delete from GxQscripts where name = 'archGroupToAppInsertForDeferredCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupToAppInsertForDeferredCatalog')
	delete from GXDBVersions where aliasname = 'archGroupToAppInsertForDeferredCatalog'
GO

insert into GXDBVersions values(2, 'archGroupToAppInsertForDeferredCatalog',  '00010001000200040000', 'archGroupToAppInsertForDeferredCatalog', '00010001000200040000')
GO

