

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupList.sp,v $ $Id: archGroupList.sp,v 1.30.2.12 2019/03/08 22:18:53 sudhanarayanan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupList')
BEGIN
	print '>>> Drop Stored Procedure: archGroupList <<<'
	drop procedure archGroupList
END
IF EXISTS (select * from GxQscripts where name='archGroupList')
	delete from GxQscripts where name = 'archGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupList')
	delete from GXDBVersions where aliasname = 'archGroupList'
GO
print '... Creating Procedure: archGroupList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGroupList
  @i_RestrictUserId int,
  @i_StoragePolicyId int = 0,
  @i_filterGlobalPolicies int = 0
AS
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName NVARCHAR(255)
  DECLARE @o_maxStreams integer
  DECLARE @o_type integer
  DECLARE @o_flags integer
  DECLARE @o_incrSP integer
  DECLARE @o_incrSPName NVARCHAR(255)
  DECLARE @o_defaultCopy integer
  DECLARE @o_defaultSnapCopy integer
  DECLARE @o_copyName NVARCHAR(255)
  DECLARE @o_copyNum integer
  DECLARE @o_numDeDupCopies integer
  DECLARE @o_numSiloedCopies integer
  DECLARE @o_drivePoolId integer
  DECLARE @o_drivePoolType integer
  DECLARE @o_clientId integer
  DECLARE @o_osId integer
  DECLARE @o_isNRSInstalled integer
  DECLARE @o_isCenteraPartOfDefCopy integer
  DECLARE @o_numApplications integer
  DECLARE @o_isINCRSPFor integer
  DECLARE @o_isCIEnabled integer
  DECLARE @o_isMultiplexingEnabled integer
  DECLARE @o_isSnapToMediaEnabled integer
  DECLARE @o_isAuxcopyEncEnabled integer
  DECLARE @o_SIBlockSizeKB integer
  DECLARE @o_AuxCopyAlertGB integer
  DECLARE @o_AuxCopyAlertDays integer
  DECLARE @o_description NVARCHAR(max)
  DECLARE @o_ClientsCount integer
  DECLARE @o_numNonGDSPDedupeCopies integer
  DECLARE @o_isIBMiVTL integer
  DECLARE @o_TimeZoneType integer
  DECLARE @o_logSP integer
  DECLARE @o_logSPName NVARCHAR(255)
  DECLARE @o_fullSPCountIsLogSPFor integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- restrict showing of archive UMGroups that are visible to user, first do general
-- stuff
DECLARE @globalPolicyFlag INT = 256 | 16384 | 8388608 | 33554432
if object_id('tempdb.dbo.#tmpAGTable')        is not null DROP TABLE #tmpAGTable
if object_id('tempdb.dbo.#appCountTbl')       is not Null DROP TABLE #appCountTbl
if object_id('tempdb.dbo.#l_tmpMagLibs')      is not Null DROP TABLE #l_tmpMagLibs
CREATE TABLE  #tmpAGTable (
				AGid 				integer,
				defaultCopy			integer,
				defaultSnapCopy		integer,
				name				nvarchar(255),
				maxStreams			integer,
				type				integer,
				flags				integer,
				incrSP				integer,
				SIBlockSizeKB		integer,
				AuxCopyAlertGB		integer,
				AuxCopyAlertDays	integer,
				incrSPName			nvarchar(255),
				defCopyName			nvarchar(255),
				numCopies			integer,
				numDeDupCopies		integer,
				numSiloedCopies		integer,
				drivePoolId			integer,
				drivePoolType			integer,
				drivePoolClientId		integer,
				drivePoolClientsimSystemOSId	integer,
				isNRSInstalledOndrivePoolClient	integer,
				isCenteraPartOfDefCopy	integer,
				numApps				integer,
				visibleToUser			integer,
				NDMPHostId				integer,
				isCIEnabled				integer,
				primaryCopyMultiplexFactor integer,
				isSnapToMediaEnabled	integer,
				isAuxcopyEncEnabled		integer,
				archGroupDescription	nvarchar(max),
				clientCount		integer,
				numNonGDSPDedupeCopies      integer,
				isIBMiVTL			integer,
				timeZoneType		integer,
				logSP				integer,
				logSPName			nvarchar(255))
CREATE INDEX #tmpAGTableIndx ON #tmpAGTable (AGid)
CREATE TABLE #appCountTbl   (AGid int, clientCount int,appCount int, incrSPClientCount int, incrAppCount int, PRIMARY KEY (AGid))
DECLARE @showHiddenSPConfig INT = 0
SELECT 	@showHiddenSPConfig = value
FROM    MMConfigs WITH (NOLOCK)
WHERE 	name = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES'
-- get all the semi-complex information that needs to be gotten
INSERT INTO #tmpAGTable
SELECT  AG.id, AG.defaultCopy, AG.defaultSnapCopy, AG.name, AG.maxStreams, AG.type, AG.flags, AG.incrSP,
	AG.SIBlockSizeKB, AG.AuxCopyAlertGB, AG.AuxCopyAlertDays,
	incrSPName = isnull((select name from archGroup WITH (NOLOCK) where id = AG.incrSP), ''),
        '',
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, isnull(AG.description, N''),0,0,0, AG.TimeZoneType, AG.logSP, logSPName = isnull((select name from archGroup WITH (NOLOCK) where id = AG.logSP), '')
FROM  archGroup as AG
WHERE ((@i_StoragePolicyId <> 0 AND id = @i_StoragePolicyId) OR
	   (@i_StoragePolicyId = 0 AND id > 1))
	   AND
	  ((@i_filterGlobalPolicies = 1 AND (flags & @globalPolicyFlag = 0)) OR
	   (@i_filterGlobalPolicies = 0 AND flags >= 0 ) )
AND ( @showHiddenSPConfig > 0 OR ( @showHiddenSPConfig = 0 AND AG.flags & 64 = 0 ))
-- remove AGs/Clients user can't see
IF @i_RestrictUserId > 0
BEGIN
		IF OBJECT_ID('tempdb.dbo.#archGroupList_UserObjects') IS NOT NULL DROP TABLE #archGroupList_UserObjects
create table  #archGroupList_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @i_RestrictUserId, 2231, 0, '#archGroupList_UserObjects'
		IF EXISTS(
				SELECT 1 FROM #archGroupList_UserObjects Sec
WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				)					--commcell level associations
			UPDATE #tmpAGTable
			SET visibleToUser = 1
		ELSE
		BEGIN
			UPDATE #tmpAGTable
			SET visibleToUser = 1
			FROM #tmpAGTable as tt INNER JOIN #archGroupList_UserObjects Sec
			ON tt.AGid = Sec.archGroupId
			WHERE Sec.archGroupId <> 0
		END
END
ELSE
BEGIN
		UPDATE #tmpAGTable SET visibleToUser = 1
END
DELETE  #tmpAGTable
FROM #tmpAGTable as tt
WHERE tt.visibleToUser = 0
--Delete all Scaleout storagepools which are not configured
DELETE #tmpAGTable from #tmpAGTable ag
INNER JOIN  MMSDSStoragePool ms ON ag.AGid = ms.GDSPId
WHERE
ag.flags & 33554432 = 33554432
AND
ms.StoragePoolStatus = 200
AND
ms.Flags & 1 = 0
IF @i_RestrictUserId > 0
BEGIN
		INSERT INTO #appCountTbl
		SELECT tt.AGid,  count(distinct(app.clientId)),count(distinct app.id),0,0
		FROM #tmpAGTable tt INNER JOIN APP_Application app WITH (NOLOCK)  on app.dataArchGrpId = tt.AGid OR app.logArchGrpID = tt.AGid
		INNER JOIN #archGroupList_UserObjects a on app.clientId = a.clientId
		WHERE   (subclientStatus & 2) = 0 AND (subclientStatus & 4) = 0 AND
			((subclientStatus & 32) = 0 AND (subclientStatus & 16) = 0 OR (subclientStatus & 64) > 0)
		GROUP BY tt.AGid
		IF OBJECT_ID('tempdb.dbo.#archGroupList_UserObjects') IS NOT NULL DROP TABLE #archGroupList_UserObjects
END
ELSE
BEGIN
		INSERT INTO #appCountTbl
		SELECT tt.AGid,  count(distinct(app.clientId)),count(distinct app.id),0,0
		FROM #tmpAGTable tt INNER JOIN APP_Application app WITH (NOLOCK)  on app.dataArchGrpId = tt.AGid OR app.logArchGrpID = tt.AGid
		WHERE   (subclientStatus & 2) = 0 AND (subclientStatus & 4) = 0 AND
			((subclientStatus & 32) = 0 AND (subclientStatus & 16) = 0 OR (subclientStatus & 64) > 0)
		GROUP BY tt.AGid
END
UPDATE #appCountTbl
SET incrSPClientCount = tempTbl.cc,
    incrAppCount      = tempTbl.ac
FROM (SELECT tt.incrsp AS id,SUM(tbl.clientCount) AS cc ,SUM(tbl.appCount) AS ac FROM #appCountTbl tbl INNER JOIN #tmpAGTable tt
ON tbl.AGid = tt.AGid GROUP BY tt.incrsp) AS tempTbl
WHERE tempTbl.id = AGid
UPDATE	#tmpAGTable
SET isSnapToMediaEnabled = enabled
From #tmpAGTable t INNER JOIN archMaterializeSnapshotProp  a  WITH (NOLOCK)
ON t.AGid = a.archGroupId
-- Check whether any of the copy has Multiplexing enable
UPDATE	#tmpAGTable
SET	primaryCopyMultiplexFactor = copy.maxMultiplex,
        defCopyName =  isnull(copy.name, ''),
	drivePoolId = ISNULL(m.drivePoolId,0)
FROM	#tmpAGTable as tt INNER JOIN  ArchGroupCopy as copy WITH (NOLOCK)
ON	tt.defaultCopy = copy.Id  LEFT OUTER JOIN MMDataPath m
ON m.CopyId = tt.defaultCopy AND ((Flag & 1) = 1)
UPDATE	#tmpAGTable
SET 	numCopies = cc.copyCount
FROM	#tmpAGTable AS tt,
(SELECT archGroupId, COUNT(id) AS copyCount FROM archGroupCopy WITH (NOLOCK) WHERE type <> 5
		GROUP BY archGroupId) AS cc
WHERE	tt.AGid = cc.archGroupId
UPDATE	#tmpAGTable
SET 	numApps = appTbl.appCount+appTbl.incrAppCount,
		clientCount = appTbl.clientCount+appTbl.incrSPClientCount
FROM	#tmpAGTable AS tt, #appCountTbl appTbl
WHERE   tt.AGid = appTbl.AGid
UPDATE	#tmpAGTable
SET 	numDeDupCopies = dd.copyCount
FROM	#tmpAGTable AS tt,
		(SELECT archGroupId, COUNT(id) AS copyCount FROM archGroupCopy WITH (NOLOCK)
WHERE (dedupeFlags & 262144) > 0 GROUP BY archGroupId) AS dd
WHERE	tt.AGid = dd.archGroupId
--Filter migrated copys
UPDATE	#tmpAGTable
SET 	numNonGDSPDedupeCopies = dd.numNonGDSPDedupCopies
FROM	#tmpAGTable AS tt,
   	       (SELECT archGroupId, COUNT(id) AS numNonGDSPDedupCopies FROM ArchGroupCopy WITH (NOLOCK)
WHERE (dedupeFlags & 262144) > 0 AND (dedupeFlags & 134217728) =  0
AND (extendedFlags&32) = 0 GROUP BY archGroupId) AS dd
WHERE	tt.AGid = dd.archGroupId
UPDATE	#tmpAGTable
SET 	numSiloedCopies = dd.copyCount
FROM	#tmpAGTable AS tt,
		(SELECT archGroupId, COUNT(id) AS copyCount FROM archGroupCopy WITH (NOLOCK)
WHERE (dedupeFlags & 2097152) > 0 AND (dedupeFlags & 134217728) = 0 AND (flags & 524288) = 0 GROUP BY archGroupId) AS dd
		-- do not consider GDSP dependent copies and silo copies as they share dedupeflags but do not really have silo enabled for themselves.
WHERE	tt.AGid = dd.archGroupId
-- fill in drive pool type information and DrivePoolClientId here for all the drivePools
UPDATE #tmpAGTable
SET drivePoolType = MD.DrivePoolType, drivePoolClientId = MD.clientId
FROM MMDrivePool as MD, #tmpAGTable as tt
WHERE tt.DrivePoolId > 0 AND MD.drivePoolId = tt.drivePoolId
-- If it is a NAS DrivePool, then overwrite the drivePoolClientId with the one from NDMPHostInfo table
UPDATE #tmpAGTable
SET 	drivePoolClientId = NDMPHI.ClientId
FROM 	#tmpAGTable as tt, MMNDMPHostInfo AS NDMPHI WITH (NOLOCK)
WHERE	tt.DrivePoolType = 3 AND tt.NDMPHostId > 0 AND NDMPHI.NdmpHostId = tt.NdmpHostId
-- now fill in SimSystemOS and ClientId
UPDATE #tmpAGTable
SET 	drivePoolClientsimSystemOSId = cl.simOperatingSystemId
FROM 	#tmpAGTable as tt, APP_Client as cl WITH (NOLOCK)
WHERE   tt.drivePoolClientId > 0 AND cl.id = tt.drivePoolClientId
-- now find out which clients have NRS installed
-- 10.0 installed on ALL MAs
UPDATE #tmpAGTable
SET isNRSInstalledOndrivePoolClient = 1
FROM #tmpAGTable as tt, APP_Client as CL
WHERE ((tt.drivePoolType <> 3) AND (tt.drivePoolClientId = CL.id) AND (CL.releaseId >= 15))
-- Pre 10.0 check the client property
DECLARE @sNRS_CP varchar(128)
SET @sNRS_CP = dbo.GetLicensePropName(1004);
UPDATE #tmpAGTable
SET isNRSInstalledOndrivePoolClient = 1
FROM #tmpAGTable as tt, APP_ClientProp as CP WITH (NOLOCK)
WHERE (tt.drivePoolType <> 3 AND tt.isNRSInstalledOndrivePoolClient <> 1  AND
       CP.componentNameId = tt.drivePoolClientId AND
	   CP.attrName = @sNRS_CP AND CP.modified = 0 AND CP.attrVal = '1')
-- figure out centera
	-- first get list of all maglibs and the mountpath type
	CREATE TABLE #l_tmpMagLibs(libraryId Integer, topMPType integer)
	INSERT INTO #l_tmpMagLibs
	SELECT	MP.LibraryId, MP.MountPathTypeId
	FROM	MMLibrary AS ML WITH (NOLOCK),
			MMMountPath AS MP WITH (NOLOCK)
	WHERE	MP.LibraryId= ML.LibraryId AND ML.LibraryTypeId = 3
	-- get all centera drivepools
	DECLARE @l_tmpCenteraDPs TABLE (DrivePoolId Integer)
	INSERT INTO @l_tmpCenteraDPs
	SELECT DP.DrivePoolId
	FROM #l_tmpMagLibs AS tmpML, MMMasterPool AS MP WITH (NOLOCK), MMDrivePool AS DP WITH (NOLOCK)
	WHERE tmpML.topMPType = 1 AND MP.libraryId = tmpML.libraryId AND DP.MasterPoolId = MP.MasterPoolId
	-- now update main temporary table
	UPDATE #tmpAGTable
	SET isCenteraPartOfDefCopy = 1
	FROM #tmpAGTable as tt, MMDataPath as DPath WITH (NOLOCK), @l_tmpCenteraDPs as tCDPs
	WHERE DPath.CopyId = tt.defaultCopy AND DPath.DrivePoolId = tCDPs.DrivePoolId
-- Check whether ArchGroup is ContentIndexing enable
UPDATE	#tmpAGTable
SET		isCIEnabled = ciRules.enabled
FROM	#tmpAGTable as tt, archContentIndexingRules as ciRules
WHERE	tt.AGId = ciRules.ArchGroupId
-- Check if any of the Auxcopy has AuxCopy encryption enabled
UPDATE	#tmpAGTable
SET		isAuxcopyEncEnabled = ISNULL(copy.encKeyLen, 0)
FROM	#tmpAGTable as tt, ArchGroupCopy as copy
WHERE	tt.AGId = copy.ArchGroupId AND copy.encType <> 0
-- Check if the snap copy has Replicetion datapath
UPDATE	#tmpAGTable
SET		flags = (tt.flags | 1024)
FROM	#tmpAGTable as tt,
		APP_IDAName as ida,
		MMHost as hst,
		(SELECT	DISTINCT A.AGid, B.HostClientId
		FROM	#tmpAGTable A, MMDataPath B WITH (NOLOCK), MMDrivePool C WITH (NOLOCK)
		WHERE	A.defaultSnapCopy > 0
			AND B.CopyId = A.defaultSnapCopy
			AND C.DrivePoolId = B.DrivePoolId AND C.DrivePoolType = 10001) as cl
WHERE	tt.AGid = cl.AGid
	AND cl.HostClientId = ida.clientId AND ida.appTypeId = 84
	AND cl.HostClientId = hst.ClientId
UPDATE	#tmpAGTable
SET 	isIBMiVTL = 1
FROM	#tmpAGTable AS tt,
       (select ag.AGid as archGroupId FROM #tmpAGTable as ag WITH (NOLOCK)
			JOIN MMDataPath as dtp WITH (NOLOCK) ON ag.defaultCopy = dtp.CopyId
			JOIN MMDrivePool as drp WITH (NOLOCK) ON dtp.DrivePoolId = drp.DrivePoolId
			JOIN MMMasterPool as MP WITH (NOLOCK) ON MP.MasterPoolId = DrP.MasterPoolId
			JOIN MMLibrary as L WITH (NOLOCK) ON MP.LibraryId = L.LibraryId
WHERE L.VTLType = 4) AS dd
WHERE	tt.AGid = dd.archGroupId
-- now return the data
IF OBJECT_ID('tempdb.dbo.#tmpStoragePolicies') IS NOT NULL
BEGIN
	INSERT INTO #tmpStoragePolicies
	SELECT  tt.AGid, tt.name, tt.maxStreams, tt.type, tt.flags,
			tt.incrSP, tt.incrSPName, tt.defaultCopy, tt.defaultSnapCopy, tt.defCopyName,
			tt.numCopies, tt.numDeDupCopies, tt.numSiloedCopies, tt.drivePoolId, tt.drivePoolType, tt.drivePoolClientId,
			tt.drivePoolClientsimSystemOSId, tt.isNRSInstalledOndrivePoolClient, tt.isCenteraPartOfDefCopy, tt.numApps, isnull(AG.id, 0),
			tt.isCIEnabled, tt.primaryCopyMultiplexFactor, tt.isSnapToMediaEnabled, tt.isAuxcopyEncEnabled, tt.SIBlockSizeKB,
			tt.AuxCopyAlertGB, tt.AuxCopyAlertDays, tt.archGroupDescription,tt.clientCount,tt.numNonGDSPDedupeCopies,
			tt.isIBMiVTL, tt.timeZoneType, tt.logSP, tt.logSPName, (select count(*) from ArchGroup WITH(NOLOCK) where logSP = tt.AGid)
	FROM 	#tmpAGTable as tt LEFT OUTER JOIN ArchGroup as AG ON AG.id = tt.incrSP
END
ELSE
BEGIN
	SELECT  tt.AGid, tt.name, tt.maxStreams, tt.type, tt.flags,
			tt.incrSP, tt.incrSPName, tt.defaultCopy, tt.defaultSnapCopy, tt.defCopyName,
			tt.numCopies, tt.numDeDupCopies, tt.numSiloedCopies, tt.drivePoolId, tt.drivePoolType, tt.drivePoolClientId,
			tt.drivePoolClientsimSystemOSId, tt.isNRSInstalledOndrivePoolClient, tt.isCenteraPartOfDefCopy, tt.numApps, isnull(AG.id, 0),
			tt.isCIEnabled, tt.primaryCopyMultiplexFactor, tt.isSnapToMediaEnabled, tt.isAuxcopyEncEnabled, tt.SIBlockSizeKB,
			tt.AuxCopyAlertGB, tt.AuxCopyAlertDays, tt.archGroupDescription,tt.clientCount,tt.numNonGDSPDedupeCopies,
			tt.isIBMiVTL, tt.timeZoneType, tt.logSP, tt.logSPName, (select count(*) from ArchGroup WITH(NOLOCK) where logSP = tt.AGid)
	FROM 	#tmpAGTable as tt LEFT OUTER JOIN ArchGroup as AG WITH (NOLOCK) ON AG.id = tt.incrSP
END
DROP TABLE #tmpAGTable
if object_id('tempdb.dbo.#TMP_VNA_forAGList') is not null DROP TABLE #TMP_VNA_forAGList
if object_id('tempdb.dbo.#UMuserGroup')       is not Null DROP TABLE #UMuserGroup
if object_id('tempdb.dbo.#appCountTbl')       is not Null DROP TABLE #appCountTbl
if object_id('tempdb.dbo.#l_tmpMagLibs')      is not Null DROP TABLE #l_tmpMagLibs
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupList')
	delete from GxQscripts where name = 'archGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupList')
	delete from GXDBVersions where aliasname = 'archGroupList'
GO

insert into GXDBVersions values(2, 'archGroupList',  '00010030000200120000', 'archGroupList', '00010030000200120000')
GO

