

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupCopyDeleteAllJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupCopyDeleteAllJobs.sp,v $ $Id: archGroupCopyDeleteAllJobs.sp,v 1.4.66.4 2020/10/09 04:57:06 kkumar Exp $";
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupCopyDeleteAllJobs')
BEGIN
	print '>>> Drop Stored Procedure: archGroupCopyDeleteAllJobs <<<'
	drop procedure archGroupCopyDeleteAllJobs
END
IF EXISTS (select * from GxQscripts where name='archGroupCopyDeleteAllJobs')
	delete from GxQscripts where name = 'archGroupCopyDeleteAllJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyDeleteAllJobs')
	delete from GXDBVersions where aliasname = 'archGroupCopyDeleteAllJobs'
GO
print '... Creating Procedure: archGroupCopyDeleteAllJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupCopyDeleteAllJobs
  @i_archGroupId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_agedByFlag	INTEGER	= 268435456
DECLARE @l_datetime		DATETIME= GetUTCDate()
DECLARE @l_now			INTEGER = dbo.GetUnixTime(@l_datetime)
DECLARE	@l_bytesOnDisk	BIGINT	= 0
DECLARE @l_copyExtendedFlags INTEGER = 0
SET @retVal = 0
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
IF	@i_copyId > 0
	INSERT	INTO #ToBeAgedAFC
	SELECT	archFileId, commCellId, archCopyId
	FROM	archFileCopy WITH (NOLOCK)
	WHERE	archCopyId = @i_copyId
ELSE
	INSERT	INTO #ToBeAgedAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	archCopyId = AGC.id AND AGC.archGroupId = @i_archGroupId
EXEC @retVal = archFileDeleteViaTable 0, @l_bytesOnDisk OUTPUT
DROP TABLE #ToBeAgedAFC
IF @retVal <> 0 GOTO CX_EXIT
IF	@i_copyId > 0
BEGIN
    --Netapp open replication MR: 233092
	SELECT @l_copyExtendedFlags = extendedFlags from archGroupCopy WITH (NOLOCK)
	WHERE id = @i_copyId AND isSnapCopy = 1
	UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (disabled | 256),
			agedTime = @l_now, mediaDeletedTime = @l_now, modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
	FROM	JMJobDataStats
	WHERE	archGrpCopyId = @i_copyId
		AND status <> 1000
	CREATE TABLE #NotPrunedJobs (
		jobId INT, commCellId INT,
		PRIMARY KEY (jobId, commCellId))
	INSERT	INTO #NotPrunedJobs
	SELECT	DISTINCT jobId, commCellId
	FROM	JMJobDataStats
	WHERE	archGrpId = @i_archGroupId
		AND status <> 1000
	UPDATE	JMBkpStats WITH (PAGLOCK)
	SET		dataStatus = 2, agedTime = (case when agedTime = 0 then @l_now else agedTime end),
			mediaDeletedTime = @l_now, modifiedTime = @l_now
	FROM	JMBkpStats J LEFT OUTER JOIN #NotPrunedJobs T ON J.jobId = T.jobId AND J.commCellId = T.commCellId
	WHERE	(dataArchGrpId = @i_archGroupId OR logArchGrpId = @i_archGroupId)
		AND dataStatus <> 2 AND T.jobId IS NULL
	DROP TABLE #NotPrunedJobs
	UPDATE	archGroupCopy
	SET		name = case
						when right(name,8)= '_DELETED'
								then name
						else
								name + '_DELETED'
					end,
isActive = 0, flags = (flags | 1073741824), sourceCopyId = 0,
			description = 'This storage policy copy is deleted by user. It will be deleted automatically after all snapshots have been physically deleted.'
	WHERE	id = @i_copyId
	--Reset the extended flags indicating that the copy is a default copy - Netapp open replication
	IF (@l_copyExtendedFlags & 525056) = 525056
		UPDATE	archGroupCopy SET extendedFlags = 0 WHERE id = @i_copyId AND isSnapCopy = 1
END
ELSE
BEGIN
	UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (disabled | 256),
			agedTime = @l_now, mediaDeletedTime = @l_now, modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
	FROM	JMJobDataStats J, archGroupCopy AGC
	WHERE	J.archGrpCopyId = AGC.id AND AGC.archGroupId = @i_archGroupId
		AND J.status <> 1000
	UPDATE	JMBkpStats WITH (PAGLOCK)
	SET		dataStatus = 2, agedTime = (case when agedTime = 0 then @l_now else agedTime end),
			mediaDeletedTime = @l_now, modifiedTime = @l_now
	FROM	JMBkpStats
	WHERE	(dataArchGrpId = @i_archGroupId OR logArchGrpId = @i_archGroupId)
		AND dataStatus <> 2
	UPDATE	archGroupCopy
SET		isActive = 0, flags = (flags | 1073741824)
	WHERE	archGroupId = @i_archGroupId
	UPDATE	archGroup
	SET		name = case
						when right(name,8)= '_DELETED'
								then name
						else
								name + '_DELETED'
					end,
flags = (flags | 4096 | 64),
			description = 'This storage policy is deleted by user. It will be deleted automatically after all snapshots have been physically deleted.'
	WHERE	id = @i_archGroupId
END
CX_EXIT:
SELECT	@retVal
RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupCopyDeleteAllJobs')
	delete from GxQscripts where name = 'archGroupCopyDeleteAllJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyDeleteAllJobs')
	delete from GXDBVersions where aliasname = 'archGroupCopyDeleteAllJobs'
GO

insert into GXDBVersions values(2, 'archGroupCopyDeleteAllJobs',  '00010004006600040000', 'archGroupCopyDeleteAllJobs', '00010004006600040000')
GO

