

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupCopyDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupCopyDelete.sp,v $ $Id: archGroupCopyDelete.sp,v 1.73.2.29 2020/09/14 20:43:20 lviswambharan Exp $";
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupCopyDelete')
BEGIN
	print '>>> Drop Stored Procedure: archGroupCopyDelete <<<'
	drop procedure archGroupCopyDelete
END
IF EXISTS (select * from GxQscripts where name='archGroupCopyDelete')
	delete from GxQscripts where name = 'archGroupCopyDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyDelete')
	delete from GXDBVersions where aliasname = 'archGroupCopyDelete'
GO
print '... Creating Procedure: archGroupCopyDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupCopyDelete
  @i_archGroupId INTEGER,
  @i_copyId INTEGER,
  @i_userId INTEGER = 0,
  @i_recursiveCall INTEGER = 0
AS
  DECLARE @dbErrorCode INTEGER;
  DECLARE @amErrorCode INTEGER;
  DECLARE @errorString VARCHAR(1024);
  DECLARE @numJobDataStats INTEGER;
  DECLARE @numMagVols INTEGER;
  DECLARE @numNonMagMedia INTEGER;
  DECLARE @tmPolicyCount INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/**********************************************/
/* Initialize and declare temporary variables */
/**********************************************/
DECLARE @l_totalSpaceMB		BIGINT = 0
DECLARE @l_mediaSideId		INTEGER = 0
DECLARE @l_volumeId			INTEGER = 0
DECLARE @l_mediaId			INTEGER = 0
DECLARE @l_spareGroupId		INTEGER = 0
DECLARE @l_expiredGroupId	INTEGER = 0
DECLARE	@l_mediaGroupId		INTEGER = 0
DECLARE	@l_drivePoolId		INTEGER = 0
DECLARE	@l_libraryId		INTEGER = 0
DECLARE @l_capacityFreedMB	bigint = 0
DECLARE	@l_lastWriteLibraryId	INTEGER = 0
DECLARE @l_dedupeFlags		INTEGER = 0
DECLARE @l_isSnapCopy			INTEGER = 0
DECLARE	@l_siloAppId		INTEGER = 0
DECLARE	@l_SMRelationId		INTEGER = 0
DECLARE @l_SMRelationNodeId INTEGER = 0
DECLARE @spType 			INTEGER = 0
DECLARE	@copyType			INTEGER = 0
DECLARE	@copyPrecedence		INTEGER = 0
DECLARE	@defCopyId			INTEGER = 0
DECLARE	@defSnapCopyId		INTEGER = 0
DECLARE @l_copyFlags		INTEGER = 0
DECLARE @l_archGroupFlags	INTEGER = 0
DECLARE @l_archGroupName	NVARCHAR(144)
DECLARE @l_copyName			NVARCHAR(64)
DECLARE @opMsgId 			INTEGER
DECLARE @opEvMsgId 		INTEGER
DECLARE @opId 				INTEGER
DECLARE @paramMsgId 	INTEGER
DECLARE @GUIAuditUserId INT
SELECT	@GUIAuditUserId = ISNULL(@i_userId, 0)
SET @dbErrorCode = 0
SET	@amErrorCode = 0
SET @numJobDataStats = 0
SET @numMagVols = 0
SET @numNonMagMedia = 0
SET @tmPolicyCount = 0
DECLARE @oneConstReal REAL
SET			@oneConstReal = 1.0
DECLARE @archGroupId	INTEGER = 0
DECLARE @copyId			INTEGER = 0
DECLARE @isPrimary		INTEGER = 0
/***************************/
/* Create temparary tables */
/***************************/
CREATE	TABLE #copyIdList (
		copyId INT,
		dedupeFlags INT,
		siloAppId INT,
		siloBackupsetId INT,
		isSnapCopy	INT
)
CREATE	TABLE #tmpArchTask (
		archTaskId INT
)
CREATE	TABLE #dataPathIdList (
		dataPathId INT
)
CREATE	TABLE #archFileIdList (
		archFileId INT,
		commCellId INT,
		PRIMARY KEY (archFileId, commCellId)
)
CREATE	TABLE #jobIdList (
		jobId INT,
		commCellId INT,
		PRIMARY KEY (jobId, commCellId)
)
CREATE	TABLE #ptoc (
		PolicyId INT,
		RefCount INT,
		NewRefCount INT
)
CREATE	TABLE #adminParamList (
		subTaskId INT,
		deleteTask INT
)
CREATE	TABLE #mediaGroupIdList (
		MediaGroupId INT,
		DrivePoolId INT,
		SpareGroupId INT,
		SpareGroupType INT,
		CopyId INT,
		EraseOnPrune INT,
		agcExflags INT
)
CREATE	TABLE #volIdList (
		VolumeId INT,
		MediaId INT,
		MediaSideId INT,
		MediaGroupId INT,
		SIDBStoreId INT,
		MediaTypeId INT,
		MediaFlags INT,
		LibraryId INT,
		LastWriteLibraryId INT,
		SpareGroupId INT,
		SpareGroupType INT,
		TotalSpaceMB BIGINT,
		MountPathId INT,
		AddToDeletedAF INT,
		flags INT
)
CREATE	TABLE #libHistory (
		LibraryId INT,
		NumberOfMediaFreed INT,
		CapacityFreedMB BIGINT
)
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, acCommcellId INT, archFileId INT, afCommcellId INT, archCopyId INT, physicalSize BIGINT, dedupSize BIGINT, JobId INT, appSizeFreedBytes BIGINT,
	PRIMARY KEY (archChunkId, acCommcellId, archFileId, afCommCellId, archCopyId))
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
CREATE TABLE #ToBeAgedAFCWithoutChunks (
	archFileId INT, commCellId INT, archCopyId INT, SIDBStoreId INT, isAged INT
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE INDEX Idx_tmpToBeAgedAFCWithoutChunks_1 ON #ToBeAgedAFCWithoutChunks (SIDBStoreId)
--
-- Check if DA is enabled before proceeding
--
declare @l_isDAEnabled integer
set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
if (@l_isDAEnabled = 0)
begin
set @dbErrorCode = -1000
	SET @errorString = 'Exiting. Data Aging Activity is disabled'
	GOTO CX_ERROR_EXIT
end
IF	@i_copyId > 0
	SET @errorString = 'Copy [' + CONVERT(varchar(20), @i_copyId) + ']:'
ELSE
IF	@i_archGroupId > 0
	SET @errorString = 'Policy [' + CONVERT(varchar(20), @i_archGroupId) + ']:'
ELSE
BEGIN
	SET @errorString = 'Both Policy ID and Copy ID are invalid'
	GOTO CX_ERROR_EXIT
END
	/************************/
	/* Populate temp tables */
	/************************/
--BEGIN TRY
	IF	@i_copyId > 0
	BEGIN
		SELECT	@i_archGroupId = archGroupId, @copyType = type, @copyPrecedence = copy, @l_dedupeFlags = dedupeFlags, @l_siloAppId = siloAppId, @l_copyFlags = flags, @l_copyName = name, @l_isSnapCopy	= isSnapCopy
		FROM	archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId
		IF ((@@ROWCOUNT = 0) OR (@i_archGroupId = 0))
		BEGIN
			SET @errorString = 'Exiting. Copy does not exist'
			GOTO CX_ERROR_EXIT
		END
		SELECT @defCopyId = defaultCopy, @defSnapCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId
SET @l_siloAppId = ((case when @l_copyFlags & 524288 > 0 then @l_siloAppId else 0 end)) -- set siloappid only if siloCopy is getting deleted, not for sec Silo Copy, if set then below it deletes siloAppId also
		INSERT	INTO #copyIdList
		SELECT	@i_copyId, @l_dedupeFlags, @l_siloAppId,
				(case when @l_siloAppId = 0 then 0 else (SELECT backupSet FROM APP_Application WITH (NOLOCK) WHERE id = @l_siloAppId) end),
				@l_isSnapCopy
		DELETE	FROM	MMEntityProp
WHERE	EntityType = 2
				AND EntityID IN (SELECT copyId FROM #copyIdList)
	END
	ELSE
	IF	@i_archGroupId > 1
	BEGIN
		SELECT	@spType = type, @l_archGroupFlags = flags, @defCopyId = defaultCopy, @l_archGroupName = name  FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId
		IF (@@ROWCOUNT = 0)
		BEGIN
			SET @errorString = 'Exiting. Storage Policy does not exist'
			GOTO CX_ERROR_EXIT
		END
		INSERT	INTO #copyIdList
SELECT	id, dedupeFlags, (case when flags & 524288 > 0 then siloAppId else 0 end), 0, isSnapCopy -- set siloappid only if siloCopy is getting deleted, not for sec Silo Copy, if set then below it deletes siloAppId also
		FROM	archGroupCopy WITH (NOLOCK)
		WHERE	archGroupId = @i_archGroupId
		DECLARE @dependentIdList TABLE(
		archGroupId INT, copyId INT, isPrimary INT
		)
IF ((@l_archGroupFlags & 256) <> 0 OR (@l_archGroupFlags & 16384) <> 0 OR (@l_archGroupFlags & 8388608) <> 0)
		BEGIN
			-- Get all dependent copies for GSP
			INSERT INTO @dependentIdList
			SELECT A.id, C.id, (case when A.defaultCopy = C.id then 1 else 0 end)
			FROM archGroup A WITH(READUNCOMMITTED), archGroupCopy C WITH(READUNCOMMITTED), archCopyToGlobalPolicy B WITH(READUNCOMMITTED)
			WHERE B.globalPolicyId = @i_archGroupId
			AND B.copyId = C.id
			AND C.archGroupId = A.id
		END
		IF EXISTS (SELECT * FROM @dependentIdList)
		BEGIN
			DECLARE getDependent CURSOR LOCAL FAST_FORWARD FOR
			SELECT archGroupId, copyId, isPrimary
			FROM @dependentIdList
			OPEN getDependent
			FETCH NEXT FROM getDependent
			INTO @archGroupId, @copyId, @isPrimary
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @isPrimary = 0
				BEGIN
					EXEC @dbErrorCode = archGroupCopyDelete @archGroupId, @copyId, @i_userId, 1 --recursive deletes get audited in the stored procedure, so pass a flag
				END
				ELSE
				BEGIN
					EXEC @dbErrorCode = archGroupCopyDelete @archGroupId, 0, @i_userId, 1 --recursive deletes get audited in the stored procedure, so pass a flag
				END
				FETCH NEXT FROM getDependent INTO @archGroupId, @copyId, @isPrimary
			END
			CLOSE getDependent
			DEALLOCATE getDependent
			IF (@dbErrorCode <> 0)
			BEGIN
				SET @errorString = 'Failed to clean up tables for dependent copies.'
				GOTO CX_ERROR_EXIT
			END
		END
		UPDATE	#copyIdList SET siloBackupsetId = APP_Application.backupSet
		FROM	APP_Application WITH (NOLOCK)
		WHERE	APP_Application.id = #copyIdList.siloAppId AND #copyIdList.siloAppId > 0
		DELETE	FROM	MMEntityProp
WHERE	EntityType = 2
				AND EntityID IN (SELECT copyId FROM #copyIdList)
		DELETE	FROM	MMEntityProp
WHERE	EntityType = 1
				AND EntityID = @i_archGroupId
	END
	INSERT	INTO #tmpArchTask
	SELECT	sealStoreTaskId
	FROM	archGroupCopy
WHERE	id IN (SELECT copyId FROM #copyIdList WHERE (dedupeFlags & 134217728) = 0) AND sealStoreTaskId > 0
	IF	@i_copyId = 0
		INSERT	INTO #adminParamList
		SELECT	subTaskId, 1
		FROM	TM_SubTask WITH (NOLOCK)
		WHERE	taskId IN (SELECT taskId FROM TM_AssocEntity WITH (NOLOCK) WHERE policyId = @i_archGroupId
			  OR copyId IN (SELECT copyId FROM #copyIdList))
	ELSE
		INSERT	INTO #adminParamList
		SELECT	subTaskId, 1
		FROM	TM_SubTask WITH (NOLOCK)
		WHERE	taskId IN (SELECT taskId FROM TM_AssocEntity WHERE copyId = @i_copyId)
	UPDATE	#adminParamList
	SET		deleteTask = 0
	FROM	#adminParamList T, TM_SubTask S WITH (NOLOCK)
	WHERE	S.subTaskId = T.subTaskId
		AND taskId IN (SELECT taskId FROM TM_AssocEntity WITH (NOLOCK) WHERE policyId <> @i_archGroupId
			  OR (@i_copyId <> 0 AND copyId NOT IN (SELECT copyId FROM #copyIdList))
			  )
	IF @i_copyId > 0
		INSERT	INTO #archFileIdList
		SELECT 	archFileId, commCellId
		FROM   	archFileCopy WITH (NOLOCK)
		WHERE  	archCopyId = @i_copyId
	INSERT	INTO #jobIdList
	SELECT	J.jobId, J.commCellId
	FROM	JMJobDataStats J WITH (NOLOCK), #copyIdList C
	WHERE	J.archGrpCopyId = C.copyId
	GROUP BY J.jobId, J.commCellId
	/* Get mediaGroupIds */
	INSERT	INTO #mediaGroupIdList
	SELECT	b.MediaGroupId, b.DrivePoolId, b.SpareGroupId, c.SpareGroupType,
a.archGroupCopyId, (a.flags & 64)/64, a.extendedFlags
	FROM	(SELECT	S.mediaGroupId, S.archGroupCopyId, AGC.flags, AGC.extendedFlags
			FROM	#copyIdList T, archGroupCopy AGC WITH (NOLOCK), archStream S WITH (NOLOCK)
			WHERE	AGC.id = T.copyId AND S.archGroupCopyId = T.copyId ) a,
			MMMediaGroup b WITH (NOLOCK), MMSpareGroup c WITH (NOLOCK)
	WHERE	b.MediaGroupId = a.MediaGroupId
	AND		c.SpareGroupId = b.SpareGroupId
	INSERT	INTO #dataPathIdList
	SELECT	d.DataPathId
	FROM	MMDataPath d WITH (NOLOCK), #copyIdList c
	WHERE	d.CopyId = c.copyId
	/* Get all volumes */
	INSERT	INTO #volIdList
	SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.MediaGroupId, V.SIDBStoreId,
			M.MediaTypeId, M.MediaFlags, M.LibraryId, M.LastWriteLibraryId,
			M.SpareGroupId, T.SpareGroupType, 0, 0, 0, 1
	FROM	#mediaGroupIdList T, MMVolume V WITH (NOLOCK), MMMedia M WITH (NOLOCK)
	WHERE	V.MediaGroupId = T.mediaGroupId
	AND		M.MediaId = V.MediaId
	SELECT	@numMagVols = @@ROWCOUNT
	/* update TotalSpaceMB */
	UPDATE	#volIdList
	SET		TotalSpaceMB = S.TotalSpaceMB
	FROM	#volIdList V, MMMediaSide S WITH (NOLOCK)
	WHERE	V.MediaSideId = S.MediaSideId
AND		V.MediaTypeId != 10001
	SELECT	@numNonMagMedia = @@ROWCOUNT
	SET		@numMagVols =(@numMagVols - @numNonMagMedia)
	UPDATE	#volIdList
	SET		TotalSpaceMB = B.CapacityFreedMB
	FROM	#volIdList V,
			(SELECT	AC.volumeId, SUM(AC.physicalSize)/(1024*1024) AS CapacityFreedMB
			FROM	archChunk AC WITH (NOLOCK), #volIdList T
			WHERE	AC.volumeId = T.volumeId
			GROUP BY AC.volumeId
			) B
	WHERE	V.VolumeId = B.volumeId
AND		V.MediaTypeId = 10001
	/* get SpareGroupId for non-magnetic media if it's not set */
	UPDATE	#volIdList
	SET		SpareGroupId = S.SpareGroupId
	FROM	#volIdList T, MMSpareGroup S WITH (NOLOCK)
WHERE	S.SpareGroupType = 2
	AND		S.LibraryId = T.LastWriteLibraryId
	AND		T.LastWriteLibraryId != T.LibraryId
	AND		T.LastWriteLibraryId > 0
AND		T.MediaTypeId != 10001
	AND		T.SpareGroupId = 0
	/* check warm media */
	UPDATE	#volIdList
	SET		Mediaflags = 2/*MEDIA_FLAG_BAD*/
	FROM	#volIdList T, MMMediaType M WITH (NOLOCK)
	WHERE	M.MediaTypeId = T.MediaTypeId
	AND		M.IsWormMedia > 0
AND		T.MediaTypeId != 10001
	AND		T.SpareGroupId = 0
	UPDATE	#volIdList
	SET		MediaFlags = 3/*MEDIA_FLAG_DEPRECATED*/, SpareGroupId = SG.SpareGroupId, LastWriteLibraryId = 0
	FROM	#volIdList T, MMSpareGroup SG WITH (NOLOCK), MMMediaType MT WITH (NOLOCK)
	WHERE	MT.MediaTypeId = T.MediaTypeId
	AND		MT.IsWormMedia > 0
	AND		SG.LibraryId = T.LastWriteLibraryId
AND		SG.SpareGroupType = 8
	AND		T.LastWriteLibraryId != T.LibraryId
	AND		T.LastWriteLibraryId > 0
AND		T.MediaTypeId != 10001
	AND		T.SpareGroupId = 0
	/* for centera */
	UPDATE	#volIdList
	SET		MountPathId = P.MountPathId, AddToDeletedAF = (CASE WHEN P.MountPathTypeId = 1/*MOUNT_PATH_CENTERA*/ THEN 1 ELSE 0 END)
	FROM	#volIdList V, MMMountPath P WITH (NOLOCK)
	WHERE	P.MediaSideId = V.MediaSideId
AND		V.MediaTypeId = 10001
	/* for Global Deduped AF */
	UPDATE	#volIdList
	SET		AddToDeletedAF = 1
	FROM	#volIdList V,
			(SELECT SIDBStoreId FROM archCopySIDBStore WITH (NOLOCK)
			WHERE	SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM #volIdList WHERE SIDBStoreId > 0)
			GROUP BY SIDBStoreId HAVING COUNT(CopyId) > 1) S
	WHERE	V.SIDBStoreId = S.SIDBStoreId
	/* for object-based cloud storage AF */
	UPDATE	#volIdList
	SET		AddToDeletedAF = 1
	FROM	#volIdList V
		INNER JOIN MMVolume VOL WITH (NOLOCK) ON V.VolumeId = VOL.VolumeId
		INNER JOIN MMMountPath MP WITH (NOLOCK) ON VOL.MediaSideId = MP.MediaSideId
		INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK) ON MP.MountPathId = MPSD.MountPathId
		INNER JOIN MMDevice DEV WITH (NOLOCK) ON MPSD.DeviceId = DEV.DeviceId
	WHERE MP.MountPathTypeId = 7 /* MOUNT_PATH_EXTERNAL_REMOTE_HOST */
		/*
		TYPE_SAN_MAGNETIC_REMOTE_HOST_CARINGO_CASTOR
		TYPE_SAN_MAGNETIC_REMOTE_HOST_DELL_DX_OBJECTSTORAGE
		*/
		AND DEV.DeviceTypeId > 41 /* TYPE_SAN_MAGNETIC_REMOTE_HOST_OBJECT_BASE_START */
		AND DEV.DeviceTypeId < 60 /* TYPE_SAN_MAGNETIC_REMOTE_HOST_OBJECT_BASE_END */
	/* for updating MMLibraryHistory */
	INSERT	INTO #libHistory
	SELECT	LibraryId, 0, SUM(TotalSpaceMB)
	FROM	#volIdList
WHERE	MediaTypeId = 10001
	GROUP BY LibraryId
	INSERT	INTO #libHistory
	SELECT	DISTINCT T.LibraryId, 1, 0
	FROM	(SELECT	(CASE WHEN LastWriteLibraryId > 0 THEN LastWriteLibraryId ELSE LibraryId END) AS LibraryId
			FROM	#volIdList
WHERE	MediaTypeId != 10001) T
	INSERT	INTO #ptoc
	SELECT	DISTINCT PolicyId, 0, 0
	FROM	VTPolicyToCopy WITH (NOLOCK)
	WHERE	CopyId IN (SELECT copyId FROM #copyIdList)
	OR 		(@i_copyId = 0 AND ArchGroupId = @i_archGroupId)
	UPDATE	#ptoc
	SET		RefCount = t.PolicyId
	FROM	#ptoc p, VTPolicyToCopy t WITH (NOLOCK)
	WHERE	p.PolicyId = t.PolicyId
--END TRY
--BEGIN CATCH
	SET @dbErrorCode = ERROR_NUMBER()
	IF @dbErrorCode > 0
	BEGIN
		SET @errorString = @errorString + ' -- Failed to populate temp tables'
		GOTO CX_ERROR_EXIT
	END
--END	CATCH
--BEGIN TRY
	/**********************/
	/* Delete from tables */
	/**********************/
	IF	@i_copyId > 0
	BEGIN
		DECLARE	@l_transitiveCopyId INT
		SELECT	@l_transitiveCopyId = targetCopyId FROM archCopyMediaRefreshProp WITH (NOLOCK) WHERE copyId = @i_copyId
		IF	@l_transitiveCopyId IS NOT NULL
		BEGIN
			DELETE	FROM archCopyMediaRefreshProp WHERE copyId = @i_copyId
			EXEC	archGroupCopyDelete @i_archGroupId, @l_transitiveCopyId, @i_userId, 1 --recursive deletes get audited in the stored procedure, so pass a flag
		END
		DECLARE	@l_siloCopyId INT
SELECT	@l_siloCopyId = id FROM archGroupCopy WITH (NOLOCK) WHERE sourceCopyId = @i_copyId AND (flags & 524288) <> 0
		IF	@l_siloCopyId IS NOT NULL
			EXEC	archGroupCopyDelete @i_archGroupId, @l_siloCopyId, @i_userId, 1 --recursive deletes get audited in the stored procedure, so pass a flag
	END
	IF	@i_copyId <= 0
	BEGIN
IF (@spType = 2)
		BEGIN
			UPDATE APP_Application SET dataArchGrpId = 1 WHERE appTypeId = 1000 AND dataArchGrpId = @i_archGroupId
			UPDATE APP_Application SET logArchGrpId = 1 WHERE appTypeId = 1000 AND logArchGrpId = @i_archGroupId
		END
		--Reset storage policies of Index Server Clients. These can be cleaned up from Data Aging
		DECLARE @tblIndexServerClients table(ClientId int)
		INSERT @tblIndexServerClients
		SELECT DISTINCT App.clientId FROM APP_Application App WITH (NOLOCK)
		INNER JOIN App_InstanceProp IPROP WITH(NOLOCK) ON App.instance = IPROP.componentNameId
		WHERE	(App.dataArchGrpId = @i_archGroupId OR App.logArchGrpId = @i_archGroupId)
AND IPROP.attrName = 'Distributed Cluster Type' AND IPROP.attrVal = 7 AND IPROP.modified = 0
		UPDATE App_Application SET dataArchGrpId = CASE WHEN (dataArchGrpId = @i_archGroupId) THEN 1 ELSE dataArchGrpId END,
							   logArchGrpId = CASE WHEN (logArchGrpId = @i_archGroupId) THEN 1 ELSE logArchGrpId END
		WHERE clientId IN (SELECT ClientId FROM @tblIndexServerClients)
	END
	/* Clean up Media Movement tables */
	DELETE	FROM VTPolicyToCopy
	WHERE (@i_copyId = 0 AND ArchGroupId = @i_archGroupId)
	OR CopyId IN (SELECT copyId FROM #copyIdList)
	UPDATE	#ptoc
	SET		NewRefCount = t.PolicyId
	FROM	#ptoc p, VTPolicyToCopy t
	WHERE	p.PolicyId = t.PolicyId
	/* Disable if policy has no copy any more */
	UPDATE	VTPolicy
SET		Flag = Flag & ~1, OfflineReason = 4
	WHERE	PolicyId IN (SELECT PolicyId FROM #ptoc WHERE RefCount > 0 AND NewRefCount = 0)
	SELECT	@tmPolicyCount = @@rowcount
	/* Delete all schedules */
	--DELETE	TM_SubTaskOptions	--Options are deleted when schedule is deleted
	--FROM	TM_SubTaskOptions S, #adminParamList T
	--WHERE	S.subTaskId = T.subTaskId
	--	AND	(T.deleteTask = 1 OR S.type = T.type AND S.value = T.data)
	--DELETE INDIVIDUAL SCHEDULES
	UPDATE	TM_Task
	SET		deleted = 1
WHERE taskType = 2 AND taskId IN (SELECT taskId FROM TM_SubTask WITH (NOLOCK) WHERE subTaskId IN (
			SELECT DISTINCT subTaskId FROM #adminParamList WHERE deleteTask = 1))
	--DELETE ASSOCIATION FROM SCHEDULE POLICIES
	DELETE TM_AssocEntity WHERE (policyId = @i_archGroupId AND @i_copyId = 0) OR copyId IN (SELECT copyId FROM #copyIdList)
	--Get all archive files without any chunks to populate MMDeletedAF table
	IF @i_copyId > 0
	BEGIN
		INSERT INTO #ToBeAgedAFCWithoutChunks
SELECT AFC.archFileId, AFC.commCellId, AFC.archCopyId, 0, (AFC.flags & 256)
		FROM archFileCopy AFC WITH (NOLOCK) LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
		ON 	AFC.archFileId = ACM.archFileId
		AND	AFC.commCellId = ACM.commCellId
		AND 	AFC.archCopyId = ACM.archCopyId
		WHERE	AFC.archCopyId = @i_copyId
		AND	ACM.archFileId IS NULL
	END
	ELSE
	BEGIN
		INSERT INTO #ToBeAgedAFCWithoutChunks
SELECT AFC.archFileId, AFC.commCellId, AFC.archCopyId, 0, (AFC.flags & 256)
		FROM archFileCopy AFC WITH (NOLOCK) INNER JOIN archFile AF WITH (NOLOCK)
		ON 	AFC.archFileId = AF.id
		AND	AFC.commCellId = AF.commCellId
		LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
		ON 	AFC.archFileId = ACM.archFileId
		AND	AFC.commCellId = ACM.commCellId
		AND 	AFC.archCopyId = ACM.archCopyId
		WHERE	AF.archGroupId = @i_archGroupId
		AND	ACM.archFileId IS NULL
	END
	--Get the SIDBStoreId for archive files
	UPDATE #ToBeAgedAFCWithoutChunks
	SET	SIDBStoreId = AFCD.SIDBStoreId
	FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopyDedup AFCD WITH (NOLOCK)
	WHERE	T.archFileId = AFCD.archFileId
	AND	T.commCellId = AFCD.commCellId
	AND 	T.archCopyId = AFCD.archCopyId
	--CALCULATE appSizeFreedBytes
	INSERT	INTO #ToBeAgedACM
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, ACM.dedupedSize, ACM.JobId, ACM.unCompSize
	FROM	#volIdList V, #mediaGroupIdList MG, archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK)
	WHERE	AC.volumeId = V.VolumeId AND AC.version >= 3
		AND V.MediaGroupId = MG.MediaGroupId AND V.AddToDeletedAF = 1 AND V.SIDBStoreId > 0
		AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId AND ACM.archCopyId = MG.CopyId
	INSERT INTO #tmpJobSizeInfo
	SELECT DISTINCT JobId, afCommcellId, 0, 0, 0
	FROM	#ToBeAgedACM WHERE appSizeFreedBytes = -1
	-- Get totalBackupSize, totalAppSize, totalIndexSize for dedupe jobs
	EXEC archGetJobSizeInfo 0
	UPDATE #ToBeAgedACM
	SET		appSizeFreedBytes = (CASE WHEN JI.totalBackupSize > 0
																	THEN CAST(((@oneConstReal * (JI.totalAppSize + JI.totalIndexSize) * ACM.physicalSize) / JI.totalBackupSize) AS BIGINT)
																	ELSE ACM.physicalSize
															END)
	FROM	#ToBeAgedACM ACM, #tmpJobSizeInfo JI
	WHERE ACM.JobId = JI.JobId
	AND  	ACM.afCommcellId = JI.CommCellId
	AND		ACM.appSizeFreedBytes = -1
	/* Add pruned centera chunk with cclip into MMDeletedAF table */
	INSERT	INTO MMDeletedAF
	SELECT	0, V.VolumeId, 0, 0, MG.CopyId, AC.cclip, AC.physicalSize,
			AC.id, V.MountPathId, 0, 0, dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 0, 0, AC.commCellId
	FROM	#volIdList V, #mediaGroupIdList MG, archChunk AC WITH (NOLOCK)
	WHERE	AC.volumeId = V.VolumeId AND AC.version >= 3
		AND V.MediaGroupId = MG.MediaGroupId AND V.AddToDeletedAF = 1 AND V.SIDBStoreId = 0
	INSERT	INTO MMDeletedAF
	SELECT	ACM.archFileId, V.VolumeId, 0, 0, MG.CopyId, AC.cclip, ACM.physicalSize,
			AC.id, V.MountPathId, V.SIDBStoreId, ACM.afCommCellId, dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, ACM.appSizeFreedBytes, 0, AC.commCellId
	FROM	#volIdList V, #mediaGroupIdList MG, archChunk AC WITH (NOLOCK), #ToBeAgedACM ACM
	WHERE	AC.volumeId = V.VolumeId AND AC.version >= 3
		AND V.MediaGroupId = MG.MediaGroupId AND V.AddToDeletedAF = 1 AND V.SIDBStoreId > 0
		AND ACM.archChunkId = AC.id AND ACM.acCommcellId = AC.commCellId AND ACM.archCopyId = MG.CopyId
	INSERT INTO MMDeletedAF
	SELECT	archFileId, 0, 0, 0, archCopyId, 0, 0, 0, 0, SIDBStoreId, commCellId,  dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 0, 0, 0
	FROM 	#ToBeAgedAFCWithoutChunks
	WHERE	SIDBStoreId > 0
	AND	isAged = 0
	IF OBJECT_ID('tempdb.dbo.#replGroupToDel') IS NOT NULL
        DROP TABLE #replGroupToDel
	IF OBJECT_ID('tempdb.dbo.#replEntitiesToDel') IS NOT NULL
        DROP TABLE #replEntitiesToDel
	CREATE TABLE #replGroupToDel (
			ReplicaGroupId int
		)
	CREATE TABLE #replEntitiesToDel (
			ReplicaEntityId	int
		)
	create clustered index replGroupToDel_ReplicaGroupId_Idx ON #replGroupToDel(ReplicaGroupId)
	create clustered index replEntitiesToDel_ReplicaEntityId_Idx ON #replEntitiesToDel(ReplicaEntityId)
	/* Delete from Archive related tables */
	IF @i_copyId > 0
	BEGIN
     DELETE	AFCT
		 FROM archFileCopy AFCT WITH(PAGLOCK), archGroupCopy AGC WITH (NOLOCK), archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
		 WHERE	AGC.id = @i_copyId
				AND AGC.destMediaCopyId > 0
				AND AGC.destMediaCopyId = M.copyId
				AND AFCT.archcopyId = M.targetcopyid
				AND AFC.archcopyid = @i_copyId
				AND AFC.archfileid = AFCT.archfileid
				AND AFC.commCellId = AFCT.commCellId
		DELETE	FROM archFileCopy WITH(PAGLOCK)
		WHERE	archCopyId = @i_copyId
		DELETE	#archFileIdList
		FROM	#archFileIdList a, archFileCopy b WITH (NOLOCK)
		WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
		--Delete archive files from archVSAAppAFLink table before deleting from archFile table
		DELETE	archVSAAppAFLink
		FROM	archVSAAppAFLink AFL, #archFileIdList AF
		WHERE	AFL.childAFId = AF.archFileId
		AND 	AFL.commCellId = AF.commCellId
		DELETE	archVSAAppAFLink
		FROM	archVSAAppAFLink AFL, #archFileIdList AF
		WHERE	AFL.ParentIndexAFId = AF.archFileId
		AND 	AFL.commCellId = AF.commCellId
		DELETE	archFile WITH(PAGLOCK)
		FROM	archFile AS a JOIN #archFileIdList AS b
			ON	a.id = b.archFileId AND a.commCellId = b.commCellId
		UPDATE	archMaterializeSnapshotProp SET sourceCopyId = 0
		WHERE	archGroupId = @i_archGroupId AND sourceCopyId = @i_copyId
		UPDATE	archDeferredCatalogProp SET sourceCopyId = 0
		WHERE	archGroupId = @i_archGroupId AND sourceCopyId = @i_copyId
		IF	@defSnapCopyId = @i_copyId
			DELETE	FROM archMaterializeSnapshotProp
			WHERE	archGroupId = @i_archGroupId
		IF	@defSnapCopyId = @i_copyId
			DELETE	FROM archDeferredCatalogProp
			WHERE	archGroupId = @i_archGroupId
		SELECT	@l_SMRelationId = SMRelationId FROM SMCopyToRelationMap WHERE ArchGroupCopyId = @i_copyId
		SELECT @l_SMRelationNodeId = SMRelationNodeId FROM SMCopyToRelationMap WHERE ArchGroupCopyId = @i_copyId
		IF @l_SMRelationId IS NOT NULL AND @l_SMRelationId > 0
		BEGIN
			IF	EXISTS (SELECT * FROM SMCopyToRelationMap WHERE SMRelationId = @l_SMRelationId AND ArchGroupCopyId <> @i_copyId)
			BEGIN
				DELETE	FROM SMCopyToRelationMap
				WHERE	ArchGroupCopyId = @i_copyId
				DELETE	FROM SMRelationNode
				WHERE	SMRelationNodeId = @l_SMRelationNodeId
			END
			ELSE
			BEGIN
				DELETE	FROM SMRelation
				WHERE	SMRelationId = @l_SMRelationId
			END
		END
		-- Delete tables for Offline replication
		-- Get the replica groups that can be deleted
		INSERT INTO #replGroupToDel
		SELECT	DISTINCT ReplicaGroupId
		FROM	SMReplicaGroupMap MAP1 (NOLOCK)
		WHERE	MAP1.CopyId = @i_copyId
				AND NOT EXISTS (	SELECT	1 FROM SMReplicaGroupMap MAP2 (NOLOCK)
									WHERE	MAP1.ReplicaGroupId = MAP2.ReplicaGroupId
											AND MAP2.CopyId <> @i_copyId )
		IF EXISTS (SELECT 1 FROM #replGroupToDel)
		BEGIN
			DELETE	MAP1
			FROM	SMReplicaGroupMap MAP1 WHERE copyId = @i_copyId
			-- Get the replica entities to be deleted if they are not being used.
			INSERT INTO #replEntitiesToDel
			SELECT	SRC.SrcEntityId
			FROM	SMReplicaGroup (NOLOCK) SRC
			WHERE	ReplicaGroupId IN (SELECT ReplicaGroupId FROM #replGroupToDel)
					AND SRC.SrcEntityId NOT IN (
						SELECT	SrcEntityId FROM SMReplicaGroup G1 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND SRC.SrcEntityId = G1.SrcEntityId
					)
					AND SRC.SrcEntityId NOT IN (
						SELECT	TgtEntityId FROM SMReplicaGroup G2 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND SRC.SrcEntityId = G2.TgtEntityId
					)
			INSERT INTO #replEntitiesToDel
			SELECT	TGT.TgtEntityId
			FROM	SMReplicaGroup (NOLOCK) TGT
			WHERE	ReplicaGroupId IN (SELECT ReplicaGroupId FROM #replGroupToDel)
					AND TGT.TgtEntityId NOT IN (
						SELECT	SrcEntityId FROM SMReplicaGroup G1 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND TGT.TgtEntityId = G1.SrcEntityId
					)
					AND TGT.TgtEntityId NOT IN (
						SELECT	TgtEntityId FROM SMReplicaGroup G2 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND TGT.TgtEntityId = G2.TgtEntityId
					)
			DELETE  A
			FROM	SMSnapToReplicaGroupMap A
					INNER JOIN #replGroupToDel RG_DEL ON A.ReplicaGroupId = RG_DEL.ReplicaGroupId
			DELETE	RG
			FROM	SMReplicaGroup RG
					INNER JOIN #replGroupToDel RG_DEL ON RG.ReplicaGroupId = RG_DEL.ReplicaGroupId
			DELETE	RE
			FROM	SMReplicaEntities RE
					INNER JOIN #replEntitiesToDel RE_DEL ON RE.ReplicaEntityId = RE_DEL.ReplicaEntityId
		END
	END
	ELSE
	BEGIN
		DELETE	FROM archFile WITH(PAGLOCK)
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM archContentIndexingAF WITH(PAGLOCK)
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM archContentIndexingApp
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM archContentIndexingRestart
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM archContentIndexingRules
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM archMaterializeSnapshotProp
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM archDeferredCatalogProp
		WHERE	archGroupId = @i_archGroupId
		DELETE	FROM SMRelation
		WHERE	SMRelationId IN (
				SELECT	DISTINCT SMRelationId
				FROM	SMCopyToRelationMap
				WHERE	ArchGroupCopyId IN (SELECT copyId FROM #copyIdList))
		-- Get the replica groups that can be deleted
		INSERT INTO #replGroupToDel
		SELECT	DISTINCT ReplicaGroupId
		FROM	SMReplicaGroupMap MAP1 (NOLOCK)
		WHERE	MAP1.CopyId IN (SELECT CopyId FROM #copyIdList)
				AND NOT EXISTS ( SELECT 1 FROM SMReplicaGroupMap MAP2
									WHERE MAP1.ReplicaGroupId = MAP2.ReplicaGroupId
									AND MAP2.CopyId NOT IN (SELECT CopyId FROM #copyIdList) )
		IF EXISTS (SELECT 1 FROM #replGroupToDel)
		BEGIN
			DELETE	MAP1
			FROM	SMReplicaGroupMap MAP1 WHERE copyId IN (SELECT copyId FROM #copyIdList)
			-- Get the replica entities to be deleted if they are not being used.
			INSERT INTO #replEntitiesToDel
			SELECT	SRC.SrcEntityId
			FROM	SMReplicaGroup (NOLOCK) SRC
			WHERE	ReplicaGroupId IN (SELECT ReplicaGroupId FROM #replGroupToDel)
					AND SRC.SrcEntityId NOT IN (
						SELECT	SrcEntityId FROM SMReplicaGroup G1 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND SRC.SrcEntityId = G1.SrcEntityId
					)
					AND SRC.SrcEntityId NOT IN (
						SELECT	TgtEntityId FROM SMReplicaGroup G2 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND SRC.SrcEntityId = G2.TgtEntityId
					)
			INSERT INTO #replEntitiesToDel
			SELECT	TGT.TgtEntityId
			FROM	SMReplicaGroup (NOLOCK) TGT
			WHERE	ReplicaGroupId IN (SELECT ReplicaGroupId FROM #replGroupToDel)
					AND TGT.TgtEntityId NOT IN (
						SELECT	SrcEntityId FROM SMReplicaGroup G1 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND TGT.TgtEntityId = G1.SrcEntityId
					)
					AND TGT.TgtEntityId NOT IN (
						SELECT	TgtEntityId FROM SMReplicaGroup G2 (NOLOCK)
						WHERE	ReplicaGroupId NOT IN (SELECT ReplicaGroupId FROM #replGroupToDel)
								AND TGT.TgtEntityId = G2.TgtEntityId
					)
			DELETE  A
			FROM	SMSnapToReplicaGroupMap A
					INNER JOIN #replGroupToDel RG_DEL ON A.ReplicaGroupId = RG_DEL.ReplicaGroupId
			DELETE	RG
			FROM	SMReplicaGroup RG
					INNER JOIN #replGroupToDel RG_DEL ON RG.ReplicaGroupId = RG_DEL.ReplicaGroupId
			DELETE	RE
			FROM	SMReplicaEntities RE
					INNER JOIN #replEntitiesToDel RE_DEL ON RE.ReplicaEntityId = RE_DEL.ReplicaEntityId
		END
	END
	IF OBJECT_ID('tempdb.dbo.#replGroupToDel') IS NOT NULL
        DROP TABLE #replGroupToDel
	IF OBJECT_ID('tempdb.dbo.#replEntitiesToDel') IS NOT NULL
        DROP TABLE #replEntitiesToDel
	---------------------------------------------------------
	-- Prune snap records after archfilecopy table is pruned
	---------------------------------------------------------
	declare @tblRtn table (retVal int)
	insert into @tblRtn
	EXEC @dbErrorCode = archPruneVolSnaps @i_archGroupId, @i_copyId
	if @dbErrorCode <> 0 GOTO CX_ERROR_EXIT
	---------------------------------------------------------
	-- If chunks are still referenced by archChunkMapping table, they must belong to a different storage policy or copy.
	-- The volume is assigned to this storage policy copy but the old chunks have not been deleted. Leave those chunks alone.
 	DELETE 	FROM archChunk WITH(PAGLOCK)
 	FROM	archChunk C JOIN #volIdList V ON C.volumeId = V.volumeId
 			LEFT JOIN archChunkMapping CM ON C.id = CM.archChunkId AND C.commCellId = CM.chunkCommCellId
 	WHERE  	CM.archChunkId IS NULL
    DECLARE	@CurrDateTime	DATETIME
	DECLARE	@CurrentTime	INT
	SET	@CurrDateTime	= GetUTCDate()
	SET	@CurrentTime	= dbo.GetUnixTime(@CurrDateTime)
    /*
     After deletion of archChunkMapping entries of this copy, if there are no more unaged archChunkMapping entries for the chunks, mark them aged.
    */
    IF OBJECT_ID('tempdb..#tempChunksToAge') IS NOT NULL
        DROP TABLE #tempChunksToAge
    CREATE TABLE #tempChunksToAge(ChunkId int, CommcellId int, Primary Key(ChunkId, CommcellId))
    INSERT INTO #tempChunksToAge
    SELECT C.id, C.commCellId
    FROM	archChunk C WITH(NOLOCK) INNER JOIN #volIdList V ON C.volumeId = V.volumeId
 			INNER JOIN archChunkMapping CM WITH(NOLOCK) ON C.id = CM.archChunkId AND C.commCellId = CM.chunkCommCellId
    GROUP BY C.id, C.CommcellId
HAVING MIN(CM.flags & 256) = 256
    UPDATE archChunk
SET flags |= 256, agedBy |= 268435456, modifiedTime = @CurrentTime
	FROM archChunk AC INNER JOIN #tempChunksToAge T ON AC.id = T.ChunkId AND AC.commCellId = T.commCellId
    IF OBJECT_ID('tempdb..#tempChunksToAge') IS NOT NULL
        DROP TABLE #tempChunksToAge
	DELETE	FROM archAgingRule
	WHERE	copyId IN (SELECT copyId FROM #copyIdList)
	DELETE	FROM archAgingRuleExtended
	WHERE	copyId IN (SELECT copyId FROM #copyIdList)
	DELETE	FROM archSelectiveCopy
	WHERE	copyId IN (SELECT copyId FROM #copyIdList)
	DELETE	FROM archStream
	WHERE	archGroupCopyId IN (SELECT copyId FROM #copyIdList)
	DELETE	FROM archCopyToApp
	WHERE   copyId IN (SELECT copyId FROM #copyIdList)
	IF EXISTS (SELECT 1 FROM #copyIDList T, archGroup AG WITH (READUNCOMMITTED) WHERE AG.defaultSnapCopy = t.copyId AND AG.id = @i_archGroupId AND  t.isSnapCopy = 1)
	BEGIN
		DELETE FROM archGroupToApp
		WHERE archGroupId = @i_archGroupId
	END
	DELETE	FROM archChunkToCopy
	WHERE	destCopyId IN (SELECT copyId FROM #copyIdList)
	DELETE	FROM archChunkToVerify
	WHERE	archCopyId IN (SELECT copyId FROM #copyIdList)
 	DELETE	FROM CCRToSubClient
 	WHERE	DataPathId IN (SELECT dataPathId FROM #dataPathIdList)
	DELETE	FROM APP_AppToDataPath
	WHERE	dataPathId IN (SELECT dataPathId FROM #dataPathIdList)
	DELETE	FROM ArchEncKeys
	WHERE	archCopyId IN (SELECT copyId FROM #copyIdList)
	-- do not delete the backup jobs. Just update the mediaDeletedTime so that qnet has a chance
	-- to sync up this job with qnet server
	-- Update the CN table directly here since the QNet trigger is removed.
	-- So we can delete jos from JM table now! ???
	UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (disabled | 256), agedBy = (agedBy | 268435456),
			agedTime = @CurrentTime, mediaDeletedTime = @CurrentTime, modifiedTime = @CurrentTime
	WHERE	archGrpCopyId IN (SELECT copyId FROM #copyIdList)
		AND status <> 1000
	SELECT	@numJobDataStats = @@ROWCOUNT
	IF EXISTS (SELECT TOP 1 copyId FROM #copyIdList WHERE isSnapCopy > 0)
	BEGIN
		--Disable jobs for cataloging if job on source copy is aged
		UPDATE JMJobSnapDeferredCatalogStats WITH (PAGLOCK)
SET 	Disabled = JS.Disabled | 1, unPickReason = 4
		FROM JMJobSnapDeferredCatalogStats JS INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
		ON 		JS.jobId = JDS.jobId
		AND		JS.commCellId = JDS.commCellId
		INNER JOIN archGroup AG WITH (NOLOCK)
		ON 		JDS.archGrpId = AG.id
		LEFT OUTER JOIN	ArchDeferredCatalogProp B WITH (NOLOCK)
		ON 		AG.id = B.archGroupId
		WHERE (JS.Disabled & 1) = 0
		AND 	JS.catalogStatus in (101, 102, 103)
AND		JDS.dataType = 1
AND		(JDS.disabled & 256) > 0
		AND		(	B.archGroupId IS NULL
						OR	(B.sourceCopyId = 0 AND JDS.archGrpCopyId = AG.defaultSnapCopy)
						OR	(B.sourceCopyId > 0 AND JDS.archGrpCopyId = B.sourceCopyId)
					)
		--Disable jobs for backup copy if job on source copy is aged
		UPDATE JMJobSnapshotStats WITH (PAGLOCK)
SET 	Disabled = JS.Disabled | 1, unPickReason = 4
		FROM JMJobSnapshotStats JS INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
		ON 		JS.jobId = JDS.jobId
		AND		JS.commCellId = JDS.commCellId
		INNER JOIN archGroup AG WITH (NOLOCK)
		ON 		JDS.archGrpId = AG.id
		LEFT OUTER JOIN	archMaterializeSnapshotProp B WITH (NOLOCK)
		ON 		AG.id = B.archGroupId
		WHERE (JS.Disabled & 1) = 0
		AND 	JS.materializationStatus in (101, 102, 103)
AND		JDS.dataType = 1
AND		(JDS.disabled & 256) > 0
		AND		(	B.archGroupId IS NULL
						OR	(B.sourceCopyId = 0 AND JDS.archGrpCopyId = AG.defaultSnapCopy)
						OR	(B.sourceCopyId > 0 AND JDS.archGrpCopyId = B.sourceCopyId)
					)
	END
	DELETE	#jobIdList
	FROM	JMJobDataStats
	WHERE	#jobIdList.jobId = JMJobDataStats.jobId
		AND #jobIdList.commCellId = JMJobDataStats.commCellId
	/* Recycle Volumes AND Media */
	DELETE	FROM VTAlerts
WHERE	mediaId IN (SELECT mediaId FROM #volIdList WHERE MediaTypeId != 10001)
	/* Set the flags on volidlist to indicate the vol recycle processing. for gacp where a single vol can hold data from multiple copies this is important*/
	/* Only when all the chunks are pruned we should mark the vol/media as aged and move it to scratch pool. */
	/* MR:142047 - Changed the condition check to determine if there is atleast 1 chunk present which is not marked aged.*/
	UPDATE V
	SET V.flags = V.flags & ~(1)
	FROM #mediaGroupIdList M, #volIdList V
INNER JOIN archChunk C WITH (NOLOCK) ON C.volumeId = V.volumeId AND ((C.flags & 256) = 0)
	UPDATE	MMVolume
SET		MediaGroupId = 0, VolumeFlags = (CASE WHEN T.MediaTypeId = 10001 THEN 6 ELSE 5 END),
LogicalBytesMB = (CASE WHEN T.MediaTypeId = 10001 THEN V.LogicalBytesMB ELSE 0 END),
PhysicalBytesMB = (CASE WHEN T.MediaTypeId = 10001 THEN V.PhysicalBytesMB ELSE 0 END),
NumberOfActiveFiles = (CASE WHEN T.MediaTypeId = 10001 THEN V.NumberOfActiveFiles ELSE 0 END),
LastFile = (CASE WHEN T.MediaTypeId = 10001 THEN V.LastFile ELSE 0 END)
	FROM	MMVolume V, #volIdList T
	WHERE	V.VolumeId = T.VolumeId
	AND T.flags & 1 = 1
	/* Set mediaSide for non-magnetic media */
	UPDATE	MMMediaSide
	SET		LogicalBytesMB = 0, PhysicalBytesMB = 0, IsOMLValid = 0,
			FreeBytesMB = T.totalSpaceMB, isErasable = T.EraseOnPrune
	FROM	MMMediaSide S,
			(SELECT	V.MediaSideId, V.totalSpaceMB, MG.EraseOnPrune
			FROM	#volIdList V, #mediaGroupIdList MG
WHERE	MG.MediaGroupId = V.MediaGroupId AND V.MediaTypeId != 10001 AND V.flags & 1 = 1) T
	WHERE	S.MediaSideId = T.MediaSideId
	UPDATE	MMMedia
SET		SpareGroupId = T.SpareGroupId, MediaFlags = T.MediaFlags, LastWriteLibraryId = T.LastWriteLibraryId, IsInMediaGroup = 0, IsAged = (CASE WHEN T.MediaTypeId = 10001 THEN IsAged ELSE 1 END)
	FROM	MMMedia M, #volIdList T
	WHERE	M.MediaId = T.MediaId
	AND T.flags & 1 = 1
	DELETE	FROM MMMediaGroup
WHERE	mediaGroupId IN (SELECT mediaGroupId FROM #mediaGroupIdList WHERE (agcExFlags & 2) = 0)
	/*Due to the above where we want mediaGroupId to go only when GACP is deleted, we'll need to reset any MediaGroup entries which are pointing
	 to dataPaths used by dependent copies since those DPs will be cleaned up with copy deletion */
	UPDATE 	MMMediaGroup
	SET 	DataPathId = 0
	WHERE 	MediaGroupId IN (SELECT MediaGroupId FROM MMMediaGroup WITH (NOLOCK) WHERE DataPathId IN (SELECT dataPathId FROM #dataPathIdList))
	DELETE	FROM MMDataPath
	WHERE	DataPathId IN (SELECT dataPathId FROM #dataPathIdList)
	/* Delete the SILO subclient and its ondemand backupset */
IF EXISTS (SELECT * FROM #copyIdList WHERE siloAppId > 0 AND (dedupeFlags & 134217728) = 0)
	BEGIN
		DECLARE @taskIdTbl TABLE (taskId INT)
		INSERT	INTO @taskIdTbl
		SELECT	id FROM SchedBackupTask WITH (NOLOCK) --SubTaskType.BACKUP
		WHERE	backupSet IN (
				SELECT	siloBackupsetId
				FROM	#copyIdList
WHERE	siloBackupsetId > 0 AND (dedupeFlags & 134217728) = 0)
		And flags!=9999
		DELETE FROM SchedBackupTaskOptions WHERE backupTaskId IN (SELECT taskId FROM @taskIdTbl)
		DELETE FROM SchedBackupTask WHERE id IN (SELECT taskId FROM @taskIdTbl)
		DELETE FROM Schedule WHERE taskId IN (SELECT taskId FROM @taskIdTbl) and TaskType=1 -- TT_BACKUP
		delete from @taskIdTbl
		INSERT	INTO @taskIdTbl
		SELECT	id FROM SchedRestoreTask WITH (NOLOCK) -- --SubTaskType.RESTORE
		WHERE	backupSetId IN (
				SELECT	siloBackupsetId
				FROM	#copyIdList
WHERE	siloBackupsetId > 0 AND (dedupeFlags & 134217728) = 0)
		And flags!=9999
		DELETE FROM SchedRestoreTaskOptions WHERE restoreTaskId IN (SELECT taskId FROM @taskIdTbl)
		DELETE FROM SchedRestoreTask WHERE id IN (SELECT taskId FROM @taskIdTbl)
		DELETE FROM Schedule WHERE taskId IN (SELECT taskId FROM @taskIdTbl) and TaskType=2 -- TT_RESTORE
		DELETE FROM APP_SubClientProp WHERE componentNameId IN (
SELECT siloAppId FROM #copyIdList WHERE siloAppId > 0 AND (dedupeFlags & 134217728) = 0)
		DELETE FROM APP_ScFilterFile WHERE componentNameId IN (
SELECT siloAppId FROM #copyIdList WHERE siloAppId > 0 AND (dedupeFlags & 134217728) = 0)
		DELETE FROM APP_Application WHERE id IN (
SELECT siloAppId FROM #copyIdList WHERE siloAppId > 0 AND (dedupeFlags & 134217728) = 0)
		DELETE FROM APP_BackupsetProp WHERE componentNameId IN (
SELECT siloBackupsetId FROM #copyIdList WHERE siloBackupsetId > 0 AND (dedupeFlags & 134217728) = 0)
		DELETE FROM APP_BackupsetName WHERE id IN (
SELECT siloBackupsetId FROM #copyIdList WHERE siloBackupsetId > 0 AND (dedupeFlags & 134217728) = 0)
	END
	IF EXISTS (SELECT * FROM #libHistory)
		INSERT	INTO MMLibraryHistory
		SELECT	LibraryId, 1, 0, 0, 0, 0, NumberOfMediaFreed, 0, 0, 0, 0, CapacityFreedMB, 0, 0
		FROM	#libHistory
	DELETE	FROM archGroupCopy
	WHERE	id IN (SELECT copyId FROM #copyIdList)
	--MR 222361 reset sourcecopyID's set to "0" as these copies are delete
	IF EXISTS (SELECT * FROM archGroupCopy WITH (READUNCOMMITTED) WHERE sourceCopyId IN (SELECT copyId FROM #copyIdList))
		UPDATE 	archGroupCopy
		SET 	sourceCopyId = 0
		WHERE 	id IN (SELECT id FROM archGroupCopy WITH (READUNCOMMITTED) WHERE sourceCopyId IN (SELECT copyId FROM #copyIdList) AND sourceCopyId > 0)
	DELETE	archTask
	FROM	#tmpArchTask
	WHERE	archTask.id = #tmpArchTask.archTaskId
	-- Remove any storage policy group relation
	UPDATE	ArchGroupClientGroupAssociation
	SET		enabled = 0, modified =  dbo.GetUnixTime(GETUTCDATE())
	WHERE	(
				archGroupCopyId IN (SELECT copyId FROM #copyIdList)
				OR
				associatedCopyId IN (SELECT copyId FROM #copyIdList)
			)
	AND		enabled = 1
	IF	@i_copyId > 0
	BEGIN
		/* Rearrange copy precedences of the storage policy */
		UPDATE	AGC
		SET 	copy = (copy - 1)
		FROM	archGroupCopy AGC WITH (INDEX(argrcp_idx2))
		WHERE	archGroupId = @i_archGroupId AND copy > @copyPrecedence AND @copyType <> 5
		/* Reset defaultSnapCopy when deleting primary snap copy */
		IF	@defSnapCopyId = @i_copyId
			UPDATE	archGroup SET defaultSnapCopy = 0
			WHERE	id = @i_archGroupId AND defaultSnapCopy = @i_copyId
/* Reset the 32 on archGroup if this is the last dedup copy on storage policy*/
IF NOT EXISTS(SELECT 1 FROM archGroupCopy WITH (INDEX(argrcp_idx2)) WHERE ((dedupeFlags & 262144) > 0 OR SIDBStoreId > 0) AND archGroupId = @i_archGroupId)
			UPDATE 	archGroup
SET 	flags = flags & ~(32)
			WHERE 	id = @i_archGroupId
	END
	ELSE
	BEGIN
		DELETE	FROM APP_SubClientProp
		WHERE   cs_attrName IN ( CHECKSUM(N'last data SP'), CHECKSUM(N'last log SP') ) AND attrName IN ('last data SP', 'last log SP') AND attrVal = CAST (@i_archGroupId AS char(20))
		UPDATE archGroup SET logSP = 0 WHERE id IN (SELECT id FROM archGroup WITH (NOLOCK) WHERE logSP = @i_archGroupId)
		UPDATE archGroup SET incrSP = 0 WHERE id IN (SELECT id FROM archGroup WITH (NOLOCK) WHERE incrSP = @i_archGroupId)
		DELETE	FROM archGroup
		WHERE	id = @i_archGroupId
	END
	SET @errorString = @errorString + ' -- deleted successfully'
	--BEGIN AUDIT
	IF @i_userId > 0 AND @i_recursiveCall = 1
	BEGIN
		IF @i_copyId > 0
		BEGIN
				-- Set GUI Audit Operation - Delete Storage Policy Copy
SET @opMsgId = (13 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @i_copyId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- Set GUI Audit Parameter - Storage Policy Name, if we archGroupID
				IF @i_archGroupId > 1
				BEGIN
				SET @l_archGroupName = ISNULL(@l_archGroupName, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId))
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @l_archGroupName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				END
				-- Set GUI Audit Parameter - Storage Policy Copy Name
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @l_copyName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
		END
		ELSE
		BEGIN
				-- Set GUI Audit Operation - Delete Storage Policy
SET @opMsgId = (6 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @i_archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- Set GUI Audit Parameter - Storage Policy Name
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @l_archGroupName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
		END
	END
	--END AUDIT
--END TRY
--BEGIN	CATCH
	SET @dbErrorCode = ERROR_NUMBER()
--END		CATCH
CX_ERROR_EXIT:
	DROP TABLE #archFileIdList
	DROP TABLE #jobIdList
	DROP TABLE #ptoc
	DROP TABLE #adminParamList
	DROP TABLE #volIdList
	DROP TABLE #mediaGroupIdList
	DROP TABLE #copyIdList
	DROP TABLE #dataPathIdList
	DROP TABLE #libHistory
	DROP TABLE #tmpArchTask
	DROP TABLE #ToBeAgedACM
	DROP TABLE #tmpJobSizeInfo
	DROP TABLE #ToBeAgedAFCWithoutChunks
	IF @dbErrorCode IS NULL
		SET @dbErrorCode = 0
	SELECT	@dbErrorCode, @amErrorCode, @errorString, @numJobDataStats, @numMagVols, @numNonMagMedia, @tmPolicyCount
	RETURN	@dbErrorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupCopyDelete')
	delete from GxQscripts where name = 'archGroupCopyDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyDelete')
	delete from GXDBVersions where aliasname = 'archGroupCopyDelete'
GO

insert into GXDBVersions values(2, 'archGroupCopyDelete',  '00010073000200290000', 'archGroupCopyDelete', '00010073000200290000')
GO

