

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupCopyClone.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupCopyClone.sp,v $ $Id: archGroupCopyClone.sp,v 1.1.2.16 2020/04/17 14:11:04 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupCopyClone')
BEGIN
	print '>>> Drop Stored Procedure: archGroupCopyClone <<<'
	drop procedure archGroupCopyClone
END
IF EXISTS (select * from GxQscripts where name='archGroupCopyClone')
	delete from GxQscripts where name = 'archGroupCopyClone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyClone')
	delete from GXDBVersions where aliasname = 'archGroupCopyClone'
GO
print '... Creating Procedure: archGroupCopyClone'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGroupCopyClone
  @i_oldArchGroupId int,
  @i_oldArchGroupCopyId int,
  @i_newArchGroupId int,
  @i_newArchGroupName NVARCHAR(256),
  @i_newArchGroupCopyName NVARCHAR(256)
AS
  DECLARE @retVal integer;
  DECLARE @newArchGroupCopyId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
DECLARE @now	integer
SET @now = dbo.GetUnixTime(GETDATE())
SET @newArchGroupCopyId = 0
DECLARE @t_oldDefCopyId		int
DECLARE @t_oldDefSnapCopyId	int
DECLARE @t_newArchGroupCopyId		int
SET @t_oldDefCopyId		= 0
SET @t_oldDefSnapCopyId = 0
SET @t_newArchGroupCopyId		= 0
CREATE TABLE #tempCopyPair(oldCopyId int, newCopyId int)
CREATE TABLE #tempCopiesUsingGACP(oldCopyId int, newCopyId int)
CREATE TABLE #tempMediaGroupName(oldMediaGroupId int, archGroupCopyId int, stream int, mediaGroupName varchar(256))
CREATE TABLE #tempSILOBkpSet(backupSetId int, subClientId int, errorStr varchar(256))
DECLARE @oldArchGroupName NVARCHAR(256) = ''
IF NOT EXISTS (SELECT name FROM ArchGroup WHERE Id = @i_oldArchGroupId)
OR NOT EXISTS (SELECT 1 FROM ArchGroupCopy WHERE Id = @i_oldArchGroupCopyId)
OR EXISTS (SELECT 1 FROM archGroupCopy WHERE ArchGroupId = @i_newArchGroupId AND name = @i_newArchGroupCopyName)
BEGIN
	SELECT @t_newArchGroupCopyId = Id FROM ArchGroupCopy WHERE ArchGroupId = @i_newArchGroupId AND name = @i_newArchGroupCopyName
	SET	@retVal = 1
	GOTO FINISH
END
SELECT @oldArchGroupName = name FROM ArchGroup WHERE Id = @i_oldArchGroupId
	INSERT INTO archGroupCopy
			(archGroupId, copy, name, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
			SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
			sealStoreTaskId, extendedFlags, destMediaCopyId, DDBLimitExtensionTimeStamp, DDBLimitExtensionTimeStampEncrypted, archCheckValidPeriodType,
			endTime)
	SELECT	@i_newArchGroupId, (select max(copy) + 1 from archgroupcopy where archgroupId = @i_newArchGroupId),
			@i_newArchGroupCopyName, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, 0, 0, 0 /*sourceCopyId*/,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, 0,
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
			SIDBSnapIntervalHours, siloAppId, nDataInstance, 'Cloned from storage policy [' + @oldArchGroupName + '] Copy [' + name + ']' /*description*/, dedupeFlags,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
			0, extendedFlags, destMediaCopyId, 0, '', archCheckValidPeriodType,
			endTime
	FROM   archGroupCopy
	WHERE  archGroupId = @i_oldArchGroupId
	AND		Id = @i_oldArchGroupCopyId
	SELECT @t_newArchGroupCopyId = Id FROM ArchGroupCopy WHERE ArchGroupId = @i_newArchGroupId AND name = @i_newArchGroupCopyName
	INSERT INTO #tempCopyPair
	SELECT a.id, b.id
	FROM   archGroupCopy a, archGroupCopy b
	WHERE  a.Id = @i_oldArchGroupCopyId AND b.Id = @t_newArchGroupCopyId
	-- User has to manually set SIDB properties after cloning.
	-- This following will be included in post 7.0
	-- Create entries in idx* tables for SIDB copies
	DECLARE	@l_newCopyId		INT
	DECLARE @l_oldCopyId		INT
	DECLARE	@l_SIDBStoreId		INT
	DECLARE @SIDBStoreId		INT
	DECLARE @l_oldsealStoreTaskId	INT
	DECLARE @l_newsealStoreTaskId	INT
	SET	@l_newCopyId		=	@t_newArchGroupCopyId
	--SET	@l_SIDBStoreId		=	(SELECT SIDBStoreId FROM ArchGroupCopy WHERE Id = @i_oldArchGroupCopyId)
	SET @l_oldCopyId		=	@i_oldArchGroupCopyId
	SET 	@SIDBStoreId		=	0
	SET 	@l_oldsealStoreTaskId	=	(SELECT sealStoreTaskId FROM ArchGroupCopy WHERE Id = @i_oldArchGroupCopyId)
	SET 	@l_newsealStoreTaskId	=	0
	DECLARE curGetSIDBCopy CURSOR FOR
	SELECT	distinct SIDBStoreId
	FROM	archCopySIDBStore c
	WHERE	@l_oldCopyId = c.CopyId
AND c.flags & (1|4) = 4  --get all active non fulls
	OPEN	curGetSIDBCopy
	FETCH	NEXT FROM curGetSIDBCopy
	INTO	@l_SIDBStoreId
	-- loop for no of copies
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		DECLARE @copyDedupFlags int =0
		SET @copyDedupFlags = (SELECT dedupeFlags FROM archGroupCopy WHERE id = @l_newCopyId)
IF ((@copyDedupFlags & 134217728) = 0)
		BEGIN
		    INSERT	INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
							IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
							MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
							flags,
							TotalDataSizeBytes, InstancedDataSizeBytes, Status,
							LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId,
							Version, SIDBSnapPath, LastSnapTime, LastRecoveryTime,
							SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId,
							SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile,
							LastDDBVerificationTime, LastDataVerificationTime, DedupFactor)
		    SELECT	SIDBStoreName + ' Clone', SIDBStoreAliasName + ' Clone', commCellId,
				0, 0, ClientId, -1, MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType, flags, 0, 0, 0, 0,
				@now, 0, origCCSIDBStoreId, Version, SIDBSnapPath, 0, 0, 0, 0, 0, 0, SubStoreCount, 0, 0,
				0, 0, DedupFactor
		    FROM	IdxSIDBStore
		    WHERE	SIDBStoreId = @l_SIDBStoreId
		    SET		@SIDBStoreId = SCOPE_IDENTITY()
		END
		ELSE
		BEGIN
			SET @SIDBStoreId = @l_SIDBStoreId
		END
		INSERT INTO archCopySIDBStore
		SELECT @l_newCopyId, @SIDBStoreId, commCellId, flags, 0, 0
		FROM archCopySIDBStore
		WHERE SIDBStoreId = @l_SIDBStoreId
		AND CopyId = @l_oldCopyId
		UPDATE	AGC SET SIDBStoreId = @SIDBStoreId
		FROM  archGroupCopy AGC, archCopySIDBStore ACS
		WHERE	id = @l_newCopyId AND AGC.id = ACS.copyId
AND ACS.flags & 2 > 0 AND ACS.sidbStoreID = @SIDBStoreId
IF ((@copyDedupFlags & 2097152) > 0) -- check for silo enabled copy
		BEGIN
			--create SILO backupset
			declare @inputStr nvarchar(300)
			set @inputStr = '<CVGui_CreateOnDemandBackupSetReq dataArchGrpId="' + CAST(@i_newArchGroupId as varchar(10))
			set @inputStr = @inputStr + '" siloCopyId="' + CAST(@l_newCopyId as varchar(10)) + '" />'
			INSERT INTO #tempSILOBkpSet
			exec AppCreateOnDemandBackupSet @inputStr
			Update archGroupCopy
			set siloAppId = T.subClientId
			from #tempSILOBkpSet T
			where id = @l_newCopyId
			Update archGroupCopy
			set siloAppId = T.subClientId
			from #tempSILOBkpSet T
			where sourceCopyId = @l_newCopyId
			delete from #tempSILOBkpSet
		END
		IF (@l_oldsealStoreTaskId > 0)
		BEGIN
			INSERT INTO archTask
			SELECT type, flags, active, periodType, numPeriod, dayNumber, dataSizeGB, lastEvent, nextEvent, percentCorruptLimit
			FROM archTask
			WHERE id = @l_oldsealStoreTaskId
			SET @l_newsealStoreTaskId = SCOPE_IDENTITY()
			UPDATE archGroupCopy
			SET sealStoreTaskId = @l_newsealStoreTaskId
			WHERE id = @l_newCopyId
		END
IF ((@copyDedupFlags & 134217728) = 0)
		BEGIN
			DECLARE @l_SubStoreId INT
			DECLARE @l_PoolId INT
			DECLARE @l_CacheId INT
			DECLARE @l_APId INT
			SET @l_SubStoreId = 0
			SET @l_PoolId = 0
			SET @l_CacheId = 0
			SET @l_APId = 0
			--get the old substore to new SubStorePair
			DECLARE curSubStore CURSOR FOR
			SELECT a.SubStoreId, b.IdxPoolId, a.IdxCacheId, a.IdxAccessPathId
			FROM IdxSIDBSubStore a, IdxCache b
			WHERE a.SIDBStoreId = @l_SIDBStoreId
			AND a.IdxCacheId = b.IdxCacheId
			OPEN curSubStore
			FETCH NEXT FROM curSubStore
			INTO @l_SubStoreId, @l_PoolId, @l_CacheId, @l_APId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT	INTO IdxPool
				SELECT	Description, 1, IsShared, AgeingNoOfDays
				FROM	IdxPool P
				WHERE	P.IdxPoolId = @l_PoolId
				SET @l_PoolId = SCOPE_IDENTITY()
				INSERT	INTO IdxCache
				SELECT	@l_PoolId, Description + 'Cloned', 1, @now, 1, 0,
						AgeingPercentDiskspace, FillUpOrder, FreeDiskSpaceMB, -1, 0, 0, 0,
						DiskFreeThresholdMB, DiskFreeWarningThreshholdMB, IdxCacheType, DiskReadSpeed,
						DiskWriteSpeed, CatalogServerClientId, flags, TotalCapacityMB
				FROM	IdxCache IC
				WHERE	IC.IdxCacheId = @l_CacheId
				SET @l_CacheId = SCOPE_IDENTITY()
			    INSERT INTO IdxAccessPath
			    SELECT	@l_CacheId, ClientId, Path + '_SPCopy_copy' + CAST(@l_newCopyId AS varchar(8)),
					    Username, Password, Enabled, SoftState, 0, Priority, 0, ActualDaysIndexRetain, Flags,
					    AgeingNoOfDays, AgeingPercentDiskspace, DiskFreeThresholdMB, DiskFreeWarningThreshholdMB,
					    TotalCapacityMB, FreeDiskSpaceMB, DiskUsageMB, DiskUsageLastChecked, StagingCachePath, VolumeGUID
			    FROM	IdxAccessPath IA
			    WHERE	IA.IdxAccessPathId = @l_APId
			    SET @l_APId = SCOPE_IDENTITY()
			    INSERT INTO IdxSIDBSubStore
		           (SIDBStoreId, commCellId, GroupNumber, IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
		           flags, TotalDataSizeBytes, InstancedDataSizeBytes,Status, LastAccessTime,
		           CreatedTime, SealedTime, Version, SIDBSnapPath, LastSnapTime, origSubStoreId, ReconLevel, LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, 					    ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, PageSize)
			    SELECT @SIDBStoreId, commCellId, GroupNumber, @l_CacheId, @l_APId, ClientId, -1,
				flags, 0, 0, 0, 0,
				@now, 0, Version, SIDBSnapPath, 0, origSubStoreId, 0, 0, '', 0, 0, 0,
				0, '', '', '', MaxNumOfAFsInSecFile, ExtendedFlags, PageSize
			    FROM IdxSIDBSubStore Sub
			    WHERE SubStoreId = @l_SubStoreId
			    FETCH NEXT FROM curSubStore
			    INTO @l_SubStoreId, @l_PoolId, @l_CacheId, @l_APId
			END
		    CLOSE curSubStore
		    DEALLOCATE curSubStore
		END
		FETCH	NEXT FROM curGetSIDBCopy
		INTO	@l_SIDBStoreId
	END
	CLOSE		curGetSIDBCopy
	DEALLOCATE	curGetSIDBCopy
	INSERT INTO archSelectiveCopy
	SELECT b.newCopyId, a.type, a.numPeriod, a.dayNumber, a.startPeriod, a.nextPeriod, a.prevPeriodBegin, a.nextPeriodEnd
	FROM   archSelectiveCopy a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO archAgingRule
	SELECT b.newCopyId, a.retentionDays, a.fullCycles, a.flags, a.weekStart, a.monthStart, a.yearStart, a.archiverRetDays, a.retentionJobs , a.minutesSinceDayStarts
	FROM   archAgingRule a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO archAgingRuleExtended
	SELECT b.newCopyId, a.retentionDays, a.retentionRule, a.currPeriodBegin, a.currPeriodEnd, a.prevPeriodBegin, a.nextPeriodEnd, a.GraceDays , a.EveryXHours
	FROM   archAgingRuleExtended a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO archCopyMediaRefreshProp
	SELECT b.newCopyId, (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = a.targetCopyId),
	       a.flags, a.daysAfterWritten, a.daysBeforeAged, a.percentage
	FROM   archCopyMediaRefreshProp a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO MMDataPath
	SELECT b.newCopyId, a.DrivePoolId, a.HostClientId, a.Flag, a.SpareGroupId,
	a.ReadinessFlag, a.Priority, a.IsHardwareCompressed, a.ChunkSizeMB,
	a.FlushBlockSizeKB, a.UseHardwareEncryption
	FROM   MMDataPath a, #tempCopyPair b
	WHERE  a.CopyId = b.oldCopyId
	--Filter out the copies which are pointing to GACP.
	INSERT INTO #tempCopiesUsingGACP
	SELECT a.oldCopyId, a.newCopyId
	FROM #tempCopyPair a, archGroupCopy b
	WHERE a.oldCopyId = b.id
AND (b.extendedFlags & 2) > 0
	INSERT INTO archStream
	SELECT @i_newArchGroupId, b.newCopyId, a.stream, 0, a.isActive, 0, 0, a.flags
	FROM   archStream a, #tempCopyPair b
	WHERE  a.archGroupCopyId = b.oldCopyId
    --archstream entries are created so delete from #tempCopyPair
	DELETE #tempCopyPair
	WHERE oldCopyId in (select oldCopyId from #tempCopiesUsingGACP)
	INSERT INTO #tempMediaGroupName
	SELECT a.mediaGroupId, b.newCopyId, a.stream,
		   'AG[' + CAST(@i_newArchGroupId AS varchar(8)) +
		   ']_AGC[' + CAST(b.newCopyId AS varchar(8)) +
		   ']_stream[' + CAST(a.stream AS varchar(8)) + ']'
	FROM   archStream a, #tempCopyPair b
	WHERE  archGroupCopyId = b.oldCopyId
	INSERT INTO MMMediaGroup
	SELECT b.mediaGroupName, a.DrivePoolId, a.SpareGroupId, a. DesiredMediaTypeId, a.RecordingFormatId, 0
	FROM   MMMediaGroup a, #tempMediaGroupName b
	WHERE  a.MediaGroupId = b.oldMediaGroupId
	UPDATE archStream SET mediaGroupId = c.MediaGroupId
	FROM   archStream a, #tempMediaGroupName b, MMMediaGroup c
	WHERE  a.archGroupId = @i_newArchGroupId AND a.archGroupCopyId = b.archGroupCopyId AND a.stream = b.stream AND b.mediaGroupName = c.MediaGroupName
	--update archStream table with mediaGroupId of GACP copy
	IF EXISTS (SELECT * from #tempCopiesUsingGACP)
	BEGIN
	    --UPDATE archStream
	    UPDATE Dep
	    SET mediaGroupId = d.MediaGroupId
	    FROM  archStream Dep, #tempCopiesUsingGACP b, archGroupCopy c, archStream d
	    WHERE Dep.archGroupCopyId = b.newCopyId
	    AND b.oldCopyId = c.id
	    AND c.destMediaCopyId = d.archGroupCopyId
	    AND Dep.stream = d.stream
	END
	SET	@retVal = ISNULL((SELECT ERROR_NUMBER()), 0)
FINISH:
DROP TABLE #tempCopyPair
DROP TABLE #tempMediaGroupName
DROP TABLE #tempCopiesUsingGACP
DROP TABLE #tempSILOBkpSet
SELECT @retVal, @t_newArchGroupCopyId
RETURN @t_newArchGroupCopyId
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupCopyClone')
	delete from GxQscripts where name = 'archGroupCopyClone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyClone')
	delete from GXDBVersions where aliasname = 'archGroupCopyClone'
GO

insert into GXDBVersions values(2, 'archGroupCopyClone',  '00010001000200160000', 'archGroupCopyClone', '00010001000200160000')
GO

