

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupCopyCleanupByMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupCopyCleanupByMA.sp,v $ $Id: archGroupCopyCleanupByMA.sp,v 1.1.4.7 2019/11/08 01:06:11 mmani Exp $";
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupCopyCleanupByMA')
BEGIN
	print '>>> Drop Stored Procedure: archGroupCopyCleanupByMA <<<'
	drop procedure archGroupCopyCleanupByMA
END
IF EXISTS (select * from GxQscripts where name='archGroupCopyCleanupByMA')
	delete from GxQscripts where name = 'archGroupCopyCleanupByMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyCleanupByMA')
	delete from GXDBVersions where aliasname = 'archGroupCopyCleanupByMA'
GO
print '... Creating Procedure: archGroupCopyCleanupByMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupCopyCleanupByMA
  @i_options INTEGER
AS
  DECLARE @o_PolicyId INT;
  DECLARE @o_CopyId INT;
  DECLARE @o_DeletePolicy INT;
  DECLARE @o_SMRelationId INT;
  DECLARE @o_SMRelationNodeId INT;
  DECLARE @o_ControlHostId INT;
  DECLARE @o_MAClientId INT;
  DECLARE @o_ErrCode INT;
  DECLARE @o_ErrMsg VARCHAR(255);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblAGC	TABLE (archGroupId INT, archGroupName NVARCHAR(256), copyId INT, copyName NVARCHAR(256), deletePolicy INT)
DECLARE	@tblPendingAGC TABLE (archGroupId INT, copyId INT, SMRelationId INT, SMRelationNodeId INT)
DECLARE @CV_PROP_NAS_VSERVER_NAME NVARCHAR(1024) = N'NAS vServer Name'
DECLARE @tblResult TABLE
	(
		PolicyId INTEGER,
		CopyId INTEGER,
		DeletePolicy INTEGER,
		SMRelationId INTEGER,
		SMRelationNodeId INTEGER,
		ControlHostId INTEGER,
		MAClientId INTEGER
	)
INSERT	INTO @tblAGC
SELECT	AG.id, AG.name, AGC.id, AGC.name, (AG.flags & 4096)
FROM	archGroupCopy AGC WITH (NOLOCK) INNER JOIN  archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
LEFT OUTER JOIN ArchGroupControlHost AGCH WITH (NOLOCK) ON AGCH.ArchGroupId = AG.id AND AGCH.SMReplicationProtocolType = 1
WHERE	(AGC.id <> AG.defaultSnapCopy OR AGCH.ArchGroupId is not null)
	AND AGC.isSnapCopy = 1
AND ((AG.flags & 4096) <> 0 OR (AGC.flags & 1073741824) <> 0)
INSERT	INTO @tblPendingAGC
SELECT	DISTINCT T.archGroupId, T.copyId, MAP.SMRelationId, MAP.SMRelationNodeId
FROM	@tblAGC T, SMVolume V WITH (NOLOCK), SMCopyToRelationMap MAP WITH (NOLOCK)
WHERE	T.copyId > 0 AND V.CopyId = T.copyId AND MAP.ArchGroupCopyId = T.copyId
DELETE	@tblAGC
WHERE	copyId IN (SELECT copyId FROM @tblPendingAGC)
UPDATE	@tblAGC
SET		deletePolicy = 0
WHERE	archGroupId IN (SELECT DISTINCT archGroupId FROM @tblPendingAGC) AND deletePolicy <> 0
INSERT	INTO @tblResult
SELECT	T.archGroupId, T.copyId, T.deletePolicy, B.SMRelationId, SRN.SMRelationNodeId, C.ControlHostId, 0
FROM	@tblAGC T
		INNER JOIN SMCopyToRelationMap A WITH (NOLOCK) ON A.ArchGroupCopyId = T.copyId
		INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON A.SMRelationNodeId = SRN.SMRelationNodeId
		INNER JOIN SMRelation B WITH (NOLOCK) ON B.SMRelationId = A.SMRelationId
		INNER JOIN SMControlHost C WITH (NOLOCK) ON C.ControlHostId = A.ControlHostId
WHERE	(C.Flags & 2) = 0
		AND NOT EXISTS (SELECT * FROM @tblPendingAGC P WHERE B.SMRelationId = P.SMRelationId AND SRN.SMRelationNodeId < P.SMRelationNodeId)
		AND SRN.vFilerId = 0
DECLARE @tblArrayMA TABLE (ClientId INT, ReleaseId INT, SPMajor INT, useForPruning INT)
INSERT INTO @tblArrayMA
SELECT DISTINCT AC.MMHostId, 0, 0, 0
FROM	@tblResult TMP
		INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = TMP.ControlHostID
;WITH ClientSPLevel AS (
		SELECT
			TMP.ClientId AS ClientId,
			CLIENT.ReleaseId AS ReleaseId,
			PKG.HighestSP AS SPMajor,
			PKG.SpMinorVersion AS SPMinor,
			ROW_NUMBER() OVER (PARTITION BY TMP.ClientId
			ORDER BY TMP.ClientId, CLIENT.ReleaseId, PKG.HighestSP, PKG.SpMinorVersion) AS RowNum
		FROM
			@tblArrayMA TMP
			LEFT OUTER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = TMP.ClientId
			INNER JOIN SimInstalledPackages PKG (NOLOCK) ON PKG.ClientId = ISNULL(MAP.PMClientId, TMP.ClientId)
			INNER JOIN APP_Client CLIENT (NOLOCK) ON CLIENT.id = ISNULL(MAP.PMClientId, TMP.ClientId)
		WHERE
PKG.simPackageID in (51 /*N_WIN_PACKAGE_MEDIAAGENT*/, 1301 /*N_UNIX_PACKAGES_MEDIA_AGENT*/))
UPDATE  @tblArrayMA
SET     ReleaseId = SPL.ReleaseId,
		SPMajor = SPL.SPMajor
FROM    @tblArrayMA TMP, ClientSPLevel SPL
WHERE   SPL.RowNum = 1
		AND TMP.ClientId = SPL.ClientId
UPDATE	@tblArrayMA
SET		useForPruning = 1
WHERE	ReleaseId =  16 /*SIM_ID_GX_REL110*/
		AND SPMajor >= 9
-- Update MAClientId
UPDATE	TMP
SET		TMP.MAClientId = MA.ClientId
FROM	@tblResult TMP
		INNER JOIN SMArrayController AC (NOLOCK) ON AC.ArrayNum = TMP.ControlHostID
		INNER JOIN @tblArrayMA MA ON MA.ClientId = AC.MMHostId AND MA.useForPruning = 1
		INNER JOIN MMHost HOST (NOLOCK)
			ON MA.ClientId = HOST.ClientId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
--Check if there are any rows in the @tblResult table without any MA information
IF EXISTS (SELECT 1 FROM @tblResult where MAClientId = 0)
BEGIN
	DECLARE @tblTmp TABLE
	(
		PolicyId INTEGER,
		CopyId INTEGER,
		SrcCopyId INTEGER,
		SrcMAClientId INTEGER
	)
	--This table will be populated only when the MAClient = 0 indicates that no MA was found for the SP/copy
	INSERT INTO @tblTmp
	SELECT T.PolicyId, T.copyId, AGC.id , 0
	FROM @tblResult T
	INNER JOIN archGroupCopy AGC (NOLOCK) ON T.PolicyId = AGC.archGroupId
	WHERE AGC.isSnapCopy = 1  AND AGC.sourceCopyId = 0
	AND T.MAClientId = 0
	UPDATE  TMP
	SET     TMP.SrcMAClientId = D.ClientId
	FROM    @tblTmp TMP
INNER JOIN MMDataPath DP (NOLOCK) ON TMP.SrcCopyId = DP.CopyId AND (DP.Flag & 1 = 1) --if the least significant bit is set then it indicates the default datapath
	INNER JOIN MMDrivePool D (NOLOCK) ON DP.DrivePoolId = D.DrivePoolId
	INNER JOIN MMHost HOST (NOLOCK) ON D.ClientId = HOST.ClientId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
	UPDATE TMP1
	SET TMP1.MAClientId = TMP2.SrcMAClientId
	FROM @tblResult TMP1
	INNER JOIN @tblTmp TMP2 ON TMP1.PolicyId = TMP2.PolicyId
END
DELETE FROM @tblResult
WHERE MAClientId = 0
SELECT *, 0, '' FROM @tblResult
ORDER BY ControlHostId ASC, PolicyId ASC, copyId DESC
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupCopyCleanupByMA')
	delete from GxQscripts where name = 'archGroupCopyCleanupByMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyCleanupByMA')
	delete from GXDBVersions where aliasname = 'archGroupCopyCleanupByMA'
GO

insert into GXDBVersions values(2, 'archGroupCopyCleanupByMA',  '00010001000400070000', 'archGroupCopyCleanupByMA', '00010001000400070000')
GO

