

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupCopyCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupCopyCleanup.sp,v $ $Id: archGroupCopyCleanup.sp,v 1.6.60.6 2018/12/22 12:11:52 mtayal Exp $";
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupCopyCleanup')
BEGIN
	print '>>> Drop Stored Procedure: archGroupCopyCleanup <<<'
	drop procedure archGroupCopyCleanup
END
IF EXISTS (select * from GxQscripts where name='archGroupCopyCleanup')
	delete from GxQscripts where name = 'archGroupCopyCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyCleanup')
	delete from GXDBVersions where aliasname = 'archGroupCopyCleanup'
GO
print '... Creating Procedure: archGroupCopyCleanup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupCopyCleanup
  @i_options INTEGER
AS
  DECLARE @o_PolicyId INTEGER;
  DECLARE @o_PolicyName NVARCHAR(255);
  DECLARE @o_CopyId INTEGER;
  DECLARE @o_CopyName NVARCHAR(255);
  DECLARE @o_DeletePolicy INTEGER;
  DECLARE @o_ExtRelationId INTEGER;
  DECLARE @o_RelationNodeId INTEGER;
  DECLARE @o_ControlHostId INTEGER;
  DECLARE @o_SMArrayId NVARCHAR(255);
  DECLARE @o_SMHostUserName NVARCHAR(255);
  DECLARE @o_SMHostPassword NVARCHAR(255);
  DECLARE @o_ExtRelationSID NVARCHAR(512);
  DECLARE @o_RelationNodeSID NVARCHAR(512);
  DECLARE @o_UseTunneling INT;
  DECLARE @o_VolumeName NVARCHAR(255);
  DECLARE @o_vServerName NVARCHAR(255);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblAGC	TABLE (archGroupId INT, archGroupName NVARCHAR(256), copyId INT, copyName NVARCHAR(256), deletePolicy INT)
DECLARE	@tblPendingAGC TABLE (archGroupId INT, copyId INT, SMRelationId INT, SMRelationNodeId INT)
DECLARE @CV_PROP_NAS_VSERVER_NAME NVARCHAR(1024) = N'NAS vServer Name'
DECLARE @tblResult TABLE
	(
		PolicyId INTEGER,
		PolicyName NVARCHAR(255),
		CopyId INTEGER,
		CopyName NVARCHAR(255),
		DeletePolicy INTEGER,
		ExtRelationId INTEGER,
		RelationNodeId INTEGER,
		ControlHostId INTEGER,
		SMArrayId NVARCHAR(255),
		SMHostUserName NVARCHAR(255),
		SMHostPassword NVARCHAR(255),
		ExtRelationSID NVARCHAR(512),
		RelationNodeSID NVARCHAR(512),
		UseTunneling INT,
		VolumeName	NVARCHAR(255),
		vServerName NVARCHAR(255),
		credAssocId INT
	)
INSERT	INTO @tblAGC
SELECT	AG.id, AG.name, AGC.id, AGC.name, (AG.flags & 4096)
FROM	archGroupCopy AGC WITH (NOLOCK) INNER JOIN  archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
LEFT OUTER JOIN ArchGroupControlHost AGCH WITH (NOLOCK) ON AGCH.ArchGroupId = AG.id AND AGCH.SMReplicationProtocolType = 1
WHERE	(AGC.id <> AG.defaultSnapCopy OR AGCH.ArchGroupId is not null)
	AND AGC.isSnapCopy = 1
AND ((AG.flags & 4096) <> 0 OR (AGC.flags & 1073741824) <> 0)
INSERT	INTO @tblPendingAGC
SELECT	DISTINCT T.archGroupId, T.copyId, MAP.SMRelationId, MAP.SMRelationNodeId
FROM	@tblAGC T, SMVolume V WITH (NOLOCK), SMCopyToRelationMap MAP WITH (NOLOCK)
WHERE	T.copyId > 0 AND V.CopyId = T.copyId AND MAP.ArchGroupCopyId = T.copyId
DELETE	@tblAGC
WHERE	copyId IN (SELECT copyId FROM @tblPendingAGC)
UPDATE	@tblAGC
SET		deletePolicy = 0
WHERE	archGroupId IN (SELECT DISTINCT archGroupId FROM @tblPendingAGC) AND deletePolicy <> 0
INSERT	INTO @tblResult
SELECT	T.archGroupId, T.archGroupName, T.copyId, T.copyName, T.deletePolicy,
		(CASE WHEN ISNUMERIC(B.ExtRelationId) = 1 THEN CAST(B.ExtRelationId AS INTEGER) ELSE 0 END),
		(CASE WHEN ISNUMERIC(SRN.ExtNodeId) = 1 THEN CAST(SRN.ExtNodeId AS INTEGER) ELSE 0 END),
		SRN.vFilerId, '', '', '', B.ExtRelationId, SRN.ExtNodeId, 0, SRN.vFiler, '', -1
FROM	@tblAGC T, SMCopyToRelationMap A WITH (NOLOCK) INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON A.SMRelationNodeId = SRN.SMRelationNodeId,
		SMRelation B WITH (NOLOCK), SMControlHost C WITH (NOLOCK)
WHERE	A.ArchGroupCopyId = T.copyId AND B.SMRelationId = A.SMRelationId AND C.ControlHostId = A.ControlHostId
		AND NOT EXISTS (SELECT * FROM @tblPendingAGC P WHERE B.SMRelationId = P.SMRelationId AND SRN.SMRelationNodeId < P.SMRelationNodeId)
		AND SRN.vFilerId > 0
UPDATE	TMP
SET		TMP.SMArrayId = HOST.SMArrayId,
		TMP.SMHostUserName = HOST.SMHostUserName,
		TMP.SMHostPassword = HOST.SMHostPassword,
		TMP.credAssocId    = HOST.CredentialId,
		UseTunneling = CFg.ValueInt
FROM	@tblResult TMP
		INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = TMP.ControlHostId
		INNER JOIN SMConfigs CFG (NOLOCK) ON HOST.ControlHostId = CFG.ArrayId AND CFG.AssocId = HOST.ControlHostId
		INNER JOIN SMMasterConfigs MCFG (NOLOCK) ON MCFG.KeyName = 'SMCONFIG_NAME_USE_TUNNELING' AND MCFG.VendorId = 3
					AND MCFg.ID = CFG.MasterConfigId
UPDATE	TMP
SET		TMP.SMArrayId = PHY_HOST.SMArrayId,
		TMP.SMHostUserName = PHY_HOST.SMHostUserName,
		TMP.SMHostPassword = PHY_HOST.SMHostPassword,
		TMP.credAssocId    = PHY_HOST.CredentialId
FROM	@tblResult TMP
		INNER JOIN SMControlHost HOST(NOLOCK)
			ON HOST.ControlhostId = TMP.ControlHostId
		INNER JOIN APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = HOST.ClientId
		INNER JOIN SMControlHost PHY_HOST (NOLOCK) ON PHY_HOST.ClientId = MAP.PMClientId
WHERE	TMP.UseTunneling = 1
UPDATE	TMP
SET		TMP.vServerName = PROP.attrVal
FROM	@tblResult TMP
		INNER JOIN SMControlHost HOST(NOLOCK)
			ON HOST.ControlhostId = TMP.ControlHostId
		INNER JOIN APP_ClientProp PROP (NOLOCK) ON PROP.componentNameId = HOST.ClientId
			AND PROP.attrName = @CV_PROP_NAS_VSERVER_NAME
WHERE	TMP.UseTunneling = 1
--update credentials if credentials are stored in credential manager
BEGIN
	IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
	CREATE TABLE #AssocToCMCredentials (
	assocId 			INTEGER,
	credentialId 		INTEGER,
	userName			nvarchar(MAX) default '',
	password			nvarchar(MAX) default '',
	credentialInfoXml   xml default '',
	flags				int default 0,
	recordType			int default 0
	)
	INSERT INTO #AssocToCMCredentials (assocId, credentialId)
		SELECT DISTINCT InArray.credAssocId, 0
		FROM @tblResult InArray
		WHERE InArray.credAssocId > 0
	exec AppGetAssocToCMCredentialsList
	UPDATE InArray
	SET	InArray.SMHostUserName = Creds.userName, InArray.SMHostPassword = Creds.password
	FROM @tblResult InArray
		INNER JOIN #AssocToCMCredentials Creds ON Creds.assocId = InArray.credAssocId
	IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
END
SELECT PolicyId, PolicyName, CopyId, CopyName, DeletePolicy, ExtRelationId, RelationNodeId, ControlHostId, SMArrayId, SMHostUserName, SMHostPassword, ExtRelationSID, RelationNodeSID, UseTunneling, VolumeName, vServerName
FROM @tblResult
ORDER BY ControlHostId ASC, PolicyId ASC, copyId DESC
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupCopyCleanup')
	delete from GxQscripts where name = 'archGroupCopyCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupCopyCleanup')
	delete from GXDBVersions where aliasname = 'archGroupCopyCleanup'
GO

insert into GXDBVersions values(2, 'archGroupCopyCleanup',  '00010006006000060000', 'archGroupCopyCleanup', '00010006006000060000')
GO

