

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupConfigClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGroupConfigClientGroup.sp,v $ $Id: ArchGroupConfigClientGroup.sp,v 1.1.2.9 2018/06/11 18:46:11 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGroupConfigClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: ArchGroupConfigClientGroup <<<'
	drop procedure ArchGroupConfigClientGroup
END
IF EXISTS (select * from GxQscripts where name='ArchGroupConfigClientGroup')
	delete from GxQscripts where name = 'ArchGroupConfigClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGroupConfigClientGroup')
	delete from GXDBVersions where aliasname = 'ArchGroupConfigClientGroup'
GO
print '... Creating Procedure: ArchGroupConfigClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchGroupConfigClientGroup
  @i_archGroupId int,
  @i_clientGroupId int,
  @i_storagePolicyGroupId int = 0,
  @i_flags int = 1
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
DECLARE @now	integer
SET @now = dbo.GetUnixTime(GETUTCDATE())
IF NOT EXISTS (SELECT 1 FROM APP_ClientGroup WHERE id = @i_clientGroupId)
OR @i_archGroupId > 0 AND NOT EXISTS (SELECT 1 FROM ArchGroup where id = @i_archGroupId)
BEGIN
	SET @retVal = 1
	GOTO FINISH
END
IF @i_flags = 0
BEGIN
	SET @i_flags = 1 -- Default is to create storage policy group for region based client group
END
DECLARE @currentStoragePolicyGroupId	int = 0
DECLARE @currentArchGroupName			NVARCHAR(256)
SET @currentArchGroupName = ''
DECLARE @currentDefaultCopyId			int = 0
DECLARE @currentAttributes				int = 0
-- When ginve archgroupId is 0, this is reset the relation of archgroup, storage policy group and client group.
IF @i_archGroupId > 0
BEGIN
	SELECT @currentArchGroupName = name, @currentDefaultCopyId = defaultCopy, @currentAttributes = 1
	FROM	ArchGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
END
SAVE TRANSACTION CONFIG_TRANS
-- Step 1: figure out the correct storage policy group Id
IF @i_storagePolicyGroupId > 0
AND EXISTS (SELECT	1 FROM	ArchStoragePolicyGroup WITH (NOLOCK) WHERE storagePolicyGroupId = @i_storagePolicyGroupId)
BEGIN
	SET @currentStoragePolicyGroupId = @i_storagePolicyGroupId
END
ELSE IF @i_archGroupId > 0
BEGIN
	-- Step 1.1. For type 1 (region based storage policy group), select the current storage policy group Id.
	--			If no such storage policy exists, create a new one with given archgroup and flag.
	-- Step 1.2. For other type (not 1), select current storage policy id based on the archgroup and flag
	--			If no such storage policy exists, create a new one with given archgroup and flag.
	IF @i_flags = 1
	BEGIN
		-- Create a default storage policy group. Right now, it doesn't show up in GUI
		SELECT @currentStoragePolicyGroupId = storagePolicyGroupId
		FROM	ArchStoragePolicyGroup WITH (NOLOCK)
		WHERE	flags = 1 /*storage policy group type for region based client group backup feature*/
	END
	ELSE
	BEGIN
		-- There is an assumption in the following, that one storage policy only belongs to one storage policy group.
		-- If supporting one storage policy for multiple storage policy group, or given storage policy points to existing storage policy group,
		-- the storage policy group has be created before hand and Id should be passed as parameter storagePolicyGroupId.
		SELECT @currentStoragePolicyGroupId = a.storagePolicyGroupId
		FROM	ArchStoragePolicyGroup a WITH (NOLOCK), ArchGroupClientGroupAssociation b WITH (NOLOCK)
		WHERE	a.storagePolicyGroupId = b.StoragePolicyGroupId
		AND		b.archGroupId = @i_archGroupId
		AND		a.flags = @i_flags
	END
	IF @currentStoragePolicyGroupId = 0
	BEGIN
		INSERT INTO ArchStoragePolicyGroup (flags, defaultStoragePolicyId)
		SELECT @i_flags, 0
		SELECT @currentStoragePolicyGroupId = SCOPE_IDENTITY()
	END
END
-- If the storage policy group already exists, try to adjust the stored values
If @currentStoragePolicyGroupId > 0
BEGIN
	UPDATE  a
	SET		enabled = 0, modified = @now
	FROM	ArchGroupClientGroupAssociation a
			LEFT JOIN APP_ClientGroup clientgroup WITH (NOLOCK) ON a.ClientGroupId = clientgroup.Id
			LEFT JOIN ArchGroup policy WITH (NOLOCK) ON a.archGroupId = policy.Id
			LEFT JOIN ArchGroupCopy copy WITH (NOLOCK) ON a.archGroupCopyId = copy.Id
			LEFT JOIN ArchGroupCopy secCopy WITH (NOLOCK) ON a.associatedCopyId = secCopy.Id
			LEFT JOIN APP_ClientGroup secClientGroup WITH (NOLOCK) ON a.associatedClientGroupId = secClientGroup.Id
	WHERE	a.storagePolicyGroupId = @currentStoragePolicyGroupId
	--AND		a.clientGroupId = @i_clientGroupId
	AND		a.enabled = 1
	AND		( clientgroup.Id IS NULL
				OR
				policy.Id IS NULL
				OR
				copy.Id IS NULL
				OR
				a.associatedCopyId > 0 AND secCopy.Id IS NULL
				OR
				a.associatedClientGroupId > 0 AND secClientGroup.Id IS NULL
			)
	IF NOT EXISTS (SELECT	a.defaultStoragePolicyId
					FROM	ArchStoragePolicyGroup a WITH (NOLOCK), ArchGroupClientGroupAssociation b WITH (NOLOCK)
					WHERE	a.storagePolicyGroupId = @currentStoragePolicyGroupId
					AND		a.storagePolicyGroupId = b.storagePolicyGroupId
					AND		a.defaultStoragePolicyId = b.archGroupId
					AND		b.clientGroupId = @i_clientGroupId
					AND		b.enabled = 1)
	BEGIN
		UPDATE ArchStoragePolicyGroup SET defaultStoragePolicyId = @i_archGroupId
		WHERE storagePolicyGroupId = @currentStoragePolicyGroupId
	END
END
-- End of Step 1: figure out the correct storage policy group Id
-- Step 2: create relation between storage policy group and the given archgroup
-- At this point, current storage policy group and current archGroup value can be 0, but client group should be valid.
--  This case, it is to reset client group relation with storage policy group.
IF @currentStoragePolicyGroupId = 0 and @i_archGroupId = 0 and @i_clientGroupId > 0
BEGIN
	UPDATE ArchGroupClientGroupAssociation
	SET		enabled = 0, modified = @now
	WHERE	clientGroupId = @i_clientGroupId
	AND		enabled = 1
	GOTO FINISH
END
ELSE IF @currentStoragePolicyGroupId = 0
BEGIN
	GOTO FINISH
END
DECLARE @previousArchGroupId int  = 0
SELECT TOP 1 @previousArchGroupId = ArchGroupId
FROM	ArchGroupClientGroupAssociation WITH (NOLOCK)
WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
AND		clientGroupId = @i_clientGroupId
AND		associatedCopyId = 0 -- If the value points to a copy Id, it is cloned by the process and point to a primary copy from another archgroup
AND		enabled = 1
-- Reset storage policy for client group.
-- There is an assumption that one client group can point to only one storage policy group at any given time.
-- But several client groups can point to the same storeage policy.
IF @i_archGroupId > 0 AND @previousArchGroupId = @i_archGroupId
BEGIN
	GOTO FINISH
END
ELSE
BEGIN
	-- Since there may be several copies for each archgroup in table ArchGroupClientGroupAssociation for the given storage policy group and client group,
	-- changing the archgroup for given client group will make all the enties from the same archgroup invalid.
	UPDATE ArchGroupClientGroupAssociation
	SET		enabled = 0, modified = @now
	WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
	AND		clientGroupId = @i_clientGroupId
	AND		enabled = 1
	-- Since there could be several client groups pointing to the same storage policy group.
	-- These entries are created by copy clone process for pointing the secondary copy of current archgroup to one of the client group and archgroup's primary copy
	UPDATE ArchGroupClientGroupAssociation
	SET		enabled = 0, modified = @now
	WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
	AND		associatedClientGroupId = @i_clientGroupId
	AND		enabled = 1
	IF @i_archGroupId = 0
		GOTO FINISH
END
-- At this point, archgroup, storage policy group and client group should all have valid values.
-- All the entries for the previous archgroup of given client group should be marked invalid at this point.
-- Create entry for storage policy and copy with client group
INSERT INTO ArchGroupClientGroupAssociation
			(storagePolicyGroupId, archGroupId, archGroupCopyId, clientGroupId, enabled, attributes, associatedCopyId, associatedClientGroupId, created, modified)
SELECT @currentStoragePolicyGroupId, @i_archGroupId, @currentDefaultCopyId, @i_clientGroupId, 1, @currentAttributes, 0, 0, @now, 0
-- If there is no other client group exists for the same storage policy group, then skip rest of the logic.
IF NOT EXISTS (SELECT 1 FROM ArchGroupClientGroupAssociation WITH (NOLOCK)
				WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
				AND		clientGroupId > 0 AND archGroupId > 0
				AND		ClientGroupId != @i_clientGroupId
				AND		enabled = 1)
BEGIN
	GOTO FINISH
END
-- End of Step 2: create relation between storage policy group and the given archgroup
-- Step 3: create secondary copy info if there are several client group associated with the given storage policy group.
DECLARE @currentRegionalStoragePolicyAndCopyList TABLE
	(
		ClientGroupId	int,
		ArchGroupId		int,
		ArchGroupCopyId int,
		IsPrimary		int
	)
DECLARE @copyCloneResult TABLE
	(
		retCode			int,
		newCopyId		int
	)
if exists (select value from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_AUTO_CLONE_COPY_FOR_CLIENT_GROUP_STORAGE_POLICY' and value = 1)
BEGIN
	INSERT INTO @currentRegionalStoragePolicyAndCopyList (ClientGroupId, ArchGroupId, ArchGroupCopyId, IsPrimary)
	SELECT		DISTINCT a.ClientGroupId, a.ArchGroupId, a.ArchGroupCopyId, 1
	FROM		ArchGroupClientGroupAssociation a WITH (NOLOCK), ArchGroup b WITH (NOLOCK)
	WHERE		a.storagePolicyGroupId = @currentStoragePolicyGroupId
	AND			a.ClientGroupId > 0 AND a.ClientGroupId != @i_clientGroupId
	AND			a.ArchGroupId > 0 -- AND a.ArchGroupId != @i_archGroupId
	AND			a.ArchGroupId = b.Id
	AND			a.ArchGroupCopyId = b.defaultCopy
	AND			enabled = 1
END
-- 1. For each existing client group and storage policy, add a secondary copy for the newly added client group and its storage policy primary copy.
-- 2. For newly added client group and its storage policy, add secondary copies for every existing client group and their storage polciy primary copies.
-- 3. Entries for every newly added copy should be added to table ArchGroupClientGroupAssociation, and point to associated primary copy and client group.
DECLARE @cloneSourceClientGroupId int = 0
DECLARE @cloneSourceArchGroupId int = 0
DECLARE @cloneSourceArchGroupPrimaryCopyId int = 0
DECLARE @cloneSourceArchGroupName NVARCHAR(256)
SET  @cloneSourceArchGroupName = ''
DECLARE @newCopyid int = 0
DECLARE @description NVARCHAR(MAX)
SET @description = ''
-- This is a list for all the copies from all the existing client group archgroups, except the newly added client group.
DECLARE getRegionalStoragePolicy CURSOR LOCAL FOR
SELECT	a.ClientGroupId, a.ArchGroupId, a.ArchGroupCopyId, b.name
FROM	@currentRegionalStoragePolicyAndCopyList a, ArchGroup b
WHERE	a.ArchGroupId = b.Id
AND		a.ArchGroupId != @i_ArchGroupId
OPEN	getRegionalStoragePolicy
FETCH	NEXT FROM getRegionalStoragePolicy
INTO	@cloneSourceClientGroupId, @cloneSourceArchGroupId, @cloneSourceArchGroupPrimaryCopyId,  @cloneSourceArchGroupName
-- loop for no of copies
WHILE	@@FETCH_STATUS = 0
BEGIN
	SET @newCopyId = 0
	-- For current storage policy, if the entries exists for the given regional storage policy primary copy
	SELECT @newCopyId = ArchGroupCopyId
	FROM ArchGroupClientGroupAssociation
	WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
	AND		ArchGroupId = @i_archGroupId
	AND		associatedCopyId > 0 AND associatedCopyId = @cloneSourceArchGroupPrimaryCopyId
	IF NOT EXISTS (SELECT 1 FROM ArchGroupCopy WHERE id = @newCopyId)
	BEGIN
		SET @newCopyId = 0
	END
	-- If the secondary copy was created before and removed from association later, then don't do clone again. Just reuse the copy.
	IF @newCopyId > 0
	BEGIN
		INSERT INTO ArchGroupClientGroupAssociation
					(storagePolicyGroupId, archGroupId, archGroupCopyId, clientGroupId, enabled, attributes, associatedCopyId, associatedClientGroupId, created, modified)
		SELECT TOP 1 storagePolicyGroupId, archGroupId, archGroupCopyId,
				@i_clientGroupId,
				1, attributes, associatedCopyId, @cloneSourceClientGroupId,
				@now, 0
		FROM	ArchGroupClientGroupAssociation
		WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
		AND ArchGroupId = @i_archGroupId
		--AND clientGroupId != @i_clientGroupId
		AND		associatedCopyId > 0 AND associatedCopyId = @cloneSourceArchGroupPrimaryCopyId
		AND		archGroupCopyId = @newCopyId
	END
	ELSE
	BEGIN
		-- Check if current source primary copy is using GDSP. If not, don't do clone copy.
IF EXISTS (SELECT 1 FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = @cloneSourceArchGroupPrimaryCopyId AND (dedupeFlags & 134217728) > 0)
		BEGIN
IF (LEN(@cloneSourceArchGroupName) + 8) > 64
SET @description = 'Clone [' + SUBSTRING(@cloneSourceArchGroupName, 0, 64 - 12)  + '...]'
ELSE IF (LEN(@cloneSourceArchGroupName) + 51) > 64
				SET @description  = 'Clone [' + @cloneSourceArchGroupName + ']'
			ELSE
			BEGIN
				IF @i_flags = 1
					SET @description =  'Regional Support for Storage Policy [' + @cloneSourceArchGroupName + ']'
				ELSE
					SET @description =  'Dynamica Client Group Support for Storage Policy [' + @cloneSourceArchGroupName + ']'
			END
			DELETE FROM @copyCloneResult
			BEGIN TRY
				INSERT INTO @copyCloneResult
				EXEC @newCopyid = archGroupCopyClone @cloneSourceArchGroupId, @cloneSourceArchGroupPrimaryCopyId, @i_archGroupId, '', @description
			END TRY
			BEGIN CATCH
				SET @retVal = 1
				GOTO FINISH
			END CATCH
			INSERT INTO ArchGroupClientGroupAssociation
						(storagePolicyGroupId, archGroupId, archGroupCopyId, clientGroupId, enabled, attributes, associatedCopyId, associatedClientGroupId, created, modified)
			SELECT @currentStoragePolicyGroupId, @i_archGroupId, @newCopyid,
					@i_clientGroupId,
					1, @currentAttributes, @cloneSourceArchGroupPrimaryCopyId, @cloneSourceClientGroupId,
					@now, 0
		END
	END
	-- For storage policies used by other regional client group, check if row exists for current storage policy primary copy
	SET @newCopyId = 0
	SELECT @newCopyId = ArchGroupCopyId
	FROM ArchGroupClientGroupAssociation
	WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
	AND		ArchGroupId = @cloneSourceArchGroupId
	AND		associatedCopyId > 0 AND associatedCopyId = @currentDefaultCopyId
	IF NOT EXISTS (SELECT 1 FROM ArchGroupCopy WHERE id = @newCopyId)
	BEGIN
		SET @newCopyId = 0
	END
	IF @newCopyId > 0
	BEGIN
		INSERT INTO ArchGroupClientGroupAssociation
					(storagePolicyGroupId, archGroupId, archGroupCopyId, clientGroupId, enabled, attributes, associatedCopyId, associatedClientGroupId, created, modified)
		SELECT TOP 1 storagePolicyGroupId, archGroupId, archGroupCopyId,
				@cloneSourceClientGroupId,
				1, attributes, associatedCopyId, @i_clientGroupId,
				@now, 0
		FROM	ArchGroupClientGroupAssociation
		WHERE	storagePolicyGroupId = @currentStoragePolicyGroupId
		AND		ArchGroupId = @cloneSourceArchGroupId
		--AND		clientGroupId != @cloneSourceClientGroupId
		AND		associatedCopyId > 0 AND associatedCopyId = @currentDefaultCopyId
		AND		archGroupCopyId = @newCopyId
	END
	ELSE
	BEGIN
		-- Check if current source primary copy is using GDSP. If not, don't do clone copy.
IF EXISTS (SELECT 1 FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = @currentDefaultCopyId AND (dedupeFlags & 134217728) > 0)
		BEGIN
			SELECT @cloneSourceArchGroupName = name FROM ArchGroup WHERE Id = @i_archGroupId
IF (LEN(@cloneSourceArchGroupName) + 8) > 64
SET @description = 'Clone [' + SUBSTRING(@cloneSourceArchGroupName, 0, 64 - 12)  + '...]'
ELSE IF (LEN(@cloneSourceArchGroupName) + 51) > 64
				SET @description  = 'Clone [' + @cloneSourceArchGroupName + ']'
			ELSE
			BEGIN
				IF @i_flags = 1
					SET @description =  'Regional Support for Storage Policy [' + @cloneSourceArchGroupName + ']'
				ELSE
					SET @description =  'Dynamica Client Group Support for Storage Policy [' + @cloneSourceArchGroupName + ']'
			END
			DELETE FROM @copyCloneResult
			BEGIN TRY
				INSERT INTO @copyCloneResult
				EXEC @newCopyid = archGroupCopyClone @i_archGroupId, @currentDefaultCopyId, @cloneSourceArchGroupId, '', @description
			END TRY
			BEGIN CATCH
				SET @retVal = 1
				GOTO FINISH
			END CATCH
			INSERT INTO ArchGroupClientGroupAssociation
						(storagePolicyGroupId, archGroupId, archGroupCopyId, clientGroupId, enabled, attributes, associatedCopyId, associatedClientGroupId, created, modified)
			SELECT @currentStoragePolicyGroupId, @cloneSourceArchGroupId, @newCopyid,
					@cloneSourceClientGroupId,
					1, @currentAttributes, @currentDefaultCopyId, @i_clientGroupId,
					@now, 0
		END
	END
	FETCH	NEXT FROM getRegionalStoragePolicy
	INTO	@cloneSourceClientGroupId, @cloneSourceArchGroupId, @cloneSourceArchGroupPrimaryCopyId,  @cloneSourceArchGroupName
END
CLOSE		getRegionalStoragePolicy
DEALLOCATE	getRegionalStoragePolicy
-- End of Step 3: create secondary copy info if there are several client group associated with the given storage policy group.
FINISH:
IF @retVal = 1
BEGIN
	ROLLBACK TRANSACTION CONFIG_TRANS
END
SELECT @retVal
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupConfigClientGroup')
	delete from GxQscripts where name = 'archGroupConfigClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupConfigClientGroup')
	delete from GXDBVersions where aliasname = 'archGroupConfigClientGroup'
GO

insert into GXDBVersions values(2, 'archGroupConfigClientGroup',  '00010001000200090000', 'archGroupConfigClientGroup', '00010001000200090000')
GO

