

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupClone.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupClone.sp,v $ $Id: archGroupClone.sp,v 1.70.2.27.4.1 2021/01/29 03:17:14 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archGroupClone')
BEGIN
	print '>>> Drop Stored Procedure: archGroupClone <<<'
	drop procedure archGroupClone
END
IF EXISTS (select * from GxQscripts where name='archGroupClone')
	delete from GxQscripts where name = 'archGroupClone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupClone')
	delete from GXDBVersions where aliasname = 'archGroupClone'
GO
print '... Creating Procedure: archGroupClone'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archGroupClone
  @i_oldArchGrpId int,
  @i_newArchGrpName NVARCHAR(256)
AS
  DECLARE @retVal integer;
  DECLARE @newArchGroupId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @t_oldDefCopyId		int
DECLARE @t_oldDefSnapCopyId	int
DECLARE @t_newArchGrpId		int
SET @t_oldDefCopyId		= 0
SET @t_oldDefSnapCopyId = 0
SET @t_newArchGrpId		= 0
DECLARE @o_retVal INT = 0
DECLARE @now	integer
SET @now = dbo.GetUnixTime(GETDATE())
CREATE TABLE #tempCopyPair(oldCopyId int, newCopyId int)
CREATE TABLE #tempCopiesUsingGACP(oldCopyId int, newCopyId int)
CREATE TABLE #tempMediaGroupName(oldMediaGroupId int, archGroupCopyId int, stream int, mediaGroupName varchar(256))
CREATE TABLE #tempSILOBkpSet(backupSetId int, subClientId int, errorStr varchar(256))
IF EXISTS (SELECT 1 FROM archGroup WHERE name = @i_newArchGrpName)
BEGIN
	SET	@o_retVal = 1
	GOTO FINISH
END
--BEGIN TRY
	INSERT INTO archGroup
	SELECT 0, @i_newArchGrpName, 'Cloned from storage policy ' + name,
		   maxStreams, type, incrSP, 0, 0, 0, SIBlockSizeKB,
AuxCopyAlertGB, AuxCopyAlertDays, (flags | 8192), '', TimeZoneType, TimeZone, SubclientExtensionTimeStamp, SubclientExtensionTimeStampEncrypted, logSP
	FROM   archGroup
	WHERE  id = @i_oldArchGrpId
	SELECT @t_oldDefCopyId = defaultCopy, @t_oldDefSnapCopyId = defaultSnapCopy FROM archGroup WHERE id = @i_oldArchGrpId
	SET @t_newArchGrpId = (SELECT id FROM archGroup WHERE name = @i_newArchGrpName)
	INSERT	INTO UMGroupAssociation
	SELECT	groupId, type1, @t_newArchGrpId, type2, id2, type3, id3, type4, id4, flag
	FROM	UMGroupAssociation
	WHERE	type1 = 2231 AND id1 = @i_oldArchGrpId
	IF dbo.isNewSecurity() = 1
	BEGIN
		DECLARE @errorCode INT
		DECLARE @errorString NVARCHAR(MAX)
EXEC sec_cloneSecurityAssociationsFromEntity 1, 0, @errorCode OUTPUT, @errorString OUTPUT, 17, @i_oldArchGrpId, 17, @t_newArchGrpId
	END
	INSERT INTO archContentIndexingRules
	SELECT @t_newArchGrpId, enabled, type, flags, cloudId, startTime, sourceCopyId, deferredDays, retentionDays,
			numPeriod, dayNumber, startPeriod, nextPeriod, calendarId, minDocSizeKB, maxDocSizeKB, includeDocTypes, excludeDocTypes,
			entityIds, prevPeriodBegin, nextPeriodEnd, filterSelected, operationType
	FROM   archContentIndexingRules
	WHERE  archGroupId = @i_oldArchGrpId
	INSERT INTO archMaterializeSnapshotProp
	SELECT @t_newArchGrpId, enabled, type, flags, startTime, sourceCopyId, deferredDays,
			numPeriod, dayNumber, currPeriodBegin, currPeriodEnd, calendarId, numOfReaders, prevPeriodBegin, nextPeriodEnd
	FROM   archMaterializeSnapshotProp
	WHERE  archGroupId = @i_oldArchGrpId
	INSERT INTO archDeferredCatalogProp
	SELECT @t_newArchGrpId, enabled, type, flags, startTime, sourceCopyId, deferredDays,
			numPeriod, dayNumber, currPeriodBegin, currPeriodEnd, calendarId, numOfReaders, prevPeriodBegin, nextPeriodEnd
	FROM   archDeferredCatalogProp
	WHERE  archGroupId = @i_oldArchGrpId
	INSERT INTO archGroupCopy
			(archGroupId, copy, name, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
			SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
			sealStoreTaskId, extendedFlags, destMediaCopyId, DDBLimitExtensionTimeStamp, DDBLimitExtensionTimeStampEncrypted, archCheckValidPeriodType, endTime)
	SELECT	@t_newArchGrpId, copy, name, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, 0, 0, sourceCopyId,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId,
(case when dedupeFlags & 134217728 > 0 then SIDBStoreId else 0 end),
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
SIDBSnapIntervalHours, 0 /*siloAppId*/, nDataInstance, description, dedupeFlags & ~2097152,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
(case when dedupeFlags & 134217728 > 0 then sealStoreTaskId else 0 end),
			extendedFlags, destMediaCopyId, 0, '', archCheckValidPeriodType, endTime
	FROM   archGroupCopy
	WHERE  archGroupId = @i_oldArchGrpId
AND flags & 524288 = 0 --Don't clone silo copies
AND extendedFlags & 8 = 0 --Don't clone secondary silo copies
	INSERT INTO #tempCopyPair
	SELECT a.id, b.id
	FROM   archGroupCopy a, archGroupCopy b
	WHERE  a.archGroupId = @i_oldArchGrpId AND b.archGroupId = @t_newArchGrpId AND a.name = b.name
	UPDATE archGroup
	SET		defaultCopy		= (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = @t_oldDefCopyId),
			defaultSnapCopy = ISNULL((SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = @t_oldDefSnapCopyId), 0)
	WHERE  id = @t_newArchGrpId
	UPDATE archGroupCopy SET sourceCopyId = (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = archGroupCopy.sourceCopyId)
	WHERE  archGroupId = @t_newArchGrpId AND sourceCopyId <> 0
	UPDATE archContentIndexingRules SET sourceCopyId = (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = archContentIndexingRules.sourceCopyId)
	WHERE  archGroupId = @t_newArchGrpId AND sourceCopyId <> 0
	UPDATE archMaterializeSnapshotProp SET sourceCopyId = (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = archMaterializeSnapshotProp.sourceCopyId)
	WHERE  archGroupId = @t_newArchGrpId AND sourceCopyId <> 0
	UPDATE archDeferredCatalogProp SET sourceCopyId = (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = archDeferredCatalogProp.sourceCopyId)
	WHERE  archGroupId = @t_newArchGrpId AND sourceCopyId <> 0
	--Add DDB mapping for cloned copies which are GDSP dependent copies
	INSERT 	INTO archCopySIDBStore
	SELECT 	T.newCopyId, CS.SIDBStoreId, CS.commCellId, CS.flags, 0, 0
	FROM 	archCopySIDBStore CS, #tempCopyPair T, archGroupCopy AGC
	WHERE 	CS.CopyId = T.oldCopyId
			AND T.newCopyId = AGC.id
			AND
			(
CS.flags & (4 | 1) = 4
OR CS.flags & 2 > 0
			)
AND AGC.dedupeFlags & 134217728 > 0
	-- Create new DDBs if old copy is hosting DDB either GDSP or standalone dedupe copy
	DECLARE	@l_newCopyId		INT = 0
	DECLARE @l_oldCopyId		INT = 0
	DECLARE @l_oldsealStoreTaskId	INT = 0
	DECLARE @l_newsealStoreTaskId	INT = 0
	DECLARE curGetSIDBCopy CURSOR FOR
	SELECT	a.newCopyId, a.oldCopyId, d.sealStoreTaskId
	FROM	#tempCopyPair a, archGroupCopy d
	WHERE	d.id = a.oldCopyId
AND d.dedupeFlags & (134217728 | 262144) = 262144 --dedupe host copies
	OPEN	curGetSIDBCopy
	FETCH	NEXT FROM curGetSIDBCopy
	INTO	@l_newCopyId, @l_oldCopyId, @l_oldsealStoreTaskId
	-- loop for no of copies
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		--
		-- Clone active DDBs
		--
DECLARE @lt_FullSIDBStores TABLE ( CopyId 				int, SIDBGroupId			int, AppTypeGroupId 		int, SIDBStoreId 		int default 0, StoreName 			nvarchar(256) default N'', StoreAliasName 		nvarchar(256) default N'', AppTypeGroupName 	nvarchar(256) default N'', newSIDBStoreId 		int default 0, newStoreName 		nvarchar(256) default N'', FullReason			tinyint default 0, createNewDDB		BIT default 1 ) 			DELETE @lt_FullSIDBStores
		INSERT INTO @lt_FullSIDBStores (CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, AppTypeGroupName)
		SELECT	@l_newCopyId, ST.SIDBGroupId, ST.AppTypeGroupId, ACS.SIDBStoreId, ISNULL(G.GroupName, '')
		FROM	archCopySIDBStore ACS with (readuncommitted)
				INNER JOIN IdxSIDBStore ST with (readuncommitted) ON ACS.SIDBStoreId = ST.SIDBStoreId
LEFT OUTER JOIN App_AppTypeGroup G ON ST.AppTypeGroupId = G.AppTypeGroupId AND G.TypeOfGroup = 4
		WHERE	ACS.copyId = @l_oldCopyId
AND ACS.flags & (4 | 1) = 4
				AND ST.SIDBGroupId = 0 --Don't clone CommCellId based DDBs
		--
		-- Check if there are DDBs with AppTypeGroupId = 0 then create AppType DDBs
		-- DDBs created before InfiniStore feature will have AppTypeGroupId = 0
		--
		IF EXISTS(SELECT 1 FROM @lt_FullSIDBStores WHERE AppTypeGroupId = 0)
		BEGIN
			INSERT INTO @lt_FullSIDBStores (CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, AppTypeGroupName)
			SELECT 	S.CopyId, S.SIDBGroupId, G.AppTypeGroupId, S.SIDBStoreId, G.GroupName
			FROM	@lt_FullSIDBStores S,
					App_AppTypeGroup G WITH(READUNCOMMITTED)
			WHERE	S.AppTypeGroupId = 0
AND G.TypeOfGroup = 4
			DELETE @lt_FullSIDBStores WHERE	AppTypeGroupId = 0
		END
		--
		-- Create DDBs
		--
--
-- BEGIN: archCreateNewDDBs.spb
--
				--
				-- Set name for DDB
				-- Format : <StoragePolicyName + [copyName] + [AppTypeGroupName]>
				--
				UPDATE 	S
				SET 	StoreAliasName = AG.name
						+
						(
							--Append copy name for standalone copies
case when AGC.dedupeFlags & 268435456 = 0
								then N'_' + AGC.name
								else N''
							end
						)
						+
						(
							--Append AppTypeGroupName for appType based DDBs
							case when S.AppTypeGroupId > 0
								then N'_' + S.AppTypeGroupName
								else N''
							end
						)
				FROM	@lt_FullSIDBStores S,
						ArchGroupCopy AGC WITH(READUNCOMMITTED),
						ArchGroup AG WITH(READUNCOMMITTED)
				WHERE	S.CopyId = AGC.id
						AND AGC.archGroupId = AG.id
						AND S.StoreAliasName = N''
DECLARE @GarbageCollectionConfig INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DDB_GARBAGE_COLLECTION'), 1)
				DECLARE @l_CopyId INT = 0
				DECLARE @l_NewSIDBGroupId INT = 0
				DECLARE @l_AppTypeGroupId INT = 0
				DECLARE @l_OldStoreId INT = 0
				DECLARE @l_NewStoreId INT = 0
DECLARE @l_StoreAliasName nvarchar(256) = N''
				DECLARE @l_AppTypeGroupName nvarchar(256) = N''
				DECLARE @l_StrStoreId nvarchar(15) = N''
				DECLARE @l_SubStoreId INT = 0
				DECLARE	@l_DefSIDBStoreId	INT = 0
				DECLARE @l_nowTime INT = dbo.GetUnixTime(GETUTCDATE())
				DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
				SELECT CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, StoreAliasName, AppTypeGroupName
				FROM @lt_FullSIDBStores
				WHERE  createNewDDB = 1
				ORDER BY AppTypeGroupId, SIDBStoreId
				OPEN curStore
				FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				WHILE (@@FETCH_STATUS = 0)
				BEGIN
					--Remove old storeId from name
					SET @l_StrStoreId = N'_' + CONVERT(nvarchar, @l_OldStoreId)
					SET @l_StoreAliasName = case when CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) > 0
												then LEFT(@l_StoreAliasName, CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) - 1)
												else @l_StoreAliasName
											end
					--
					--Create DDBs
					--
					INSERT  INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
								IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
								MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
								flags,
								TotalDataSizeBytes, InstancedDataSizeBytes, Status,
								LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId,
								Version, SIDBSnapPath, LastSnapTime, LastRecoveryTime,
								SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId,
								SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile,
								LastDDBVerificationTime, LastDataVerificationTime, DedupFactor, AppTypeGroupId,
								ExtendedFlags, SIDBGroupId)
					SELECT  @l_StoreAliasName, @l_StoreAliasName, 2,
							IdxCacheId, IdxAccessPathId, ClientId, -1,
							MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
(flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072),
							0, 0, 0,
							0, @l_nowTime, 0, 0,
							-1, SIDBSnapPath, 0, 0,
							0, 0, 0, 0,
							SubStoreCount, MaxAllowedConnections, 1 /*MaxNumOfAFsInSecFile*/,
							0, 0, DedupFactor, @l_AppTypeGroupId,
(ExtendedFlags & ~( 1 | 2											)) | ( 0 ) |
								(
CASE WHEN @GarbageCollectionConfig = 1 AND ((flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072) & 8192) = 0
AND ExtendedFlags & (4 | 8) = 0
THEN (4 | 8)
										ELSE 0
									END
								),
							@l_NewSIDBGroupId
					FROM    IdxSIDBStore WITH (READUNCOMMITTED)
					WHERE 	SIDBStoreId = @l_OldStoreId
					SELECT	@o_retVal = @@ERROR, @l_NewStoreId = SCOPE_IDENTITY()
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					SET @l_StoreAliasName = @l_StoreAliasName + N'_' + CONVERT(nvarchar, @l_NewStoreId)
					UPDATE 	@lt_FullSIDBStores
					SET		newSIDBStoreId 	= @l_NewStoreId,
							newStoreName 	= @l_StoreAliasName
					WHERE	SIDBStoreId = @l_oldStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--During storage policy clone we don't set default flag
					IF @l_DefSIDBStoreId = 0
						SET @l_DefSIDBStoreId = @l_NewStoreId
						UPDATE 	archGroupCopy
						SET		SIDBStoreId = @l_DefSIDBStoreId
						WHERE	id = @l_newCopyId
					--
					--Update name with new storeId
					--
					UPDATE  IdxSIDBStore
					SET     SIDBStoreName = @l_StoreAliasName,
							SIDBStoreAliasName = @l_StoreAliasName
,ExtendedFlags = CASE WHEN @l_NewStoreId = @l_DefSIDBStoreId THEN ExtendedFlags | 2 ELSE ExtendedFlags END
					WHERE   SIDBStoreId = @l_NewStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Add association to copies
					--
					INSERT INTO archCopySIDBStore (CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes)
					SELECT
						@l_newCopyId,
@l_NewStoreId , CommCellId, flags & ~(1 | 2)
| (CASE WHEN @l_NewStoreId = @l_DefSIDBStoreId THEN 2 ELSE 0 END)
							, 0, 0
					FROM    archCopySIDBStore WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
							--For clone we create only host copy and no dependent copies created at this time so add mapping only for host copy
							AND copyId = @l_oldCopyId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Create SubStores
					--
					DECLARE curSubStore CURSOR LOCAL FORWARD_ONLY FOR
					SELECT 	SS.SubStoreId
					FROM 	IdxSIDBSubStore SS WITH (READUNCOMMITTED),
							IdxAccessPath AP WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
							AND SS.IdxAccessPathId = AP.IdxAccessPathId
					OPEN curSubStore
					FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					WHILE (@@FETCH_STATUS = 0)
					BEGIN
						--
						-- Create SubStore
						--
						INSERT INTO IdxSIDBSubStore
							   ([SIDBStoreId], [commCellId], [GroupNumber], [IdxCacheId]
							   ,[IdxAccessPathId], [ClientId], [FirstBackupTime]
							   ,[flags]
							   ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
							   ,[CreatedTime],[SealedTime],[Version],[SIDBSnapPath]
							   ,[LastSnapTime],[origSubStoreId], [ReconLevel], LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile
							   ,ExtendedFlags, PageSize)
						SELECT
							   @l_NewStoreId, SS.commCellId, SS.GroupNumber, SS.IdxCacheId
							   ,SS.IdxAccessPathId, SS.ClientId,-1
,(SS.flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072)
							   ,0,0,0,0
							   ,@l_nowTime,0,-1,''
							   ,0,0, 0, 0, '',0, 0, 0, 0
							   , '', '', '', 1 /*MaxNumOfAFsInSecFile*/
,(SS.ExtendedFlags & ~(	4	)) |
(CASE WHEN S.ExtendedFlags & 4 > 0 THEN 1 ELSE 0 END) |
(CASE WHEN S.ExtendedFlags & 8 > 0 THEN 2 ELSE 0 END)
							   ,SS.PageSize
						FROM	IdxSIDBSubStore SS WITH(READUNCOMMITTED),
								IdxSIDBStore S WITH(READUNCOMMITTED)
						WHERE	SS.SIDBStoreId = @l_OldStoreId
								AND SS.SubStoreId = @l_SubStoreId
								AND S.SIDBStoreId = @l_NewStoreId
						SELECT	@o_retVal = @@ERROR
						IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
						FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					END
					CLOSE curSubStore
					DEALLOCATE curSubStore
					FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				END
				CLOSE curStore
				DEALLOCATE curStore
--
-- END: archCreateNewDDBs.spb
--
		--
		-- Create ArchTask entries
		--
		INSERT INTO archTask
		SELECT type, flags, active, periodType, numPeriod, dayNumber, dataSizeGB, lastEvent, nextEvent, percentCorruptLimit
		FROM archTask
		WHERE id = @l_oldsealStoreTaskId
		SET @l_newsealStoreTaskId = SCOPE_IDENTITY()
		UPDATE archGroupCopy
		SET sealStoreTaskId = @l_newsealStoreTaskId
		WHERE id = @l_newCopyId
		FETCH	NEXT FROM curGetSIDBCopy
		INTO	@l_newCopyId, @l_oldCopyId, @l_oldsealStoreTaskId
	END
	CLOSE		curGetSIDBCopy
	DEALLOCATE	curGetSIDBCopy
	INSERT INTO archSelectiveCopy
	SELECT b.newCopyId, a.type, a.numPeriod, a.dayNumber, a.startPeriod, a.nextPeriod, a.prevPeriodBegin, a.nextPeriodEnd
	FROM   archSelectiveCopy a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO archAgingRule
	SELECT b.newCopyId, a.retentionDays, a.fullCycles, a.flags, a.weekStart, a.monthStart, a.yearStart, a.archiverRetDays, a.retentionJobs , a.minutesSinceDayStarts
	FROM   archAgingRule a, #tempCopyPair b, archGroupCopy c
	WHERE  a.copyId = b.oldCopyId
			and b.newCopyId = c.id
			and c.isMirrorCopy <> 1
	INSERT INTO archAgingRuleExtended
	SELECT b.newCopyId, a.retentionDays, a.retentionRule, a.currPeriodBegin, a.currPeriodEnd, a.prevPeriodBegin, a.nextPeriodEnd, a.GraceDays , a.EveryXHours
	FROM   archAgingRuleExtended a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO archCopyMediaRefreshProp
	SELECT b.newCopyId, (SELECT newCopyId FROM #tempCopyPair WHERE oldCopyId = a.targetCopyId),
	       a.flags, a.daysAfterWritten, a.daysBeforeAged, a.percentage
	FROM   archCopyMediaRefreshProp a, #tempCopyPair b
	WHERE  a.copyId = b.oldCopyId
	INSERT INTO MMEntityProp
	SELECT b.newCopyId, a.EntityType, a.propertyName,a.propDataType, a.intVal, a.longlongVal, a.stringVal, a.created, a.modified, a.CommCellId
	FROM   MMEntityProp a
			INNER JOIN #tempCopyPair b ON a.EntityId = b.oldCopyId
WHERE 	a.EntityType = 2
	--Set only KeyProviderId to new cloned copies
	--RSA key pair will be generated for each copy from caller of this stored proc after cloning storage policy
	INSERT INTO ArchCopyEncProperties (CopyId, PubKey, PriKey, MasterKeyId, KeyProviderId, EncType)
	SELECT	b.newCopyId, '' /*PubKey*/, '' /*PriKey*/, '' /*MasterKeyId*/, a.KeyProviderId, 0 /*EncType*/
	FROM	ArchCopyEncProperties a, #tempCopyPair b, archGroupCopy AGC
	WHERE  	a.CopyId = b.oldCopyId AND b.newCopyId = AGC.id
AND (AGC.extendedFlags & 2) = 0
AND (AGC.dedupeFlags & 134217728) = 0
	INSERT INTO MMDataPath
	SELECT b.newCopyId, a.DrivePoolId, a.HostClientId, a.Flag, a.SpareGroupId,
	a.ReadinessFlag, a.Priority, a.IsHardwareCompressed, a.ChunkSizeMB,
	a.FlushBlockSizeKB, a.UseHardwareEncryption
	FROM   MMDataPath a, #tempCopyPair b
	WHERE  a.CopyId = b.oldCopyId
	INSERT INTO archCopyToGlobalPolicy
	SELECT b.newCopyId, a.globalPolicyId, a.flags
	FROM   archCopyToGlobalPolicy a, #tempCopyPair b
	WHERE  a.CopyId = b.oldCopyId
	 INSERT INTO TM_AssocEntity (assocType,         taskId,         flags,      created,        exclude,
                                clientGroupId,     clientId,       apptypeId,  instanceId,     backupsetId,
                                subclientId,       policyId,       copyId,     srmReportSet,   srmReportType,
                                trackingPolicyId,  MediaAgentId,   agentlessPolicyId, workflowId, sidbStoreId,
                                libraryId, logMonitoringPolicyId )
        SELECT                  assocType,         taskId,         flags,      @now,        exclude,
                                clientGroupId,     clientId,       apptypeId,  instanceId,     backupsetId,
                                subclientId,       @t_newArchGrpId, P.newCopyId, srmReportSet,   srmReportType,
                                trackingPolicyId,  MediaAgentId,   agentlessPolicyId, workflowId, sidbStoreId,
                                libraryId, logMonitoringPolicyId
        FROM	TM_AssocEntity AE
                INNER JOIN #tempCopyPair P ON P.oldCopyId = AE.copyId
WHERE	AE.policyId = @i_oldArchGrpId AND AE.assocType = 18
				AND EXISTS (
					SELECT 1
					FROM TM_Task(READUNCOMMITTED) T
WHERE T.deleted = 0 AND T.tasktype in (4, 2) AND T.taskid = AE.taskid
				)
		UNION ALL
		SELECT                  assocType,         taskId,         flags,      @now,        exclude,
                                clientGroupId,     clientId,       apptypeId,  instanceId,     backupsetId,
                                subclientId,       @t_newArchGrpId, copyId, srmReportSet,   srmReportType,
                                trackingPolicyId,  MediaAgentId,   agentlessPolicyId, workflowId, sidbStoreId,
                                libraryId, logMonitoringPolicyId
        FROM	TM_AssocEntity AE
WHERE	AE.policyId = @i_oldArchGrpId AND AE.assocType = 17
				AND EXISTS (
					SELECT 1
					FROM TM_Task(READUNCOMMITTED) T
WHERE T.deleted = 0 AND T.tasktype in (4, 2) AND T.taskid = AE.taskid
				)
	--Filter out the copies which are pointing to GACP.
	INSERT INTO #tempCopiesUsingGACP
	SELECT a.oldCopyId, a.newCopyId
	FROM #tempCopyPair a, archGroupCopy b
	WHERE a.oldCopyId = b.id
AND (b.extendedFlags & 2) > 0
	INSERT INTO archStream
	SELECT @t_newArchGrpId, b.newCopyId, a.stream, 0, a.isActive, 0, 0, a.flags
	FROM   archStream a, #tempCopyPair b
	WHERE  a.archGroupCopyId = b.oldCopyId
        --archstream entries are created so delete from #tempCopyPair
	DELETE #tempCopyPair
	WHERE oldCopyId in (select oldCopyId from #tempCopiesUsingGACP)
	INSERT INTO #tempMediaGroupName
	SELECT a.mediaGroupId, b.newCopyId, a.stream,
		   'AG[' + CAST(@t_newArchGrpId AS varchar(8)) +
		   ']_AGC[' + CAST(b.newCopyId AS varchar(8)) +
		   ']_stream[' + CAST(a.stream AS varchar(8)) + ']'
	FROM   archStream a, #tempCopyPair b
	WHERE  archGroupCopyId = b.oldCopyId
	INSERT INTO MMMediaGroup
	SELECT b.mediaGroupName, a.DrivePoolId, a.SpareGroupId, a. DesiredMediaTypeId, a.RecordingFormatId, 0
	FROM   MMMediaGroup a, #tempMediaGroupName b
	WHERE  a.MediaGroupId = b.oldMediaGroupId
	UPDATE archStream SET mediaGroupId = c.MediaGroupId
	FROM   archStream a, #tempMediaGroupName b, MMMediaGroup c
	WHERE  a.archGroupId = @t_newArchGrpId AND a.archGroupCopyId = b.archGroupCopyId AND a.stream = b.stream AND b.mediaGroupName = c.MediaGroupName
	--update archStream table with mediaGroupId of GACP copy
	IF EXISTS (SELECT * from #tempCopiesUsingGACP)
	BEGIN
	    -- UPDATE archStream
	    UPDATE Dep
	    SET mediaGroupId = d.MediaGroupId
	    FROM  archStream Dep, #tempCopiesUsingGACP b, archGroupCopy c, archStream d
	    WHERE Dep.archGroupCopyId = b.newCopyId
	    AND b.oldCopyId = c.id
	    AND c.destMediaCopyId = d.archGroupCopyId
	    AND Dep.stream = d.stream
	END
--END TRY
--BEGIN CATCH
	SET	@o_retVal = ISNULL((SELECT ERROR_NUMBER()), 0)
--END CATCH
CX_ERROR_EXIT:
FINISH:
DROP TABLE #tempCopyPair
DROP TABLE #tempMediaGroupName
DROP TABLE #tempCopiesUsingGACP
DROP TABLE #tempSILOBkpSet
SELECT @o_retVal, @t_newArchGrpId
RETURN @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupClone')
	delete from GxQscripts where name = 'archGroupClone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupClone')
	delete from GXDBVersions where aliasname = 'archGroupClone'
GO

insert into GXDBVersions values(2, 'archGroupClone',  'v1.70.2.27.4.1', 'archGroupClone', 'v1.70.2.27.4.1')
GO

