

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupAssociatedClients.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGroupAssociatedClients				      			  */
/*                                                                            */
/*  Description :  Stored proc used to return app entities  		          */
/*	           associated with given storage policy id     		              */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupAssociatedClients.sp,v $ $Id: archGroupAssociatedClients.sp,v 1.5.2.4 2018/03/20 19:47:37 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGroupAssociatedClients <<<'

IF EXISTS (select * from sysobjects where name='archGroupAssociatedClients')
	drop procedure archGroupAssociatedClients
IF EXISTS (select * from GxQscripts where name='archGroupAssociatedClients')
	delete from GxQscripts where name = 'archGroupAssociatedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAssociatedClients')
	delete from GXDBVersions where aliasname = 'archGroupAssociatedClients'
GO
print '... Creating Procedure: archGroupAssociatedClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGroupAssociatedClients
-- used to get a list of associated subclients
  @archGroupId integer,
  @flags integer = 0
-- Following are the "columns" returned, in the order in which they are returned
AS
  DECLARE @clientId integer;
  DECLARE @clientName NVARCHAR(255);
  DECLARE @appTypeId integer;
  DECLARE @appTypeName varchar(255);
  DECLARE @instanceId integer;
  DECLARE @instanceName NVARCHAR(255);
  DECLARE @backupSetId integer;
  DECLARE @backupSetName NVARCHAR(255);
  DECLARE @appId integer;
  DECLARE @subclientName NVARCHAR(255);
  DECLARE @subClientPolicyName NVARCHAR(255);
  DECLARE @subClientFlags integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @LREP_CALL_FLAG integer = 1
IF object_id('tempdb.dbo.#tmpAssociatedSClist') IS NOT NULL DROP TABLE #tmpAssociatedSClist
CREATE TABLE #tmpAssociatedSClist (	clientId	integer,
					clientName		nvarchar(255),
					appTypeId		integer,
					appTypeName		varchar(255),
					instanceId		integer,
					instanceName	nvarchar(255),
					backupSetId		integer,
					backupSetName	nvarchar(255),
					appId			integer,
					subclientName	nvarchar(255),
					subclientPolicyName   nvarchar(255),
					subClientFlags	integer
				)
-- reason we create a temp table is that I want to put all the logic in here regarding what to display,
-- and what not to display
-- Backupset status is set to 64 for EZ Backupset
IF @flags & @LREP_CALL_FLAG = 0
BEGIN
	INSERT INTO #tmpAssociatedSClist
	select distinct APP.clientId, CL.name, APP.appTypeId, AT.name, APP.instance, INM.name,
			APP.backupSet,  BSN.name, APP.id, APP.subClientName, '',APP.subclientStatus
	from 	APP_Application APP RIGHT OUTER JOIN APP_InstanceName AS INM ON INM.id = APP.instance,
			 APP_Client as CL, APP_iDAType AS AT, APP_BackupSetName AS BSN
	where 	(dataarchgrpid=@archgroupId or (logarchgrpid=@archgroupId and ( APP.appTypeId IN (SELECT appTypeId FROM dbo.AppGetLogSpSupportedApptypes()))  ) )-- send logSP only for DB subclients
	and   CL.id = APP.clientId
	and   AT.type = APP.appTypeId
	and   BSN.id = APP.backupSet
	and	  ((BSN.status & 64) = 0)
	ORDER BY CL.name, AT.name,INM.name, BSN.name, APP.subClientName
END
ELSE
BEGIN
	DECLARE @tblLREPAgents table(appTypeId int)
	INSERT INTO @tblLREPAgents
SELECT 33 	/*CV_APPTYPE_WINDOWS_FILESYSTEM*/
	UNION
SELECT 29 				/*CV_APPTYPE_LINUX_FS*/
	UNION
SELECT 43  /*LEGACY_CV_APPTYPE_WIN2003_64BIT*/
	UNION
SELECT 20 			/*UNUSED_CV_APPTYPE_20 - Contrary to what the name suggests, it is used for Solaris 64*/
	UNION
SELECT 19			/*CV_APPTYPE_SOLARIS32_FS*/
	UNION
SELECT 81					/*CV_APPTYPE_MSSQL*/
	UNION
SELECT 53	/*CV_APPTYPE_MSEXCHANGE_DATABASE*/
	UNION
SELECT 22				/*CV_APPTYPE_ORACLE8*/
	UNION
SELECT 42	/*LEGACY_CV_APPTYPE_WIN2003_32BIT*/
	INSERT INTO #tmpAssociatedSClist
	select distinct APP.clientId, CL.name, APP.appTypeId, AT.name, APP.instance, INM.name,
			APP.backupSet,  BSN.name, APP.id, APP.subClientName, '',APP.subclientStatus
	from 	APP_Application APP RIGHT OUTER JOIN APP_InstanceName AS INM ON INM.id = APP.instance
			LEFT OUTER JOIN
			(SELECT componentNameId, attrVal FROM APP_SubClientProp
			 WHERE attrName = 'Oracle Backup Mode' and modified = 0) ORAPROP ON APP.id = ORAPROP.componentNameId,
			 APP_Client as CL, APP_iDAType AS AT, APP_BackupSetName AS BSN
	where 	appTypeId IN (SELECT appTypeId FROM @tblLREPAgents) AND
			(
				(
dataarchgrpid=@archgroupId AND (appTypeId <> 22 OR ISNULL(ORAPROP.attrVal, 0) IN(0,2) ) /*For oracle subclients consider data policy only if the 'Oracle Backup Mode' value is in (0,2) */
				)
				or
				(
logarchgrpid=@archgroupId AND APP.appTypeId = 22 AND ISNULL(ORAPROP.attrVal, 0) NOT IN(0,2) /*For oracle subclients consider log policy only if the 'Oracle Backup Mode' value is not in (0,2) */
				)
			)-- send logSP only for Oracle
	and   CL.id = APP.clientId
	and   AT.type = APP.appTypeId
	and   BSN.id = APP.backupSet
	and	  ((BSN.status & 64) = 0)
	ORDER BY CL.name, AT.name,INM.name, BSN.name, APP.subClientName
	DECLARE @l_netAppEngineId int
	SELECT @l_netAppEngineId = SnapShotEngineId
	FROM SMSnapShotEngine WHERE SnapEngineName = 'NetApp'
	DELETE #tmpAssociatedSClist
	FROM #tmpAssociatedSClist SC
	LEFT OUTER JOIN App_SubClientProp SCProp1 ON SC.appId = SCProp1.componentNameId AND SCProp1.modified = 0 AND SCProp1.attrName = 'Enable Snap Backups' AND SCProp1.attrVal = '1'
	LEFT OUTER JOIN App_SubClientProp SCProp2 ON SC.appId = SCProp2.componentNameId AND SCProp2.modified = 0 AND SCProp2.attrName = 'Snap Engine' AND SCProp2.attrVal = CAST(@l_netAppEngineId AS nvarchar(max))
	WHERE SCProp1.componentNameId is null OR SCProp2.componentNameId is null
END
UPDATE #tmpAssociatedSClist
SET instanceName = ''
WHERE (instanceId = 1)
UPDATE #tmpAssociatedSClist
SET subclientPolicyName= BKP.name  , backupSetName = ''
  FROM #tmpAssociatedSClist A INNER JOIN APP_BackupSetName BKP
  ON A.backupSetId=BKP.id
WHERE A.appTypeId = 1030 and BKP.status & 128 = 128
SELECT
	clientId, clientName,
	appTypeId, appTypeName,
	instanceId, instanceName,
	backupSetId, backupSetName,
	appId, subclientName, subclientPolicyName,subClientFlags
FROM #tmpAssociatedSClist
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupAssociatedClients')
	delete from GxQscripts where name = 'archGroupAssociatedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAssociatedClients')
	delete from GXDBVersions where aliasname = 'archGroupAssociatedClients'
GO

insert into GXDBVersions values(2, 'archGroupAssociatedClients',  '00010005000200040000', 'archGroupAssociatedClients', '00010005000200040000')
GO

