

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupAssociate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupAssociate.sp,v $ $Id: archGroupAssociate.sp,v 1.7.210.2 2018/03/22 01:10:02 jiechen Exp $";
-- This stored procedure is for associating all not associated subclients
-- to the given regular storage policy.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGroupAssociate <<<'

IF EXISTS (select * from sysobjects where name='archGroupAssociate')
	drop procedure archGroupAssociate
IF EXISTS (select * from GxQscripts where name='archGroupAssociate')
	delete from GxQscripts where name = 'archGroupAssociate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAssociate')
	delete from GXDBVersions where aliasname = 'archGroupAssociate'
GO
print '... Creating Procedure: archGroupAssociate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGroupAssociate
  @i_archGroupId integer
AS
  DECLARE @nAssociatedApp integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @nAssociatedApp = 0
DECLARE	@l_now INT
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
IF (SELECT type FROM archGroup WHERE id = @i_archGroupId) <> 1
	GOTO FINISH
-- Exclude NAS storage policy.
IF EXISTS (
	SELECT * FROM MMDataPath
	WHERE	CopyId IN (SELECT id FROM archGroupCopy WHERE archGroupId = @i_archGroupId)
AND DrivePoolId IN (SELECT DrivePoolId FROM MMDrivePool WHERE DrivePoolType = 3))
	GOTO FINISH
-- Exclude NAS and Data Migrator iDAs and the DR subclient.
-- Exclude uninstalled or deleted subclients.
-- Set dataArchGrpId and logArchGrpId to @i_archGroupId if none of them are set.
UPDATE	APP_Application
SET		dataArchGrpId = @i_archGroupId, logArchGrpId = @i_archGroupId, modified = @l_now
WHERE	dataArchGrpId <= 1 AND logArchGrpId <= 1
AND subclientStatus & (CAST(0x00002 AS INT) + CAST(0x00004 AS INT)) = 0
	AND appTypeId NOT IN (
13,
45,
56,
57,
58,
66,
73,
82,
83,
89,
90,
1000)
SET	@nAssociatedApp = @@ROWCOUNT
FINISH:
SELECT @nAssociatedApp
RETURN @nAssociatedApp;
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupAssociate')
	delete from GxQscripts where name = 'archGroupAssociate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAssociate')
	delete from GXDBVersions where aliasname = 'archGroupAssociate'
GO

insert into GXDBVersions values(2, 'archGroupAssociate',  '00010007021000020000', 'archGroupAssociate', '00010007021000020000')
GO

