

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupAppSubsetForDeferredCatalogNewView.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGroupAppSubsetForBackupCopyNewView.sp                  */
/*                                                                            */
/*  Description :  Fetches association view for backup copy/deferred catalog  */
/*  Author      :  Kanishka                                                   */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupAppSubsetForDeferredCatalogNewView.sp,v $ $Id: archGroupAppSubsetForDeferredCatalogNewView.sp,v 1.1.2.5 2020/01/08 22:59:15 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupAppSubsetForDeferredCatalogNewView')
BEGIN
	print '>>> Drop Stored Procedure: archGroupAppSubsetForDeferredCatalogNewView <<<'
	drop procedure archGroupAppSubsetForDeferredCatalogNewView
END
IF EXISTS (select * from GxQscripts where name='archGroupAppSubsetForDeferredCatalogNewView')
	delete from GxQscripts where name = 'archGroupAppSubsetForDeferredCatalogNewView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppSubsetForDeferredCatalogNewView')
	delete from GXDBVersions where aliasname = 'archGroupAppSubsetForDeferredCatalogNewView'
GO
print '... Creating Procedure: archGroupAppSubsetForDeferredCatalogNewView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupAppSubsetForDeferredCatalogNewView
  @i_archGroupId integer,
  @i_entityId integer,
  @i_entityType integer,
  @i_userId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tmpGroupApps') IS NOT NULL DROP TABLE #tmpGroupApps
CREATE TABLE #tmpGroupApps (Id int, clientGroupId int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int, assocType INT) -- isSelected = 0 means excluded, 1  selected, 2 just for population
IF OBJECT_ID('tempdb..#getNonIdaObjects_OutputTable') IS NOT NULL DROP TABLE #getNonIdaObjects_OutputTable
CREATE TABLE #getNonIdaObjects_OutputTable (entityId INT PRIMARY KEY)
DECLARE @l_sourceCopyId INTEGER
SET @l_sourceCopyId = (SELECT sourceCopyId FROM ArchDeferredCatalogProp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId)
IF  @l_sourceCopyId = 0
    SET @l_sourceCopyId = (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId)
/*
XmlMessage/CvEntities.x
CLIENT_ENTITY = 3,
CLIENT_GROUP_ENTITY = 28,
*/
--Get list of subclients having non-aged jobs on source copy
INSERT INTO #tmpGroupApps
SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
FROM	APP_Application A WITH (NOLOCK)
WHERE NOT EXISTS ( SELECT 1 FROM App_SubclientProp SP WITH (NOLOCK)
					WHERE 	A.Id = SP.componentNameId
						AND		SP.attrName IN ('Index SubClient', 'DDB Backup')
						AND		SP.attrVal = '1'
						AND		SP.modified = 0	)
AND EXISTS (
				SELECT TOP 1 1 FROM JMJobDatastats JDS WITH (NOLOCK)
				WHERE archGrpCopyId = @l_sourceCopyId
				AND status IN (100, 101, 102, 103)
AND (disabled & 256) = 0
				AND A.id = JDS.appId
			)
AND dbo.IsDeferredCatalogSupported(A.Id) <> 0 --Skip Subclients that does not support deferred catalog
AND (@i_entityType IN (0, 28)OR (@i_entityId  = A.clientId AND @i_entityType = 3))
UNION--Get list of subclients that are currently associated to storage policy
SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
FROM	APP_Application A WITH (NOLOCK)
WHERE	(
			A.dataArchGrpId = @i_archGroupId
			OR (
					A.logArchGrpId = @i_archGroupId
AND A.appTypeId IN (22, 104, 61, 37, 5, 81, 3, 125)
				 )
		)
AND NOT EXISTS ( SELECT 1 FROM App_SubclientProp SP WITH (NOLOCK)
					WHERE 	A.Id = SP.componentNameId
						AND		SP.attrName IN ('Index SubClient', 'DDB Backup')
						AND		SP.attrVal = '1'
						AND		SP.modified = 0	)
AND dbo.IsDeferredCatalogSupported(A.Id) <> 0 --Skip Subclients that does not support deferred catalog
AND (@i_entityType IN (0, 28)OR (@i_entityId  = A.clientId AND @i_entityType = 3))
UNION--Get list of subclients associated with storage policy having incremental storage policy configured
SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
FROM	APP_Application A WITH (NOLOCK)
INNER JOIN archGroup AG WITH (NOLOCK) ON A.dataArchGrpId = AG.id
WHERE	AG.incrSP = @i_archGroupId
AND NOT EXISTS ( SELECT 1 FROM App_SubclientProp SP WITH (NOLOCK)
					WHERE 	A.Id = SP.componentNameId
						AND		SP.attrName IN ('Index SubClient', 'DDB Backup')
						AND		SP.attrVal = '1'
						AND		SP.modified = 0	)
AND dbo.IsDeferredCatalogSupported(A.Id) <> 0 --Skip Subclients that does not support deferred catalog
AND (@i_entityType IN (0, 28)OR (@i_entityId  = A.clientId AND @i_entityType = 3))
CREATE INDEX tmpGroupApps_idx1 ON #tmpGroupApps (Id)
IF @i_entityType IN (0, 28)
BEGIN
	INSERT INTO #tmpGroupApps
	SELECT DISTINCT A.Id, CG.clientGroupId, A.clientId , A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
	FROM #tmpGroupApps A INNER JOIN  APP_ClientGroupAssoc CG WITH (READUNCOMMITTED) ON CG.clientId = A.clientId
	WHERE @i_entityType = 0 OR (@i_entityType =28 AND @i_entityId = CG.clientGroupId)
	IF @i_entityType = 28
		DELETE #tmpGroupApps
		WHERE clientGroupId = 0
END
/*
--Skip DDB subclients\Indexing Subclients
DELETE #tmpGroupApps
FROM #tmpGroupApps T, App_SubclientProp A WITH (NOLOCK)
WHERE 	T.appId = A.componentNameId
	AND		A.attrName IN ('Index SubClient', 'DDB Backup')
	AND		A.attrVal = '1'
	AND		A.modified = 0
--Skip Subclients that does not support deferred catalog
DELETE #tmpGroupApps
WHERE dbo.IsDeferredCatalogSupported(appId) = 0
*/
IF OBJECT_ID('tempdb.dbo.#tmpGroupAppsOut') IS NOT NULL
BEGIN
	INSERT INTO #tmpGroupAppsOut
	SELECT * FROM #tmpGroupApps
END
IF(@i_entityType = 0) -- only do this for the first request
BEGIN
-- insert mappings from archGroupToApp
	INSERT INTO #tmpGroupApps
	SELECT	DISTINCT A.subclientId, A.clientGRoupID, A.clientId, A.appTypeId, A.instanceId, A.backupSetId,  CASE WHEN A.subClientId > 0 THEN t.subclientName ELSE '' END, CASE WHEN A.exclude = 0 THEN 1 ELSE 0 END , A.assocType
	FROM	archGroupToApp A WITH (READUNCOMMITTED), #tmpGroupApps t
	WHERE	A.archGroupId = @i_archGroupId
			AND	(A.clientGroupId = t.clientGroupId OR (A.subClientId|A.backupSetId|A.instanceId|A.appTypeId|A.clientId|A.clientGroupId|A.exclude) = 0)
			AND (A.clientId = 0 OR A.clientId = t.clientId	AND (A.appTypeId = 0
			 OR A.appTypeId = t.appTypeId AND (A.instanceId = 0
			 OR A.instanceId = t.instance AND (A.backupSetId = 0
			 OR A.backupSetId = t.backupSet AND (A.subClientId = 0
			 OR A.subClientId = t.id)))))
			 AND A.assocType <> -1
	AND 	A.OperationType = 2
	UNION -- need the below for associations where no child client is present on storage policy/#tmpCopyApps
	SELECT	DISTINCT A.subclientId, A.clientGRoupID, A.clientId, A.appTypeId, A.instanceId, A.backupSetId, '', CASE WHEN A.exclude = 0 THEN 1 ELSE 0 END , A.assocType
	FROM	archGroupToApp A WITH (READUNCOMMITTED),APP_ClientGroup CG WITH (READUNCOMMITTED)
	WHERE 	A.archGroupId = @i_archGroupId AND CG.Id = A.clientGroupId AND A.assocType = 28 -- client group associations only
	AND 	A.OperationType = 2
	IF @@ROWCOUNT = 0 AND NOT EXISTS (SELECT 1 FROM archGroupToApp WITH (READUNCOMMITTED) WHERE archGroupId = @i_archGroupId
	AND 	OperationType = 2
	)
	BEGIN
		INSERT INTO #tmpGroupApps
		SELECT	0, 0, 0, 0, 0, 0, '', 1 , 2
		UNION
		SELECT	0, 0, 0, 0, 0, 0, '', 1 , 27
	END
END
	EXEC sec_getNonIdaObjectsForThisUser @i_userId, 28 /*CLIENT_GROUP_ENTITY*/, 0, '#getNonIdaObjects_OutputTable'
	select	DISTINCT tt.clientGroupID, ISNULL(CG.name,'') clientGroupName,
			CASE WHEN @i_entityType = 28 OR @i_entityType = 0 AND tt.clientGRoupID = 0 THEN  tt.clientId ELSE 0 END, CASE WHEN @i_entityType = 28 OR @i_entityType = 0 AND tt.clientGRoupID = 0 THEN ISNULL(cl.name,'') ELSE '' END as clientName,CASE WHEN @i_entityType = 28 OR @i_entityType = 0 AND tt.clientGRoupID = 0 THEN ISNULL(cl.net_hostname,'') ELSE '' END as hostname,
			CASE WHEN @i_entityType = 3 THEN tt.appTypeId ELSE 0 END, CASE WHEN @i_entityType = 3 THEN ISNULL(aType.name,'') ELSE '' END as appTypename,
			CASE WHEN @i_entityType = 3 THEN tt.instance ELSE 0 END, CASE WHEN @i_entityType = 3 THEN ISNULL(iName.name,'') ELSE '' END as instanceName,
			CASE WHEN @i_entityType = 3 THEN tt.backupset ELSE 0 END, CASE WHEN @i_entityType = 3 THEN ISNULL(bsn.name,'') ELSE '' END as backuupSetName,
			CASE WHEN @i_entityType = 3 THEN tt.id ELSE 0 END, CASE WHEN @i_entityType = 3 THEN ISNULL(tt.subclientName,'') ELSE '' END as subclientName,
			0 as include, 0 as exclude, tt.assocType,
			CASE WHEN tt.clientGroupID > 0 AND sec.EntityId IS NULL THEN 1 ELSE 0 END isHidden
	from	#tmpGroupApps as tt LEFT JOIN APP_Client as cl WITH (READUNCOMMITTED) ON tt.clientId = cl.Id LEFT JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON tt.appTypeId = aType.type
			 LEFT JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON tt.instance = iName.id LEFT JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON tt.backupSet = bsn.id
			 LEFT JOIN APP_ClientGroup CG WITH (READUNCOMMITTED) ON CG.id = tt.clientGRoupID
			 LEFT JOIN #getNonIdaObjects_OutputTable sec ON tt.clientGroupID = sec.EntityId
	where	tt.isSelected = 2
	UNION
	select	DISTINCT tt.clientGroupID, ISNULL(CG.name,'') clientGroupName,
			tt.clientId, ISNULL(cl.name,'') as clientName, ISNULL(cl.net_hostname,'') as hostname,
			tt.appTypeId, ISNULL(aType.name,'') as appTypename,
			tt.instance, ISNULL(iName.name,'') as instanceName,
			tt.backupset, ISNULL(bsn.name,'') as backuupSetName,
			tt.id, ISNULL(tt.subclientName,'') as subclientName,
			CASE WHEN tt.isSelected = 1 THEN 1 ELSE 0 END as include, CASE WHEN tt.isSelected = 0 THEN 1 ELSE 0 END as exclude, tt.assocType,
			CASE WHEN tt.clientGroupID > 0 AND sec.EntityId IS NULL THEN 1 ELSE 0 END isHidden
	from	#tmpGroupApps as tt LEFT JOIN APP_Client as cl WITH (READUNCOMMITTED) ON tt.clientId = cl.Id LEFT JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON tt.appTypeId = aType.type
			 LEFT JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON tt.instance = iName.id LEFT JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON tt.backupSet = bsn.id
			 LEFT JOIN APP_ClientGroup CG WITH (READUNCOMMITTED) ON CG.id = tt.clientGRoupID
			 LEFT JOIN #getNonIdaObjects_OutputTable sec ON tt.clientGroupID = sec.EntityId
	where	tt.isSelected IN (0,1)
	UNION
	SELECT 	CG.Id, CG.name clientGroupName,
			0,	'' as clientName,  '' as hostname,
			0, '' as appTypename,
			0, '' as instanceName,
			0, '' as backuupSetName,
			0, '' as subclientName,
			0 as include, 0 as exclude, 0,
			CASE WHEN sec.EntityId IS NULL THEN 1 ELSE 0 END isHidden
	FROM 	APP_ClientGroup CG WITH (READUNCOMMITTED)
			LEFT JOIN #getNonIdaObjects_OutputTable sec ON CG.Id = sec.EntityId
	WHERE 	@i_entityType = 0
	ORDER BY clientGroupName desc, clientName desc, appTypename desc, instanceName desc, backuupSetName desc, subclientName desc
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupAppSubsetForDeferredCatalogNewView')
	delete from GxQscripts where name = 'archGroupAppSubsetForDeferredCatalogNewView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppSubsetForDeferredCatalogNewView')
	delete from GXDBVersions where aliasname = 'archGroupAppSubsetForDeferredCatalogNewView'
GO

insert into GXDBVersions values(2, 'archGroupAppSubsetForDeferredCatalogNewView',  '00010001000200050000', 'archGroupAppSubsetForDeferredCatalogNewView', '00010001000200050000')
GO

