

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupAppSubsetForDeferredCatalog.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogPickNewJob.sp                           */
/*                                                                            */
/*  Description :  Picks new snap job for deferred catalog at the end         */
/*                 of snap backup job                                         */
/*  Author      :  Praveen                                                    */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupAppSubsetForDeferredCatalog.sp,v $ $Id: archGroupAppSubsetForDeferredCatalog.sp,v 1.1.2.5 2019/11/21 21:03:31 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupAppSubsetForDeferredCatalog')
BEGIN
	print '>>> Drop Stored Procedure: archGroupAppSubsetForDeferredCatalog <<<'
	drop procedure archGroupAppSubsetForDeferredCatalog
END
IF EXISTS (select * from GxQscripts where name='archGroupAppSubsetForDeferredCatalog')
	delete from GxQscripts where name = 'archGroupAppSubsetForDeferredCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppSubsetForDeferredCatalog')
	delete from GXDBVersions where aliasname = 'archGroupAppSubsetForDeferredCatalog'
GO
print '... Creating Procedure: archGroupAppSubsetForDeferredCatalog'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupAppSubsetForDeferredCatalog
  @i_archGroupId integer,
  @i_inputXML varchar(MAX) = ''
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tmpGroupApps') IS NOT NULL DROP TABLE #tmpGroupApps
CREATE TABLE #tmpGroupApps (appId INT, clientId INT, appTypeId INT, instance INT, backupSet INT, subclientName NVARCHAR(512), isSelected INT)
if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
CREATE TABLE #archGroupToAppId (
archGroupId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
DECLARE @l_sourceCopyId INTEGER
SET @l_sourceCopyId = (SELECT sourceCopyId FROM ArchDeferredCatalogProp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId)
IF  @l_sourceCopyId = 0
    SET @l_sourceCopyId = (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId)
DECLARE @l_operationType INT = 0
-- Check for selective subclient association for Deferred Catalog
SET @l_operationType = 2
--Get list of subclients having non-aged jobs on source copy
INSERT INTO #tmpGroupApps
SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
FROM	APP_Application A WITH (NOLOCK) INNER JOIN 	(	SELECT DISTINCT appId
																			FROM JMJobDatastats WITH (NOLOCK)
																			WHERE archGrpCopyId = @l_sourceCopyId
																			AND status IN (100, 101, 102, 103)
AND (disabled & 256) = 0
																		 ) B
ON A.id = B.appId
CREATE INDEX tmpGroupApps_idx1 ON #tmpGroupApps (appId)
--Get list of subclients that are currently associated to storage policy
INSERT INTO #tmpGroupApps
SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
FROM	APP_Application A WITH (NOLOCK) LEFT OUTER JOIN #tmpGroupApps B ON A.id = B.appId
WHERE	B.appId IS NULL
AND (
			A.dataArchGrpId = @i_archGroupId
			OR (
					A.logArchGrpId = @i_archGroupId
AND A.appTypeId IN (22, 104, 61, 37, 5, 81, 3, 125)
				 )
		)
--Get list of subclients associated with storage policy having incremental storage policy configured
INSERT INTO #tmpGroupApps
SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
FROM	APP_Application A WITH (NOLOCK) LEFT OUTER JOIN #tmpGroupApps B ON A.id = B.appId
INNER JOIN archGroup AG WITH (NOLOCK) ON A.dataArchGrpId = AG.id
WHERE	B.appId IS NULL
AND		AG.incrSP = @i_archGroupId
--Skip DDB subclients\Indexing Subclients
DELETE #tmpGroupApps
FROM #tmpGroupApps T, App_SubclientProp A WITH (NOLOCK)
WHERE 	T.appId = A.componentNameId
	AND		A.attrName IN ('Index SubClient', 'DDB Backup')
	AND		A.attrVal = '1'
	AND		A.modified = 0
--Skip Subclients that does not support deferred catalog
DELETE #tmpGroupApps
WHERE dbo.IsDeferredCatalogSupported(appId) = 0
IF EXISTS (	SELECT archGroupId
						FROM archGroupToApp WITH (NOLOCK)
						WHERE archGroupId = @i_archGroupId
						AND  assocType <> 2
						AND OperationType = @l_operationType
					) OR @i_inputXML <> ''
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_NEW_APP_COPY_ASSOC_VIEW' AND value > 0)
	BEGIN
		UPDATE	#tmpGroupApps
		SET		isSelected = (CASE 	WHEN A.appTypeId = 0 THEN 5
															WHEN A.instanceId = 0 THEN 4
															WHEN A.backupSetId = 0 THEN 3
															WHEN A.subClientId = 0 THEN 2
												ELSE 1
												END)
		FROM	#tmpGroupApps B LEFT OUTER JOIN archGroupToApp A WITH (NOLOCK)
		ON	A.archGroupId = @i_archGroupId
		AND A.clientId > 0
		AND A.OperationType = @l_operationType
		AND A.clientId = B.clientId
		AND (A.appTypeId = 0 OR A.appTypeId = B.appTypeId
				 AND (A.instanceId = 0 OR A.instanceId = B.instance
							AND (A.backupSetId = 0 OR A.backupSetId = B.backupSet
									 AND (A.subClientId = 0 OR A.subClientId = B.appId)
									)
						 )
				)
		WHERE	A.archGroupId IS NOT NULL
	END
	ELSE
	BEGIN
		exec  archGetArchGroupToAppAssociations @i_archGroupId, @l_operationType, @i_inputXML
		UPDATE	#tmpGroupApps
		SET		isSelected = 3
		FROM	#tmpGroupApps t LEFT JOIN #archGroupToAppId a ON A.archGroupId = @i_archGroupId AND t.appId = a.appId
		WHERE 	a.appId IS NOT NULL
	END
ELSE
	UPDATE	#tmpGroupApps
	SET		isSelected = 6
IF OBJECT_ID('tempdb.dbo.#tmpGroupAppsOut') IS NOT NULL
BEGIN
	INSERT INTO #tmpGroupAppsOut
	SELECT * FROM #tmpGroupApps
END
ELSE
BEGIN
	SELECT	TMP.clientId, C.name AS clientName, C.net_hostname AS netHostName,
			TMP.appTypeId, T.name AS appTypeName,
			TMP.instance, I.name AS instanceName,
			TMP.backupset, B.name AS backupSetName,
			TMP.appId, TMP.subclientName, TMP.isSelected
	FROM	#tmpGroupApps TMP, APP_Client C WITH (NOLOCK), APP_IDAType T WITH (NOLOCK),
			APP_InstanceName I WITH (NOLOCK), APP_BackupSetName B WITH (NOLOCK)
	WHERE	TMP.clientId = C.Id
	AND 	TMP.appTypeId = T.type
	AND		TMP.instance = I.id
	AND 	TMP.backupSet = B.id
	ORDER BY clientName, appTypeName, instanceName, backupSetName, TMP.subclientName
END
DROP TABLE #tmpGroupApps
IF OBJECT_ID('tempdb.dbo.#archGroupToAppId') IS NOT NULL DROP TABLE #archGroupToAppId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archGroupAppSubsetForDeferredCatalog')
	delete from GxQscripts where name = 'archGroupAppSubsetForDeferredCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppSubsetForDeferredCatalog')
	delete from GXDBVersions where aliasname = 'archGroupAppSubsetForDeferredCatalog'
GO

insert into GXDBVersions values(2, 'archGroupAppSubsetForDeferredCatalog',  '00010001000200050000', 'archGroupAppSubsetForDeferredCatalog', '00010001000200050000')
GO

