

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupAppIncludedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupAppIncludedEntities.sp,v $ $Id: archGroupAppIncludedEntities.sp,v 1.1.2.4 2019/12/27 13:06:39 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupAppIncludedEntities')
BEGIN
	print '>>> Drop Stored Procedure: archGroupAppIncludedEntities <<<'
	drop procedure archGroupAppIncludedEntities
END
IF EXISTS (select * from GxQscripts where name='archGroupAppIncludedEntities')
	delete from GxQscripts where name = 'archGroupAppIncludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppIncludedEntities')
	delete from GXDBVersions where aliasname = 'archGroupAppIncludedEntities'
GO
print '... Creating Procedure: archGroupAppIncludedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupAppIncludedEntities
  @i_archGroupId integer,
  @i_OperationType integer = 1,
  @i_inputXML varchar(MAX) = ''
AS
-- Following are the "columns" returned, in the order in which they are returned
BEGIN
	if object_id('tempdb.dbo.#tmpGroupAppsOut') is not null DROP TABLE #tmpGroupAppsOut
	CREATE TABLE #tmpGroupAppsOut (id int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int)
	IF OBJECT_ID('tempdb.dbo.#tblarchGroupToApp') is not null DROP TABLE #tblarchGroupToApp
	create table #tblarchGroupToApp (ClientId int, appTypeId int, instanceId int, backupSetId int, subClientId int, assocType int default 0)
	IF OBJECT_ID('tempdb.dbo.#tblarchGroupToAppEx') is not null DROP TABLE #tblarchGroupToAppEx
	create table #tblarchGroupToAppEx(ClientId int, appTypeId int, instanceId int, backupSetId int, subClientId int, assocType int default 0)
	if @i_OperationType = 1
		exec archGroupAppSubsetForBackupCopy @i_archGroupId, @i_inputXML
	else if @i_OperationType = 2
		exec archGroupAppSubsetForDeferredCatalog @i_archGroupId, @i_inputXML
	IF OBJECT_ID('tempdb.dbo.#tempArchGroupToApp') IS NOT NULL DROP TABLE #tempArchGroupToApp
	CREATE TABLE #tempArchGroupToApp (
		archGroupId		INTEGER,
		operationType INTEGER,
		clientId 	INTEGER,
		appTypeId 	INTEGER,
		instanceId 	INTEGER,
		backupSetId INTEGER,
		subClientId INTEGER,
		clientGroupId INTEGER,
		exclude INTEGER,
		assocType INTEGER
	)
	INSERT INTO #tblarchGroupToApp
	SELECT DISTINCT clientId, 0, 0, 0,0,0
	FROM #tmpGroupAppsOut WITH (NOLOCK) where isSelected > 0
	IF @i_inputXML = ''
	BEGIN
		INSERT INTO #tempArchGroupToApp
		SELECT A.*
		FROM archGroupToApp A WITH (READUNCOMMITTED)
		WHERE archGroupId = @i_archGroupId AND operationType = @i_OperationType
	END
	BEGIN
		DECLARE @i_xmlStr XML = convert(XML,@i_inputXML)
		INSERT INTO #tempArchGroupToApp
		SELECT
			@i_archGroupId,
			@i_OperationType,
			ISNULL((doc.col.value('@clientId', 'INT')),0),
			ISNULL((doc.col.value('@applicationId', 'INT')),0),
			ISNULL((doc.col.value('@instanceId', 'INT')),0),
			ISNULL((doc.col.value('@backupsetId', 'INT')),0),
			ISNULL((doc.col.value('@subclientId', 'INT')),0),
			ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
			ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
			ISNULL((doc.col.value('@_type_', 'INT')),0)
		FROM @i_xmlStr.nodes('EVGui_GetArchGroupToAppIncludedEntitiesReq/listEntities') doc(col)
	END
	DELETE #tblArchGroupToApp
	OUTPUT DELETED.* INTO #tblArchGroupToAppEx
	FROM #tblArchGroupToApp t, #tempArchGroupToApp A
	WHERE A.exclude = 1 AND archGroupId = @i_archGroupId
	AND (t.clientID = A.clientiD or (  A.clientId = 0 AND EXISTS (SELECT 1 FROM APP_ClientGroupAssoc CG WITH (READUNCOMMITTED) WHERE CG.clientGroupId = A.clientGroupId AND CG.clientId = t.ClientId)))
	DELETE #tblArchGroupToApp
	INSERT INTO #tblArchGroupToApp
	SELECT DISTINCT t2.clientId, CASE WHEN A.appTypeId > 0 THEN t2.appTypeId ELSE 0 END,
		  CASE WHEN A.appTypeId = t2.appTypeId AND A.instanceId > 0 THEN t2.instance ELSE 0 END,
		  CASE WHEN A.instanceId = t2.instance AND A.backupSetId > 0 THEN t2.backupSet ELSE 0 END,
		  CASE WHEN A.backupSetId = t2.backupSet AND A.subClientId > 0 THEN t2.Id ELSE 0 END,
		  0
	FROM #tblArchGroupToAppEx t1, #tempArchGroupToApp A,#tmpGroupAppsOut t2
	WHERE t1.ClientId = A.clientId AND t2.clientId = A.clientId
	AND T2.isSelected > 0 AND A.exclude = 1 AND archGroupId = @i_archGroupId
	INSERT INTO #tblArchGroupToApp
	SELECT T2.clientId, A.appTypeId, A.instanceId, A.backupSetId,A.subClientId, 0
	FROM  #tempArchGroupToApp  A WITH (NOLOCK),#tmpGroupAppsOut t2
	WHERE ((t2.clientId = A.clientId AND A.ClientId > 0) OR A.assocType = 2 )
	AND T2.isSelected > 0 AND A.archGroupId = @i_archGroupId AND NOT EXISTS (SELECT 1 FROM #tblArchGroupToAppEx t1 WHERE t1.ClientId = T2.clientId)
	AND NOT EXISTS (SELECT 1 FROM  #tmpGroupAppsOut t3 WHERE t3.clientId = t2.clientId and t3.isSelected = 0)
	UNION
	SELECT CG.clientId, A.appTypeId, A.instanceId, A.backupSetId,A.subClientId, 0
	FROM  #tempArchGroupToApp  A WITH (NOLOCK),#tmpGroupAppsOut t2, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
	WHERE t2.clientId = CG.clientId AND A.ClientId = 0  AND (A.clientGroupId = CG.clientGroupId OR A.assocType = 27)
	AND T2.isSelected > 0 AND A.archGroupId = @i_archGroupId AND not EXISTS (SELECT 1 FROM #tblArchGroupToAppEx t1 WHERE t1.ClientId = A.clientId)
	AND NOT EXISTS (SELECT 1 FROM  #tmpGroupAppsOut t3 WHERE t3.clientId = t2.clientId and t3.isSelected = 0)
	UNION
	SELECT T2.clientId, 0, 0, 0, 0, 0
	FROM #tmpGroupAppsOut T2
	WHERE NOT EXISTS (SELECT 1 FROM #tempArchGroupToApp)
	AND NOT EXISTS (SELECT 1 FROM  #tmpGroupAppsOut t3 WHERE t3.clientId = t2.clientId and t3.isSelected = 0)
	--now we should be left only with VMs that are included from the associations but there is some excluded at parent level
	-- for such entries, we will have to add the subclient level associations.
	INSERT INTO #tblArchGroupToApp
	SELECT T2.clientId, T2.appTypeId, T2.instance, T2.backupSet,T2.Id, 0
	FROM  #tempArchGroupToApp  A WITH (NOLOCK),#tmpGroupAppsOut t2
	WHERE ((t2.clientId = A.clientId AND A.ClientId > 0) OR A.assocType = 2 )
	AND T2.isSelected > 0 AND A.archGroupId = @i_archGroupId AND NOT EXISTS (SELECT 1 FROM #tblArchGroupToAppEx t1 WHERE t1.ClientId = T2.clientId)
	AND NOT EXISTS (SELECT 1 FROM #tblArchGroupToApp o WHERE o.clientId = T2.clientId)
	IF OBJECT_ID('tempdb.dbo.#tempArchGroupToApp') IS NOT NULL DROP TABLE #tempArchGroupToApp
	UPDATE #tblarchGroupToApp
	SET assocType = CASE WHEN subClientId > 0 THEN 7 WHEN backupSetId > 0 THEN 6 WHEN InstanceId > 0 THEN 5 WHEN AppTypeId > 0 THEN 4 WHEN clientId > 0 THEN 3 ELSE 0 END
	DELETE #tblarchGroupToApp
	FROM #tblarchGroupToApp ch
	WHERE EXISTS
	(SELECT 1 FROM #tblarchGroupToApp par
		WHERE ch.assocType > par.assocType
		AND ch.clientId = par.clientId
		AND	(par.apptypeID = 0 OR par.appTypeId = ch.appTypeId)
		AND (par.instanceId = 0  OR par.instanceId = ch.instanceId)
		AND (par.backupSetId = 0 OR par.backupSetId = ch.backupSetId)
		AND (par.subClientId = 0 OR par.subClientId = ch.subClientId)
	 )
	select	tt.clientId, ISNULL(cl.name,'') as clientName,
			tt.appTypeId, ISNULL(aType.name,'') as appTypename,
			tt.instanceId, ISNULL(iName.name,'') as instanceName,
			tt.backupsetId, ISNULL(bsn.name,'') as backuupSetName,
			tt.subClientId, ISNULL(aa.subclientName,'') as subclientName,
			1 as include, 0 as exclude, tt.assocType
	from	#tblarchGroupToApp as tt LEFT JOIN APP_Client as cl WITH (READUNCOMMITTED) ON tt.clientId = cl.Id LEFT JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON tt.appTypeId = aType.type
				LEFT JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON tt.instanceId = iName.id LEFT JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON tt.backupSetId = bsn.id
				LEFT JOIN app_application as aa WITH (READUNCOMMITTED) ON tt.subClientId = aa.id
END

IF EXISTS (select * from GxQscripts where name = 'archGroupAppIncludedEntities')
	delete from GxQscripts where name = 'archGroupAppIncludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppIncludedEntities')
	delete from GXDBVersions where aliasname = 'archGroupAppIncludedEntities'
GO

insert into GXDBVersions values(2, 'archGroupAppIncludedEntities',  '00010001000200040000', 'archGroupAppIncludedEntities', '00010001000200040000')
GO

