

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGroupAppExcludedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGroupAppExcludedEntities.sp,v $ $Id: archGroupAppExcludedEntities.sp,v 1.1.2.1 2020/03/17 20:41:19 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGroupAppExcludedEntities')
BEGIN
	print '>>> Drop Stored Procedure: archGroupAppExcludedEntities <<<'
	drop procedure archGroupAppExcludedEntities
END
IF EXISTS (select * from GxQscripts where name='archGroupAppExcludedEntities')
	delete from GxQscripts where name = 'archGroupAppExcludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppExcludedEntities')
	delete from GXDBVersions where aliasname = 'archGroupAppExcludedEntities'
GO
print '... Creating Procedure: archGroupAppExcludedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGroupAppExcludedEntities
  @i_archGroupId integer,
  @i_OperationType integer = 1,
  @i_inputXML varchar(MAX) = ''
AS
-- Following are the "columns" returned, in the order in which they are returned
BEGIN
	DECLARE @l_sourceCopyId INTEGER
	IF @i_operationType = 1
		SET @l_sourceCopyId = (SELECT sourceCopyId FROM ArchMaterializeSnapshotProp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId)
	ELSE
		SET @l_sourceCopyId = (SELECT sourceCopyId FROM ArchDeferredCatalogProp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId)
	IF  @l_sourceCopyId = 0
		SET @l_sourceCopyId = (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId)
	if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
	CREATE TABLE #archGroupToAppId (
	archGroupId			INTEGER,
	AppId				INTEGER
	)
	CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
	exec archGetArchGroupToAppAssociations @i_archGroupId, @i_OperationType, @i_inputXML
	if object_id('tempdb.dbo.#tmpGroupApps') is not null DROP TABLE #tmpGroupApps
	create table #tmpGroupApps (appId int, clientGroupId int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int, assocType INT) -- isSelected = 0 means excluded, 1  selected, 2 just for population
	if object_id('tempdb.dbo.#tblExcludedEntites') is not null DROP TABLE #tblExcludedEntites
	create table #tblExcludedEntites (appId int, clientGroupId int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int, assocType INT) -- isSelected = 0 means excluded, 1  selected, 2 just for population
	--Get list of subclients having non-aged jobs on source copy
	INSERT INTO #tmpGroupApps
	SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
	FROM	APP_Application A WITH (NOLOCK) INNER JOIN 	(	SELECT DISTINCT appId
																				FROM JMJobDatastats WITH (NOLOCK)
																				WHERE archGrpCopyId = @l_sourceCopyId
																				AND status IN (100, 101, 102, 103)
AND (disabled & 256) = 0
																			 ) B
	ON A.id = B.appId
	WHERE NOT EXISTS ( SELECT 1 FROM App_SubclientProp SP WITH (NOLOCK)
						WHERE 	A.Id = SP.componentNameId
							AND		SP.attrName IN ('Index SubClient', 'DDB Backup')
							AND		SP.attrVal = '1'
							AND		SP.modified = 0	)
	AND (@i_operationType = 1 OR dbo.IsDeferredCatalogSupported(A.Id) <> 0) --Skip Subclients that does not support deferred catalog
	UNION--Get list of subclients that are currently associated to storage policy
	SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
	FROM	APP_Application A WITH (NOLOCK)
	WHERE	(
				A.dataArchGrpId = @i_archGroupId
				OR (
						A.logArchGrpId = @i_archGroupId
AND A.appTypeId IN (22, 104, 61, 37, 5, 81, 3, 125)
					 )
			)
	AND NOT EXISTS ( SELECT 1 FROM App_SubclientProp SP WITH (NOLOCK)
						WHERE 	A.Id = SP.componentNameId
							AND		SP.attrName IN ('Index SubClient', 'DDB Backup')
							AND		SP.attrVal = '1'
							AND		SP.modified = 0	)
	AND (@i_operationType = 1 OR dbo.IsDeferredCatalogSupported(A.Id) <> 0) --Skip Subclients that does not support deferred catalog
	UNION--Get list of subclients associated with storage policy having incremental storage policy configured
	SELECT	DISTINCT A.id, 0, A.clientId, A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
	FROM	APP_Application A WITH (NOLOCK)
	INNER JOIN archGroup AG WITH (NOLOCK) ON A.dataArchGrpId = AG.id
	WHERE	AG.incrSP = @i_archGroupId
	AND NOT EXISTS ( SELECT 1 FROM App_SubclientProp SP WITH (NOLOCK)
						WHERE 	A.Id = SP.componentNameId
							AND		SP.attrName IN ('Index SubClient', 'DDB Backup')
							AND		SP.attrVal = '1'
							AND		SP.modified = 0	)
	AND (@i_operationType = 1 OR dbo.IsDeferredCatalogSupported(A.Id) <> 0) --Skip Subclients that does not support deferred catalog
	CREATE INDEX tmpGroupApps_idx1 ON #tmpGroupApps (AppId)
	INSERT INTO #tmpGroupApps
	SELECT DISTINCT A.AppId, CG.clientGroupId, A.clientId , A.appTypeId, A.instance , A.backupSet , A.subclientName, 2, 0
	FROM #tmpGroupApps A INNER JOIN  APP_ClientGroupAssoc CG WITH (READUNCOMMITTED) ON CG.clientId = A.clientId
	--Skip DDB subclients\Indexing Subclients
	DELETE #tmpGroupApps
	FROM #tmpGroupApps T, App_SubclientProp A WITH (NOLOCK)
	WHERE 	T.appId = A.componentNameId
		AND		A.attrName IN ('Index SubClient', 'DDB Backup')
		AND		A.attrVal = '1'
		AND		A.modified = 0
	IF @i_operationType = 2
	BEGIN
		--Skip Subclients that does not support deferred catalog
		DELETE #tmpGroupApps
		WHERE dbo.IsDeferredCatalogSupported(appId) = 0
	END
	-- delete all included entities
	delete #tmpGroupApps
	from #tmpGroupApps t1, #archGroupToAppId t2
	WHERE t2.AppId = t1.AppId
	IF OBJECT_ID('tempdb.dbo.#tempArchGroupToApp') IS NOT NULL DROP TABLE #tempArchGroupToApp
	CREATE TABLE #tempArchGroupToApp (
		ArchGroupId		INTEGER,
		OperationType   SMALLINT,
		clientId 	INTEGER,
		appTypeId 	INTEGER,
		instanceId 	INTEGER,
		backupSetId INTEGER,
		subClientId INTEGER,
		clientGroupId INTEGER,
		exclude INTEGER,
		assocType INTEGER
	)
	IF @i_inputXML <> ''
	BEGIN
		DECLARE @i_xmlStr XML = convert(XML,@i_inputXML)
		INSERT INTO #tempArchGroupToApp
		SELECT
			@i_archGroupId,
			@i_operationType,
			ISNULL((doc.col.value('@clientId', 'INT')),0),
			ISNULL((doc.col.value('@applicationId', 'INT')),0),
			ISNULL((doc.col.value('@instanceId', 'INT')),0),
			ISNULL((doc.col.value('@backupsetId', 'INT')),0),
			ISNULL((doc.col.value('@subclientId', 'INT')),0),
			ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
			ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
			ISNULL((doc.col.value('@_type_', 'INT')),0)
		FROM @i_xmlStr.nodes('EVGui_GetArchGroupToAppExcludedEntitiesReq/listEntities') doc(col)
	END
	ELSE
	BEGIN
		INSERT INTO #tempArchGroupToApp
		SELECT A.*
		FROM archGroupToApp A WITH (READUNCOMMITTED)
		WHERE A.archGroupId = @i_archGroupId AND A.operationType= @i_operationType
	END
	-- remove entities that have some exclusion but they are not being excluded themselves
	INSERT INTO #tblExcludedEntites
	SELECT t.*
	from #tmpGroupApps t,#tempArchGroupToApp A
	where A.exclude = 1
		AND	 t.clientId = A.clientId AND A.clientGroupId = t.clientGroupId AND
				(A.appTypeId = 0 OR A.appTypeId = t.appTypeId AND
			(A.instanceId = 0 OR A.instanceId = t.instance AND
			(A.backupSetId = 0 OR A.backupSetId = t.backupSet AND
			(A.subClientId = 0 OR A.subClientId = t.Appid))))
	UNION
	SELECT t.*
	from #tmpGroupApps t,#tempArchGroupToApp A, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
	where A.exclude = 1 AND CG.ClientGroupID = t.clientGroupID
	AND		A.clientId = 0 AND t.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
	DELETE #tmpGroupApps
	from #tmpGroupApps t, #tblExcludedEntites ex
	WHERE ex.clientId = t.clientId AND ex.appTypeId = t.appTypeId AND ex.backupSet = t.backupSet AND ex.instance = t.instance and ex.Appid = t.Appid
	AND ex.clientGroupId <> t.clientGroupId AND NOT EXISTS (SELECT 1 FROM #tblExcludedEntites ex2 WHERE ex2.clientId = t.clientId AND ex2.appTypeId = t.appTypeId AND ex2.backupSet = t.backupSet AND ex2.instance = t.instance and ex2.Appid = t.Appid
	AND ex2.clientGroupId = t.clientGroupId)
	UPDATE #tmpGroupApps
	SET assocType = 7 --let's show the exclusions/complete disassociations all the way to individual subclients.
	select	DISTINCT tt.clientGroupID, ISNULL(CG.name,'') clientGroupName,
		tt.clientId ,cl.name clientName,
		tt.appTypeId, aType.name appTypename,
		tt.instance, iName.name instanceName,
		tt.backupset, bsn.name backuupSetName,
		tt.Appid, tt.subclientName subclientName
	from	#tmpGroupApps as tt  JOIN APP_Client as cl WITH (READUNCOMMITTED) ON tt.clientId = cl.Id  JOIN APP_iDAType as aType WITH (READUNCOMMITTED) ON tt.appTypeId = aType.type
			  JOIN APP_InstanceName as iName WITH (READUNCOMMITTED) ON tt.instance = iName.id JOIN APP_BackupSetName as bsn WITH (READUNCOMMITTED) ON tt.backupSet = bsn.id
			 LEFT JOIN APP_ClientGroup CG WITH (READUNCOMMITTED) ON CG.id = tt.clientGRoupID
	if object_id('tempdb.dbo.#tblExcludedEntites') is not null DROP TABLE #tblExcludedEntites
	IF OBJECT_ID('tempdb.dbo.#tempArchGroupToApp') IS NOT NULL DROP TABLE #tempArchGroupToApp
	IF object_id('tempdb.dbo.#tmpGroupApps')  IS NOT NULL DROP TABLE #tmpGroupApps
END

IF EXISTS (select * from GxQscripts where name = 'archGroupAppExcludedEntities')
	delete from GxQscripts where name = 'archGroupAppExcludedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGroupAppExcludedEntities')
	delete from GXDBVersions where aliasname = 'archGroupAppExcludedEntities'
GO

insert into GXDBVersions values(2, 'archGroupAppExcludedEntities',  '00010001000200010000', 'archGroupAppExcludedEntities', '00010001000200010000')
GO

