

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGlobalDedupePolicyList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGlobalDedupePolicyList.sp,v $ $Id: archGlobalDedupePolicyList.sp,v 1.7.54.4 2018/11/03 03:23:31 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGlobalDedupePolicyList')
BEGIN
	print '>>> Drop Stored Procedure: archGlobalDedupePolicyList <<<'
	drop procedure archGlobalDedupePolicyList
END
IF EXISTS (select * from GxQscripts where name='archGlobalDedupePolicyList')
	delete from GxQscripts where name = 'archGlobalDedupePolicyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGlobalDedupePolicyList')
	delete from GXDBVersions where aliasname = 'archGlobalDedupePolicyList'
GO
print '... Creating Procedure: archGlobalDedupePolicyList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGlobalDedupePolicyList
  @i_LibraryId INTEGER,
  @i_MAClientId INTEGER,
  @i_ArchGroupId INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName NVARCHAR(255)
SET NOCOUNT ON
CREATE	TABLE #HostCopy (CopyId INT, ArchGroupId INT, ClientId INT, LibraryId INT)
INSERT	INTO #HostCopy
SELECT	DISTINCT C.id, C.archGroupId, P.HostClientId, MP.LibraryId
FROM	archGroupCopy C, MMDataPath P, MMDrivePool DP, MMMasterPool MP
WHERE	P.CopyId = C.id AND (C.dedupeFlags & 268435456) <> 0
AND (C.flags & 524288) = 0
AND DP.DrivePoolId = P.DrivePoolId AND DP.DrivePoolType = 10001
	AND MP.MasterPoolId = DP.MasterPoolId
-- Two copies of the same storage policy can not use the same Dedupe Host Policy
IF @i_ArchGroupId > 1
	DELETE	H
	FROM	#HostCopy H, archCopyToGlobalPolicy GP, archGroupCopy AGC
	WHERE	H.ArchGroupId = GP.GlobalPolicyId
			AND GP.CopyId = AGC.id
			AND AGC.archGroupId = @i_ArchGroupId
AND (AGC.dedupeFlags & 134217728) <> 0
	DELETE #HostCopy
	FROM archGroup AG WITH (NOLOCK)
	WHERE #HostCopy.ArchGroupId = AG.id
AND (AG.flags & 65536) > 0
	DELETE #HostCopy
	FROM archGroup AG WITH (NOLOCK)
	WHERE #HostCopy.ArchGroupId = AG.id
AND (AG.flags & 262144) > 0
IF @i_LibraryId > 0 AND @i_MAClientId > 0
BEGIN
	-- The input library should be accessible from all MAs of the Dedupe Host Policy Copy
	DELETE	#HostCopy
	FROM	(SELECT	DISTINCT CopyId
			 FROM	#HostCopy
			 WHERE	(clientId <> @i_MAClientId OR LibraryId <> @i_LibraryId)
				AND clientId NOT IN (SELECT	ClientId FROM MMLibraryController WHERE LibraryId = @i_LibraryId)
			) T
	WHERE	#HostCopy.CopyId = T.CopyId
	DELETE	#HostCopy
	FROM	(SELECT	DISTINCT CopyId
			 FROM	#HostCopy
			 WHERE	(clientId <> @i_MAClientId OR LibraryId <> @i_LibraryId)
				AND LibraryId NOT IN (SELECT LibraryId FROM MMLibraryController WHERE ClientId = @i_MAClientId)
			) T
	WHERE	#HostCopy.CopyId = T.CopyId
END
SELECT	DISTINCT AG.id, AG.name
FROM	#HostCopy T, archGroup AG
WHERE	AG.id = T.archGroupId
ORDER BY AG.name
DROP TABLE #HostCopy
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGlobalDedupePolicyList')
	delete from GxQscripts where name = 'archGlobalDedupePolicyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGlobalDedupePolicyList')
	delete from GXDBVersions where aliasname = 'archGlobalDedupePolicyList'
GO

insert into GXDBVersions values(2, 'archGlobalDedupePolicyList',  '00010007005400040000', 'archGlobalDedupePolicyList', '00010007005400040000')
GO

